/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.splitpanel;

import bdv.ui.splitpanel.SplitPaneOneTouchExpandAnimator;
import bdv.ui.splitpanel.SplitPanel;
import bdv.viewer.AbstractViewerPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class SplitPaneOneTouchExpandTrigger
extends MouseAdapter {
    private final SplitPaneOneTouchExpandAnimator animator;
    private final SplitPanel splitPanel;
    private final AbstractViewerPanel viewer;
    private boolean inBorderRegion = false;
    private boolean inTriggerRegion = false;

    public SplitPaneOneTouchExpandTrigger(SplitPaneOneTouchExpandAnimator animator, SplitPanel splitPanel, AbstractViewerPanel viewer) {
        this.animator = animator;
        this.splitPanel = splitPanel;
        this.viewer = viewer;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX();
        if (this.animator.isInBorderRegion(x, y = e.getY())) {
            this.checkEnterBorderRegion();
        } else {
            this.checkExitBorderRegion();
        }
        if (this.animator.isInTriggerRegion(x, y)) {
            this.checkEnterTriggerRegion();
        } else {
            this.checkExitTriggerRegion();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkExitBorderRegion();
        this.checkExitTriggerRegion();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.animator.isInTriggerRegion(e.getX(), e.getY())) {
            this.splitPanel.setCollapsed(!this.splitPanel.isCollapsed());
            this.viewer.requestRepaint();
            this.checkExitBorderRegion();
            this.checkExitTriggerRegion();
        }
    }

    private void checkExitTriggerRegion() {
        if (this.inTriggerRegion) {
            this.inTriggerRegion = false;
            if (!this.splitPanel.isCollapsed()) {
                this.startAnimation(SplitPaneOneTouchExpandAnimator.AnimationType.HIDE_COLLAPSE);
            }
        }
    }

    private void checkEnterTriggerRegion() {
        if (!this.inTriggerRegion) {
            this.inTriggerRegion = true;
            if (!this.splitPanel.isCollapsed()) {
                this.startAnimation(SplitPaneOneTouchExpandAnimator.AnimationType.SHOW_COLLAPSE);
            }
        }
    }

    private void checkExitBorderRegion() {
        if (this.inBorderRegion) {
            this.inBorderRegion = false;
            if (this.splitPanel.isCollapsed()) {
                this.startAnimation(SplitPaneOneTouchExpandAnimator.AnimationType.HIDE_EXPAND);
            }
        }
    }

    private void checkEnterBorderRegion() {
        if (!this.inBorderRegion) {
            this.inBorderRegion = true;
            if (this.splitPanel.isCollapsed()) {
                this.startAnimation(SplitPaneOneTouchExpandAnimator.AnimationType.SHOW_EXPAND);
            }
        }
    }

    private void startAnimation(SplitPaneOneTouchExpandAnimator.AnimationType animationType) {
        this.animator.startAnimation(animationType);
        this.viewer.getDisplayComponent().repaint();
    }
}

