/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;

public class TranslationAnimator
extends AbstractTransformAnimator {
    private final AffineTransform3D transformStart;
    private final double[] targetTranslation;

    public TranslationAnimator(AffineTransform3D transformStart, double[] targetTranslation, long duration) {
        super(duration);
        this.transformStart = transformStart;
        this.targetTranslation = (double[])targetTranslation.clone();
    }

    @Override
    public AffineTransform3D get(double t) {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(this.transformStart);
        double sx = transform.get(0, 3);
        double sy = transform.get(1, 3);
        double sz = transform.get(2, 3);
        double tx = this.targetTranslation[0];
        double ty = this.targetTranslation[1];
        double tz = this.targetTranslation[2];
        transform.set(sx + t * (tx - sx), 0, 3);
        transform.set(sy + t * (ty - sy), 1, 3);
        transform.set(sz + t * (tz - sz), 2, 3);
        return transform;
    }
}

