/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.Translator;

public class PerformanceProfiler
implements Translator {
    private Set<String> only;
    private Set<String> skip;
    private boolean fastButInaccurateTiming = true;
    protected static final boolean debug = false;
    private static Loader loader;
    private static Field activeField;
    private static Map<CtBehavior, Integer> counters;
    protected static Method realReport;
    private static ThreadMXBean bean;

    public PerformanceProfiler() {
        this(System.getenv("PERFORMANCE_PROFILE_ONLY"));
    }

    private PerformanceProfiler(String only) {
        this(only == null ? null : Arrays.asList(only.split(" +")));
    }

    private PerformanceProfiler(Collection<String> only) {
        if (only != null) {
            this.only = new HashSet<String>();
            this.only.addAll(only);
        }
        this.skip = new HashSet<String>();
    }

    public static boolean startProfiling(String mainClass, String ... args) throws Throwable {
        if (PerformanceProfiler.class.getClassLoader() == loader) {
            return false;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (mainClass == null) {
            mainClass = stack[2].getClassName();
        }
        PerformanceProfiler.doMain(mainClass, args);
        return true;
    }

    public static void main(String ... args) throws Throwable {
        Thread.currentThread().setContextClassLoader(PerformanceProfiler.class.getClassLoader());
        if (args.length == 0) {
            System.err.println("Usage: java " + PerformanceProfiler.class + " <main-class> [<argument>...]");
            System.exit(1);
        }
        String mainClass = args[0];
        String[] mainArgs = new String[args.length - 1];
        System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
        PerformanceProfiler.doMain(mainClass, mainArgs);
    }

    public static void setActive(boolean active) {
        if (loader == null) {
            PerformanceProfiler.init();
        }
        try {
            activeField.setBoolean(null, active);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isActive() {
        try {
            return activeField.getBoolean(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void report(File file, int column) throws FileNotFoundException {
        PrintStream stream = new PrintStream(new FileOutputStream(file));
        PerformanceProfiler.report(stream, column);
        stream.close();
    }

    public static void report(PrintStream writer) {
        PerformanceProfiler.report(writer, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(PrintStream writer, int column) {
        assert (CtBehavior.class.getClassLoader() != loader);
        Class<PerformanceProfiler> clazz = PerformanceProfiler.class;
        synchronized (PerformanceProfiler.class) {
            if (!PerformanceProfiler.isActive()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            PerformanceProfiler.setActive(false);
            ArrayList<Row> rows = writer == null || column < 1 || column > 3 ? null : new ArrayList<Row>();
            ArrayList<CtBehavior> behaviors = new ArrayList<CtBehavior>(counters.keySet());
            for (CtBehavior behavior : behaviors) {
                try {
                    int i = counters.get(behavior);
                    Class clazz2 = loader.loadClass(behavior.getDeclaringClass().getName());
                    Field counter = clazz2.getDeclaredField(PerformanceProfiler.toCounterName(i));
                    counter.setAccessible(true);
                    long count = counter.getLong(null);
                    if (count == 0L) continue;
                    Field nanosField = clazz2.getDeclaredField(PerformanceProfiler.toNanosName(i));
                    nanosField.setAccessible(true);
                    if (writer != null) {
                        long nanos = nanosField.getLong(null);
                        if (rows != null) {
                            rows.add(new Row(behavior, count, nanos));
                        } else {
                            writer.println(Row.toString(behavior, count, nanos));
                        }
                    }
                    counter.set(null, 0L);
                    nanosField.set(null, 0L);
                }
                catch (Throwable e) {
                    System.err.println("Problem with " + behavior.getLongName() + ":");
                    if (e instanceof InvocationTargetException && e.getCause() != null && e.getCause() instanceof NoClassDefFoundError) {
                        System.err.println("Class not found: " + e.getCause().getMessage());
                        break;
                    }
                    if (e instanceof ClassFormatError) {
                        System.err.println("Class format error: " + behavior.getDeclaringClass().getName());
                        break;
                    }
                    e.printStackTrace();
                }
            }
            if (rows != null && writer != null) {
                Comparator<Row> comparator = column == 1 ? new Comparator<Row>(){

                    @Override
                    public int compare(Row a, Row b) {
                        return -Double.compare(a.count, b.count);
                    }
                } : (column == 2 ? new Comparator<Row>(){

                    @Override
                    public int compare(Row a, Row b) {
                        return -Double.compare(a.count, b.count);
                    }
                } : new Comparator<Row>(){

                    @Override
                    public int compare(Row a, Row b) {
                        return -Double.compare(a.nanos, b.nanos);
                    }
                });
                Collections.sort(rows, comparator);
                for (Row row : rows) {
                    writer.println(row.toString());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static final long getNanos() {
        return bean.getCurrentThreadCpuTime();
    }

    public static final long getNanosQnD() {
        return System.nanoTime();
    }

    public synchronized void start(ClassPool pool) throws NotFoundException, CannotCompileException {
    }

    public synchronized void onLoad(ClassPool pool, String classname) throws NotFoundException {
        if (classname.equals(this.getClass().getName())) {
            return;
        }
        if (classname.startsWith("javassist.")) {
            return;
        }
        if (this.only != null && !this.only.contains(classname)) {
            return;
        }
        if (this.skip != null && this.skip.contains(classname)) {
            return;
        }
        CtClass cc = pool.get(classname);
        if (cc.isFrozen()) {
            return;
        }
        this.handle(cc, (CtBehavior)cc.getClassInitializer());
        for (CtMethod ctMethod : cc.getDeclaredMethods()) {
            this.handle(cc, (CtBehavior)ctMethod);
        }
        for (CtMethod ctMethod : cc.getDeclaredConstructors()) {
            this.handle(cc, (CtBehavior)ctMethod);
        }
    }

    private static void init() {
        assert (loader == null);
        try {
            counters = new TreeMap<CtBehavior, Integer>(new BehaviorComparator());
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new ClassClassPath(PerformanceProfiler.class));
            loader = new Loader(PerformanceProfiler.class.getClassLoader(), pool);
            CtClass that = pool.get(PerformanceProfiler.class.getName());
            CtField active = new CtField(CtClass.booleanType, "active", that);
            active.setModifiers(9);
            that.addField(active);
            realReport = PerformanceProfiler.class.getMethod("report", PrintStream.class, Integer.TYPE);
            CtMethod realReportMethod = that.getMethod("report", "(Ljava/io/PrintStream;I)V");
            realReportMethod.insertBefore("reportCaller($1, 3); realReport.invoke(null, $args); return;");
            Class thatClass = loader.loadClass(that.getName());
            activeField = thatClass.getField("active");
            bean = ManagementFactory.getThreadMXBean();
            for (String fieldName : new String[]{"loader", "activeField", "counters", "realReport", "bean"}) {
                Field thisField = PerformanceProfiler.class.getDeclaredField(fieldName);
                thisField.setAccessible(true);
                Field thatField = thatClass.getDeclaredField(fieldName);
                thatField.setAccessible(true);
                thatField.set(null, thisField.get(null));
            }
            loader.addTranslator(pool, (Translator)new PerformanceProfiler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String toCounterName(int i) {
        return "__counter" + i + "__";
    }

    private static String toNanosName(int i) {
        return "__nanos" + i + "__";
    }

    private synchronized void handle(CtClass clazz, CtBehavior behavior) {
        block8: {
            if (behavior == null) {
                return;
            }
            try {
                if (clazz != behavior.getDeclaringClass()) {
                    return;
                }
                if (behavior.isEmpty()) {
                    return;
                }
                int i = 1;
                while (PerformanceProfiler.hasField(clazz, PerformanceProfiler.toCounterName(i)) || PerformanceProfiler.hasField(clazz, PerformanceProfiler.toNanosName(i))) {
                    ++i;
                }
                String counterFieldName = PerformanceProfiler.toCounterName(i);
                String nanosFieldName = PerformanceProfiler.toNanosName(i);
                CtField counterField = new CtField(CtClass.longType, counterFieldName, clazz);
                counterField.setModifiers(8);
                clazz.addField(counterField);
                CtField nanosField = new CtField(CtClass.longType, nanosFieldName, clazz);
                nanosField.setModifiers(8);
                clazz.addField(nanosField);
                String thisName = this.getClass().getName();
                String that = clazz.getName() + ".";
                String getNanos = thisName + (this.fastButInaccurateTiming ? ".getNanosQnD()" : ".getNanos()");
                behavior.addLocalVariable("__startTime__", CtClass.longType);
                behavior.insertBefore("__startTime__ = " + thisName + ".active ? " + getNanos + " : -1;");
                behavior.insertAfter("if (__startTime__ != -1) {" + that + counterFieldName + "++;" + that + nanosFieldName + " += " + getNanos + " - __startTime__;}");
                assert (behavior.getClass().getClassLoader() != loader);
                counters.put(behavior, i);
            }
            catch (CannotCompileException e) {
                if (e.getMessage().equals("no method body")) break block8;
                System.err.println("Problem with " + behavior.getLongName() + ":");
                if (e.getCause() != null && e.getCause() instanceof NotFoundException) {
                    System.err.println("(could not find " + e.getCause().getMessage() + ")");
                }
                e.printStackTrace();
            }
        }
    }

    private static boolean hasField(CtClass clazz, String name) {
        try {
            return clazz.getField(name) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected static void reportCaller(PrintStream writer, int level) {
        if (writer == null) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack == null || stack.length <= level || stack[level] == null) {
            writer.println("Could not determine caller");
        } else {
            StackTraceElement caller = stack[level];
            writer.println("Report called by " + caller.toString());
        }
    }

    private static String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return "" + nanos + "ns";
        }
        if (nanos < 1000000L) {
            return (double)nanos / 1000.0 + "\u00b5s";
        }
        if (nanos < 1000000000L) {
            return (double)nanos / 1000000.0 + "ms";
        }
        return (double)nanos / 1.0E9 + "s";
    }

    private static void doMain(String mainClass, String ... args) throws Throwable {
        PerformanceProfiler.setActive(true);
        loader.run(mainClass, args);
        PerformanceProfiler.report(System.err);
    }

    private static class Row {
        private final CtBehavior behavior;
        private final long count;
        private final long nanos;

        public Row(CtBehavior behavior, long count, long nanos) {
            this.behavior = behavior;
            this.count = count;
            this.nanos = nanos;
        }

        public String toString() {
            return Row.toString(this.behavior, this.count, this.nanos);
        }

        public static String toString(CtBehavior behavior, long count, long nanos) {
            return behavior.getLongName() + "; " + count + "x; average: " + PerformanceProfiler.formatNanos(nanos / count) + "; total: " + PerformanceProfiler.formatNanos(nanos);
        }
    }

    private static class BehaviorComparator
    implements Comparator<CtBehavior> {
        private BehaviorComparator() {
        }

        @Override
        public int compare(CtBehavior a, CtBehavior b) {
            return a.getLongName().compareTo(b.getLongName());
        }
    }
}

