/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.Interval;

public class FlatIterationOrder {
    private final Interval interval;

    public FlatIterationOrder(Interval interval) {
        this.interval = interval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlatIterationOrder)) {
            return false;
        }
        Interval i = ((FlatIterationOrder)obj).interval;
        List<Integer> l1 = this.validIndices(i);
        List<Integer> l2 = this.validIndices(this.interval);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int d = 0; d < l1.size(); ++d) {
            if (i.min(l1.get(d)) == this.interval.min(l2.get(d)) && i.dimension(l1.get(d)) == this.interval.dimension(l2.get(d))) continue;
            return false;
        }
        return true;
    }

    private List<Integer> validIndices(Interval i) {
        ArrayList<Integer> indices = new ArrayList<Integer>(i.numDimensions());
        for (int j = 0; j < i.numDimensions(); ++j) {
            if (i.dimension(j) <= 1L) continue;
            indices.add(j);
        }
        return indices;
    }
}

