/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.List;
import java.util.Objects;
import net.imglib2.blocks.Extension;
import net.imglib2.blocks.RangesImpl;

@FunctionalInterface
interface Ranges {
    public List<Range> findRanges(long var1, int var3, long var4, int var6);

    public static Ranges forExtension(Extension extension) {
        switch (extension.type()) {
            case CONSTANT: {
                return RangesImpl.FIND_RANGES_CONSTANT;
            }
            case MIRROR_SINGLE: {
                return RangesImpl.FIND_RANGES_MIRROR_SINGLE;
            }
            case MIRROR_DOUBLE: {
                return RangesImpl.FIND_RANGES_MIRROR_DOUBLE;
            }
            case BORDER: {
                return RangesImpl.FIND_RANGES_BORDER;
            }
        }
        throw new IllegalArgumentException("Extension type not supported: " + (Object)((Object)extension.type()));
    }

    public static class Range {
        final int gridx;
        final int cellx;
        final int w;
        final Direction dir;
        final int x;

        public Range(int gridx, int cellx, int w, Direction dir, int x) {
            this.gridx = gridx;
            this.cellx = cellx;
            this.w = w;
            this.dir = dir;
            this.x = x;
        }

        public String toString() {
            return "Range{gridx=" + this.gridx + ", cellx=" + this.cellx + ", w=" + this.w + ", dir=" + (Object)((Object)this.dir) + ", x=" + this.x + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.gridx == range.gridx && this.cellx == range.cellx && this.w == range.w && this.x == range.x && this.dir == range.dir;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.gridx, this.cellx, this.w, this.dir, this.x});
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD,
        STAY,
        CONSTANT;

    }
}

