/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.concatenate;

import java.util.List;
import java.util.ListIterator;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;

public class ConcatenateUtils {
    public static void print(List<?> concatenatables) {
        ListIterator<?> iterator = concatenatables.listIterator();
        System.out.print(" ====  ");
        while (iterator.hasNext()) {
            Object a = iterator.next();
            System.out.print(a);
            if (!iterator.hasNext()) continue;
            System.out.print(" x ");
        }
        System.out.println();
    }

    public static <T> void join(List<T> objects) {
        int oldConcatenablesSize;
        do {
            if ((oldConcatenablesSize = objects.size()) < 2) continue;
            ListIterator<T> iterator = objects.listIterator();
            Object c1 = null;
            Object c2 = iterator.next();
            while (iterator.hasNext()) {
                c1 = c2;
                c2 = iterator.next();
                if (Concatenable.class.isInstance(c1) && ((Concatenable)c1).getConcatenableClass().isInstance(c2)) {
                    c2 = ((Concatenable)c1).concatenate(c2);
                    iterator.remove();
                    iterator.previous();
                    iterator.set(c2);
                    iterator.next();
                    continue;
                }
                if (!PreConcatenable.class.isInstance(c2) || !((PreConcatenable)c2).getPreConcatenableClass().isInstance(c1)) continue;
                c2 = ((PreConcatenable)c2).preConcatenate(c1);
                iterator.previous();
                iterator.previous();
                iterator.remove();
                iterator.next();
                iterator.set(c2);
            }
        } while (oldConcatenablesSize != objects.size());
    }
}

