/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import java.util.function.Supplier;
import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.util.Util;

public abstract class ImgFactory<T> {
    private T type;

    public ImgFactory(T type) {
        this.type = type;
    }

    public T type() {
        return this.type;
    }

    public abstract Img<T> create(long ... var1);

    public Img<T> create(Dimensions dimensions) {
        long[] size = new long[dimensions.numDimensions()];
        dimensions.dimensions(size);
        return this.create(size);
    }

    public Img<T> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    public abstract <S> ImgFactory<S> imgFactory(S var1) throws IncompatibleTypeException;

    public <S> ImgFactory<S> imgFactory(Supplier<S> typeSupplier) throws IncompatibleTypeException {
        return this.imgFactory(typeSupplier.get());
    }

    @Deprecated
    public ImgFactory() {
        this.type = null;
    }

    @Deprecated
    public abstract Img<T> create(long[] var1, T var2);

    @Deprecated
    public Img<T> create(Dimensions dim, T type) {
        long[] size = new long[dim.numDimensions()];
        dim.dimensions(size);
        this.cache(type);
        return this.create(size, type);
    }

    @Deprecated
    public Img<T> create(int[] dim, T type) {
        return this.create(Util.int2long(dim), type);
    }

    @Deprecated
    public Img<T> create(Supplier<T> typeSupplier, long ... dim) {
        return this.create(dim, typeSupplier.get());
    }

    @Deprecated
    public Img<T> create(Supplier<T> typeSupplier, Dimensions dim) {
        return this.create(dim, typeSupplier.get());
    }

    @Deprecated
    public Img<T> create(Supplier<T> typeSupplier, int[] dim) {
        return this.create(dim, typeSupplier.get());
    }

    @Deprecated
    protected void cache(T type) {
        if (this.type == null) {
            this.type = type;
        }
    }
}

