/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.mpicbg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import mpicbg.spim.io.TextFileAccess;

public class SketchTikZFileObject {
    BufferedReader in;
    PrintWriter out;

    public SketchTikZFileObject(BufferedReader in, PrintWriter out) {
        this.in = in;
        this.out = out;
    }

    public BufferedReader getTemplate() {
        return this.in;
    }

    public PrintWriter getOutput() {
        return this.out;
    }

    public boolean finishFiles() {
        try {
            while (this.in.ready()) {
                String line = this.in.readLine();
                this.out.println(line);
            }
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            System.err.println(" Cannot close file: " + e);
            return false;
        }
        return true;
    }

    public static SketchTikZFileObject initOutputFile(String template, String output) {
        String fillOpacity = "0.5";
        String dotSize = "0.03";
        boolean reachedInsertPosition = false;
        boolean setupColors = false;
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            String line;
            in = TextFileAccess.openFileRead(template);
            out = TextFileAccess.openFileWrite(output);
            while (in.ready() && !setupColors) {
                line = in.readLine();
                out.println(line);
                if (!line.contains("% color definitions")) continue;
                out.println("");
                out.println("  def beadStyle [dotsize=0.03,draw=none,fill=black,fill opacity=0.1] ");
                out.println("  def Bead{ dots[beadStyle](0,0,0) } ");
                out.println("");
                for (int color = 0; color < 512; ++color) {
                    int green;
                    int red;
                    if (color >= 256) {
                        red = 255;
                        green = 512 - color;
                    } else {
                        green = 255;
                        red = color;
                    }
                    String colorDef = "defColor" + color;
                    String colorName = "color" + color;
                    out.println("  special |\\definecolor{" + colorDef + "}{rgb}{ " + (float)red / 255.0f + ", " + (float)green / 255.0f + ", 0}");
                    out.println("           \\tikzstyle{" + colorName + "} = [" + colorDef + "]|[lay=under]");
                    out.println("  def ransacBead" + color + "Style [dotsize=" + dotSize + ",draw=none,fill=defColor" + color + ",fill opacity=" + fillOpacity + "] ");
                    out.println("  def RansacBead" + color + "{ dots[ransacBead" + color + "Style](0,0,0) } ");
                    out.println();
                }
                out.println();
                setupColors = true;
            }
            while (in.ready() && !reachedInsertPosition) {
                line = in.readLine();
                if (line.contains("%<--for Java-->")) {
                    reachedInsertPosition = true;
                    continue;
                }
                out.println(line);
            }
        }
        catch (IOException e) {
            System.err.println("Error reading/writing template or output file: " + e);
            return null;
        }
        return new SketchTikZFileObject(in, out);
    }

    public void putTextEntry(float x, float y, String text) {
        boolean reachedInsertPosition = false;
        try {
            while (this.in.ready() && !reachedInsertPosition) {
                String line = this.in.readLine();
                if (line.contains("%<--Text for Java-->")) {
                    reachedInsertPosition = true;
                    this.out.println("def y (" + x + "," + y + ",0)");
                    this.out.println("special|\\path #1 node[left=5pt, color=black] {$\\textbf{" + text + "}$};|(y)");
                    continue;
                }
                this.out.println(line);
            }
        }
        catch (IOException e) {
            System.err.println(" Error: " + e);
            return;
        }
    }
}

