/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.compression;

import org.scijava.java3d.utils.compression.CompressionStreamVertex;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

class MeshBuffer {
    static final int NOT_FOUND = -1;
    private static final int SIZE = 16;
    private static final int NAN_HASH = new Point3f(Float.NaN, Float.NaN, Float.NaN).hashCode();
    private int topIndex = 15;
    private int[] positionIndices = new int[16];
    private int[] normalIndices = new int[16];
    private int[] colorIndices = new int[16];
    private int topPosition = 15;
    private int[] positionHashCodes = new int[16];
    private Point3f[] positions = new Point3f[16];
    private Vector3f[] normals = new Vector3f[16];
    private Color3f[] colors3 = new Color3f[16];
    private Color4f[] colors4 = new Color4f[16];
    private int topVertex = 15;
    private CompressionStreamVertex[] vertices = new CompressionStreamVertex[16];

    MeshBuffer() {
        for (int i = 0; i < 16; ++i) {
            this.positionHashCodes[i] = NAN_HASH;
            this.positionIndices[i] = -1;
            this.normalIndices[i] = -1;
            this.colorIndices[i] = -1;
        }
    }

    private static int nextTop(int top) {
        return (top + 1) % 16;
    }

    private static int flipOffset(int top, int offset) {
        if (offset > top) {
            offset -= 16;
        }
        return top - offset;
    }

    void push(CompressionStreamVertex v) {
        this.topVertex = MeshBuffer.nextTop(this.topVertex);
        this.vertices[this.topVertex] = v;
    }

    CompressionStreamVertex getVertex(int meshReference) {
        return this.vertices[MeshBuffer.flipOffset(this.topVertex, meshReference)];
    }

    void push(int positionIndex, int normalIndex) {
        this.topIndex = MeshBuffer.nextTop(this.topIndex);
        this.positionIndices[this.topIndex] = positionIndex;
        this.normalIndices[this.topIndex] = normalIndex;
    }

    void push(int positionIndex, int colorIndex, int normalIndex) {
        this.push(positionIndex, normalIndex);
        this.colorIndices[this.topIndex] = colorIndex;
    }

    int getMeshReference(int positionIndex) {
        int index;
        for (index = 0; index < 16 && this.positionIndices[index] != positionIndex; ++index) {
        }
        if (index == 16) {
            return -1;
        }
        return MeshBuffer.flipOffset(this.topIndex, index);
    }

    int getPositionIndex(int meshReference) {
        return this.positionIndices[MeshBuffer.flipOffset(this.topIndex, meshReference)];
    }

    int getColorIndex(int meshReference) {
        return this.colorIndices[MeshBuffer.flipOffset(this.topIndex, meshReference)];
    }

    int getNormalIndex(int meshReference) {
        return this.normalIndices[MeshBuffer.flipOffset(this.topIndex, meshReference)];
    }

    void push(Point3f position, Vector3f normal) {
        this.topPosition = MeshBuffer.nextTop(this.topPosition);
        this.positionHashCodes[this.topPosition] = position.hashCode();
        this.positions[this.topPosition] = position;
        this.normals[this.topPosition] = normal;
    }

    void push(Point3f position, Color3f color, Vector3f normal) {
        this.push(position, normal);
        this.colors3[this.topPosition] = color;
    }

    void push(Point3f position, Color4f color, Vector3f normal) {
        this.push(position, normal);
        this.colors4[this.topPosition] = color;
    }

    void push(Point3f position, Object color, Vector3f normal) {
        this.push(position, normal);
        if (color instanceof Color3f) {
            this.colors3[this.topPosition] = (Color3f)color;
        } else {
            this.colors4[this.topPosition] = (Color4f)color;
        }
    }

    int getMeshReference(Point3f position) {
        int index;
        int hashCode = position.hashCode();
        for (index = 0; !(index >= 16 || this.positionHashCodes[index] == hashCode && this.positions[index].equals((Tuple3f)position)); ++index) {
        }
        if (index == 16) {
            return -1;
        }
        return MeshBuffer.flipOffset(this.topPosition, index);
    }

    Point3f getPosition(int meshReference) {
        return this.positions[MeshBuffer.flipOffset(this.topPosition, meshReference)];
    }

    Color3f getColor3(int meshReference) {
        return this.colors3[MeshBuffer.flipOffset(this.topPosition, meshReference)];
    }

    Color4f getColor4(int meshReference) {
        return this.colors4[MeshBuffer.flipOffset(this.topPosition, meshReference)];
    }

    Vector3f getNormal(int meshReference) {
        return this.normals[MeshBuffer.flipOffset(this.topPosition, meshReference)];
    }
}

