/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import io.scif.formats.imaris.HDFUtils;
import io.scif.formats.imaris.PipelineImage;
import io.scif.formats.imaris.ResolutionLevel;
import javax.swing.JOptionPane;

public class TimePoint {
    private static final int HISTOGRAM_SIZE = 256;
    private final ResolutionLevel[] resLevels_;
    private final ChannelGroup[][] channelGroups_;
    private final boolean compressImageData_;

    public TimePoint(ResolutionLevel[] resLevels, long[] resLevelIDs_, int numChannels, int frameIndex, int bitDepth, boolean compressImageData) throws HDF5LibraryException, HDF5Exception {
        this.compressImageData_ = compressImageData;
        this.resLevels_ = resLevels;
        this.channelGroups_ = new ChannelGroup[resLevels.length][numChannels];
        for (int resIndex = 0; resIndex < resLevels.length; ++resIndex) {
            long timePointID = H5.H5Gcreate((long)resLevelIDs_[resIndex], (String)("TimePoint " + frameIndex), (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            ResolutionLevel resLevel = resLevels[resIndex];
            for (int channelIndex = 0; channelIndex < numChannels; ++channelIndex) {
                this.channelGroups_[resIndex][channelIndex] = new ChannelGroup(timePointID, channelIndex, resLevel, bitDepth);
            }
            H5.H5Gclose((long)timePointID);
        }
    }

    public void writePixels(PipelineImage img) throws Exception {
        int channel = img.channel;
        Object[][] imageData = (Object[][])img.pixels;
        for (int resIndex = 0; resIndex < this.resLevels_.length; ++resIndex) {
            if (img.histograms != null) {
                this.channelGroups_[resIndex][channel].writeHistogram(img, resIndex);
            }
            Object[] sliceArray = imageData[resIndex];
            for (int sliceIndex = 0; sliceIndex < sliceArray.length; ++sliceIndex) {
                if (sliceArray[sliceIndex] == null) continue;
                int dataSlice = (img.slice + sliceIndex) / this.resLevels_[resIndex].getReductionFactorZ();
                this.channelGroups_[resIndex][channel].writeSlice(this.resLevels_[resIndex].getImageSizeX(), this.resLevels_[resIndex].getImageSizeY(), dataSlice, sliceArray[sliceIndex]);
            }
        }
    }

    public void closeTimePoint() throws HDF5LibraryException, HDF5Exception {
        for (int res = 0; res < this.channelGroups_.length; ++res) {
            for (int channel = 0; channel < this.channelGroups_[0].length; ++channel) {
                this.channelGroups_[res][channel].close();
            }
        }
    }

    private class ChannelGroup {
        private final ResolutionLevel resLevel_;
        private long[] histogramIDs_;
        private long[] imageDataIDs_;

        public ChannelGroup(long timePointID, int channelIndex, ResolutionLevel resLevel, int bitDepth) throws HDF5LibraryException, HDF5Exception {
            this.resLevel_ = resLevel;
            long id = H5.H5Gcreate((long)timePointID, (String)("Channel " + channelIndex), (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            HDFUtils.writeStringAttribute(id, "HistogramMax", (int)Math.pow(2.0, bitDepth) - 1 + ".000");
            HDFUtils.writeStringAttribute(id, "HistogramMin", "0.000");
            HDFUtils.writeStringAttribute(id, "ImageBlockSizeX", "" + this.resLevel_.getXBlockSize());
            HDFUtils.writeStringAttribute(id, "ImageBlockSizeY", "" + this.resLevel_.getYBlockSize());
            HDFUtils.writeStringAttribute(id, "ImageBlockSizeZ", "" + this.resLevel_.getZBlockSize());
            HDFUtils.writeStringAttribute(id, "ImageSizeX", "" + this.resLevel_.getImageSizeX());
            HDFUtils.writeStringAttribute(id, "ImageSizeY", "" + this.resLevel_.getImageSizeY());
            HDFUtils.writeStringAttribute(id, "ImageSizeZ", "" + this.resLevel_.getImageSizeZ());
            this.histogramIDs_ = HDFUtils.createDataSet(id, "Histogram", new long[]{256L}, HDF5Constants.H5T_NATIVE_UINT64);
            this.imageDataIDs_ = TimePoint.this.compressImageData_ ? HDFUtils.createCompressedDataSet(id, "Data", new long[]{resLevel.getContainerSizeZ(), resLevel.getContainerSizeY(), resLevel.getContainerSizeX()}, resLevel.getImageByteDepth() == 1 ? HDF5Constants.H5T_NATIVE_UCHAR : HDF5Constants.H5T_NATIVE_UINT16, new long[]{resLevel.getZBlockSize(), resLevel.getYBlockSize(), resLevel.getXBlockSize()}) : HDFUtils.createDataSet(id, "Data", new long[]{resLevel.getContainerSizeZ(), resLevel.getContainerSizeY(), resLevel.getContainerSizeX()}, resLevel.getImageByteDepth() == 1 ? HDF5Constants.H5T_NATIVE_UCHAR : HDF5Constants.H5T_NATIVE_UINT16);
            H5.H5Gclose((long)id);
        }

        private void writeHistogram(PipelineImage img, int resIndex) throws HDF5LibraryException, HDF5Exception {
            long memDataSpaceID = H5.H5Screate_simple((int)1, (long[])new long[]{256L}, null);
            try {
                long[] histogram = img.histograms[resIndex];
                H5.H5Dwrite_long((long)this.histogramIDs_[2], (long)this.histogramIDs_[1], (long)memDataSpaceID, (long)this.histogramIDs_[0], (long)HDF5Constants.H5P_DEFAULT, (long[])histogram);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Couldn't write histogram: channel " + img.channel + " slice: " + img.slice + " frame: " + img.frame + " resIndex: " + resIndex);
            }
            H5.H5Sclose((long)memDataSpaceID);
            this.closeHistograms();
            this.histogramIDs_ = null;
        }

        private void closeHistograms() throws HDF5LibraryException {
            H5.H5Sclose((long)this.histogramIDs_[0]);
            H5.H5Tclose((long)this.histogramIDs_[1]);
            H5.H5Dclose((long)this.histogramIDs_[2]);
        }

        private void close() throws HDF5LibraryException, HDF5Exception {
            if (this.histogramIDs_ != null) {
                this.closeHistograms();
            }
            H5.H5Sclose((long)this.imageDataIDs_[0]);
            H5.H5Tclose((long)this.imageDataIDs_[1]);
            H5.H5Dclose((long)this.imageDataIDs_[2]);
            if (TimePoint.this.compressImageData_) {
                H5.H5Pclose((long)this.imageDataIDs_[3]);
            }
            this.imageDataIDs_ = null;
        }

        private void writeSlice(int width, int height, int dataSlice, Object pixels) throws Exception {
            long[] start = new long[]{dataSlice, 0L, 0L};
            long[] count = new long[]{1L, height, width};
            int ret = H5.H5Sselect_hyperslab((long)this.imageDataIDs_[0], (int)HDF5Constants.H5S_SELECT_SET, (long[])start, null, (long[])count, null);
            long memDataSpaceID = H5.H5Screate_simple((int)1, (long[])new long[]{width * height}, null);
            ret = H5.H5Sselect_all((long)memDataSpaceID);
            ret = H5.H5Dwrite((long)this.imageDataIDs_[2], (long)(pixels instanceof byte[] ? HDF5Constants.H5T_NATIVE_UCHAR : HDF5Constants.H5T_NATIVE_UINT16), (long)memDataSpaceID, (long)this.imageDataIDs_[0], (long)HDF5Constants.H5P_DEFAULT, (Object)pixels);
            H5.H5Sclose((long)memDataSpaceID);
        }
    }
}

