/*
 * Decompiled with CFR 0.152.
 */
package fiji.color;

import fiji.color.Convert_Red_To_Magenta;
import ij.IJ;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;

public class Convert_Red_To_Magenta_Clipboard
implements PlugIn {
    public void run(String arg) {
        Convert_Red_To_Magenta_Clipboard.processSystemClipboard();
    }

    public static void processSystemClipboard() {
        ColorProcessor ip = Convert_Red_To_Magenta_Clipboard.getClipboardImage();
        if (ip == null) {
            return;
        }
        Convert_Red_To_Magenta.process(ip);
        Convert_Red_To_Magenta_Clipboard.copyImageToClipboard(ip);
    }

    public static ColorProcessor getClipboardImage() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            boolean imageSupported = transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
            if (!imageSupported) {
                return null;
            }
            Image img = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            if (img == null) {
                return null;
            }
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D g = bi.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
            return new ColorProcessor((Image)bi);
        }
        catch (Throwable e) {
            IJ.handleException((Throwable)e);
            return null;
        }
    }

    public static void copyImageToClipboard(final ColorProcessor ip) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.imageFlavor.equals(flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    if (!this.isDataFlavorSupported(flavor)) {
                        throw new UnsupportedFlavorException(flavor);
                    }
                    int w = ip.getWidth();
                    int h = ip.getHeight();
                    Image img = IJ.getInstance().createImage(w, h);
                    Graphics g = img.getGraphics();
                    g.drawImage(ip.createImage(), 0, 0, null);
                    g.dispose();
                    return img;
                }
            }, null);
        }
        catch (Throwable e) {
            IJ.handleException((Throwable)e);
        }
    }
}

