/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.BayesNetGenerator;
import weka.classifiers.bayes.net.EditableBayesNet;
import weka.classifiers.bayes.net.MarginCalculator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffSaver;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.gui.ConverterFileChooser;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.PropertyDialog;
import weka.gui.WekaFileChooser;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.BIFParser;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.HierarchicalBCEngine;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.visualize.PrintablePanel;

public class GUI
extends JPanel
implements LayoutCompleteEventListener {
    private static final long serialVersionUID = -2038911085935515624L;
    protected LayoutEngine m_layoutEngine;
    protected GraphPanel m_GraphPanel;
    EditableBayesNet m_BayesNet = new EditableBayesNet(true);
    protected String m_sFileName = "";
    MarginCalculator m_marginCalculator = null;
    MarginCalculator m_marginCalculatorWithEvidence = null;
    boolean m_bViewMargins = false;
    boolean m_bViewCliques = false;
    private JMenuBar m_menuBar;
    Instances m_Instances = null;
    final JTextField m_jTfZoom;
    final JToolBar m_jTbTools;
    final JLabel m_jStatusBar;
    private final JTextField m_jTfNodeWidth = new JTextField(3);
    private final JTextField m_jTfNodeHeight = new JTextField(3);
    JScrollPane m_jScrollPane;
    private final String ICONPATH = "weka/classifiers/bayes/net/icons/";
    private double m_fScale = 1.0;
    private int m_nNodeHeight = 2 * this.getFontMetrics(this.getFont()).getHeight();
    static final int DEFAULT_NODE_WIDTH = 50;
    private int m_nNodeWidth = 50;
    static final int PADDING = 10;
    private int m_nPaddedNodeWidth = 60;
    private final int[] m_nZoomPercents = new int[]{10, 25, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300, 350, 400, 450, 500, 550, 600, 650, 700, 800, 900, 999};
    Action a_new = new ActionNew();
    Action a_quit = new ActionQuit();
    Action a_save = new ActionSave();
    ActionExport a_export = new ActionExport();
    ActionPrint a_print = new ActionPrint();
    Action a_load = new ActionLoad();
    Action a_zoomin = new ActionZoomIn();
    Action a_zoomout = new ActionZoomOut();
    Action a_layout = new ActionLayout();
    Action a_saveas = new ActionSaveAs();
    Action a_viewtoolbar = new ActionViewToolbar();
    Action a_viewstatusbar = new ActionViewStatusbar();
    Action a_networkgenerator = new ActionGenerateNetwork();
    Action a_datagenerator = new ActionGenerateData();
    Action a_datasetter = new ActionSetData();
    Action a_learn = new ActionLearn();
    Action a_learnCPT = new ActionLearnCPT();
    Action a_help = new ActionHelp();
    Action a_about = new ActionAbout();
    ActionAddNode a_addnode = new ActionAddNode();
    Action a_delnode = new ActionDeleteNode();
    Action a_cutnode = new ActionCutNode();
    Action a_copynode = new ActionCopyNode();
    Action a_pastenode = new ActionPasteNode();
    Action a_selectall = new ActionSelectAll();
    Action a_addarc = new ActionAddArc();
    Action a_delarc = new ActionDeleteArc();
    Action a_undo = new ActionUndo();
    Action a_redo = new ActionRedo();
    Action a_alignleft = new ActionAlignLeft();
    Action a_alignright = new ActionAlignRight();
    Action a_aligntop = new ActionAlignTop();
    Action a_alignbottom = new ActionAlignBottom();
    Action a_centerhorizontal = new ActionCenterHorizontal();
    Action a_centervertical = new ActionCenterVertical();
    Action a_spacehorizontal = new ActionSpaceHorizontal();
    Action a_spacevertical = new ActionSpaceVertical();
    int m_nCurrentNode = -1;
    Selection m_Selection = new Selection();
    Rectangle m_nSelectedRect = null;
    ClipBoard m_clipboard = new ClipBoard();

    public GUI() {
        this.m_GraphPanel = new GraphPanel();
        this.m_jScrollPane = new JScrollPane(this.m_GraphPanel);
        this.m_jTfZoom = new JTextField("100%");
        this.m_jTfZoom.setMinimumSize(this.m_jTfZoom.getPreferredSize());
        this.m_jTfZoom.setHorizontalAlignment(0);
        this.m_jTfZoom.setToolTipText("Zoom");
        this.m_jTfZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JTextField jt = (JTextField)ae.getSource();
                try {
                    int i = -1;
                    i = jt.getText().indexOf(37);
                    i = i == -1 ? Integer.parseInt(jt.getText()) : Integer.parseInt(jt.getText().substring(0, i));
                    if (i <= 999) {
                        GUI.this.m_fScale = (double)i / 100.0;
                    }
                    jt.setText((int)(GUI.this.m_fScale * 100.0) + "%");
                    if (GUI.this.m_fScale > 0.1) {
                        if (!GUI.this.a_zoomout.isEnabled()) {
                            GUI.this.a_zoomout.setEnabled(true);
                        }
                    } else {
                        GUI.this.a_zoomout.setEnabled(false);
                    }
                    if (GUI.this.m_fScale < 9.99) {
                        if (!GUI.this.a_zoomin.isEnabled()) {
                            GUI.this.a_zoomin.setEnabled(true);
                        }
                    } else {
                        GUI.this.a_zoomin.setEnabled(false);
                    }
                    GUI.this.setAppropriateSize();
                    GUI.this.m_GraphPanel.repaint();
                    GUI.this.m_GraphPanel.invalidate();
                    GUI.this.m_jScrollPane.revalidate();
                }
                catch (NumberFormatException ne) {
                    JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for zoom.", "Error", 0);
                    jt.setText(GUI.this.m_fScale * 100.0 + "%");
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("ExtraControls"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        p.setPreferredSize(new Dimension(0, 0));
        this.m_jTbTools = new JToolBar();
        this.m_jTbTools.setFloatable(false);
        this.m_jTbTools.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.m_jTbTools.add((Component)p, gbc);
        gbc.gridwidth = 1;
        this.m_jTbTools.add(this.a_new);
        this.m_jTbTools.add(this.a_save);
        this.m_jTbTools.add(this.a_load);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_cutnode);
        this.m_jTbTools.add(this.a_copynode);
        this.m_jTbTools.add(this.a_pastenode);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_undo);
        this.m_jTbTools.add(this.a_redo);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_alignleft);
        this.m_jTbTools.add(this.a_alignright);
        this.m_jTbTools.add(this.a_aligntop);
        this.m_jTbTools.add(this.a_alignbottom);
        this.m_jTbTools.add(this.a_centerhorizontal);
        this.m_jTbTools.add(this.a_centervertical);
        this.m_jTbTools.add(this.a_spacehorizontal);
        this.m_jTbTools.add(this.a_spacevertical);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_zoomin);
        gbc.fill = 3;
        gbc.weighty = 1.0;
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setPreferredSize(this.m_jTfZoom.getPreferredSize());
        p2.setMinimumSize(this.m_jTfZoom.getPreferredSize());
        p2.add((Component)this.m_jTfZoom, "Center");
        this.m_jTbTools.add((Component)p2, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.m_jTbTools.add(this.a_zoomout);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_layout);
        this.m_jTbTools.addSeparator(new Dimension(4, 2));
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.m_jStatusBar = new JLabel("Status bar");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jTbTools, "North");
        this.add((Component)this.m_jScrollPane, "Center");
        this.add((Component)this.m_jStatusBar, "South");
        this.updateStatus();
        this.a_datagenerator.setEnabled(false);
        this.makeMenuBar();
    }

    public JMenuBar getMenuBar() {
        return this.m_menuBar;
    }

    private void makeMenuBar() {
        this.m_menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.m_menuBar.add(fileMenu);
        fileMenu.add(this.a_new);
        fileMenu.add(this.a_load);
        fileMenu.add(this.a_save);
        fileMenu.add(this.a_saveas);
        fileMenu.addSeparator();
        fileMenu.add(this.a_print);
        fileMenu.add(this.a_export);
        fileMenu.addSeparator();
        fileMenu.add(this.a_quit);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        this.m_menuBar.add(editMenu);
        editMenu.add(this.a_undo);
        editMenu.add(this.a_redo);
        editMenu.addSeparator();
        editMenu.add(this.a_selectall);
        editMenu.add(this.a_delnode);
        editMenu.add(this.a_cutnode);
        editMenu.add(this.a_copynode);
        editMenu.add(this.a_pastenode);
        editMenu.addSeparator();
        editMenu.add(this.a_addnode);
        editMenu.add(this.a_addarc);
        editMenu.add(this.a_delarc);
        editMenu.addSeparator();
        editMenu.add(this.a_alignleft);
        editMenu.add(this.a_alignright);
        editMenu.add(this.a_aligntop);
        editMenu.add(this.a_alignbottom);
        editMenu.add(this.a_centerhorizontal);
        editMenu.add(this.a_centervertical);
        editMenu.add(this.a_spacehorizontal);
        editMenu.add(this.a_spacevertical);
        JMenu toolMenu = new JMenu("Tools");
        toolMenu.setMnemonic('T');
        toolMenu.add(this.a_networkgenerator);
        toolMenu.add(this.a_datagenerator);
        toolMenu.add(this.a_datasetter);
        toolMenu.add(this.a_learn);
        toolMenu.add(this.a_learnCPT);
        toolMenu.addSeparator();
        toolMenu.add(this.a_layout);
        toolMenu.addSeparator();
        final JCheckBoxMenuItem viewMargins = new JCheckBoxMenuItem("Show Margins", false);
        viewMargins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean bPrev = GUI.this.m_bViewMargins;
                GUI.this.m_bViewMargins = viewMargins.getState();
                if (!bPrev && viewMargins.getState()) {
                    GUI.this.updateStatus();
                }
                GUI.this.repaint();
            }
        });
        toolMenu.add(viewMargins);
        final JCheckBoxMenuItem viewCliques = new JCheckBoxMenuItem("Show Cliques", false);
        viewCliques.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean bPrev = GUI.this.m_bViewCliques;
                GUI.this.m_bViewCliques = viewCliques.getState();
                if (!bPrev && viewCliques.getState()) {
                    GUI.this.updateStatus();
                }
                GUI.this.repaint();
            }
        });
        toolMenu.add(viewCliques);
        this.m_menuBar.add(toolMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        this.m_menuBar.add(viewMenu);
        viewMenu.add(this.a_zoomin);
        viewMenu.add(this.a_zoomout);
        viewMenu.addSeparator();
        viewMenu.add(this.a_viewtoolbar);
        viewMenu.add(this.a_viewstatusbar);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        this.m_menuBar.add(helpMenu);
        helpMenu.add(this.a_help);
        helpMenu.add(this.a_about);
    }

    protected void setAppropriateNodeSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int nMaxStringWidth = 50;
        if (nMaxStringWidth == 0) {
            for (int iNode = 0; iNode < this.m_BayesNet.getNrOfNodes(); ++iNode) {
                int strWidth = fm.stringWidth(this.m_BayesNet.getNodeName(iNode));
                if (strWidth <= nMaxStringWidth) continue;
                nMaxStringWidth = strWidth;
            }
        }
        this.m_nNodeWidth = nMaxStringWidth + 4;
        this.m_nPaddedNodeWidth = this.m_nNodeWidth + 10;
        this.m_jTfNodeWidth.setText("" + this.m_nNodeWidth);
        this.m_nNodeHeight = 2 * fm.getHeight();
        this.m_jTfNodeHeight.setText("" + this.m_nNodeHeight);
    }

    public void setAppropriateSize() {
        int maxX = 0;
        int maxY = 0;
        this.m_GraphPanel.setScale(this.m_fScale, this.m_fScale);
        for (int iNode = 0; iNode < this.m_BayesNet.getNrOfNodes(); ++iNode) {
            int nPosX = this.m_BayesNet.getPositionX(iNode);
            int nPosY = this.m_BayesNet.getPositionY(iNode);
            if (maxX < nPosX) {
                maxX = nPosX + 100;
            }
            if (maxY >= nPosY) continue;
            maxY = nPosY;
        }
        this.m_GraphPanel.setPreferredSize(new Dimension((int)((double)(maxX + this.m_nPaddedNodeWidth + 2) * this.m_fScale), (int)((double)(maxY + this.m_nNodeHeight + 2) * this.m_fScale)));
        this.m_GraphPanel.revalidate();
    }

    @Override
    public void layoutCompleted(LayoutCompleteEvent le) {
        LayoutEngine layoutEngine = this.m_layoutEngine;
        ArrayList<Integer> nPosX = new ArrayList<Integer>(this.m_BayesNet.getNrOfNodes());
        ArrayList<Integer> nPosY = new ArrayList<Integer>(this.m_BayesNet.getNrOfNodes());
        for (int iNode = 0; iNode < layoutEngine.getNodes().size(); ++iNode) {
            GraphNode gNode = layoutEngine.getNodes().get(iNode);
            if (gNode.nodeType != 3) continue;
            nPosX.add(gNode.x);
            nPosY.add(gNode.y);
        }
        this.m_BayesNet.layoutGraph(nPosX, nPosY);
        this.m_jStatusBar.setText("Graph layed out");
        this.a_undo.setEnabled(true);
        this.a_redo.setEnabled(false);
        this.setAppropriateSize();
        this.m_GraphPanel.invalidate();
        this.m_jScrollPane.revalidate();
        this.m_GraphPanel.repaint();
    }

    public void readBIFFromFile(String sFileName) throws BIFFormatException, IOException {
        this.m_sFileName = sFileName;
        try {
            BIFReader bayesNet = new BIFReader();
            bayesNet.processFile(sFileName);
            this.m_BayesNet = new EditableBayesNet(bayesNet);
            this.updateStatus();
            this.a_datagenerator.setEnabled(this.m_BayesNet.getNrOfNodes() > 0);
            this.m_BayesNet.clearUndoStack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        this.setAppropriateSize();
    }

    void initFromArffFile(String sFileName) {
        try {
            Instances instances = new Instances(new FileReader(sFileName));
            this.m_BayesNet = new EditableBayesNet(instances);
            this.m_Instances = instances;
            this.a_learn.setEnabled(true);
            this.a_learnCPT.setEnabled(true);
            this.setAppropriateNodeSize();
            this.setAppropriateSize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    void layoutGraph() {
        if (this.m_BayesNet.getNrOfNodes() == 0) {
            return;
        }
        try {
            ArrayList<GraphNode> m_nodes = new ArrayList<GraphNode>();
            ArrayList<GraphEdge> m_edges = new ArrayList<GraphEdge>();
            BIFParser bp = new BIFParser(this.m_BayesNet.toXMLBIF03(), m_nodes, m_edges);
            bp.parse();
            this.updateStatus();
            this.m_layoutEngine = new HierarchicalBCEngine(m_nodes, m_edges, this.m_nPaddedNodeWidth, this.m_nNodeHeight);
            this.m_layoutEngine.addLayoutCompleteEventListener(this);
            this.m_layoutEngine.layoutGraph();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateStatus() {
        this.a_undo.setEnabled(this.m_BayesNet.canUndo());
        this.a_redo.setEnabled(this.m_BayesNet.canRedo());
        this.a_datagenerator.setEnabled(this.m_BayesNet.getNrOfNodes() > 0);
        if (!this.m_bViewMargins && !this.m_bViewCliques) {
            this.repaint();
            return;
        }
        try {
            int iNode;
            this.m_marginCalculator = new MarginCalculator();
            this.m_marginCalculator.calcMargins(this.m_BayesNet);
            SerializedObject so = new SerializedObject(this.m_marginCalculator);
            this.m_marginCalculatorWithEvidence = (MarginCalculator)so.getObject();
            for (iNode = 0; iNode < this.m_BayesNet.getNrOfNodes(); ++iNode) {
                if (this.m_BayesNet.getEvidence(iNode) < 0) continue;
                this.m_marginCalculatorWithEvidence.setEvidence(iNode, this.m_BayesNet.getEvidence(iNode));
            }
            for (iNode = 0; iNode < this.m_BayesNet.getNrOfNodes(); ++iNode) {
                this.m_BayesNet.setMargin(iNode, this.m_marginCalculatorWithEvidence.getMargin(iNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    void addArcInto(int iChild) {
        String sChild = this.m_BayesNet.getNodeName(iChild);
        try {
            int nNodes = this.m_BayesNet.getNrOfNodes();
            boolean[] isNotAllowedAsParent = new boolean[nNodes];
            isNotAllowedAsParent[iChild] = true;
            for (int i = 0; i < nNodes; ++i) {
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    for (int iParent = 0; iParent < this.m_BayesNet.getNrOfParents(iNode); ++iParent) {
                        if (!isNotAllowedAsParent[this.m_BayesNet.getParent(iNode, iParent)]) continue;
                        isNotAllowedAsParent[iNode] = true;
                    }
                }
            }
            for (int iParent = 0; iParent < this.m_BayesNet.getNrOfParents(iChild); ++iParent) {
                isNotAllowedAsParent[this.m_BayesNet.getParent((int)iChild, (int)iParent)] = true;
            }
            int nCandidates = 0;
            for (int i = 0; i < nNodes; ++i) {
                if (isNotAllowedAsParent[i]) continue;
                ++nCandidates;
            }
            if (nCandidates == 0) {
                JOptionPane.showMessageDialog(null, "No potential parents available for this node (" + sChild + "). Choose another node as child node.");
                return;
            }
            Object[] options = new String[nCandidates];
            int k = 0;
            for (int i = 0; i < nNodes; ++i) {
                if (isNotAllowedAsParent[i]) continue;
                options[k++] = this.m_BayesNet.getNodeName(i);
            }
            String sParent = (String)JOptionPane.showInputDialog(null, "Select parent node for " + sChild, "Nodes", 0, null, options, options[0]);
            if (sParent == null || sParent.equals("")) {
                return;
            }
            this.m_BayesNet.addArc(sParent, sChild);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
            this.updateStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void deleteArc(int iChild, String sParent) {
        try {
            this.m_BayesNet.deleteArc(this.m_BayesNet.getNode(sParent), iChild);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    void deleteArc(String sChild, int iParent) {
        try {
            this.m_BayesNet.deleteArc(iParent, this.m_BayesNet.getNode(sChild));
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    void deleteArc(String[] options) {
        String sResult = (String)JOptionPane.showInputDialog(null, "Select arc to delete", "Arcs", 0, null, options, options[0]);
        if (sResult != null && !sResult.equals("")) {
            int nPos = sResult.indexOf(" -> ");
            String sParent = sResult.substring(0, nPos);
            String sChild = sResult.substring(nPos + 4);
            try {
                this.m_BayesNet.deleteArc(sParent, sChild);
                this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateStatus();
        }
    }

    void renameNode(int nTargetNode) {
        String sName = JOptionPane.showInputDialog(null, this.m_BayesNet.getNodeName(nTargetNode), "New name for node", 2);
        if (sName == null || sName.equals("")) {
            return;
        }
        try {
            while (this.m_BayesNet.getNode2(sName) >= 0) {
                sName = JOptionPane.showInputDialog(null, (Object)("Cannot rename to " + sName + ".\nNode with that name already exists."));
                if (sName != null && !sName.equals("")) continue;
                return;
            }
            this.m_BayesNet.setNodeName(nTargetNode, sName);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    void renameValue(int nTargetNode, String sValue) {
        String sNewValue = JOptionPane.showInputDialog(null, "New name for value " + sValue, "Node " + this.m_BayesNet.getNodeName(nTargetNode), 2);
        if (sNewValue == null || sNewValue.equals("")) {
            return;
        }
        this.m_BayesNet.renameNodeValue(nTargetNode, sValue, sNewValue);
        this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        this.a_undo.setEnabled(true);
        this.a_redo.setEnabled(false);
        this.repaint();
    }

    void deleteNode(int iNode) {
        try {
            this.m_BayesNet.deleteNode(iNode);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    void addValue() {
        String sValue = "Value" + (this.m_BayesNet.getCardinality(this.m_nCurrentNode) + 1);
        String sNewValue = JOptionPane.showInputDialog(null, "New value " + sValue, "Node " + this.m_BayesNet.getNodeName(this.m_nCurrentNode), 2);
        if (sNewValue == null || sNewValue.equals("")) {
            return;
        }
        try {
            this.m_BayesNet.addNodeValue(this.m_nCurrentNode, sNewValue);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    void delValue(int nTargetNode, String sValue) {
        try {
            this.m_BayesNet.delNodeValue(nTargetNode, sValue);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    void editCPT(int nTargetNode) {
        this.m_nCurrentNode = nTargetNode;
        final GraphVisualizerTableModel tm = new GraphVisualizerTableModel(nTargetNode);
        JTable jTblProbs = new JTable(tm);
        JScrollPane js = new JScrollPane(jTblProbs);
        int nParents = this.m_BayesNet.getNrOfParents(nTargetNode);
        if (nParents > 0) {
            int iParent2;
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel jPlRowHeader = new JPanel(new GridBagLayout());
            int[] idx = new int[nParents];
            int[] lengths = new int[nParents];
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 1, 0, 0);
            int addNum = 0;
            int temp = 0;
            boolean dark = false;
            block0: do {
                int iParent22;
                int k;
                gbc.gridwidth = 1;
                for (k = 0; k < nParents; ++k) {
                    iParent22 = this.m_BayesNet.getParent(nTargetNode, k);
                    JLabel lb = new JLabel(this.m_BayesNet.getValueName(iParent22, idx[k]));
                    lb.setFont(new Font("Dialog", 0, 12));
                    lb.setOpaque(true);
                    lb.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                    lb.setHorizontalAlignment(0);
                    if (dark) {
                        lb.setBackground(lb.getBackground().darker());
                        lb.setForeground(Color.white);
                    } else {
                        lb.setForeground(Color.black);
                    }
                    temp = lb.getPreferredSize().width;
                    lb.setPreferredSize(new Dimension(temp, jTblProbs.getRowHeight()));
                    if (lengths[k] < temp) {
                        lengths[k] = temp;
                    }
                    temp = 0;
                    if (k == nParents - 1) {
                        gbc.gridwidth = 0;
                        dark = !dark;
                    }
                    jPlRowHeader.add((Component)lb, gbc);
                    ++addNum;
                }
                for (k = nParents - 1; k >= 0; --k) {
                    iParent22 = this.m_BayesNet.getParent(this.m_nCurrentNode, k);
                    if (idx[k] != this.m_BayesNet.getCardinality(iParent22) - 1 || k == 0) {
                        int n = k;
                        idx[n] = idx[n] + 1;
                        continue block0;
                    }
                    idx[k] = 0;
                }
            } while (idx[0] != this.m_BayesNet.getCardinality(iParent2 = this.m_BayesNet.getParent(this.m_nCurrentNode, 0)));
            JLabel lb = (JLabel)jPlRowHeader.getComponent(addNum - 1);
            jPlRowHeader.remove(addNum - 1);
            lb.setPreferredSize(new Dimension(lb.getPreferredSize().width, jTblProbs.getRowHeight()));
            gbc.gridwidth = 0;
            gbc.weighty = 1.0;
            jPlRowHeader.add((Component)lb, gbc);
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            JPanel jPlRowNames = new JPanel(new GridBagLayout());
            for (int j = 0; j < nParents; ++j) {
                JLabel lb1 = new JLabel(this.m_BayesNet.getNodeName(this.m_BayesNet.getParent(nTargetNode, j)));
                lb1.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                Dimension tempd = lb1.getPreferredSize();
                if (tempd.width < lengths[j]) {
                    lb1.setPreferredSize(new Dimension(lengths[j], tempd.height));
                    lb1.setHorizontalAlignment(0);
                    lb1.setMinimumSize(new Dimension(lengths[j], tempd.height));
                } else if (tempd.width > lengths[j]) {
                    JLabel lb2 = (JLabel)jPlRowHeader.getComponent(j);
                    lb2.setPreferredSize(new Dimension(tempd.width, lb2.getPreferredSize().height));
                }
                jPlRowNames.add((Component)lb1, gbc);
            }
            js.setRowHeaderView(jPlRowHeader);
            js.setCorner("UPPER_LEFT_CORNER", jPlRowNames);
        }
        final JDialog dlg = new JDialog((Frame)this.getTopLevelAncestor(), "Probability Distribution Table For " + this.m_BayesNet.getNodeName(nTargetNode), true);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)js, "Center");
        JButton jBtRandomize = new JButton("Randomize");
        jBtRandomize.setMnemonic('R');
        jBtRandomize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                tm.randomize();
                dlg.repaint();
            }
        });
        JButton jBtOk = new JButton("Ok");
        jBtOk.setMnemonic('O');
        jBtOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                tm.setData();
                try {
                    GUI.this.m_BayesNet.setDistribution(GUI.this.m_nCurrentNode, tm.m_fProbs);
                    GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                    GUI.this.updateStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dlg.setVisible(false);
            }
        });
        JButton jBtCancel = new JButton("Cancel");
        jBtCancel.setMnemonic('C');
        jBtCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dlg.setVisible(false);
            }
        });
        Container c = new Container();
        c.setLayout(new GridBagLayout());
        c.add(jBtRandomize);
        c.add(jBtOk);
        c.add(jBtCancel);
        dlg.getContentPane().add((Component)c, "South");
        dlg.pack();
        dlg.setSize(450, 350);
        dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
        dlg.setVisible(true);
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        JFrame jf = new JFrame("Bayes Network Editor");
        GUI g = new GUI();
        JMenuBar menuBar = g.getMenuBar();
        if (args.length > 0) {
            try {
                g.readBIFFromFile(args[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (BIFFormatException bf) {
                bf.printStackTrace();
                System.exit(-1);
            }
        }
        jf.setJMenuBar(menuBar);
        jf.getContentPane().add(g);
        jf.setDefaultCloseOperation(3);
        jf.setSize(800, 600);
        jf.setVisible(true);
        g.m_Selection.updateGUI();
        GenericObjectEditor.registerEditors();
    }

    class ActionNew
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionNew() {
            super("New", "New Network", "new", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_sFileName = "";
            GUI.this.m_BayesNet = new EditableBayesNet(true);
            GUI.this.updateStatus();
            GUI.this.layoutGraph();
            GUI.this.a_datagenerator.setEnabled(false);
            GUI.this.m_BayesNet.clearUndoStack();
            GUI.this.m_jStatusBar.setText("New Network");
            GUI.this.m_Selection = new Selection();
            GUI.this.repaint();
        }
    }

    class ActionQuit
    extends ActionSave {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionQuit() {
            super("Exit", "Exit Program", "exit", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (GUI.this.m_BayesNet.isChanged()) {
                int result = JOptionPane.showConfirmDialog(null, "Network changed. Do you want to save it?", "Save before closing?", 1);
                if (result == 2) {
                    return;
                }
                if (result == 0 && !this.saveAs()) {
                    return;
                }
            }
            System.exit(0);
        }
    }

    class ActionSave
    extends MyAction {
        private static final long serialVersionUID = -20389110859355156L;
        ExtensionFileFilter ef1;

        public ActionSave() {
            super("Save", "Save Graph", "save", "ctrl S");
            this.ef1 = new ExtensionFileFilter(".xml", "XML BIF files");
        }

        public ActionSave(String sName, String sToolTipText, String sIcon, String sAcceleratorKey) {
            super(sName, sToolTipText, sIcon, sAcceleratorKey);
            this.ef1 = new ExtensionFileFilter(".xml", "XML BIF files");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!GUI.this.m_sFileName.equals("")) {
                this.saveFile(GUI.this.m_sFileName);
                GUI.this.m_BayesNet.isSaved();
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            } else if (this.saveAs()) {
                GUI.this.m_BayesNet.isSaved();
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            }
        }

        boolean saveAs() {
            int rval;
            WekaFileChooser fc = new WekaFileChooser(System.getProperty("user.dir"));
            fc.addChoosableFileFilter(this.ef1);
            fc.setDialogTitle("Save Graph As");
            if (!GUI.this.m_sFileName.equals("")) {
                fc.setSelectedFile(new File(GUI.this.m_sFileName));
            }
            if ((rval = fc.showSaveDialog(GUI.this)) == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (!sFileName.endsWith(".xml")) {
                    sFileName = sFileName.concat(".xml");
                }
                this.saveFile(sFileName);
                return true;
            }
            return false;
        }

        protected void saveFile(String sFileName) {
            try {
                FileWriter outfile = new FileWriter(sFileName);
                outfile.write(GUI.this.m_BayesNet.toXMLBIF03());
                outfile.close();
                GUI.this.m_sFileName = sFileName;
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ActionExport
    extends MyAction {
        boolean m_bIsExporting;
        private static final long serialVersionUID = -3027642085935519L;

        public ActionExport() {
            super("Export", "Export to graphics file", "export", "");
            this.m_bIsExporting = false;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.m_bIsExporting = true;
            GUI.this.m_GraphPanel.saveComponent();
            this.m_bIsExporting = false;
            GUI.this.repaint();
        }

        public boolean isExporting() {
            return this.m_bIsExporting;
        }
    }

    class ActionPrint
    extends ActionSave {
        private static final long serialVersionUID = -20389001859354L;
        boolean m_bIsPrinting;

        public ActionPrint() {
            super("Print", "Print Graph", "print", "ctrl P");
            this.m_bIsPrinting = false;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(GUI.this.m_GraphPanel);
            if (printJob.printDialog()) {
                try {
                    this.m_bIsPrinting = true;
                    printJob.print();
                    this.m_bIsPrinting = false;
                }
                catch (PrinterException pe) {
                    GUI.this.m_jStatusBar.setText("Error printing: " + pe);
                    this.m_bIsPrinting = false;
                }
            }
            GUI.this.m_jStatusBar.setText("Print");
        }

        public boolean isPrinting() {
            return this.m_bIsPrinting;
        }
    }

    class ActionLoad
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionLoad() {
            super("Load", "Load Graph", "open", "ctrl O");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            WekaFileChooser fc = new WekaFileChooser(System.getProperty("user.dir"));
            ExtensionFileFilter ef1 = new ExtensionFileFilter(".arff", "ARFF files");
            ExtensionFileFilter ef2 = new ExtensionFileFilter(".xml", "XML BIF files");
            fc.addChoosableFileFilter(ef1);
            fc.addChoosableFileFilter(ef2);
            fc.setDialogTitle("Load Graph");
            int rval = fc.showOpenDialog(GUI.this);
            if (rval == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (sFileName.endsWith(ef1.getExtensions()[0])) {
                    GUI.this.initFromArffFile(sFileName);
                } else {
                    try {
                        GUI.this.readBIFFromFile(sFileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GUI.this.m_jStatusBar.setText("Loaded " + sFileName);
                GUI.this.updateStatus();
            }
        }
    }

    class ActionZoomIn
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionZoomIn() {
            super("Zoom in", "Zoom in", "zoomin", "+");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i = 0;
            int s = (int)(GUI.this.m_fScale * 100.0);
            i = s < 300 ? s / 25 : (s < 700 ? 6 + s / 50 : 13 + s / 100);
            if (s >= 999) {
                this.setEnabled(false);
                return;
            }
            if (s >= 10) {
                if (i >= 22) {
                    this.setEnabled(false);
                }
                if (s == 10 && !GUI.this.a_zoomout.isEnabled()) {
                    GUI.this.a_zoomout.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[i + 1] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[i + 1] / 100.0;
            } else {
                if (!GUI.this.a_zoomout.isEnabled()) {
                    GUI.this.a_zoomout.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[0] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[0] / 100.0;
            }
            GUI.this.setAppropriateSize();
            GUI.this.m_GraphPanel.repaint();
            GUI.this.m_GraphPanel.invalidate();
            GUI.this.m_jScrollPane.revalidate();
            GUI.this.m_jStatusBar.setText("Zooming in");
        }
    }

    class ActionZoomOut
    extends MyAction {
        private static final long serialVersionUID = -203891108593551L;

        public ActionZoomOut() {
            super("Zoom out", "Zoom out", "zoomout", "-");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i = 0;
            int s = (int)(GUI.this.m_fScale * 100.0);
            i = s < 300 ? (int)Math.ceil((double)s / 25.0) : (s < 700 ? 6 + (int)Math.ceil((double)s / 50.0) : 13 + (int)Math.ceil((double)s / 100.0));
            if (s <= 10) {
                this.setEnabled(false);
            } else if (s < 999) {
                if (i <= 1) {
                    this.setEnabled(false);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[i - 1] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[i - 1] / 100.0;
            } else {
                if (!GUI.this.a_zoomin.isEnabled()) {
                    GUI.this.a_zoomin.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[22] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[22] / 100.0;
            }
            GUI.this.setAppropriateSize();
            GUI.this.m_GraphPanel.repaint();
            GUI.this.m_GraphPanel.invalidate();
            GUI.this.m_jScrollPane.revalidate();
            GUI.this.m_jStatusBar.setText("Zooming out");
        }
    }

    class ActionLayout
    extends MyAction {
        private static final long serialVersionUID = -203891108593551L;
        JDialog dlg;

        public ActionLayout() {
            super("Layout", "Layout Graph", "layout", "ctrl L");
            this.dlg = null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.dlg == null) {
                this.dlg = new JDialog(SwingUtilities.getWindowAncestor(GUI.this));
                this.dlg.setTitle("Graph Layout Options");
                final JCheckBox jCbCustomNodeSize = new JCheckBox("Custom Node Size");
                final JLabel jLbNodeWidth = new JLabel("Width");
                final JLabel jLbNodeHeight = new JLabel("Height");
                GUI.this.m_jTfNodeWidth.setHorizontalAlignment(0);
                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeWidth);
                GUI.this.m_jTfNodeHeight.setHorizontalAlignment(0);
                GUI.this.m_jTfNodeHeight.setText("" + GUI.this.m_nNodeHeight);
                jLbNodeWidth.setEnabled(false);
                GUI.this.m_jTfNodeWidth.setEnabled(false);
                jLbNodeHeight.setEnabled(false);
                GUI.this.m_jTfNodeHeight.setEnabled(false);
                jCbCustomNodeSize.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (((JCheckBox)ae.getSource()).isSelected()) {
                            jLbNodeWidth.setEnabled(true);
                            GUI.this.m_jTfNodeWidth.setEnabled(true);
                            jLbNodeHeight.setEnabled(true);
                            GUI.this.m_jTfNodeHeight.setEnabled(true);
                        } else {
                            jLbNodeWidth.setEnabled(false);
                            GUI.this.m_jTfNodeWidth.setEnabled(false);
                            jLbNodeHeight.setEnabled(false);
                            GUI.this.m_jTfNodeHeight.setEnabled(false);
                            GUI.this.setAppropriateSize();
                            GUI.this.setAppropriateNodeSize();
                        }
                    }
                });
                JButton jBtLayout = new JButton("Layout Graph");
                jBtLayout.setMnemonic('L');
                jBtLayout.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (jCbCustomNodeSize.isSelected()) {
                            int tmpH;
                            int tmpW;
                            try {
                                tmpW = Integer.parseInt(GUI.this.m_jTfNodeWidth.getText());
                            }
                            catch (NumberFormatException ne) {
                                JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for node width.", "Error", 0);
                                tmpW = GUI.this.m_nNodeWidth;
                                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeWidth);
                            }
                            try {
                                tmpH = Integer.parseInt(GUI.this.m_jTfNodeHeight.getText());
                            }
                            catch (NumberFormatException ne) {
                                JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for node height.", "Error", 0);
                                tmpH = GUI.this.m_nNodeHeight;
                                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeHeight);
                            }
                            if (tmpW != GUI.this.m_nNodeWidth || tmpH != GUI.this.m_nNodeHeight) {
                                GUI.this.m_nNodeWidth = tmpW;
                                GUI.this.m_nPaddedNodeWidth = GUI.this.m_nNodeWidth + 10;
                                GUI.this.m_nNodeHeight = tmpH;
                            }
                        }
                        ActionLayout.this.dlg.setVisible(false);
                        GUI.this.updateStatus();
                        GUI.this.layoutGraph();
                        GUI.this.m_jStatusBar.setText("Laying out Bayes net");
                    }
                });
                JButton jBtCancel = new JButton("Cancel");
                jBtCancel.setMnemonic('C');
                jBtCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ActionLayout.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gbc = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container c = new Container();
                c.setLayout(new GridBagLayout());
                gbc.gridwidth = 1;
                gbc.insets = new Insets(8, 0, 0, 0);
                gbc.anchor = 18;
                gbc.gridwidth = 0;
                c.add((Component)jCbCustomNodeSize, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbNodeWidth, gbc);
                gbc.gridwidth = 0;
                c.add((Component)GUI.this.m_jTfNodeWidth, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbNodeHeight, gbc);
                gbc.gridwidth = 0;
                c.add((Component)GUI.this.m_jTfNodeHeight, gbc);
                gbc.fill = 2;
                this.dlg.add((Component)c, gbc);
                this.dlg.add(jBtLayout);
                gbc.gridwidth = 0;
                this.dlg.add(jBtCancel);
            }
            this.dlg.setSize(450, 350);
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(GUI.this));
            this.dlg.setVisible(true);
        }
    }

    class ActionSaveAs
    extends ActionSave {
        private static final long serialVersionUID = -20389110859354L;

        public ActionSaveAs() {
            super("Save As", "Save Graph As", "saveas", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.saveAs();
        }
    }

    class ActionViewToolbar
    extends MyAction {
        private static final long serialVersionUID = -20389110812354L;

        public ActionViewToolbar() {
            super("View toolbar", "View toolbar", "toolbar", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_jTbTools.setVisible(!GUI.this.m_jTbTools.isVisible());
        }
    }

    class ActionViewStatusbar
    extends MyAction {
        private static final long serialVersionUID = -20389330812354L;

        public ActionViewStatusbar() {
            super("View statusbar", "View statusbar", "statusbar", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_jStatusBar.setVisible(!GUI.this.m_jStatusBar.isVisible());
        }
    }

    class ActionGenerateNetwork
    extends MyAction {
        private static final long serialVersionUID = -2038911085935517L;
        int m_nNrOfNodes;
        int m_nNrOfArcs;
        int m_nCardinality;
        int m_nSeed;
        JDialog dlg;

        public ActionGenerateNetwork() {
            super("Generate Network", "Generate Random Bayesian Network", "generate.network", "ctrl N");
            this.m_nNrOfNodes = 10;
            this.m_nNrOfArcs = 15;
            this.m_nCardinality = 2;
            this.m_nSeed = 123;
            this.dlg = null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.dlg == null) {
                this.dlg = new JDialog(SwingUtilities.getWindowAncestor(GUI.this));
                this.dlg.setTitle("Generate Random Bayesian Network Options");
                JLabel jLbNrOfNodes = new JLabel("Nr of nodes");
                final JTextField jTfNrOfNodes = new JTextField(3);
                jTfNrOfNodes.setHorizontalAlignment(0);
                jTfNrOfNodes.setText("" + this.m_nNrOfNodes);
                JLabel jLbNrOfArcs = new JLabel("Nr of arcs");
                final JTextField jTfNrOfArcs = new JTextField(3);
                jTfNrOfArcs.setHorizontalAlignment(0);
                jTfNrOfArcs.setText("" + this.m_nNrOfArcs);
                JLabel jLbCardinality = new JLabel("Cardinality");
                final JTextField jTfCardinality = new JTextField(3);
                jTfCardinality.setHorizontalAlignment(0);
                jTfCardinality.setText("" + this.m_nCardinality);
                JLabel jLbSeed = new JLabel("Random seed");
                final JTextField jTfSeed = new JTextField(3);
                jTfSeed.setHorizontalAlignment(0);
                jTfSeed.setText("" + this.m_nSeed);
                JButton jBtGo = new JButton("Generate Network");
                jBtGo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            BayesNetGenerator generator = new BayesNetGenerator();
                            GUI.this.m_BayesNet = generator;
                            GUI.this.m_BayesNet.clearUndoStack();
                            String[] options = new String[]{"-N", "" + jTfNrOfNodes.getText(), "-A", "" + jTfNrOfArcs.getText(), "-C", "" + jTfCardinality.getText(), "-S", "" + jTfSeed.getText()};
                            generator.setOptions(options);
                            generator.generateRandomNetwork();
                            BIFReader bifReader = new BIFReader();
                            bifReader.processString(GUI.this.m_BayesNet.toXMLBIF03());
                            GUI.this.m_BayesNet = new EditableBayesNet(bifReader);
                            GUI.this.updateStatus();
                            GUI.this.layoutGraph();
                            GUI.this.a_datagenerator.setEnabled(true);
                            GUI.this.m_Instances = null;
                            GUI.this.a_learn.setEnabled(false);
                            GUI.this.a_learnCPT.setEnabled(false);
                            ActionGenerateNetwork.this.dlg.setVisible(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                JButton jBtCancel = new JButton("Cancel");
                jBtCancel.setMnemonic('C');
                jBtCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ActionGenerateNetwork.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gbc = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container c = new Container();
                c.setLayout(new GridBagLayout());
                gbc.gridwidth = 2;
                gbc.insets = new Insets(8, 0, 0, 0);
                gbc.anchor = 18;
                gbc.gridwidth = -1;
                gbc.fill = 2;
                c.add((Component)jLbNrOfNodes, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfNrOfNodes, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbNrOfArcs, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfNrOfArcs, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbCardinality, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfCardinality, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbSeed, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfSeed, gbc);
                gbc.fill = 2;
                this.dlg.add((Component)c, gbc);
                this.dlg.add(jBtGo);
                gbc.gridwidth = 0;
                this.dlg.add(jBtCancel);
            }
            this.dlg.setSize(450, 350);
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(GUI.this));
            this.dlg.setVisible(true);
        }
    }

    class ActionGenerateData
    extends MyAction {
        private static final long serialVersionUID = -2038911085935516L;
        int m_nNrOfInstances;
        int m_nSeed;
        String m_sFile;
        JDialog dlg;

        public ActionGenerateData() {
            super("Generate Data", "Generate Random Instances from Network", "generate.data", "ctrl D");
            this.m_nNrOfInstances = 100;
            this.m_nSeed = 1234;
            this.m_sFile = "";
            this.dlg = null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.dlg == null) {
                this.dlg = new JDialog(SwingUtilities.getWindowAncestor(GUI.this));
                this.dlg.setTitle("Generate Random Data Options");
                JLabel jLbNrOfInstances = new JLabel("Nr of instances");
                final JTextField jTfNrOfInstances = new JTextField(3);
                jTfNrOfInstances.setHorizontalAlignment(0);
                jTfNrOfInstances.setText("" + this.m_nNrOfInstances);
                JLabel jLbSeed = new JLabel("Random seed");
                JTextField jTfSeed = new JTextField(3);
                jTfSeed.setHorizontalAlignment(0);
                jTfSeed.setText("" + this.m_nSeed);
                JLabel jLbFile = new JLabel("Output file (optional)");
                final JTextField jTfFile = new JTextField(12);
                jTfFile.setHorizontalAlignment(0);
                jTfFile.setText(this.m_sFile);
                JButton jBtGo = new JButton("Generate Data");
                jBtGo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            String tmpfilename = "tmp.bif.file.xml";
                            BayesNetGenerator generator = new BayesNetGenerator();
                            String[] options = new String[]{"-M", "" + jTfNrOfInstances.getText(), "-F", tmpfilename};
                            FileWriter outfile = new FileWriter(tmpfilename);
                            StringBuffer text = new StringBuffer();
                            if (GUI.this.m_marginCalculator == null) {
                                GUI.this.m_marginCalculator = new MarginCalculator();
                                GUI.this.m_marginCalculator.calcMargins(GUI.this.m_BayesNet);
                            }
                            text.append(GUI.this.m_marginCalculator.toXMLBIF03());
                            outfile.write(text.toString());
                            outfile.close();
                            generator.setOptions(options);
                            generator.generateRandomNetwork();
                            generator.generateInstances();
                            GUI.this.m_Instances = generator.m_Instances;
                            GUI.this.a_learn.setEnabled(true);
                            GUI.this.a_learnCPT.setEnabled(true);
                            ActionGenerateData.this.m_sFile = jTfFile.getText();
                            if (ActionGenerateData.this.m_sFile != null && !ActionGenerateData.this.m_sFile.equals("")) {
                                AbstractFileSaver saver = ConverterUtils.getSaverForFile(ActionGenerateData.this.m_sFile);
                                if (saver == null) {
                                    saver = new ArffSaver();
                                }
                                saver.setFile(new File(ActionGenerateData.this.m_sFile));
                                saver.setInstances(GUI.this.m_Instances);
                                saver.writeBatch();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ActionGenerateData.this.dlg.setVisible(false);
                    }
                });
                JButton jBtFile = new JButton("Browse");
                jBtFile.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ConverterFileChooser fc = new ConverterFileChooser(System.getProperty("user.dir"));
                        fc.setDialogTitle("Save Instances As");
                        int rval = fc.showSaveDialog(GUI.this);
                        if (rval == 0) {
                            String filename = fc.getSelectedFile().toString();
                            jTfFile.setText(filename);
                        }
                        ActionGenerateData.this.dlg.setVisible(true);
                    }
                });
                JButton jBtCancel = new JButton("Cancel");
                jBtCancel.setMnemonic('C');
                jBtCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ActionGenerateData.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gbc = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container c = new Container();
                c.setLayout(new GridBagLayout());
                gbc.gridwidth = 2;
                gbc.insets = new Insets(8, 0, 0, 0);
                gbc.anchor = 18;
                gbc.gridwidth = -1;
                gbc.fill = 2;
                c.add((Component)jLbNrOfInstances, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfNrOfInstances, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbSeed, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfSeed, gbc);
                gbc.gridwidth = -1;
                c.add((Component)jLbFile, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfFile, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jBtFile, gbc);
                gbc.fill = 2;
                this.dlg.add((Component)c, gbc);
                this.dlg.add(jBtGo);
                gbc.gridwidth = 0;
                this.dlg.add(jBtCancel);
            }
            this.dlg.setSize(450, 350);
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(GUI.this));
            this.dlg.setVisible(true);
        }
    }

    class ActionSetData
    extends MyAction {
        private static final long serialVersionUID = -2038911085935519L;

        public ActionSetData() {
            super("Set Data", "Set Data File", "setdata", "ctrl A");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ConverterFileChooser fc = new ConverterFileChooser(System.getProperty("user.dir"));
            fc.setDialogTitle("Set Data File");
            int rval = fc.showOpenDialog(GUI.this);
            if (rval == 0) {
                AbstractFileLoader loader = fc.getLoader();
                try {
                    if (loader != null) {
                        GUI.this.m_Instances = loader.getDataSet();
                    }
                    if (GUI.this.m_Instances.classIndex() == -1) {
                        GUI.this.m_Instances.setClassIndex(GUI.this.m_Instances.numAttributes() - 1);
                    }
                    GUI.this.a_learn.setEnabled(true);
                    GUI.this.a_learnCPT.setEnabled(true);
                    GUI.this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class ActionLearn
    extends MyAction {
        private static final long serialVersionUID = -2038911085935516L;
        JDialog dlg;

        public ActionLearn() {
            super("Learn Network", "Learn Bayesian Network", "learn", "ctrl L");
            this.dlg = null;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.dlg == null) {
                this.dlg = new JDialog(SwingUtilities.getWindowAncestor(GUI.this));
                this.dlg.setTitle("Learn Bayesian Network");
                JButton jBtOptions = new JButton("Options");
                jBtOptions.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            GenericObjectEditor.registerEditors();
                            GenericObjectEditor ce = new GenericObjectEditor(true);
                            ce.setClassType(Classifier.class);
                            ce.setValue(GUI.this.m_BayesNet);
                            PropertyDialog pd = PropertyDialog.getParentDialog(GUI.this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(GUI.this), (PropertyEditor)ce, -1, -1) : new PropertyDialog(PropertyDialog.getParentFrame(GUI.this), (PropertyEditor)ce, -1, -1);
                            pd.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    PropertyEditor pe = ((PropertyDialog)e.getSource()).getEditor();
                                    Object c = pe.getValue();
                                    String options = "";
                                    if (c instanceof OptionHandler) {
                                        options = Utils.joinOptions(((OptionHandler)c).getOptions());
                                        try {
                                            GUI.this.m_BayesNet.setOptions(((OptionHandler)c).getOptions());
                                        }
                                        catch (Exception e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                    System.out.println(c.getClass().getName() + " " + options);
                                    System.exit(0);
                                }
                            });
                            pd.setVisible(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.err.println(ex.getMessage());
                        }
                        GUI.this.m_BayesNet.clearUndoStack();
                        GUI.this.a_undo.setEnabled(false);
                        GUI.this.a_redo.setEnabled(false);
                    }
                });
                JTextField jTfOptions = new JTextField(40);
                jTfOptions.setHorizontalAlignment(0);
                jTfOptions.setText("" + Utils.joinOptions(GUI.this.m_BayesNet.getOptions()));
                JButton jBtGo = new JButton("Learn");
                jBtGo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            GUI.this.m_BayesNet.buildClassifier(GUI.this.m_Instances);
                            GUI.this.layoutGraph();
                            GUI.this.updateStatus();
                            GUI.this.m_BayesNet.clearUndoStack();
                            ActionLearn.this.dlg.setVisible(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ActionLearn.this.dlg.setVisible(false);
                    }
                });
                JButton jBtCancel = new JButton("Cancel");
                jBtCancel.setMnemonic('C');
                jBtCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ActionLearn.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gbc = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container c = new Container();
                c.setLayout(new GridBagLayout());
                gbc.gridwidth = 2;
                gbc.insets = new Insets(8, 0, 0, 0);
                gbc.anchor = 18;
                gbc.gridwidth = -1;
                gbc.fill = 2;
                c.add((Component)jBtOptions, gbc);
                gbc.gridwidth = 0;
                c.add((Component)jTfOptions, gbc);
                gbc.fill = 2;
                this.dlg.add((Component)c, gbc);
                this.dlg.add(jBtGo);
                gbc.gridwidth = 0;
                this.dlg.add(jBtCancel);
            }
            this.dlg.setSize(450, 350);
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(GUI.this));
            this.dlg.setVisible(true);
        }
    }

    class ActionLearnCPT
    extends MyAction {
        private static final long serialVersionUID = -2022211085935516L;

        public ActionLearnCPT() {
            super("Learn CPT", "Learn conditional probability tables", "learncpt", "");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (GUI.this.m_Instances == null) {
                JOptionPane.showMessageDialog(null, "Select instances to learn from first (menu Tools/Set Data)");
                return;
            }
            try {
                GUI.this.m_BayesNet.setData(GUI.this.m_Instances);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Data set is not compatible with network.\n" + e.getMessage() + "\nChoose other instances (menu Tools/Set Data)");
                return;
            }
            try {
                GUI.this.m_BayesNet.estimateCPTs();
                GUI.this.m_BayesNet.clearUndoStack();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GUI.this.updateStatus();
        }
    }

    class ActionHelp
    extends MyAction {
        private static final long serialVersionUID = -20389110859354L;

        public ActionHelp() {
            super("Help", "Bayesian Network Workbench Help", "help", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JOptionPane.showMessageDialog(null, "See Weka Homepage\nhttp://www.cs.waikato.ac.nz/ml", "Help Message", -1);
        }
    }

    class ActionAbout
    extends MyAction {
        private static final long serialVersionUID = -20389110859353L;

        public ActionAbout() {
            super("About", "Help about", "about", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JOptionPane.showMessageDialog(null, "Bayesian Network Workbench\nPart of Weka\n2007", "About Message", -1);
        }
    }

    class ActionAddNode
    extends MyAction {
        private static final long serialVersionUID = -2038910085935519L;
        JDialog dlg;
        JTextField jTfName;
        JTextField jTfCard;
        int m_X;
        int m_Y;

        public ActionAddNode() {
            super("Add Node", "Add Node", "addnode", "");
            this.dlg = null;
            this.jTfName = new JTextField(20);
            this.jTfCard = new JTextField(3);
            this.m_X = Integer.MAX_VALUE;
        }

        public void addNode(int nX, int nY) {
            this.m_X = nX;
            this.m_Y = nY;
            this.addNode();
        }

        void addNode() {
            if (this.dlg == null) {
                this.dlg = new JDialog(SwingUtilities.getWindowAncestor(GUI.this));
                this.dlg.setTitle("Add node");
                JLabel jLbName = new JLabel("Name");
                this.jTfName.setHorizontalAlignment(0);
                JLabel jLbCard = new JLabel("Cardinality");
                this.jTfCard.setHorizontalAlignment(0);
                this.jTfCard.setText("2");
                JButton jBtCancel = new JButton("Cancel");
                jBtCancel.setMnemonic('C');
                jBtCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ActionAddNode.this.dlg.setVisible(false);
                    }
                });
                JButton jBtOk = new JButton("Ok");
                jBtOk.setMnemonic('O');
                jBtOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        String sName = ActionAddNode.this.jTfName.getText();
                        if (sName.length() <= 0) {
                            JOptionPane.showMessageDialog(null, "Name should have at least one character");
                            return;
                        }
                        int nCard = new Integer(ActionAddNode.this.jTfCard.getText());
                        if (nCard <= 1) {
                            JOptionPane.showMessageDialog(null, "Cardinality should be larger than 1");
                            return;
                        }
                        try {
                            if (ActionAddNode.this.m_X < Integer.MAX_VALUE) {
                                GUI.this.m_BayesNet.addNode(sName, nCard, ActionAddNode.this.m_X, ActionAddNode.this.m_Y);
                            } else {
                                GUI.this.m_BayesNet.addNode(sName, nCard);
                            }
                            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                            GUI.this.a_undo.setEnabled(true);
                            GUI.this.a_redo.setEnabled(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GUI.this.repaint();
                        ActionAddNode.this.dlg.setVisible(false);
                    }
                });
                this.dlg.setLayout(new GridLayout(3, 2, 10, 10));
                this.dlg.add(jLbName);
                this.dlg.add(this.jTfName);
                this.dlg.add(jLbCard);
                this.dlg.add(this.jTfCard);
                this.dlg.add(jBtOk);
                this.dlg.add(jBtCancel);
                this.dlg.setSize(450, 350);
            }
            this.jTfName.setText("Node" + (GUI.this.m_BayesNet.getNrOfNodes() + 1));
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(SwingUtilities.getWindowAncestor(GUI.this));
            this.dlg.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.m_X = Integer.MAX_VALUE;
            this.addNode();
        }
    }

    class ActionDeleteNode
    extends MyAction {
        private static final long serialVersionUID = -2038912085935519L;

        public ActionDeleteNode() {
            super("Delete Node", "Delete Node", "delnode", "DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (GUI.this.m_Selection.getSelected().size() > 0) {
                GUI.this.m_BayesNet.deleteSelection(GUI.this.m_Selection.getSelected());
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                GUI.this.m_Selection.clear();
                GUI.this.updateStatus();
                GUI.this.repaint();
            } else {
                Object[] options = new String[GUI.this.m_BayesNet.getNrOfNodes()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = GUI.this.m_BayesNet.getNodeName(i);
                }
                String sResult = (String)JOptionPane.showInputDialog(null, "Select node to delete", "Nodes", 0, null, options, options[0]);
                if (sResult != null && !sResult.equals("")) {
                    int iNode = GUI.this.m_BayesNet.getNode2(sResult);
                    GUI.this.deleteNode(iNode);
                }
            }
        }
    }

    class ActionCutNode
    extends ActionCopyNode {
        private static final long serialVersionUID = -2038822085935519L;

        public ActionCutNode() {
            super("Cut", "Cut Nodes", "cut", "ctrl X");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.copy();
            GUI.this.m_BayesNet.deleteSelection(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.m_Selection.clear();
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCopyNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionCopyNode() {
            super("Copy", "Copy Nodes", "copy", "ctrl C");
        }

        public ActionCopyNode(String sName, String sToolTipText, String sIcon, String sAcceleratorKey) {
            super(sName, sToolTipText, sIcon, sAcceleratorKey);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.copy();
        }

        public void copy() {
            String sXML = GUI.this.m_BayesNet.toXMLBIF03(GUI.this.m_Selection.getSelected());
            GUI.this.m_clipboard.setText(sXML);
        }
    }

    class ActionPasteNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionPasteNode() {
            super("Paste", "Paste Nodes", "paste", "ctrl V");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                GUI.this.m_BayesNet.paste(GUI.this.m_clipboard.getText());
                GUI.this.updateStatus();
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean isEnabled() {
            return GUI.this.m_clipboard.hasText();
        }
    }

    class ActionSelectAll
    extends MyAction {
        private static final long serialVersionUID = -2038642085935519L;

        public ActionSelectAll() {
            super("Select All", "Select All Nodes", "selectall", "ctrl A");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_Selection.selectAll();
            GUI.this.repaint();
        }
    }

    class ActionAddArc
    extends MyAction {
        private static final long serialVersionUID = -2038913085935519L;

        public ActionAddArc() {
            super("Add Arc", "Add Arc", "addarc", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                Object[] options = new String[GUI.this.m_BayesNet.getNrOfNodes()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = GUI.this.m_BayesNet.getNodeName(i);
                }
                String sChild = (String)JOptionPane.showInputDialog(null, "Select child node", "Nodes", 0, null, options, options[0]);
                if (sChild == null || sChild.equals("")) {
                    return;
                }
                int iChild = GUI.this.m_BayesNet.getNode(sChild);
                GUI.this.addArcInto(iChild);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ActionDeleteArc
    extends MyAction {
        private static final long serialVersionUID = -2038914085935519L;

        public ActionDeleteArc() {
            super("Delete Arc", "Delete Arc", "delarc", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int nEdges = 0;
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                nEdges += GUI.this.m_BayesNet.getNrOfParents(iNode);
            }
            String[] options = new String[nEdges];
            int i = 0;
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                for (int iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(iNode); ++iParent) {
                    int nParent = GUI.this.m_BayesNet.getParent(iNode, iParent);
                    String sEdge = GUI.this.m_BayesNet.getNodeName(nParent);
                    sEdge = sEdge + " -> ";
                    sEdge = sEdge + GUI.this.m_BayesNet.getNodeName(iNode);
                    options[i++] = sEdge;
                }
            }
            GUI.this.deleteArc(options);
        }
    }

    class ActionUndo
    extends MyAction {
        private static final long serialVersionUID = -3038910085935519L;

        public ActionUndo() {
            super("Undo", "Undo", "undo", "ctrl Z");
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return GUI.this.m_BayesNet.canUndo();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sMsg = GUI.this.m_BayesNet.undo();
            GUI.this.m_jStatusBar.setText("Undo action performed: " + sMsg);
            GUI.this.a_redo.setEnabled(GUI.this.m_BayesNet.canRedo());
            GUI.this.a_undo.setEnabled(GUI.this.m_BayesNet.canUndo());
            GUI.this.m_Selection.clear();
            GUI.this.updateStatus();
            GUI.this.repaint();
        }
    }

    class ActionRedo
    extends MyAction {
        private static final long serialVersionUID = -4038910085935519L;

        public ActionRedo() {
            super("Redo", "Redo", "redo", "ctrl Y");
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return GUI.this.m_BayesNet.canRedo();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sMsg = GUI.this.m_BayesNet.redo();
            GUI.this.m_jStatusBar.setText("Redo action performed: " + sMsg);
            GUI.this.m_Selection.clear();
            GUI.this.updateStatus();
            GUI.this.repaint();
        }
    }

    class ActionAlignLeft
    extends MyAction {
        private static final long serialVersionUID = -3138642085935519L;

        public ActionAlignLeft() {
            super("Align Left", "Align Left", "alignleft", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.alignLeft(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignRight
    extends MyAction {
        private static final long serialVersionUID = -4238642085935519L;

        public ActionAlignRight() {
            super("Align Right", "Align Right", "alignright", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.alignRight(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignTop
    extends MyAction {
        private static final long serialVersionUID = -5338642085935519L;

        public ActionAlignTop() {
            super("Align Top", "Align Top", "aligntop", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.alignTop(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignBottom
    extends MyAction {
        private static final long serialVersionUID = -6438642085935519L;

        public ActionAlignBottom() {
            super("Align Bottom", "Align Bottom", "alignbottom", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.alignBottom(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCenterHorizontal
    extends MyAction {
        private static final long serialVersionUID = -7538642085935519L;

        public ActionCenterHorizontal() {
            super("Center Horizontal", "Center Horizontal", "centerhorizontal", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.centerHorizontal(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCenterVertical
    extends MyAction {
        private static final long serialVersionUID = -8638642085935519L;

        public ActionCenterVertical() {
            super("Center Vertical", "Center Vertical", "centervertical", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.centerVertical(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionSpaceHorizontal
    extends MyAction {
        private static final long serialVersionUID = -9738642085935519L;

        public ActionSpaceHorizontal() {
            super("Space Horizontal", "Space Horizontal", "spacehorizontal", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.spaceHorizontal(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionSpaceVertical
    extends MyAction {
        private static final long serialVersionUID = -838642085935519L;

        public ActionSpaceVertical() {
            super("Space Vertical", "Space Vertical", "spacevertical", "");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GUI.this.m_BayesNet.spaceVertical(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class Selection {
        ArrayList<Integer> m_selected = new ArrayList();

        public ArrayList<Integer> getSelected() {
            return this.m_selected;
        }

        void updateGUI() {
            if (this.m_selected.size() > 0) {
                GUI.this.a_cutnode.setEnabled(true);
                GUI.this.a_copynode.setEnabled(true);
            } else {
                GUI.this.a_cutnode.setEnabled(false);
                GUI.this.a_copynode.setEnabled(false);
            }
            if (this.m_selected.size() > 1) {
                GUI.this.a_alignleft.setEnabled(true);
                GUI.this.a_alignright.setEnabled(true);
                GUI.this.a_aligntop.setEnabled(true);
                GUI.this.a_alignbottom.setEnabled(true);
                GUI.this.a_centerhorizontal.setEnabled(true);
                GUI.this.a_centervertical.setEnabled(true);
                GUI.this.a_spacehorizontal.setEnabled(true);
                GUI.this.a_spacevertical.setEnabled(true);
            } else {
                GUI.this.a_alignleft.setEnabled(false);
                GUI.this.a_alignright.setEnabled(false);
                GUI.this.a_aligntop.setEnabled(false);
                GUI.this.a_alignbottom.setEnabled(false);
                GUI.this.a_centerhorizontal.setEnabled(false);
                GUI.this.a_centervertical.setEnabled(false);
                GUI.this.a_spacehorizontal.setEnabled(false);
                GUI.this.a_spacevertical.setEnabled(false);
            }
        }

        public void addToSelection(int nNode) {
            for (int iNode = 0; iNode < this.m_selected.size(); ++iNode) {
                if (nNode != this.m_selected.get(iNode)) continue;
                return;
            }
            this.m_selected.add(nNode);
            this.updateGUI();
        }

        public void addToSelection(int[] iNodes) {
            for (int iNode2 : iNodes) {
                this.addToSelection(iNode2);
            }
            this.updateGUI();
        }

        public void addToSelection(Rectangle selectedRect) {
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                if (!this.contains(selectedRect, iNode)) continue;
                this.addToSelection(iNode);
            }
        }

        public void selectAll() {
            this.m_selected.clear();
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                this.m_selected.add(iNode);
            }
            this.updateGUI();
        }

        boolean contains(Rectangle rect, int iNode) {
            return rect.intersects((double)GUI.this.m_BayesNet.getPositionX(iNode) * GUI.this.m_fScale, (double)GUI.this.m_BayesNet.getPositionY(iNode) * GUI.this.m_fScale, (double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale, (double)GUI.this.m_nNodeHeight * GUI.this.m_fScale);
        }

        public void removeFromSelection(int nNode) {
            for (int iNode = 0; iNode < this.m_selected.size(); ++iNode) {
                if (nNode != this.m_selected.get(iNode)) continue;
                this.m_selected.remove(iNode);
            }
            this.updateGUI();
        }

        public void toggleSelection(int nNode) {
            for (int iNode = 0; iNode < this.m_selected.size(); ++iNode) {
                if (nNode != this.m_selected.get(iNode)) continue;
                this.m_selected.remove(iNode);
                this.updateGUI();
                return;
            }
            this.addToSelection(nNode);
        }

        public void toggleSelection(Rectangle selectedRect) {
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                if (!this.contains(selectedRect, iNode)) continue;
                this.toggleSelection(iNode);
            }
        }

        public void clear() {
            this.m_selected.clear();
            this.updateGUI();
        }

        public void draw(Graphics g) {
            if (this.m_selected.size() == 0) {
                return;
            }
            for (int iNode = 0; iNode < this.m_selected.size(); ++iNode) {
                int nNode = this.m_selected.get(iNode);
                int nPosX = GUI.this.m_BayesNet.getPositionX(nNode);
                int nPosY = GUI.this.m_BayesNet.getPositionY(nNode);
                g.setColor(Color.BLACK);
                int nXRC = nPosX + GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth - (GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth) / 2;
                int nYRC = nPosY;
                int d = 5;
                g.fillRect(nXRC, nYRC, d, d);
                g.fillRect(nXRC, nYRC + GUI.this.m_nNodeHeight, d, d);
                g.fillRect(nXRC + GUI.this.m_nNodeWidth, nYRC, d, d);
                g.fillRect(nXRC + GUI.this.m_nNodeWidth, nYRC + GUI.this.m_nNodeHeight, d, d);
            }
        }
    }

    class ClipBoard {
        String m_sText = null;

        public ClipBoard() {
            if (GUI.this.a_pastenode != null) {
                GUI.this.a_pastenode.setEnabled(false);
            }
        }

        public boolean hasText() {
            return this.m_sText != null;
        }

        public String getText() {
            return this.m_sText;
        }

        public void setText(String sText) {
            this.m_sText = sText;
            GUI.this.a_pastenode.setEnabled(true);
        }
    }

    private class GraphPanel
    extends PrintablePanel
    implements Printable {
        private static final long serialVersionUID = -3562813603236753173L;
        static final int HIGHLIGHTED = 1;
        static final int NORMAL = 0;
        int m_nClique = 1;

        public GraphPanel() {
            this.addMouseListener(new GraphVisualizerMouseListener());
            this.addMouseMotionListener(new GraphVisualizerMouseMotionListener());
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            int y = 0;
            int x = 0;
            Rectangle r = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            x += me.getX();
            y += me.getY();
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                r.x = (int)((double)GUI.this.m_BayesNet.getPositionX(iNode) * GUI.this.m_fScale);
                r.y = (int)((double)GUI.this.m_BayesNet.getPositionY(iNode) * GUI.this.m_fScale);
                if (!r.contains(x, y)) continue;
                return GUI.this.m_BayesNet.getNodeName(iNode) + " (right click to manipulate this node)";
            }
            return null;
        }

        @Override
        public void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setRenderingHints(rh);
            g.scale(GUI.this.m_fScale, GUI.this.m_fScale);
            Rectangle r = g.getClipBounds();
            g.clearRect(r.x, r.y, r.width, r.height);
            if (GUI.this.m_bViewCliques) {
                this.m_nClique = 1;
                this.viewCliques(g, GUI.this.m_marginCalculator.m_root);
            }
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                this.drawNode(g, iNode, 0);
            }
            if (!GUI.this.a_export.isExporting() && !GUI.this.a_print.isPrinting()) {
                GUI.this.m_Selection.draw(g);
            }
            if (GUI.this.m_nSelectedRect != null) {
                g.drawRect((int)((double)GUI.this.m_nSelectedRect.x / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.y / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.width / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.height / GUI.this.m_fScale));
            }
        }

        void viewCliques(Graphics g, MarginCalculator.JunctionTreeNode node) {
            int[] nodes = node.m_nNodes;
            g.setColor(new Color(this.m_nClique % 7 * 256 / 7, this.m_nClique % 2 * 256 / 2, this.m_nClique % 3 * 256 / 3));
            int dX = GUI.this.m_nPaddedNodeWidth / 2 + this.m_nClique;
            int dY = GUI.this.m_nNodeHeight / 2;
            int nPosX = 0;
            int nPosY = 0;
            String sStr = "";
            for (int j = 0; j < nodes.length; ++j) {
                nPosX += GUI.this.m_BayesNet.getPositionX(nodes[j]);
                nPosY += GUI.this.m_BayesNet.getPositionY(nodes[j]);
                sStr = sStr + " " + nodes[j];
                for (int k = j + 1; k < nodes.length; ++k) {
                    g.drawLine(GUI.this.m_BayesNet.getPositionX(nodes[j]) + dX, GUI.this.m_BayesNet.getPositionY(nodes[j]) + dY, GUI.this.m_BayesNet.getPositionX(nodes[k]) + dX, GUI.this.m_BayesNet.getPositionY(nodes[k]) + dY);
                }
            }
            ++this.m_nClique;
            g.drawString("Clique " + this.m_nClique + "(" + sStr + ")", nPosX /= nodes.length, nPosY /= nodes.length);
            for (int iChild = 0; iChild < node.m_children.size(); ++iChild) {
                this.viewCliques(g, node.m_children.elementAt(iChild));
            }
        }

        protected void drawNode(Graphics g, int iNode, int mode) {
            int nPosX = GUI.this.m_BayesNet.getPositionX(iNode);
            int nPosY = GUI.this.m_BayesNet.getPositionY(iNode);
            g.setColor(this.getBackground().darker().darker());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (mode == 1) {
                g.setXORMode(Color.green);
            }
            g.fillOval(nPosX + GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth - (GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth) / 2, nPosY, GUI.this.m_nNodeWidth, GUI.this.m_nNodeHeight);
            g.setColor(Color.white);
            if (mode == 1) {
                g.setXORMode(Color.red);
            }
            if (fm.stringWidth(GUI.this.m_BayesNet.getNodeName(iNode)) <= GUI.this.m_nNodeWidth) {
                g.drawString(GUI.this.m_BayesNet.getNodeName(iNode), nPosX + GUI.this.m_nPaddedNodeWidth / 2 - fm.stringWidth(GUI.this.m_BayesNet.getNodeName(iNode)) / 2, nPosY + GUI.this.m_nNodeHeight / 2 + fm.getHeight() / 2 - 2);
            } else if (fm.stringWidth("" + iNode) <= GUI.this.m_nNodeWidth) {
                g.drawString("" + iNode, nPosX + GUI.this.m_nPaddedNodeWidth / 2 - fm.stringWidth("" + iNode) / 2, nPosY + GUI.this.m_nNodeHeight / 2 + fm.getHeight() / 2 - 2);
            }
            if (mode == 1) {
                g.setXORMode(Color.green);
            }
            if (GUI.this.m_bViewMargins) {
                if (GUI.this.m_BayesNet.getEvidence(iNode) < 0) {
                    g.setColor(new Color(0, 128, 0));
                } else {
                    g.setColor(new Color(128, 0, 0));
                }
                double[] P = GUI.this.m_BayesNet.getMargin(iNode);
                for (int iValue = 0; iValue < P.length; ++iValue) {
                    String sP = P[iValue] + "";
                    if (sP.charAt(0) == '0') {
                        sP = sP.substring(1);
                    }
                    if (sP.length() > 5) {
                        sP = sP.substring(1, 5);
                    }
                    g.fillRect(nPosX + GUI.this.m_nPaddedNodeWidth, nPosY + iValue * 10 + 2, (int)(P[iValue] * 100.0), 8);
                    g.drawString(GUI.this.m_BayesNet.getNodeValue(iNode, iValue) + " " + sP, nPosX + GUI.this.m_nPaddedNodeWidth + (int)(P[iValue] * 100.0), nPosY + iValue * 10 + 10);
                }
            }
            if (GUI.this.m_bViewCliques) {
                return;
            }
            g.setColor(Color.black);
            for (int iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(iNode); ++iParent) {
                int nParent = GUI.this.m_BayesNet.getParent(iNode, iParent);
                int nPosX1 = nPosX + GUI.this.m_nPaddedNodeWidth / 2;
                int nPosY1 = nPosY + GUI.this.m_nNodeHeight;
                int nPosX2 = GUI.this.m_BayesNet.getPositionX(nParent);
                int nPosY2 = GUI.this.m_BayesNet.getPositionY(nParent);
                int nPosX2b = nPosX2 + GUI.this.m_nPaddedNodeWidth / 2;
                int nPosY2b = nPosY2;
                double phi = Math.atan2(((double)(nPosX2b - nPosX1) + 0.0) * (double)GUI.this.m_nNodeHeight, ((double)(nPosY2b - nPosY1) + 0.0) * (double)GUI.this.m_nNodeWidth);
                nPosX1 = (int)((double)(nPosX + GUI.this.m_nPaddedNodeWidth / 2) + Math.sin(phi) * (double)GUI.this.m_nNodeWidth / 2.0);
                nPosY1 = (int)((double)(nPosY + GUI.this.m_nNodeHeight / 2) + Math.cos(phi) * (double)GUI.this.m_nNodeHeight / 2.0);
                nPosX2b = (int)((double)(nPosX2 + GUI.this.m_nPaddedNodeWidth / 2) - Math.sin(phi) * (double)GUI.this.m_nNodeWidth / 2.0);
                nPosY2b = (int)((double)(nPosY2 + GUI.this.m_nNodeHeight / 2) - Math.cos(phi) * (double)GUI.this.m_nNodeHeight / 2.0);
                this.drawArrow(g, nPosX2b, nPosY2b, nPosX1, nPosY1);
            }
            if (mode == 1) {
                ArrayList<Integer> children = GUI.this.m_BayesNet.getChildren(iNode);
                for (int iChild = 0; iChild < children.size(); ++iChild) {
                    int nChild = children.get(iChild);
                    int nPosX1 = nPosX + GUI.this.m_nPaddedNodeWidth / 2;
                    int nPosY1 = nPosY;
                    int nPosX2 = GUI.this.m_BayesNet.getPositionX(nChild);
                    int nPosY2 = GUI.this.m_BayesNet.getPositionY(nChild);
                    int nPosX2b = nPosX2 + GUI.this.m_nPaddedNodeWidth / 2;
                    int nPosY2b = nPosY2 + GUI.this.m_nNodeHeight;
                    double phi = Math.atan2(((double)(nPosX2b - nPosX1) + 0.0) * (double)GUI.this.m_nNodeHeight, ((double)(nPosY2b - nPosY1) + 0.0) * (double)GUI.this.m_nNodeWidth);
                    nPosX1 = (int)((double)(nPosX + GUI.this.m_nPaddedNodeWidth / 2) + Math.sin(phi) * (double)GUI.this.m_nNodeWidth / 2.0);
                    nPosY1 = (int)((double)(nPosY + GUI.this.m_nNodeHeight / 2) + Math.cos(phi) * (double)GUI.this.m_nNodeHeight / 2.0);
                    nPosX2b = (int)((double)(nPosX2 + GUI.this.m_nPaddedNodeWidth / 2) - Math.sin(phi) * (double)GUI.this.m_nNodeWidth / 2.0);
                    nPosY2b = (int)((double)(nPosY2 + GUI.this.m_nNodeHeight / 2) - Math.cos(phi) * (double)GUI.this.m_nNodeHeight / 2.0);
                    this.drawArrow(g, nPosX1, nPosY1, nPosX2b, nPosY2b);
                }
            }
        }

        protected void drawArrow(Graphics g, int nPosX1, int nPosY1, int nPosX2, int nPosY2) {
            g.drawLine(nPosX1, nPosY1, nPosX2, nPosY2);
            if (nPosX1 == nPosX2) {
                if (nPosY1 < nPosY2) {
                    g.drawLine(nPosX2, nPosY2, nPosX2 + 4, nPosY2 - 8);
                    g.drawLine(nPosX2, nPosY2, nPosX2 - 4, nPosY2 - 8);
                } else {
                    g.drawLine(nPosX2, nPosY2, nPosX2 + 4, nPosY2 + 8);
                    g.drawLine(nPosX2, nPosY2, nPosX2 - 4, nPosY2 + 8);
                }
            } else {
                double theta;
                double hyp = 0.0;
                double base = 0.0;
                double perp = 0.0;
                int nPosX3 = 0;
                int nPosY3 = 0;
                if (nPosX2 < nPosX1) {
                    base = nPosX1 - nPosX2;
                    hyp = Math.sqrt((nPosX2 - nPosX1) * (nPosX2 - nPosX1) + (nPosY2 - nPosY1) * (nPosY2 - nPosY1));
                    theta = Math.acos(base / hyp);
                } else {
                    base = nPosX1 - nPosX2;
                    hyp = Math.sqrt((nPosX2 - nPosX1) * (nPosX2 - nPosX1) + (nPosY2 - nPosY1) * (nPosY2 - nPosY1));
                    theta = Math.acos(base / hyp);
                }
                double beta = 0.5235987755982988;
                hyp = 8.0;
                base = Math.cos(theta - beta) * hyp;
                perp = Math.sin(theta - beta) * hyp;
                nPosX3 = (int)((double)nPosX2 + base);
                nPosY3 = nPosY1 < nPosY2 ? (int)((double)nPosY2 - perp) : (int)((double)nPosY2 + perp);
                g.drawLine(nPosX2, nPosY2, nPosX3, nPosY3);
                base = Math.cos(theta + beta) * hyp;
                perp = Math.sin(theta + beta) * hyp;
                nPosX3 = (int)((double)nPosX2 + base);
                nPosY3 = nPosY1 < nPosY2 ? (int)((double)nPosY2 - perp) : (int)((double)nPosY2 + perp);
                g.drawLine(nPosX2, nPosY2, nPosX3, nPosY3);
            }
        }

        public void highLight(int iNode) {
            Graphics2D g = (Graphics2D)this.getGraphics();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setRenderingHints(rh);
            g.setPaintMode();
            g.scale(GUI.this.m_fScale, GUI.this.m_fScale);
            this.drawNode(g, iNode, 1);
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double fHeight = pageFormat.getImageableHeight();
            double fWidth = pageFormat.getImageableWidth();
            int xMax = 1;
            int yMax = 1;
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                if (xMax < GUI.this.m_BayesNet.getPositionX(iNode)) {
                    xMax = GUI.this.m_BayesNet.getPositionX(iNode);
                }
                if (yMax >= GUI.this.m_BayesNet.getPositionY(iNode)) continue;
                yMax = GUI.this.m_BayesNet.getPositionY(iNode);
            }
            double fCurrentScale = GUI.this.m_fScale;
            if (fWidth / (double)(xMax += GUI.this.m_nPaddedNodeWidth + 100) < fHeight / (double)yMax) {
                GUI.this.m_fScale = fWidth / (double)xMax;
            } else {
                GUI.this.m_fScale = fHeight / (double)yMax;
            }
            this.paint(g2d);
            GUI.this.m_fScale = fCurrentScale;
            return 0;
        }
    }

    private class GraphVisualizerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4789813491347366596L;
        final String[] m_sColumnNames;
        final double[][] m_fProbs;

        public GraphVisualizerTableModel(int iNode) {
            double[][] probs = GUI.this.m_BayesNet.getDistribution(iNode);
            this.m_fProbs = new double[probs.length][probs[0].length];
            for (int i = 0; i < probs.length; ++i) {
                for (int j = 0; j < probs[0].length; ++j) {
                    this.m_fProbs[i][j] = probs[i][j];
                }
            }
            this.m_sColumnNames = GUI.this.m_BayesNet.getValues(iNode);
        }

        public void randomize() {
            int nProbs = this.m_fProbs[0].length;
            Random random = new Random();
            for (int i = 0; i < this.m_fProbs.length; ++i) {
                int j;
                for (j = 0; j < nProbs - 1; ++j) {
                    this.m_fProbs[i][j] = random.nextDouble();
                }
                for (j = 0; j < nProbs - 1; ++j) {
                    for (int k = j + 1; k < nProbs - 1; ++k) {
                        if (!(this.m_fProbs[i][j] > this.m_fProbs[i][k])) continue;
                        double h = this.m_fProbs[i][j];
                        this.m_fProbs[i][j] = this.m_fProbs[i][k];
                        this.m_fProbs[i][k] = h;
                    }
                }
                double sum = this.m_fProbs[i][0];
                for (int j2 = 1; j2 < nProbs - 1; ++j2) {
                    this.m_fProbs[i][j2] = this.m_fProbs[i][j2] - sum;
                    sum += this.m_fProbs[i][j2];
                }
                this.m_fProbs[i][nProbs - 1] = 1.0 - sum;
            }
        }

        public void setData() {
        }

        @Override
        public int getColumnCount() {
            return this.m_sColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.m_fProbs.length;
        }

        @Override
        public String getColumnName(int iCol) {
            return this.m_sColumnNames[iCol];
        }

        @Override
        public Object getValueAt(int iRow, int iCol) {
            return new Double(this.m_fProbs[iRow][iCol]);
        }

        @Override
        public void setValueAt(Object oProb, int iRow, int iCol) {
            int i;
            Double fProb = (Double)oProb;
            if (fProb < 0.0 || fProb > 1.0) {
                return;
            }
            this.m_fProbs[iRow][iCol] = fProb;
            double sum = 0.0;
            for (i = 0; i < this.m_fProbs[iRow].length; ++i) {
                sum += this.m_fProbs[iRow][i];
            }
            if (sum > 1.0) {
                i = this.m_fProbs[iRow].length - 1;
                while (sum > 1.0) {
                    if (i != iCol) {
                        if (this.m_fProbs[iRow][i] > sum - 1.0) {
                            double[] dArray = this.m_fProbs[iRow];
                            int n = i;
                            dArray[n] = dArray[n] - (sum - 1.0);
                            sum = 1.0;
                        } else {
                            sum -= this.m_fProbs[iRow][i];
                            this.m_fProbs[iRow][i] = 0.0;
                        }
                    }
                    --i;
                }
            } else {
                i = this.m_fProbs[iRow].length - 1;
                while (sum < 1.0) {
                    if (i != iCol) {
                        double[] dArray = this.m_fProbs[iRow];
                        int n = i;
                        dArray[n] = dArray[n] + (1.0 - sum);
                        sum = 1.0;
                    }
                    --i;
                }
            }
            GUI.this.validate();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }

    private class GraphVisualizerMouseMotionListener
    extends MouseMotionAdapter {
        int m_nLastNode = -1;
        int m_nPosX;
        int m_nPosY;

        private GraphVisualizerMouseMotionListener() {
        }

        int getGraphNode(MouseEvent me) {
            this.m_nPosY = 0;
            this.m_nPosX = 0;
            Rectangle r = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            this.m_nPosX += me.getX();
            this.m_nPosY += me.getY();
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                r.x = (int)((double)GUI.this.m_BayesNet.getPositionX(iNode) * GUI.this.m_fScale);
                r.y = (int)((double)GUI.this.m_BayesNet.getPositionY(iNode) * GUI.this.m_fScale);
                if (!r.contains(this.m_nPosX, this.m_nPosY)) continue;
                return iNode;
            }
            return -1;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (GUI.this.m_nSelectedRect != null) {
                GUI.this.m_nSelectedRect.width = me.getPoint().x - GUI.this.m_nSelectedRect.x;
                GUI.this.m_nSelectedRect.height = me.getPoint().y - GUI.this.m_nSelectedRect.y;
                GUI.this.repaint();
                return;
            }
            int iNode = this.getGraphNode(me);
            if (iNode >= 0) {
                if (GUI.this.m_Selection.getSelected().size() > 0) {
                    if (GUI.this.m_Selection.getSelected().contains(iNode)) {
                        GUI.this.m_BayesNet.setPosition(iNode, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)), GUI.this.m_Selection.getSelected());
                    } else {
                        GUI.this.m_Selection.clear();
                        GUI.this.m_BayesNet.setPosition(iNode, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)));
                    }
                    GUI.this.repaint();
                } else {
                    GUI.this.m_BayesNet.setPosition(iNode, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)));
                }
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                GUI.this.a_undo.setEnabled(true);
                GUI.this.a_redo.setEnabled(false);
                GUI.this.m_GraphPanel.highLight(iNode);
            }
            if (iNode < 0) {
                if (this.m_nLastNode >= 0) {
                    GUI.this.m_GraphPanel.repaint();
                    this.m_nLastNode = -1;
                } else {
                    GUI.this.m_nSelectedRect = new Rectangle(me.getPoint().x, me.getPoint().y, 1, 1);
                    GUI.this.m_GraphPanel.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            int iNode = this.getGraphNode(me);
            if (iNode >= 0 && iNode != this.m_nLastNode) {
                GUI.this.m_GraphPanel.highLight(iNode);
                if (this.m_nLastNode >= 0) {
                    GUI.this.m_GraphPanel.highLight(this.m_nLastNode);
                }
                this.m_nLastNode = iNode;
            }
            if (iNode < 0 && this.m_nLastNode >= 0) {
                GUI.this.m_GraphPanel.repaint();
                this.m_nLastNode = -1;
            }
        }
    }

    private class GraphVisualizerMouseListener
    extends MouseAdapter {
        int m_nPosX = 0;
        int m_nPosY = 0;

        private GraphVisualizerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Rectangle r = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            int x = me.getX();
            int y = me.getY();
            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                r.x = (int)((double)GUI.this.m_BayesNet.getPositionX(iNode) * GUI.this.m_fScale);
                r.y = (int)((double)GUI.this.m_BayesNet.getPositionY(iNode) * GUI.this.m_fScale);
                if (!r.contains(x, y)) continue;
                GUI.this.m_nCurrentNode = iNode;
                if (me.getButton() == 3) {
                    this.handleRightNodeClick(me);
                }
                if (me.getButton() == 1) {
                    if ((me.getModifiersEx() & 0x80) != 0) {
                        GUI.this.m_Selection.toggleSelection(GUI.this.m_nCurrentNode);
                    } else if ((me.getModifiersEx() & 0x40) != 0) {
                        GUI.this.m_Selection.addToSelection(GUI.this.m_nCurrentNode);
                    } else {
                        GUI.this.m_Selection.clear();
                        GUI.this.m_Selection.addToSelection(GUI.this.m_nCurrentNode);
                    }
                    GUI.this.repaint();
                }
                return;
            }
            if (me.getButton() == 3) {
                this.handleRightClick(me, (int)((double)x / GUI.this.m_fScale), (int)((double)y / GUI.this.m_fScale));
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (GUI.this.m_nSelectedRect != null) {
                if ((me.getModifiersEx() & 0x80) != 0) {
                    GUI.this.m_Selection.toggleSelection(GUI.this.m_nSelectedRect);
                } else if ((me.getModifiersEx() & 0x40) != 0) {
                    GUI.this.m_Selection.addToSelection(GUI.this.m_nSelectedRect);
                } else {
                    GUI.this.m_Selection.clear();
                    GUI.this.m_Selection.addToSelection(GUI.this.m_nSelectedRect);
                }
                GUI.this.m_nSelectedRect = null;
                GUI.this.repaint();
            }
        }

        void handleRightClick(MouseEvent me, int nPosX, int nPosY) {
            ActionListener act = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (ae.getActionCommand().equals("Add node")) {
                        GUI.this.a_addnode.addNode(GraphVisualizerMouseListener.this.m_nPosX, GraphVisualizerMouseListener.this.m_nPosY);
                        return;
                    }
                    GUI.this.repaint();
                }
            };
            JPopupMenu popupMenu = new JPopupMenu("Choose a value");
            JMenuItem addNodeItem = new JMenuItem("Add node");
            addNodeItem.addActionListener(act);
            popupMenu.add(addNodeItem);
            ArrayList<Integer> selected = GUI.this.m_Selection.getSelected();
            JMenu addArcMenu = new JMenu("Add parent");
            popupMenu.add(addArcMenu);
            if (selected.size() == 0) {
                addArcMenu.setEnabled(false);
            } else {
                int iParent;
                int iNode;
                int nNodes = GUI.this.m_BayesNet.getNrOfNodes();
                boolean[] isNotAllowedAsParent = new boolean[nNodes];
                for (iNode = 0; iNode < selected.size(); ++iNode) {
                    isNotAllowedAsParent[selected.get((int)iNode).intValue()] = true;
                }
                for (int i = 0; i < nNodes; ++i) {
                    for (int iNode2 = 0; iNode2 < nNodes; ++iNode2) {
                        for (iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(iNode2); ++iParent) {
                            if (!isNotAllowedAsParent[GUI.this.m_BayesNet.getParent(iNode2, iParent)]) continue;
                            isNotAllowedAsParent[iNode2] = true;
                        }
                    }
                }
                for (iNode = 0; iNode < selected.size(); ++iNode) {
                    int nNode = selected.get(iNode);
                    for (iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(nNode); ++iParent) {
                        isNotAllowedAsParent[GUI.this.m_BayesNet.getParent((int)nNode, (int)iParent)] = true;
                    }
                }
                ActionListener addParentAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            GUI.this.m_BayesNet.addArc(ae.getActionCommand(), GUI.this.m_Selection.getSelected());
                            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                            GUI.this.updateStatus();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                int nCandidates = 0;
                for (int i = 0; i < nNodes; ++i) {
                    if (isNotAllowedAsParent[i]) continue;
                    JMenuItem item = new JMenuItem(GUI.this.m_BayesNet.getNodeName(i));
                    item.addActionListener(addParentAction);
                    addArcMenu.add(item);
                    ++nCandidates;
                }
                if (nCandidates == 0) {
                    addArcMenu.setEnabled(false);
                }
            }
            this.m_nPosX = nPosX;
            this.m_nPosY = nPosY;
            popupMenu.setLocation(me.getX(), me.getY());
            popupMenu.show(GUI.this.m_GraphPanel, me.getX(), me.getY());
        }

        void handleRightNodeClick(MouseEvent me) {
            GUI.this.m_Selection.clear();
            GUI.this.repaint();
            ActionListener renameValueAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this.renameValue(GUI.this.m_nCurrentNode, ae.getActionCommand());
                }
            };
            ActionListener delValueAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this.delValue(GUI.this.m_nCurrentNode, ae.getActionCommand());
                }
            };
            ActionListener addParentAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        GUI.this.m_BayesNet.addArc(ae.getActionCommand(), GUI.this.m_BayesNet.getNodeName(GUI.this.m_nCurrentNode));
                        GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                        GUI.this.updateStatus();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            ActionListener delParentAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this.deleteArc(GUI.this.m_nCurrentNode, ae.getActionCommand());
                }
            };
            ActionListener delChildAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this.deleteArc(ae.getActionCommand(), GUI.this.m_nCurrentNode);
                }
            };
            ActionListener setAvidenceAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        int iValue;
                        String[] outcomes = GUI.this.m_BayesNet.getValues(GUI.this.m_nCurrentNode);
                        for (iValue = 0; iValue < outcomes.length && !outcomes[iValue].equals(ae.getActionCommand()); ++iValue) {
                        }
                        if (iValue == outcomes.length) {
                            iValue = -1;
                        }
                        if (iValue < outcomes.length) {
                            GUI.this.m_jStatusBar.setText("Set evidence for " + GUI.this.m_BayesNet.getNodeName(GUI.this.m_nCurrentNode));
                            if (GUI.this.m_BayesNet.getEvidence(GUI.this.m_nCurrentNode) < 0 && iValue >= 0) {
                                GUI.this.m_BayesNet.setEvidence(GUI.this.m_nCurrentNode, iValue);
                                GUI.this.m_marginCalculatorWithEvidence.setEvidence(GUI.this.m_nCurrentNode, iValue);
                            } else {
                                GUI.this.m_BayesNet.setEvidence(GUI.this.m_nCurrentNode, iValue);
                                SerializedObject so = new SerializedObject(GUI.this.m_marginCalculator);
                                GUI.this.m_marginCalculatorWithEvidence = (MarginCalculator)so.getObject();
                                for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                                    if (GUI.this.m_BayesNet.getEvidence(iNode) < 0) continue;
                                    GUI.this.m_marginCalculatorWithEvidence.setEvidence(iNode, GUI.this.m_BayesNet.getEvidence(iNode));
                                }
                            }
                            for (int iNode = 0; iNode < GUI.this.m_BayesNet.getNrOfNodes(); ++iNode) {
                                GUI.this.m_BayesNet.setMargin(iNode, GUI.this.m_marginCalculatorWithEvidence.getMargin(iNode));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    GUI.this.repaint();
                }
            };
            ActionListener act = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (ae.getActionCommand().equals("Rename")) {
                        GUI.this.renameNode(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (ae.getActionCommand().equals("Add parent")) {
                        GUI.this.addArcInto(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (ae.getActionCommand().equals("Add value")) {
                        GUI.this.addValue();
                        return;
                    }
                    if (ae.getActionCommand().equals("Delete node")) {
                        GUI.this.deleteNode(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (ae.getActionCommand().equals("Edit CPT")) {
                        GUI.this.editCPT(GUI.this.m_nCurrentNode);
                        return;
                    }
                    GUI.this.repaint();
                }
            };
            try {
                int iParent;
                String[] outcomes;
                JPopupMenu popupMenu = new JPopupMenu("Choose a value");
                JMenu setEvidenceMenu = new JMenu("Set evidence");
                for (String outcome : outcomes = GUI.this.m_BayesNet.getValues(GUI.this.m_nCurrentNode)) {
                    JMenuItem item = new JMenuItem(outcome);
                    item.addActionListener(setAvidenceAction);
                    setEvidenceMenu.add(item);
                }
                setEvidenceMenu.addSeparator();
                JMenuItem item = new JMenuItem("Clear");
                item.addActionListener(setAvidenceAction);
                setEvidenceMenu.add(item);
                popupMenu.add(setEvidenceMenu);
                setEvidenceMenu.setEnabled(GUI.this.m_bViewMargins);
                popupMenu.addSeparator();
                JMenuItem renameItem = new JMenuItem("Rename");
                renameItem.addActionListener(act);
                popupMenu.add(renameItem);
                JMenuItem delNodeItem = new JMenuItem("Delete node");
                delNodeItem.addActionListener(act);
                popupMenu.add(delNodeItem);
                JMenuItem editCPTItem = new JMenuItem("Edit CPT");
                editCPTItem.addActionListener(act);
                popupMenu.add(editCPTItem);
                popupMenu.addSeparator();
                JMenu addArcMenu = new JMenu("Add parent");
                popupMenu.add(addArcMenu);
                int nNodes = GUI.this.m_BayesNet.getNrOfNodes();
                boolean[] isNotAllowedAsParent = new boolean[nNodes];
                isNotAllowedAsParent[GUI.this.m_nCurrentNode] = true;
                for (int i = 0; i < nNodes; ++i) {
                    for (int iNode = 0; iNode < nNodes; ++iNode) {
                        for (iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(iNode); ++iParent) {
                            if (!isNotAllowedAsParent[GUI.this.m_BayesNet.getParent(iNode, iParent)]) continue;
                            isNotAllowedAsParent[iNode] = true;
                        }
                    }
                }
                for (int iParent2 = 0; iParent2 < GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode); ++iParent2) {
                    isNotAllowedAsParent[GUI.this.m_BayesNet.getParent((int)GUI.this.m_nCurrentNode, (int)iParent2)] = true;
                }
                int nCandidates = 0;
                for (int i = 0; i < nNodes; ++i) {
                    if (isNotAllowedAsParent[i]) continue;
                    item = new JMenuItem(GUI.this.m_BayesNet.getNodeName(i));
                    item.addActionListener(addParentAction);
                    addArcMenu.add(item);
                    ++nCandidates;
                }
                if (nCandidates == 0) {
                    addArcMenu.setEnabled(false);
                }
                JMenu delArcMenu = new JMenu("Delete parent");
                popupMenu.add(delArcMenu);
                if (GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode) == 0) {
                    delArcMenu.setEnabled(false);
                }
                for (iParent = 0; iParent < GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode); ++iParent) {
                    item = new JMenuItem(GUI.this.m_BayesNet.getNodeName(GUI.this.m_BayesNet.getParent(GUI.this.m_nCurrentNode, iParent)));
                    item.addActionListener(delParentAction);
                    delArcMenu.add(item);
                }
                JMenu delChildMenu = new JMenu("Delete child");
                popupMenu.add(delChildMenu);
                ArrayList<Integer> nChildren = GUI.this.m_BayesNet.getChildren(GUI.this.m_nCurrentNode);
                if (nChildren.size() == 0) {
                    delChildMenu.setEnabled(false);
                }
                for (int iChild = 0; iChild < nChildren.size(); ++iChild) {
                    item = new JMenuItem(GUI.this.m_BayesNet.getNodeName(nChildren.get(iChild)));
                    item.addActionListener(delChildAction);
                    delChildMenu.add(item);
                }
                popupMenu.addSeparator();
                JMenuItem addValueItem = new JMenuItem("Add value");
                addValueItem.addActionListener(act);
                popupMenu.add(addValueItem);
                JMenu renameValue = new JMenu("Rename value");
                popupMenu.add(renameValue);
                for (String outcome : outcomes) {
                    item = new JMenuItem(outcome);
                    item.addActionListener(renameValueAction);
                    renameValue.add(item);
                }
                JMenu delValue = new JMenu("Delete value");
                popupMenu.add(delValue);
                if (GUI.this.m_BayesNet.getCardinality(GUI.this.m_nCurrentNode) <= 2) {
                    delValue.setEnabled(false);
                }
                for (String outcome : outcomes) {
                    JMenuItem delValueItem = new JMenuItem(outcome);
                    delValueItem.addActionListener(delValueAction);
                    delValue.add(delValueItem);
                }
                popupMenu.setLocation(me.getX(), me.getY());
                popupMenu.show(GUI.this.m_GraphPanel, me.getX(), me.getY());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = -2038911111935517L;

        public MyAction(String sName, String sToolTipText, String sIcon, String sAcceleratorKey) {
            super(sName);
            this.putValue("ShortDescription", sToolTipText);
            this.putValue("LongDescription", sToolTipText);
            if (sAcceleratorKey.length() > 0) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(sAcceleratorKey);
                this.putValue("AcceleratorKey", keyStroke);
            }
            this.putValue("MnemonicKey", sName.charAt(0));
            URL tempURL = ClassLoader.getSystemResource("weka/classifiers/bayes/net/icons/" + sIcon + ".png");
            if (tempURL != null) {
                this.putValue("SmallIcon", new ImageIcon(tempURL));
            } else {
                this.putValue("SmallIcon", new ImageIcon(new BufferedImage(20, 20, 6)));
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

