/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.DoStep;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Mode;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.graphics.GraphicsSource;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.AlignTask;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ManualAlignMode
implements Mode {
    private final Display display;
    private final HashMap<Layer, Landmarks> m = new HashMap();
    private final GraphicsSource gs = new GraphicsSource(){

        @Override
        public List<? extends Paintable> asPaintable(List<? extends Paintable> ds) {
            return ds;
        }

        @Override
        public void paintOnTop(Graphics2D g, Display display, Rectangle srcRect, double magnification) {
            Landmarks lm = (Landmarks)ManualAlignMode.this.m.get(display.getLayer());
            AffineTransform t = g.getTransform();
            g.setTransform(new AffineTransform());
            Stroke stroke = g.getStroke();
            g.setStroke(new BasicStroke(1.0f));
            if (null != lm) {
                lm.paint(g, srcRect, magnification);
            }
            g.setTransform(t);
            g.setStroke(stroke);
        }
    };
    private Layer current_layer = null;
    private int index = -1;

    public ManualAlignMode(Display display) {
        this.display = display;
    }

    @Override
    public GraphicsSource getGraphicsSource() {
        return this.gs;
    }

    @Override
    public boolean canChangeLayer() {
        return true;
    }

    @Override
    public boolean canZoom() {
        return true;
    }

    @Override
    public boolean canPan() {
        return true;
    }

    @Override
    public boolean isDragging() {
        return false;
    }

    private final void addPoint(Layer layer, double x, double y) {
        Landmarks lm = this.m.get(layer);
        if (null == lm) {
            lm = new Landmarks(layer);
            this.m.put(layer, lm);
        }
        lm.add(layer, x, y);
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
        this.current_layer = this.display.getLayer();
        Landmarks lm = this.m.get(this.current_layer);
        if (null == lm) {
            lm = new Landmarks(this.current_layer);
            this.m.put(this.current_layer, lm);
        }
        this.index = lm.find(x_p, y_p, magnification);
        if (-1 == this.index) {
            this.index = lm.add(this.current_layer, x_p, y_p);
        } else if (Utils.isControlDown(me) && me.isShiftDown()) {
            lm.remove(this.index);
            if (0 == lm.points.size()) {
                this.m.remove(this.current_layer);
            }
        }
        this.display.repaintAll3();
    }

    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        Landmarks lm;
        if (-1 != this.index && this.current_layer == this.display.getLayer() && null != (lm = this.m.get(this.current_layer))) {
            lm.set(this.index, x_d, y_d);
            Display.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
    }

    @Override
    public void undoOneStep() {
    }

    @Override
    public void redoOneStep() {
    }

    @Override
    public boolean apply() {
        TranslationModel2D model;
        int min;
        Layer la;
        Object lm;
        if (this.m.size() < 2) {
            Utils.showMessage("Need more than one layer to align!");
            return false;
        }
        final Layer ref_layer = this.display.getLayer();
        if (null == this.m.get(ref_layer)) {
            Utils.showMessage("Please scroll to a layer with landmarks,\nto be used as reference.");
            return false;
        }
        int n_landmarks = -1;
        for (Map.Entry<Layer, Landmarks> e : this.m.entrySet()) {
            lm = e.getValue();
            if (-1 == n_landmarks) {
                n_landmarks = ((Landmarks)lm).points.size();
                continue;
            }
            if (n_landmarks == ((Landmarks)lm).points.size()) continue;
            Utils.showMessage("Can't apply: there are different amounts of landmarks per layer.\nSee the log window.");
            for (Map.Entry<Layer, Landmarks> ee : this.m.entrySet()) {
                Utils.log(ee.getValue().points.size() + " landmarks in layer " + ee.getKey());
            }
            return false;
        }
        final TreeMap<Layer, Landmarks> sorted = new TreeMap<Layer, Landmarks>(new Comparator<Layer>(){

            @Override
            public boolean equals(Object ob) {
                return this == ob;
            }

            @Override
            public int compare(Layer l1, Layer l2) {
                double dz = l1.getZ() - l2.getZ();
                if (dz < 0.0) {
                    return -1;
                }
                if (dz > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        sorted.putAll(this.m);
        int iref = 0;
        lm = sorted.keySet().iterator();
        while (lm.hasNext() && (la = (Layer)lm.next()) != ref_layer) {
            ++iref;
        }
        GenericDialog gd = new GenericDialog("Model");
        gd.addChoice("Model:", Align.Param.modelStrings, Align.Param.modelStrings[1]);
        gd.addCheckbox("Propagate to first layer", 0 != iref);
        ((Component)gd.getCheckboxes().get(0)).setEnabled(0 != iref);
        gd.addCheckbox("Propagate to last layer", sorted.size() - 1 != iref);
        ((Component)gd.getCheckboxes().get(1)).setEnabled(sorted.size() - 1 != iref);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int model_index = gd.getNextChoiceIndex();
        final boolean propagate_to_first = gd.getNextBoolean();
        final boolean propagate_to_last = gd.getNextBoolean();
        switch (model_index) {
            case 0: {
                min = 1;
                model = new TranslationModel2D();
                break;
            }
            case 1: {
                min = 2;
                model = new RigidModel2D();
                break;
            }
            case 2: {
                min = 2;
                model = new SimilarityModel2D();
                break;
            }
            case 3: {
                min = 3;
                model = new AffineModel2D();
                break;
            }
            default: {
                Utils.log("Unknown model index!");
                return false;
            }
        }
        if (n_landmarks < min) {
            Utils.showMessage("Need at least " + min + " landmarks for a " + Align.Param.modelStrings[model_index] + " model");
            return false;
        }
        Bureaucrat.createAndStart((Worker)new Worker.Task("Aligning layers with landmarks", (AbstractAffineModel2D)model){
            final /* synthetic */ AbstractAffineModel2D val$model;
            {
                this.val$model = abstractAffineModel2D;
                super(title);
            }

            @Override
            public void exec() {
                List<Layer> affected;
                TreeMap first_chunk;
                TreeMap first_chunk_ = new TreeMap(sorted.headMap(ref_layer));
                first_chunk_.put(ref_layer, ManualAlignMode.this.m.get(ref_layer));
                final SortedMap second_chunk = sorted.tailMap(ref_layer);
                if (first_chunk_.size() > 1) {
                    TreeMap fc = new TreeMap(new Comparator<Layer>(){

                        @Override
                        public boolean equals(Object ob) {
                            return this == ob;
                        }

                        @Override
                        public int compare(Layer l1, Layer l2) {
                            double dz = l2.getZ() - l1.getZ();
                            if (dz < 0.0) {
                                return -1;
                            }
                            if (dz > 0.0) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    fc.putAll(first_chunk_);
                    first_chunk = fc;
                } else {
                    first_chunk = first_chunk_;
                }
                final LayerSet ls = ref_layer.getParent();
                final HashSet affected_layers = new HashSet(ManualAlignMode.this.m.keySet());
                ArrayList<Patch> patches = new ArrayList<Patch>();
                for (Layer la : ManualAlignMode.this.m.keySet()) {
                    patches.addAll(la.getAll(Patch.class));
                }
                if (propagate_to_first && first_chunk.size() > 1) {
                    affected = ls.getLayers().subList(0, ls.indexOf((Layer)first_chunk.lastKey()));
                    for (Layer la : affected) {
                        patches.addAll(la.getAll(Patch.class));
                    }
                    affected_layers.addAll(affected);
                }
                if (propagate_to_last && second_chunk.size() > 1) {
                    affected = ls.getLayers().subList(ls.indexOf(second_chunk.lastKey()) + 1, ls.size());
                    for (Layer la : affected) {
                        patches.addAll(la.getAll(Patch.class));
                    }
                }
                AlignTask.transformPatchesAndVectorData(patches, new Runnable(){

                    @Override
                    public void run() {
                        AffineTransform aff;
                        HashSet<Displayable> ds = new HashSet<Displayable>();
                        ArrayList<Displayable> patches = new ArrayList<Displayable>();
                        for (Layer layer : affected_layers) {
                            for (Displayable d : layer.getDisplayables()) {
                                if (d.getClass() == Patch.class) {
                                    patches.add(d);
                                    continue;
                                }
                                ds.add(d);
                            }
                        }
                        block2: for (ZDisplayable zd : ls.getZDisplayables()) {
                            for (Layer layer : affected_layers) {
                                if (!zd.paintsAt(layer)) continue;
                                ds.add(zd);
                                continue block2;
                            }
                        }
                        if (ds.size() > 0) {
                            Displayable.DoEdits step = ls.addTransformStepWithData(ds);
                            if (patches.size() > 0) {
                                Iterator<Layer> a = new ArrayList<DoStep>();
                                ((ArrayList)((Object)a)).add((Layer)((Object)new Displayable.DoTransforms().addAll(patches)));
                                step.addDependents((Collection<DoStep>)((Object)a));
                            }
                        }
                        if (first_chunk.size() > 1) {
                            aff = ManualAlignMode.this.align(first_chunk, val$model);
                            if (propagate_to_first) {
                                for (Layer la : ls.getLayers().subList(0, ls.indexOf((Layer)first_chunk.lastKey()))) {
                                    la.apply(Patch.class, aff);
                                }
                            }
                        }
                        if (second_chunk.size() > 1) {
                            aff = ManualAlignMode.this.align(second_chunk, val$model);
                            if (propagate_to_last) {
                                for (Layer la : ls.getLayers().subList(ls.indexOf((Layer)second_chunk.lastKey()) + 1, ls.size())) {
                                    la.apply(Patch.class, aff);
                                }
                            }
                        }
                        Display.repaint();
                        if (ds.size() > 0) {
                            Displayable.DoEdits step2 = ls.addTransformStepWithData(ds);
                            if (patches.size() > 0) {
                                ArrayList<DoStep> a2 = new ArrayList<DoStep>();
                                a2.add(new Displayable.DoTransforms().addAll(patches));
                                step2.addDependents(a2);
                            }
                        }
                    }
                });
            }
        }, this.display.getProject());
        return true;
    }

    private AffineTransform align(SortedMap<Layer, Landmarks> sm, AbstractAffineModel2D<?> model) {
        Layer layer1 = sm.firstKey();
        Landmarks lm1 = (Landmarks)sm.get(sm.firstKey());
        AffineTransform accum = new AffineTransform();
        for (Map.Entry<Layer, Landmarks> e : sm.entrySet()) {
            Layer layer2 = e.getKey();
            if (layer1 == layer2) continue;
            Landmarks lm2 = e.getValue();
            ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
            for (int i = 0; i < lm1.points.size(); ++i) {
                matches.add(new PointMatch(lm2.points.get(i), lm1.points.get(i)));
            }
            AbstractAffineModel2D mod = (AbstractAffineModel2D)model.copy();
            try {
                mod.fit(matches);
            }
            catch (Throwable t) {
                IJError.print(t);
            }
            accum.preConcatenate(mod.createAffine());
            layer2.apply(Patch.class, accum);
            layer1 = layer2;
            lm1 = lm2;
        }
        return accum;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return (Rectangle)this.display.getCanvas().getSrcRect().clone();
    }

    @Override
    public void srcRectUpdated(Rectangle srcRect, double magnification) {
    }

    @Override
    public void magnificationUpdated(Rectangle srcRect, double magnification) {
    }

    public boolean exportLandmarks() {
        if (this.m.isEmpty()) {
            Utils.log("No landmarks to export!");
            return false;
        }
        StringBuilder sb = new StringBuilder("<landmarks>\n");
        for (Map.Entry<Layer, Landmarks> e : new TreeMap<Layer, Landmarks>(this.m).entrySet()) {
            sb.append(" <layer id=\"").append(e.getKey().getId()).append("\">\n");
            for (Point p : e.getValue().points) {
                double[] w = p.getW();
                double x = w[0];
                double y = w[1];
                Collection<Displayable> under = e.getKey().find(Patch.class, (int)x, (int)y, true);
                if (!under.isEmpty()) {
                    Patch patch = (Patch)under.iterator().next();
                    Point2D.Double po = patch.inverseTransformPoint(x, y);
                    x = po.x;
                    y = po.y;
                    sb.append("  <point patch_id=\"").append(patch.getId()).append('\"');
                } else {
                    sb.append("  <point ");
                }
                sb.append(" x=\"").append(x).append("\" y=\"").append(y).append("\" />\n");
            }
            sb.append(" </layer>\n");
        }
        sb.append("</landmarks>");
        File f = Utils.chooseFile(null, "landmarks", ".xml");
        return null != f && Utils.saveToFile(f, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean importLandmarks() {
        block26: {
            String[] fs2333333332;
            InputStream istream;
            HashMap<Layer, Landmarks> current;
            block25: {
                block24: {
                    if (!this.m.isEmpty() && !Utils.checkYN("Remove current landmarks and import new landmarks from a file?")) {
                        return false;
                    }
                    current = new HashMap<Layer, Landmarks>(this.m);
                    istream = null;
                    fs2333333332 = Utils.selectFile("Choose landmarks XML file");
                    if (null != fs2333333332 && null != fs2333333332[0] && null != fs2333333332[1]) break block24;
                    boolean bl = false;
                    try {
                        if (null != istream) {
                            istream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                File f = new File(fs2333333332[0] + fs2333333332[1]);
                if (f.exists() && f.canRead()) break block25;
                Utils.log("ERROR: cannot read file at " + f.getAbsolutePath());
                boolean bl = false;
                try {
                    if (null != istream) {
                        istream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
            this.m.clear();
            SAXParserFactory ft = SAXParserFactory.newInstance();
            ft.setValidating(false);
            SAXParser parser = ft.newSAXParser();
            istream = Utils.createStream(fs2333333332[0] + fs2333333332[1]);
            parser.parse(new InputSource(istream), (DefaultHandler)new LandmarksParser());
            HashSet<Integer> sizes = new HashSet<Integer>();
            for (Landmarks lm : this.m.values()) {
                sizes.add(lm.points.size());
            }
            if (sizes.size() > 1) {
                Utils.log("WARNING: different number of landmarks in at least one layer.");
            }
            Display.repaint();
            try {
                if (null != istream) {
                    istream.close();
                }
                break block26;
            }
            catch (Exception fs2333333332) {}
            break block26;
            catch (Throwable t) {
                try {
                    IJError.print(t);
                    Utils.log("ERROR: did not import any landmarks.");
                    this.m.clear();
                    this.m.putAll(current);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (null != istream) {
                            istream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }

    private final class LandmarksParser
    extends DefaultHandler {
        Layer layer = null;

        private LandmarksParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            HashMap<String, String> a = new HashMap<String, String>();
            for (int i = attributes.getLength() - 1; i > -1; --i) {
                a.put(attributes.getQName(i).toLowerCase(), attributes.getValue(i));
            }
            String tag = qName.toLowerCase();
            if ("point".equals(tag)) {
                if (null == this.layer) {
                    return;
                }
                String sid = (String)a.get("patch_id");
                String sX = (String)a.get("x");
                String sY = (String)a.get("y");
                if (null == sX || null == sY) {
                    Utils.log("ERROR: ignoring point with x, y : " + sX + ", " + sY);
                    return;
                }
                if (null == sid) {
                    ManualAlignMode.this.addPoint(this.layer, Double.parseDouble(sX), Double.parseDouble(sY));
                } else {
                    Patch p = (Patch)this.layer.findById(Long.parseLong(sid));
                    if (null == p) {
                        Utils.log("ERROR: ignoring point for layer " + this.layer + "\n  Reason: could not find Patch with id " + sid);
                        return;
                    }
                    Point2D.Double po = p.transformPoint(Double.parseDouble(sX), Double.parseDouble(sY));
                    ManualAlignMode.this.addPoint(this.layer, (float)po.x, (float)po.y);
                }
            } else if ("layer".equals(tag)) {
                String sid = (String)a.get("id");
                this.layer = null;
                if (null == sid) {
                    Utils.log("ERROR: could not parse a layer that lacks an id!");
                    return;
                }
                this.layer = ManualAlignMode.this.display.getLayerSet().getLayer(Long.parseLong(sid));
                if (null == this.layer) {
                    Utils.log("ERROR: could not find layer with id " + sid);
                    return;
                }
            }
        }

        @Override
        public void endElement(String namespace_URI, String local_name, String qualified_name) {
            if ("layer".equals(qualified_name)) {
                Landmarks lm = (Landmarks)ManualAlignMode.this.m.get(this.layer);
                Utils.log("Loaded " + lm.points.size() + " landmarks for layer " + (this.layer.getParent().indexOf(this.layer) + 1) + ": " + this.layer);
            }
        }
    }

    public class Landmarks {
        Layer layer;
        ArrayList<Point> points = new ArrayList();

        public Landmarks(Layer layer) {
            this.layer = layer;
        }

        public synchronized int add(Layer layer, double x_p, double y_p) {
            if (this.layer != layer) {
                return -1;
            }
            this.points.add(new Point(new double[]{x_p, y_p}));
            return this.points.size() - 1;
        }

        public synchronized int find(double x_p, double y_p, double mag) {
            int index = -1;
            double d = 10.0 / mag;
            if (d < 2.0) {
                d = 2.0;
            }
            double min_dist = 2.147483647E9;
            int i = 0;
            Point ref = new Point(new double[]{x_p, y_p});
            for (Point p : this.points) {
                double dist = Point.distance((Point)ref, (Point)p);
                if (dist <= d && dist <= min_dist) {
                    min_dist = dist;
                    index = i;
                }
                ++i;
            }
            return index;
        }

        public synchronized void set(int index, double x_d, double y_d) {
            if (index < 0 || index >= this.points.size()) {
                return;
            }
            this.points.remove(index);
            this.points.add(index, new Point(new double[]{x_d, y_d}));
        }

        public synchronized void remove(int index) {
            if (index < 0 || index >= this.points.size()) {
                return;
            }
            this.points.remove(index);
        }

        public synchronized void paint(Graphics2D g, Rectangle srcRect, double mag) {
            g.setColor(Color.yellow);
            g.setFont(new Font("SansSerif", 1, 14));
            int i = 1;
            for (Point p : this.points) {
                double[] w = p.getW();
                int x = (int)((w[0] - (double)srcRect.x) * mag);
                int y = (int)((w[1] - (double)srcRect.y) * mag);
                g.setColor(Color.black);
                g.drawLine(x - 4, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y - 4, x + 1, y + 4);
                g.setColor(Color.yellow);
                g.drawLine(x - 4, y, x + 4, y);
                g.drawLine(x, y - 4, x, y + 4);
                g.drawString(Integer.toString(i), x + 5, y + 5);
                ++i;
            }
        }
    }
}

