/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.plugin.filter.GaussianBlur;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.imaging.IntegralHistogram2d;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class CorrectBackground
implements IFilter {
    protected int medianRadius = 512;
    protected int nBins = 32;
    protected boolean postGaussian = true;
    protected float sigma = 5.0f;

    public CorrectBackground() {
    }

    public CorrectBackground(int radius, float sigma) {
        this.medianRadius = radius;
        this.sigma = sigma;
    }

    public CorrectBackground(Map<String, String> params) {
        try {
            this.medianRadius = Integer.parseInt(params.get("medianradius"));
            this.nBins = Integer.parseInt(params.get("nbins"));
            this.postGaussian = Boolean.parseBoolean(params.get("postgaussian"));
            this.sigma = Float.parseFloat(params.get("sigma"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cound not create CorrectBackground filter!", e);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        ShortProcessor sp;
        try {
            sp = (ShortProcessor)ip;
        }
        catch (ClassCastException cce) {
            System.out.println("CorrectBackground supports 16-bit images only!");
            return ip;
        }
        double min = ip.getMin();
        double max = ip.getMax();
        long[] hist = IntegralHistogram2d.integralHistogram2d((short[])sp.getPixels(), sp.getWidth(), sp.getHeight(), this.nBins, min, max);
        short[] median = IntegralHistogram2d.median(sp.getWidth(), sp.getHeight(), hist, this.nBins, min, max, this.medianRadius);
        if (this.postGaussian) {
            GaussianBlur g = new GaussianBlur();
            g.blurGaussian((ImageProcessor)new ShortProcessor(sp.getWidth(), sp.getHeight(), median, null), (double)this.sigma, (double)this.sigma, 0.02);
        }
        double binInc = (max - min + 1.0) / (double)this.nBins;
        double sum = 0.0;
        long count = 0L;
        int i = hist.length - this.nBins;
        for (int j = 0; j < this.nBins; ++j) {
            sum += (double)hist[i] * (min + (double)j * binInc);
            count += hist[i];
            ++i;
        }
        double mean = sum / (double)count;
        short[] p = (short[])sp.getPixels();
        for (int i2 = 0; i2 < p.length; ++i2) {
            double m = median[i2] & 0xFFFF;
            p[i2] = (short)((double)(p[i2] & 0xFFFF) / m * mean);
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" medianRadius=\"" + this.medianRadius + "\" nBins=\"" + this.nBins + "\" postGaussian=\"" + this.postGaussian + "\" sigma=\"" + this.sigma + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            CorrectBackground cb = (CorrectBackground)o;
            return cb.medianRadius == this.medianRadius && cb.nBins == this.nBins && cb.sigma == this.sigma && cb.postGaussian == this.postGaussian;
        }
        return false;
    }
}

