/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class StdOutWindow {
    private static final StdOutWindow instance = new StdOutWindow();
    private static PrintStream default_err;
    private static PrintStream default_out;
    private JFrame window = null;

    private StdOutWindow() {
    }

    private void init() {
        JTextArea aout = new JTextArea();
        JTextArea aerr = new JTextArea();
        aout.setEditable(false);
        aerr.setEditable(false);
        JSplitPane split = new JSplitPane(0, this.wrap(aout, "StdOut"), this.wrap(aerr, "StdErr"));
        split.setDividerLocation(0.7);
        this.window = new JFrame("System log");
        this.window.setDefaultCloseOperation(0);
        this.window.getContentPane().add(split);
        this.window.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle b = this.window.getBounds();
        this.window.setLocation(screen.width - b.width, screen.height - b.height);
        this.window.setVisible(true);
        System.setOut(new PrintStream(new MonitorableOutputStream(10000, aout)));
        System.setErr(new PrintStream(new MonitorableOutputStream(10000, aerr)));
    }

    private Component wrap(Component c, String title) {
        JScrollPane s = new JScrollPane(c);
        s.setBackground(Color.white);
        s.setMinimumSize(new Dimension(400, 15));
        s.setPreferredSize(new Dimension(400, 200));
        s.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), title));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        StdOutWindow stdOutWindow = instance;
        synchronized (stdOutWindow) {
            if (null != StdOutWindow.instance.window) {
                return;
            }
            default_out = System.out;
            default_err = System.err;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        instance.init();
                    }
                    catch (Exception e) {
                        IJ.log((String)("error: " + e.toString()));
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quit() {
        StdOutWindow stdOutWindow = instance;
        synchronized (stdOutWindow) {
            System.setOut(default_out);
            System.setErr(default_err);
            default_out = null;
            default_err = null;
            StdOutWindow.instance.window.dispose();
            StdOutWindow.instance.window = null;
        }
    }

    private class MonitorableOutputStream
    extends ByteArrayOutputStream {
        final JTextArea a;

        MonitorableOutputStream(int size, JTextArea a) {
            super(size);
            this.a = a;
        }

        @Override
        public synchronized void write(int b) {
            super.write(b);
            this.a.setText(this.toString());
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            this.a.setText(this.toString());
        }
    }
}

