/*
 * Decompiled with CFR 0.152.
 */
package lenscorrection;

import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import lenscorrection.NonLinearTransform;
import mpi.fruitfly.general.MultiThreading;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class Distortion_Correction
implements PlugIn {
    public static final BasicParam p = new BasicParam();
    public static final PluginParam sp = new PluginParam();
    NonLinearTransform nlt = new NonLinearTransform();
    AbstractAffineModel2D<?>[] models;

    public void run(String arg) {
        if (!sp.setup("Lens Correction")) {
            return;
        }
        ArrayList<ArrayList> inliers = null;
        if (Distortion_Correction.sp.saveOrLoad == 0) {
            ImagePlus imgTmp = new Opener().openImage(Distortion_Correction.sp.source_dir + Distortion_Correction.sp.names[0]);
            int imageWidth = imgTmp.getWidth();
            int imageHeight = imgTmp.getHeight();
            imgTmp.flush();
            List<Feature>[] siftFeatures = Distortion_Correction.extractSIFTFeaturesThreaded(Distortion_Correction.sp.numberOfImages, Distortion_Correction.sp.source_dir, Distortion_Correction.sp.names);
            ArrayList[] inliersTmp = new ArrayList[Distortion_Correction.sp.numberOfImages * (Distortion_Correction.sp.numberOfImages - 1)];
            this.models = new AbstractAffineModel2D[Distortion_Correction.sp.numberOfImages * (Distortion_Correction.sp.numberOfImages - 1)];
            IJ.showStatus((String)"Estimating Correspondences");
            for (int i = 0; i < Distortion_Correction.sp.numberOfImages; ++i) {
                IJ.log((String)("Estimating correspondences of image " + i));
                IJ.showProgress((int)(i + 1), (int)Distortion_Correction.sp.numberOfImages);
                Distortion_Correction.extractSIFTPointsThreaded(i, siftFeatures, inliersTmp, this.models);
            }
            int wholeCount = 0;
            inliers = new ArrayList<ArrayList>();
            for (int i = 0; i < inliersTmp.length; ++i) {
                if (inliersTmp[i].size() > 10) {
                    wholeCount += inliersTmp[i].size();
                }
                inliers.add(inliersTmp[i]);
            }
            double[][] tp = new double[wholeCount][6];
            double[][] h1 = new double[wholeCount][2];
            double[][] h2 = new double[wholeCount][2];
            int count = 0;
            for (int i = 0; i < inliers.size(); ++i) {
                if (((List)inliers.get(i)).size() <= 10) continue;
                double[][] points1 = new double[((List)inliers.get(i)).size()][2];
                double[][] points2 = new double[((List)inliers.get(i)).size()][2];
                for (int j = 0; j < ((List)inliers.get(i)).size(); ++j) {
                    double[] tmp1 = ((PointMatch)((List)inliers.get(i)).get(j)).getP1().getL();
                    double[] tmp2 = ((PointMatch)((List)inliers.get(i)).get(j)).getP2().getL();
                    points1[j][0] = tmp1[0];
                    points1[j][1] = tmp1[1];
                    points2[j][0] = tmp2[0];
                    points2[j][1] = tmp2[1];
                    h1[count] = new double[]{tmp1[0], tmp1[1]};
                    h2[count] = new double[]{tmp2[0], tmp2[1]};
                    this.models[i].createAffine().getMatrix(tp[count]);
                    ++count;
                }
            }
            this.nlt = Distortion_Correction.distortionCorrection(h1, h2, tp, Distortion_Correction.sp.dimension, Distortion_Correction.sp.lambda, imageWidth, imageHeight);
            this.nlt.visualizeSmall(Distortion_Correction.sp.lambda);
            while (true) {
                GenericDialog gdl = new GenericDialog("New lambda?");
                gdl.addMessage("If the distortion field shows a clear translation, \n it is likely that you need to increase lambda.");
                gdl.addNumericField("lambda :", Distortion_Correction.sp.lambda, 6);
                gdl.showDialog();
                if (gdl.wasCanceled()) break;
                Distortion_Correction.sp.lambda = gdl.getNextNumber();
                this.nlt = Distortion_Correction.distortionCorrection(h1, h2, tp, Distortion_Correction.sp.dimension, Distortion_Correction.sp.lambda, imageWidth, imageHeight);
                this.nlt.visualizeSmall(Distortion_Correction.sp.lambda);
            }
            this.nlt.save(Distortion_Correction.sp.source_dir + Distortion_Correction.sp.saveFileName);
        }
        if (Distortion_Correction.sp.saveOrLoad == 1) {
            this.nlt.load(Distortion_Correction.sp.source_dir + Distortion_Correction.sp.saveFileName);
            this.nlt.print();
        }
        if (Distortion_Correction.sp.applyCorrection || Distortion_Correction.sp.visualizeResults) {
            Distortion_Correction.sp.target_dir = this.correctImages();
        }
        if (Distortion_Correction.sp.visualizeResults && Distortion_Correction.sp.saveOrLoad == 0) {
            IJ.log((String)"call nlt.visualize()");
            this.nlt.visualize();
            if (null != Distortion_Correction.sp.target_dir) {
                IJ.log((String)"Evaluating distortion correction...");
                this.evaluateCorrection(inliers);
            }
        }
        IJ.log((String)" Done ");
    }

    public void evaluateCorrection(List<List<PointMatch>> inliers) {
        IJ.showStatus((String)"Evaluating Distortion Correction");
        double[][] original = new double[Distortion_Correction.sp.numberOfImages][2];
        double[][] corrected = new double[Distortion_Correction.sp.numberOfImages][2];
        for (int i = Distortion_Correction.sp.firstImageIndex; i < Distortion_Correction.sp.numberOfImages; ++i) {
            original[i] = this.evaluateCorrectionXcorr(i, Distortion_Correction.sp.source_dir);
            corrected[i] = this.evaluateCorrectionXcorr(i, Distortion_Correction.sp.target_dir);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetGain = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetGrad = new DefaultCategoryDataset();
        for (int i = 0; i < original.length; ++i) {
            dataset.setValue(Math.abs(original[i][0]), (Comparable)((Object)"before"), (Comparable)((Object)("image" + i)));
            dataset.setValue(Math.abs(corrected[i][0]), (Comparable)((Object)"after"), (Comparable)((Object)("image" + i)));
            datasetGrad.setValue(Math.abs(original[i][1]), (Comparable)((Object)"before"), (Comparable)((Object)("image" + i)));
            datasetGrad.setValue(Math.abs(corrected[i][1]), (Comparable)((Object)"after"), (Comparable)((Object)("image" + i)));
            datasetGain.setValue(Math.abs(corrected[i][0]) - Math.abs(original[i][0]), (Comparable)((Object)"gray"), (Comparable)((Object)("image" + i)));
            datasetGain.setValue(Math.abs(corrected[i][1]) - Math.abs(original[i][1]), (Comparable)((Object)"grad"), (Comparable)((Object)("image" + i)));
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"Xcorr before and after correction", (String)"ImageNumber", (String)"Xcorr", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ImagePlus imp = new ImagePlus("Xcorr before and after correction Plot", (Image)chart.createBufferedImage(500, 300));
        imp.show();
        JFreeChart chartGrad = ChartFactory.createBarChart((String)"XcorrGradient before and after correction", (String)"ImageNumber", (String)"Xcorr", (CategoryDataset)datasetGrad, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ImagePlus impGrad = new ImagePlus("XcorrGradient before and after correction Plot", (Image)chartGrad.createBufferedImage(500, 300));
        impGrad.show();
        JFreeChart chartGain = ChartFactory.createBarChart((String)"Gain in Xcorr", (String)"ImageNumber", (String)"Xcorr", (CategoryDataset)datasetGain, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ImagePlus impGain = new ImagePlus("Gain in Xcorr Plot", (Image)chartGain.createBufferedImage(500, 300));
        impGain.show();
        this.visualizePoints(inliers);
        String original0 = "";
        String original1 = "";
        String corrected0 = "";
        String corrected1 = "";
        String gain0 = "";
        String gain1 = "";
        for (int i = 0; i < original.length; ++i) {
            original0 = original0 + Double.toString(original[i][0]) + "; ";
            original1 = original1 + Double.toString(original[i][1]) + "; ";
            corrected0 = corrected0 + Double.toString(corrected[i][0]) + "; ";
            corrected1 = corrected1 + Double.toString(corrected[i][1]) + "; ";
            gain0 = gain0 + Double.toString(Math.abs(corrected[i][0]) - Math.abs(original[i][0])) + "; ";
            gain1 = gain1 + Double.toString(Math.abs(corrected[i][1]) - Math.abs(original[i][1])) + "; ";
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(Distortion_Correction.sp.source_dir + "xcorrData.log"));
            out.write(original0);
            out.newLine();
            out.newLine();
            out.write(original1);
            out.newLine();
            out.newLine();
            out.write(corrected0);
            out.newLine();
            out.newLine();
            out.write(corrected1);
            out.newLine();
            out.newLine();
            out.write(gain0);
            out.newLine();
            out.newLine();
            out.write(gain1);
            out.newLine();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    protected void extractSIFTPoints(int index, List<Feature>[] siftFeatures, List<List<PointMatch>> inliers, List<AbstractAffineModel2D<?>> models) {
        ArrayList<Vector> candidates = new ArrayList<Vector>();
        for (int j = 0; j < siftFeatures.length; ++j) {
            if (index == j) continue;
            candidates.add(FloatArray2DSIFT.createMatches(siftFeatures[index], siftFeatures[j], (double)1.5, null, (double)3.4028234663852886E38, (double)0.5));
        }
        for (int i = 0; i < candidates.size(); ++i) {
            TranslationModel2D m;
            ArrayList tmpInliers = new ArrayList();
            switch (Distortion_Correction.sp.expectedModelIndex) {
                case 0: {
                    m = new TranslationModel2D();
                    break;
                }
                case 1: {
                    m = new RigidModel2D();
                    break;
                }
                case 2: {
                    m = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    m = new AffineModel2D();
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                m.filterRansac((List)candidates.get(i), tmpInliers, 1000, (double)Distortion_Correction.sp.maxEpsilon, (double)Distortion_Correction.sp.minInlierRatio, 10);
            }
            catch (NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            inliers.add(tmpInliers);
            models.add((AbstractAffineModel2D<?>)m);
        }
    }

    public static NonLinearTransform createInverseDistortionModel(Collection<PointMatchCollectionAndAffine> pointMatches, int dimension, double lambda, int imageWidth, int imageHeight) {
        int wholeCount = 0;
        for (PointMatchCollectionAndAffine pma : pointMatches) {
            if (pma.pointMatches.size() <= 10) continue;
            wholeCount += pma.pointMatches.size();
        }
        double[][] tp = new double[wholeCount][6];
        double[][] h1 = new double[wholeCount][2];
        double[][] h2 = new double[wholeCount][2];
        int count = 0;
        for (PointMatchCollectionAndAffine pma : pointMatches) {
            if (pma.pointMatches.size() <= 10) continue;
            int i = 0;
            for (PointMatch match : pma.pointMatches) {
                double[] tmp1 = match.getP1().getL();
                double[] tmp2 = match.getP2().getL();
                h1[count] = new double[]{tmp1[0], tmp1[1]};
                h2[count] = new double[]{tmp2[0], tmp2[1]};
                pma.affine.getMatrix(tp[count]);
                ++count;
                ++i;
            }
        }
        NonLinearTransform nlt = Distortion_Correction.distortionCorrection(h1, h2, tp, dimension, lambda, imageWidth, imageHeight);
        nlt.inverseTransform(h1);
        return nlt;
    }

    protected static NonLinearTransform distortionCorrection(double[][] hack1, double[][] hack2, double[][] transformParams, int dimension, double lambda, int w, int h) {
        IJ.showStatus((String)"Getting the Distortion Field");
        NonLinearTransform nlt = new NonLinearTransform(dimension, w, h);
        nlt.estimateDistortion(hack1, hack2, transformParams, lambda, w, h);
        nlt.inverseTransform(hack1);
        return nlt;
    }

    protected String correctImages() {
        String[] namesTarget;
        if (!Distortion_Correction.sp.applyCorrection) {
            Distortion_Correction.sp.target_dir = System.getProperty("user.dir").replace('\\', '/') + "/distCorr_tmp/";
            System.out.println("Tmp target directory: " + Distortion_Correction.sp.target_dir);
            if (new File(Distortion_Correction.sp.target_dir).exists()) {
                System.out.println("removing old tmp directory!");
                String[] filesToDelete = new File(Distortion_Correction.sp.target_dir).list();
                for (int i = 0; i < filesToDelete.length; ++i) {
                    System.out.println(filesToDelete[i]);
                    boolean deleted = new File(Distortion_Correction.sp.target_dir + filesToDelete[i]).delete();
                    if (deleted) continue;
                    IJ.log((String)"Error: Could not remove temporary directory!");
                }
                new File(Distortion_Correction.sp.target_dir).delete();
            }
            try {
                boolean success = new File(Distortion_Correction.sp.target_dir).mkdir();
                if (success) {
                    new File(Distortion_Correction.sp.target_dir).deleteOnExit();
                }
            }
            catch (Exception e) {
                IJ.showMessage((String)("Error! Could not create temporary directory. " + e.getMessage()));
            }
        }
        if (Distortion_Correction.sp.target_dir == "" || null == Distortion_Correction.sp.target_dir) {
            DirectoryChooser dc = new DirectoryChooser("Target Directory");
            Distortion_Correction.sp.target_dir = dc.getDirectory();
            if (null == Distortion_Correction.sp.target_dir) {
                return null;
            }
            Distortion_Correction.sp.target_dir = Distortion_Correction.sp.target_dir.replace('\\', '/');
            if (!Distortion_Correction.sp.target_dir.endsWith("/")) {
                Distortion_Correction.sp.target_dir = Distortion_Correction.sp.target_dir + "/";
            }
        }
        if ((namesTarget = new File(Distortion_Correction.sp.target_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String namesTarget) {
                int idot = namesTarget.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return namesTarget.contains(namesTarget.substring(idot).toLowerCase());
            }
        })).length > 0) {
            IJ.showMessage((String)"Overwrite Message", (String)"There  are already images in that directory. These will be used for evaluation.");
        } else {
            IJ.showStatus((String)"Correcting Images");
            Thread[] threads = MultiThreading.newThreads();
            final AtomicInteger ai = new AtomicInteger(Distortion_Correction.sp.applyCorrection ? 0 : Distortion_Correction.sp.firstImageIndex);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    @Override
                    public void run() {
                        this.setPriority(5);
                        int i = ai.getAndIncrement();
                        while (i < (Distortion_Correction.sp.applyCorrection ? Distortion_Correction.sp.names.length : Distortion_Correction.sp.firstImageIndex + Distortion_Correction.sp.numberOfImages)) {
                            IJ.log((String)("Correcting image " + Distortion_Correction.sp.names[i]));
                            ImagePlus imps = new Opener().openImage(Distortion_Correction.sp.source_dir + Distortion_Correction.sp.names[i]);
                            imps.setProcessor(imps.getTitle(), imps.getProcessor().convertToShort(false));
                            ImageProcessor[] transErg = Distortion_Correction.this.nlt.transform(imps.getProcessor());
                            imps.setProcessor(imps.getTitle(), transErg[0]);
                            if (!Distortion_Correction.sp.applyCorrection) {
                                new File(Distortion_Correction.sp.target_dir + Distortion_Correction.sp.names[i]).deleteOnExit();
                            }
                            new FileSaver(imps).saveAsTiff(Distortion_Correction.sp.target_dir + Distortion_Correction.sp.names[i]);
                            i = ai.getAndIncrement();
                        }
                    }
                };
            }
            MultiThreading.startAndJoin(threads);
        }
        return Distortion_Correction.sp.target_dir;
    }

    protected double[] evaluateCorrectionXcorr(int index, String directory) {
        ImagePlus im1 = new Opener().openImage(directory + Distortion_Correction.sp.names[index]);
        im1.setProcessor(Distortion_Correction.sp.names[index], im1.getProcessor().convertToShort(false));
        int count = 0;
        ArrayList<Double> xcorrVals = new ArrayList<Double>();
        ArrayList<Double> xcorrValsGrad = new ArrayList<Double>();
        for (int i = 0; i < Distortion_Correction.sp.numberOfImages; ++i) {
            if (i == index) continue;
            if (this.models[index * (Distortion_Correction.sp.numberOfImages - 1) + count] == null) {
                ++count;
                continue;
            }
            ImagePlus newImg = new Opener().openImage(directory + Distortion_Correction.sp.names[i + Distortion_Correction.sp.firstImageIndex]);
            newImg.setProcessor(newImg.getTitle(), newImg.getProcessor().convertToShort(false));
            newImg.setProcessor(Distortion_Correction.sp.names[i + Distortion_Correction.sp.firstImageIndex], this.applyTransformToImageInverse(this.models[index * (Distortion_Correction.sp.numberOfImages - 1) + count], newImg.getProcessor()));
            xcorrVals.add(Distortion_Correction.getXcorrBlackOut(im1.getProcessor(), newImg.getProcessor()));
            xcorrValsGrad.add(this.getXcorrBlackOutGradient(im1.getProcessor(), newImg.getProcessor()));
            ++count;
        }
        Collections.sort(xcorrVals);
        Collections.sort(xcorrValsGrad);
        double m1 = 0.0;
        double m2 = 0.0;
        for (int i = 0; i < xcorrVals.size(); ++i) {
            m1 += ((Double)xcorrVals.get(i)).doubleValue();
            m2 += ((Double)xcorrValsGrad.get(i)).doubleValue();
        }
        double[] means = new double[]{m1 /= (double)xcorrVals.size(), m2 /= (double)xcorrVals.size()};
        return means;
    }

    ImageProcessor applyTransformToImageInverse(AbstractAffineModel2D<?> a, ImageProcessor ip) {
        ImageProcessor newIp = ip.duplicate();
        newIp.max(0.0);
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                double[] position = new double[]{x, y};
                double[] newPosition = new double[]{0.0, 0.0};
                try {
                    newPosition = a.applyInverse(position);
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
                int xn = (int)newPosition[0];
                int yn = (int)newPosition[1];
                if (xn < 0 || yn < 0 || xn >= ip.getWidth() || yn >= ip.getHeight()) continue;
                newIp.set(xn, yn, ip.get(x, y));
            }
        }
        return newIp;
    }

    double getXcorrBlackOutGradient(ImageProcessor ip1, ImageProcessor ip2) {
        ImageProcessor ip1g = this.getGradientSobel(ip1);
        ImageProcessor ip2g = this.getGradientSobel(ip2);
        return Distortion_Correction.getXcorrBlackOut(ip1g, ip2g);
    }

    ImageProcessor getGradientSobel(ImageProcessor ip) {
        ImageProcessor ipGrad = ip.duplicate();
        ipGrad.max(0.0);
        for (int i = 1; i < ipGrad.getWidth() - 1; ++i) {
            for (int j = 1; j < ipGrad.getHeight() - 1; ++j) {
                if (ip.get(i - 1, j - 1) == 0 || ip.get(i - 1, j) == 0 || ip.get(i - 1, j + 1) == 0 || ip.get(i, j - 1) == 0 || ip.get(i, j) == 0 || ip.get(i, j + 1) == 0 || ip.get(i + 1, j - 1) == 0 || ip.get(i + 1, j) == 0 || ip.get(i + 1, j + 1) == 0) continue;
                double gradX = (double)(-ip.get(i - 1, j - 1)) - (double)(2 * ip.get(i - 1, j)) - (double)ip.get(i - 1, j + 1) + (double)ip.get(i + 1, j - 1) + (double)(2 * ip.get(i + 1, j)) + (double)ip.get(i + 1, j + 1);
                double gradY = (double)(-ip.get(i - 1, j - 1)) - (double)(2 * ip.get(i, j - 1)) - (double)ip.get(i + 1, j - 1) + (double)ip.get(i - 1, j + 1) + (double)(2 * ip.get(i, j + 1)) + (double)ip.get(i + 1, j + 1);
                double mag = Math.sqrt(gradX * gradX + gradY * gradY);
                ipGrad.setf(i, j, (float)mag);
            }
        }
        return ipGrad;
    }

    static double getXcorrBlackOut(ImageProcessor ip1, ImageProcessor ip2) {
        ip1 = ip1.convertToFloat();
        ip2 = ip2.convertToFloat();
        for (int i = 0; i < ip1.getWidth(); ++i) {
            for (int j = 0; j < ip1.getHeight(); ++j) {
                if (ip1.get(i, j) == 0) {
                    ip2.set(i, j, 0);
                }
                if (ip2.get(i, j) != 0) continue;
                ip1.set(i, j, 0);
            }
        }
        float[] data1 = (float[])ip1.getPixels();
        float[] data2 = (float[])ip2.getPixels();
        double[] data1b = new double[data1.length];
        double[] data2b = new double[data2.length];
        int count = 0;
        double mean1 = 0.0;
        double mean2 = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            data1b[i] = data1[i];
            data2b[i] = data2[i];
            mean1 += data1b[i];
            mean2 += data2b[i];
            ++count;
        }
        mean1 /= (double)count;
        mean2 /= (double)count;
        double L2_1 = 0.0;
        double L2_2 = 0.0;
        for (int i = 0; i < count; ++i) {
            L2_1 += (data1b[i] - mean1) * (data1b[i] - mean1);
            L2_2 += (data2b[i] - mean2) * (data2b[i] - mean2);
        }
        L2_1 = Math.sqrt(L2_1);
        L2_2 = Math.sqrt(L2_2);
        double xcorr = 0.0;
        for (int i = 0; i < count; ++i) {
            xcorr += (data1b[i] - mean1) / L2_1 * ((data2b[i] - mean2) / L2_2);
        }
        return xcorr;
    }

    void visualizePoints(List<List<PointMatch>> inliers) {
        ColorProcessor ip = new ColorProcessor(this.nlt.getWidth(), this.nlt.getHeight());
        ip.setColor(Color.red);
        ip.setLineWidth(5);
        for (int i = 0; i < inliers.size(); ++i) {
            for (int j = 0; j < inliers.get(i).size(); ++j) {
                double[] tmp1 = inliers.get(i).get(j).getP1().getW();
                double[] tmp2 = inliers.get(i).get(j).getP2().getL();
                ip.setColor(Color.red);
                ip.drawDot((int)tmp2[0], (int)tmp2[1]);
                ip.setColor(Color.blue);
                ip.drawDot((int)tmp1[0], (int)tmp1[1]);
            }
        }
        ImagePlus points = new ImagePlus("Corresponding Points after correction", (ImageProcessor)ip);
        points.show();
    }

    public void getTransform(double[][] points1, double[][] points2, double[][] transformParams) {
        double[][] p1 = new double[points1.length][3];
        double[][] p2 = new double[points2.length][3];
        for (int i = 0; i < points1.length; ++i) {
            p1[i][0] = points1[i][0];
            p1[i][1] = points1[i][1];
            p1[i][2] = 100.0;
            p2[i][0] = points2[i][0];
            p2[i][1] = points2[i][1];
            p2[i][2] = 100.0;
        }
        Matrix s1 = new Matrix(p1);
        Matrix s2 = new Matrix(p2);
        Matrix t = s1.transpose().times(s1).inverse().times(s1.transpose()).times(s2);
        t = t.inverse();
        for (int i = 0; i < transformParams.length; ++i) {
            if (transformParams[i][0] != -10.0) continue;
            transformParams[i][0] = t.get(0, 0);
            transformParams[i][1] = t.get(0, 1);
            transformParams[i][2] = t.get(1, 0);
            transformParams[i][3] = t.get(1, 1);
            transformParams[i][4] = t.get(2, 0);
            transformParams[i][5] = t.get(2, 1);
        }
        t.print(1, 1);
    }

    static List<Feature>[] extractSIFTFeaturesThreaded(final int numberOfImages, final String directory, final String[] names) {
        final List[] siftFeatures = new ArrayList[numberOfImages];
        Thread[] threads = MultiThreading.newThreads();
        final AtomicInteger ai = new AtomicInteger(0);
        IJ.showStatus((String)"Extracting SIFT Features");
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int i = ai.getAndIncrement();
                    while (i < numberOfImages) {
                        ArrayList fs = new ArrayList();
                        ImagePlus imps = new Opener().openImage(directory + names[i + Distortion_Correction.sp.firstImageIndex]);
                        imps.setProcessor(imps.getTitle(), imps.getProcessor().convertToFloat());
                        FloatArray2DSIFT sift = new FloatArray2DSIFT(Distortion_Correction.sp.sift.clone());
                        SIFT ijSIFT = new SIFT(sift);
                        ijSIFT.extractFeatures(imps.getProcessor(), fs);
                        Collections.sort(fs);
                        IJ.log((String)("Extracting SIFT of image: " + i));
                        siftFeatures[i] = fs;
                        i = ai.getAndIncrement();
                    }
                }
            };
        }
        MultiThreading.startAndJoin(threads);
        return siftFeatures;
    }

    protected static void extractSIFTPointsThreaded(final int index, final List<Feature>[] siftFeatures, final List<PointMatch>[] inliers, final AbstractAffineModel2D<?>[] models) {
        final List[] candidates = new List[siftFeatures.length - 1];
        Thread[] threads = MultiThreading.newThreads();
        final AtomicInteger ai = new AtomicInteger(0);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    this.setPriority(5);
                    int j = ai.getAndIncrement();
                    while (j < candidates.length) {
                        int i = j < index ? j : j + 1;
                        candidates[j] = FloatArray2DSIFT.createMatches((List)siftFeatures[index], (List)siftFeatures[i], (double)1.5, null, (double)3.4028234663852886E38, (double)0.5);
                        j = ai.getAndIncrement();
                    }
                }
            };
        }
        MultiThreading.startAndJoin(threads);
        final AtomicInteger ai2 = new AtomicInteger(0);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    this.setPriority(5);
                    int i = ai2.getAndIncrement();
                    while (i < candidates.length) {
                        TranslationModel2D m;
                        ArrayList tmpInliers = new ArrayList();
                        switch (Distortion_Correction.sp.expectedModelIndex) {
                            case 0: {
                                m = new TranslationModel2D();
                                break;
                            }
                            case 1: {
                                m = new RigidModel2D();
                                break;
                            }
                            case 2: {
                                m = new SimilarityModel2D();
                                break;
                            }
                            case 3: {
                                m = new AffineModel2D();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        boolean modelFound = false;
                        try {
                            modelFound = m.filterRansac(candidates[i], tmpInliers, 1000, (double)Distortion_Correction.sp.maxEpsilon, (double)Distortion_Correction.sp.minInlierRatio, 10);
                        }
                        catch (NotEnoughDataPointsException e) {
                            modelFound = false;
                        }
                        if (modelFound) {
                            IJ.log((String)("Model found:\n  " + candidates[i].size() + " candidates\n  " + tmpInliers.size() + " inliers\n  " + String.format("%.2f", m.getCost()) + "px average displacement"));
                        } else {
                            IJ.log((String)"No Model found.");
                        }
                        inliers[index * (Distortion_Correction.sp.numberOfImages - 1) + i] = tmpInliers;
                        models[index * (Distortion_Correction.sp.numberOfImages - 1) + i] = m;
                        i = ai2.getAndIncrement();
                    }
                }
            };
        }
        MultiThreading.startAndJoin(threads);
    }

    public static class PluginParam
    extends BasicParam {
        public String source_dir = "";
        public String target_dir = "";
        public String saveFileName = "distCorr.txt";
        public boolean applyCorrection = true;
        public boolean visualizeResults = true;
        public int numberOfImages = 9;
        public int firstImageIndex = 0;
        public String[] names;
        public int saveOrLoad = 0;

        @Override
        public void addFields(GenericDialog gd) {
            super.addFields(gd);
        }

        @Override
        public boolean readFields(GenericDialog gd) {
            super.readFields(gd);
            return !gd.invalidNumber();
        }

        @Override
        public boolean setup(String title) {
            this.source_dir = "";
            while (this.source_dir == "") {
                DirectoryChooser dc = new DirectoryChooser("Calibration Images");
                this.source_dir = dc.getDirectory();
                if (null == this.source_dir) {
                    return false;
                }
                this.source_dir = this.source_dir.replace('\\', '/');
                if (this.source_dir.endsWith("/")) continue;
                this.source_dir = this.source_dir + "/";
            }
            String exts = ".tif.jpg.png.gif.tiff.jpeg.bmp.pgm";
            this.names = new File(this.source_dir).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int idot = name.lastIndexOf(46);
                    if (-1 == idot) {
                        return false;
                    }
                    return ".tif.jpg.png.gif.tiff.jpeg.bmp.pgm".contains(name.substring(idot).toLowerCase());
                }
            });
            Arrays.sort(this.names);
            GenericDialog gd = new GenericDialog(title);
            gd.addNumericField("number_of_images :", 9.0, 0);
            gd.addChoice("first_image :", this.names, this.names[0]);
            gd.addNumericField("power_of_polynomial_kernel :", (double)this.dimension, 0);
            gd.addNumericField("lambda :", this.lambda, 6);
            gd.addCheckbox("apply_correction_to_images", this.applyCorrection);
            gd.addCheckbox("visualize results", this.visualizeResults);
            String[] options = new String[]{"save", "load"};
            gd.addChoice("What to do? ", options, options[this.saveOrLoad]);
            gd.addStringField("file_name: ", this.saveFileName);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.numberOfImages = (int)gd.getNextNumber();
            this.firstImageIndex = gd.getNextChoiceIndex();
            this.dimension = (int)gd.getNextNumber();
            this.lambda = gd.getNextNumber();
            this.applyCorrection = gd.getNextBoolean();
            this.visualizeResults = gd.getNextBoolean();
            this.saveOrLoad = gd.getNextChoiceIndex();
            this.saveFileName = gd.getNextString();
            if (this.saveOrLoad == 0 || this.visualizeResults) {
                GenericDialog gds = new GenericDialog(title);
                SIFT.addFields((GenericDialog)gds, (FloatArray2DSIFT.Param)this.sift);
                gds.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
                gds.addMessage("Geometric Consensus Filter:");
                gds.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
                gds.addNumericField("inlier_ratio :", (double)this.minInlierRatio, 2);
                gds.addChoice("expected_transformation :", modelStrings, modelStrings[this.expectedModelIndex]);
                gds.showDialog();
                if (gds.wasCanceled()) {
                    return false;
                }
                SIFT.readFields((GenericDialog)gds, (FloatArray2DSIFT.Param)this.sift);
                this.rod = (float)gds.getNextNumber();
                this.maxEpsilon = (float)gds.getNextNumber();
                this.minInlierRatio = (float)gds.getNextNumber();
                this.expectedModelIndex = gds.getNextChoiceIndex();
                return !gd.invalidNumber() && !gds.invalidNumber();
            }
            return !gd.invalidNumber();
        }
    }

    public static class BasicParam {
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public float rod = 0.92f;
        public float maxEpsilon = 32.0f;
        public float minInlierRatio = 0.2f;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
        public int expectedModelIndex = 1;
        public int dimension = 5;
        public double lambda = 0.01;

        public BasicParam() {
            this.sift.fdSize = 8;
            this.sift.maxOctaveSize = 1600;
            this.sift.minOctaveSize = 400;
        }

        public void addFields(GenericDialog gd) {
            SIFT.addFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            gd.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
            gd.addMessage("Geometric Consensus Filter :");
            gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
            gd.addNumericField("inlier_ratio :", (double)this.minInlierRatio, 2);
            gd.addChoice("expected_transformation :", modelStrings, modelStrings[this.expectedModelIndex]);
            gd.addMessage("Lens Model :");
            gd.addNumericField("power_of_polynomial_kernel :", (double)this.dimension, 0);
            gd.addNumericField("lambda :", this.lambda, 6);
        }

        public boolean readFields(GenericDialog gd) {
            SIFT.readFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            this.rod = (float)gd.getNextNumber();
            this.maxEpsilon = (float)gd.getNextNumber();
            this.minInlierRatio = (float)gd.getNextNumber();
            this.expectedModelIndex = gd.getNextChoiceIndex();
            this.dimension = (int)gd.getNextNumber();
            this.lambda = gd.getNextNumber();
            return !gd.invalidNumber();
        }

        public boolean setup(String title) {
            GenericDialog gd = new GenericDialog(title);
            this.addFields(gd);
            do {
                gd.showDialog();
                if (!gd.wasCanceled()) continue;
                return false;
            } while (!this.readFields(gd));
            return true;
        }

        public BasicParam clone() {
            BasicParam p = new BasicParam();
            p.sift.set(this.sift);
            p.dimension = this.dimension;
            p.expectedModelIndex = this.expectedModelIndex;
            p.lambda = this.lambda;
            p.maxEpsilon = this.maxEpsilon;
            p.minInlierRatio = this.minInlierRatio;
            p.rod = this.rod;
            return p;
        }
    }

    public static class PointMatchCollectionAndAffine {
        public final AffineTransform affine;
        public final Collection<PointMatch> pointMatches;

        public PointMatchCollectionAndAffine(AffineTransform affine, Collection<PointMatch> pointMatches) {
            this.affine = affine;
            this.pointMatches = pointMatches;
        }
    }
}

