/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Pfacc;
import edu.mines.jtk.util.Check;

public class FftReal {
    private int _nfft;

    public FftReal(int nfft) {
        Check.argument(nfft % 2 == 0 && Pfacc.nfftValid(nfft / 2), "nfft=" + nfft + " is valid FFT length");
        this._nfft = nfft;
    }

    public static int nfftSmall(int n) {
        Check.argument(n <= 1441440, "n does not exceed 1441440");
        return 2 * Pfacc.nfftSmall((n + 1) / 2);
    }

    public static int nfftFast(int n) {
        Check.argument(n <= 1441440, "n does not exceed 1441440");
        return 2 * Pfacc.nfftFast((n + 1) / 2);
    }

    public int getNfft() {
        return this._nfft;
    }

    public void realToComplex(int sign, float[] rx, float[] cy) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft, rx, "rx");
        FftReal.checkArray(this._nfft + 2, cy, "cy");
        int n = this._nfft;
        while (--n >= 0) {
            cy[n] = 0.5f * rx[n];
        }
        Pfacc.transform(sign, this._nfft / 2, cy);
        cy[this._nfft] = 2.0f * (cy[0] - cy[1]);
        cy[0] = 2.0f * (cy[0] + cy[1]);
        cy[this._nfft + 1] = 0.0f;
        cy[1] = 0.0f;
        double theta = (double)sign * 2.0 * Math.PI / (double)this._nfft;
        double wt = Math.sin(0.5 * theta);
        double wpr = -2.0 * wt * wt;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int j = 2;
        for (int k = this._nfft - 2; j <= k; j += 2, k -= 2) {
            float sumr = cy[j] + cy[k];
            float sumi = cy[j + 1] + cy[k + 1];
            float difr = cy[j] - cy[k];
            float difi = cy[j + 1] - cy[k + 1];
            float tmpr = (float)(wi * (double)difr + wr * (double)sumi);
            float tmpi = (float)(wi * (double)sumi - wr * (double)difr);
            cy[j] = sumr + tmpr;
            cy[j + 1] = tmpi + difi;
            cy[k] = sumr - tmpr;
            cy[k + 1] = tmpi - difi;
            wt = wr;
            wr += wr * wpr - wi * wpi;
            wi += wi * wpr + wt * wpi;
        }
    }

    public void complexToReal(int sign, float[] cx, float[] ry) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft + 2, cx, "cx");
        FftReal.checkArray(this._nfft, ry, "ry");
        if (cx != ry) {
            int n = this._nfft;
            while (--n >= 2) {
                ry[n] = cx[n];
            }
        }
        ry[1] = cx[0] - cx[this._nfft];
        ry[0] = cx[0] + cx[this._nfft];
        double theta = (double)(-sign) * 2.0 * Math.PI / (double)this._nfft;
        double wt = Math.sin(0.5 * theta);
        double wpr = -2.0 * wt * wt;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int j = 2;
        for (int k = this._nfft - 2; j <= k; j += 2, k -= 2) {
            float sumr = ry[j] + ry[k];
            float sumi = ry[j + 1] + ry[k + 1];
            float difr = ry[j] - ry[k];
            float difi = ry[j + 1] - ry[k + 1];
            float tmpr = (float)(wi * (double)difr - wr * (double)sumi);
            float tmpi = (float)(wi * (double)sumi + wr * (double)difr);
            ry[j] = sumr + tmpr;
            ry[j + 1] = tmpi + difi;
            ry[k] = sumr - tmpr;
            ry[k + 1] = tmpi - difi;
            wt = wr;
            wr += wr * wpr - wi * wpi;
            wi += wi * wpr + wt * wpi;
        }
        Pfacc.transform(sign, this._nfft / 2, ry);
    }

    public void realToComplex1(int sign, int n2, float[][] rx, float[][] cy) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft, n2, rx, "rx");
        FftReal.checkArray(this._nfft + 2, n2, cy, "cy");
        for (int i2 = 0; i2 < n2; ++i2) {
            this.realToComplex(sign, rx[i2], cy[i2]);
        }
    }

    public void complexToReal1(int sign, int n2, float[][] cx, float[][] ry) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft + 2, n2, cx, "cx");
        FftReal.checkArray(this._nfft, n2, ry, "ry");
        for (int i2 = 0; i2 < n2; ++i2) {
            this.complexToReal(sign, cx[i2], ry[i2]);
        }
    }

    public void realToComplex2(int sign, int n1, float[][] rx, float[][] cy) {
        FftReal.checkSign(sign);
        FftReal.checkArray(n1, this._nfft, rx, "rx");
        FftReal.checkArray(2 * n1, this._nfft / 2 + 1, cy, "cy");
        int i1 = n1 - 1;
        int j1 = i1 * 2;
        while (i1 >= 0) {
            int i2 = this._nfft - 2;
            int j2 = i2 / 2;
            while (i2 >= 0) {
                cy[j2][j1] = 0.5f * rx[i2][i1];
                cy[j2][j1 + 1] = 0.5f * rx[i2 + 1][i1];
                i2 -= 2;
                --j2;
            }
            --i1;
            j1 -= 2;
        }
        Pfacc.transform2a(sign, n1, this._nfft / 2, cy);
        float[] cy0 = cy[0];
        float[] cyn = cy[this._nfft / 2];
        for (int i12 = 2 * n1 - 2; i12 >= 0; i12 -= 2) {
            cyn[i12] = 2.0f * (cy0[i12] - cy0[i12 + 1]);
            cy0[i12] = 2.0f * (cy0[i12] + cy0[i12 + 1]);
            cyn[i12 + 1] = 0.0f;
            cy0[i12 + 1] = 0.0f;
        }
        double theta = (double)sign * 2.0 * Math.PI / (double)this._nfft;
        double wt = Math.sin(0.5 * theta);
        double wpr = -2.0 * wt * wt;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int j2 = 1;
        for (int k2 = this._nfft / 2 - 1; j2 <= k2; ++j2, --k2) {
            float[] cyj2 = cy[j2];
            float[] cyk2 = cy[k2];
            int i13 = 0;
            int j12 = 0;
            while (i13 < n1) {
                float sumr = cyj2[j12] + cyk2[j12];
                float sumi = cyj2[j12 + 1] + cyk2[j12 + 1];
                float difr = cyj2[j12] - cyk2[j12];
                float difi = cyj2[j12 + 1] - cyk2[j12 + 1];
                float tmpr = (float)(wi * (double)difr + wr * (double)sumi);
                float tmpi = (float)(wi * (double)sumi - wr * (double)difr);
                cyj2[j12] = sumr + tmpr;
                cyj2[j12 + 1] = tmpi + difi;
                cyk2[j12] = sumr - tmpr;
                cyk2[j12 + 1] = tmpi - difi;
                ++i13;
                j12 += 2;
            }
            wt = wr;
            wr += wr * wpr - wi * wpi;
            wi += wi * wpr + wt * wpi;
        }
    }

    public void complexToReal2(int sign, int n1, float[][] cx, float[][] ry) {
        FftReal.checkSign(sign);
        FftReal.checkArray(2 * n1, this._nfft / 2 + 1, cx, "cx");
        FftReal.checkArray(n1, this._nfft, ry, "ry");
        int i1 = 0;
        for (int j1 = 0; j1 < n1; ++j1) {
            float cx0 = cx[0][i1];
            float cxn = cx[this._nfft / 2][i1];
            int i2 = this._nfft / 2 - 1;
            int j2 = 2 * i2;
            while (i2 > 0) {
                ry[j2][j1] = cx[i2][i1];
                ry[j2 + 1][j1] = cx[i2][i1 + 1];
                --i2;
                j2 -= 2;
            }
            ry[1][j1] = cx0 - cxn;
            ry[0][j1] = cx0 + cxn;
            i1 += 2;
        }
        double theta = (double)(-sign) * 2.0 * Math.PI / (double)this._nfft;
        double wt = Math.sin(0.5 * theta);
        double wpr = -2.0 * wt * wt;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int j2 = 2;
        for (int k2 = this._nfft - 2; j2 <= k2; j2 += 2, k2 -= 2) {
            float[] ryj2r = ry[j2];
            float[] ryj2i = ry[j2 + 1];
            float[] ryk2r = ry[k2];
            float[] ryk2i = ry[k2 + 1];
            for (int i12 = 0; i12 < n1; ++i12) {
                float sumr = ryj2r[i12] + ryk2r[i12];
                float sumi = ryj2i[i12] + ryk2i[i12];
                float difr = ryj2r[i12] - ryk2r[i12];
                float difi = ryj2i[i12] - ryk2i[i12];
                float tmpr = (float)(wi * (double)difr - wr * (double)sumi);
                float tmpi = (float)(wi * (double)sumi + wr * (double)difr);
                ryj2r[i12] = sumr + tmpr;
                ryj2i[i12] = tmpi + difi;
                ryk2r[i12] = sumr - tmpr;
                ryk2i[i12] = tmpi - difi;
            }
            wt = wr;
            wr += wr * wpr - wi * wpi;
            wi += wi * wpr + wt * wpi;
        }
        Pfacc.transform2b(sign, n1, this._nfft / 2, ry);
    }

    public void realToComplex1(int sign, int n2, int n3, float[][][] rx, float[][][] cy) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft, n2, n3, rx, "rx");
        FftReal.checkArray(this._nfft + 2, n2, n3, cy, "cy");
        for (int i3 = 0; i3 < n3; ++i3) {
            this.realToComplex1(sign, n2, rx[i3], cy[i3]);
        }
    }

    public void complexToReal1(int sign, int n2, int n3, float[][][] cx, float[][][] ry) {
        FftReal.checkSign(sign);
        FftReal.checkArray(this._nfft + 2, n2, n3, cx, "cx");
        FftReal.checkArray(this._nfft, n2, n3, ry, "ry");
        for (int i3 = 0; i3 < n3; ++i3) {
            this.complexToReal1(sign, n2, cx[i3], ry[i3]);
        }
    }

    public void scale(int n1, float[] rx) {
        float s = 1.0f / (float)this._nfft;
        while (--n1 >= 0) {
            int n = n1;
            rx[n] = rx[n] * s;
        }
    }

    public void scale(int n1, int n2, float[][] rx) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.scale(n1, rx[i2]);
        }
    }

    public void scale(int n1, int n2, int n3, float[][][] rx) {
        for (int i3 = 0; i3 < n3; ++i3) {
            this.scale(n1, n2, rx[i3]);
        }
    }

    private static void checkSign(int sign) {
        Check.argument(sign == 1 || sign == -1, "sign equals 1 or -1");
    }

    private static void checkArray(int n, float[] a, String name) {
        Check.argument(a.length >= n, "dimensions of " + name + " are valid");
    }

    private static void checkArray(int n1, int n2, float[][] a, String name) {
        boolean ok = a.length >= n2;
        for (int i2 = 0; i2 < n2 && ok; ++i2) {
            ok = a[i2].length >= n1;
        }
        Check.argument(ok, "dimensions of " + name + " are valid");
    }

    private static void checkArray(int n1, int n2, int n3, float[][][] a, String name) {
        boolean ok = a.length >= n3;
        for (int i3 = 0; i3 < n3 && ok; ++i3) {
            ok = a[i3].length >= n2;
            for (int i2 = 0; i2 < n2 && ok; ++i2) {
                ok = a[i3][i2].length >= n1;
            }
        }
        Check.argument(ok, "dimensions of " + name + " are valid");
    }
}

