/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder2;
import edu.mines.jtk.mesh.TriMesh;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class NearestGridder2
implements Gridder2 {
    private float[] _f;
    private TriMesh _mesh;

    public NearestGridder2(float[] f, float[] x1, float[] x2) {
        this.setScattered(f, x1, x2);
    }

    public void computeDistancesAndValues(Sampling s1, Sampling s2, float[][] d, float[][] g) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                TriMesh.Node node = this._mesh.findNodeNearest(x1, x2);
                float d1 = x1 - node.x();
                float d2 = x2 - node.y();
                if (g != null) {
                    g[i2][i1] = this._f[node.index];
                }
                if (d == null) continue;
                d[i2][i1] = ArrayMath.sqrt(d1 * d1 + d2 * d2);
            }
        }
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2) {
        this._f = ArrayMath.copy(f);
        this._mesh = new TriMesh();
        int n = f.length;
        int i = 0;
        while (i < n) {
            TriMesh.Node node = new TriMesh.Node(x1[i], x2[i]);
            node.index = i++;
            boolean added = this._mesh.addNode(node);
            Check.argument(added, "samples have unique coordinates (x1,x2)");
        }
    }

    @Override
    public float[][] grid(Sampling s1, Sampling s2) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        float[][] g = new float[n2][n1];
        this.computeDistancesAndValues(s1, s2, null, g);
        return g;
    }
}

