/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.PolyTrend2;
import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixLud;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class RadialInterpolator2 {
    private Basis _basis;
    private int _n;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private float[] _w;
    private double _m11;
    private double _m12;
    private double _m22;
    private boolean _mt;
    private PolyTrend2 _trend;
    private int _order = -1;

    public RadialInterpolator2(Basis basis, float[] f, float[] x1, float[] x2) {
        this._basis = basis;
        this.setSamples(f, x1, x2);
    }

    public void setBasis(Basis basis) {
        this._basis = basis;
    }

    public void setSamples(float[] f, float[] x1, float[] x2) {
        this._n = f.length;
        this._f = ArrayMath.copy(f);
        this._x1 = ArrayMath.copy(x1);
        this._x2 = ArrayMath.copy(x2);
        this._w = null;
        if (this._trend != null) {
            this._trend.detrend(this._f, this._x1, this._x2);
        }
    }

    public void setMetricTensor(double m11, double m12, double m22) {
        Check.argument(m11 * m22 >= m12 * m12, "determinant is non-negative");
        if (this._m11 != m11 || this._m12 != m12 || this._m22 != m22) {
            this._m11 = m11;
            this._m12 = m12;
            this._m22 = m22;
            this._mt = this._m11 != 1.0 || this._m12 != 0.0 || this._m22 != 1.0;
            this._w = null;
        }
    }

    public void setPolyTrend(int order) {
        Check.argument(-1 <= order, "-1<=order");
        Check.argument(order <= 2, "order<=2");
        if (this._order != order) {
            if (this._trend != null) {
                this._trend.restore(this._f, this._x1, this._x2);
                this._trend = null;
            }
            if (order != -1) {
                this._trend = new PolyTrend2(order, this._f, this._x1, this._x2);
                this._trend.detrend(this._f, this._x1, this._x2);
            }
            this._order = order;
            this._w = null;
        }
    }

    public float interpolate(float x1, float x2) {
        this.ensureWeights();
        double f = 0.0;
        double x1i = x1;
        double x2i = x2;
        for (int k = 0; k < this._n; ++k) {
            double x1k = this._x1[k];
            double x2k = this._x2[k];
            f += (double)this._w[k] * this.g(x1k, x2k, x1i, x2i);
        }
        float ff = (float)f;
        if (this._trend != null) {
            ff = this._trend.restore(ff, x1, x2);
        }
        return ff;
    }

    public float[][] interpolate(Sampling s1, Sampling s2) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        float[][] f = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                f[i2][i1] = this.interpolate(x1, x2);
            }
        }
        return f;
    }

    public float[] getWeights() {
        this.ensureWeights();
        return ArrayMath.copy(this._w);
    }

    private double g(double x1a, double x2a, double x1b, double x2b) {
        return this._basis.evaluate(this.r(x1a, x2a, x1b, x2b));
    }

    private double r(double x1a, double x2a, double x1b, double x2b) {
        return this.r(x1a - x1b, x2a - x2b);
    }

    private double r(double d1, double d2) {
        return this._mt ? ArrayMath.sqrt(this._m11 * d1 * d1 + 2.0 * this._m12 * d1 * d2 + this._m22 * d2 * d2) : ArrayMath.hypot(d1, d2);
    }

    private void ensureWeights() {
        if (this._w != null) {
            return;
        }
        DMatrix a = new DMatrix(this._n, this._n);
        DMatrix b = new DMatrix(this._n, 1);
        for (int i = 0; i < this._n; ++i) {
            double x1i = this._x1[i];
            double x2i = this._x2[i];
            for (int j = 0; j < this._n; ++j) {
                double x1j = this._x1[j];
                double x2j = this._x2[j];
                a.set(i, j, this.g(x1i, x2i, x1j, x2j));
            }
            b.set(i, 0, this._f[i]);
        }
        DMatrixLud lud = new DMatrixLud(a);
        DMatrix w = lud.solve(b);
        this._w = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._w[i] = (float)w.get(i, 0);
        }
    }

    public static class WesselBercovici
    implements Basis {
        private double _p;
        private double _q;
        private double _s;
        private static final double LOG2 = 0.6931471805599453;
        private static final double EULER_GAMMA = 0.5772156649015329;

        public WesselBercovici(double tension) {
            this(tension, 1.0);
        }

        public WesselBercovici(double tension, double scale) {
            Check.argument(0.0 <= tension, "0.0<=tension");
            Check.argument(tension < 1.0, "tension<1.0");
            this._p = ArrayMath.sqrt(tension / (1.0 - tension));
            this._q = 2.0 / this._p;
            this._s = 1.0 / scale;
        }

        @Override
        public double evaluate(double r) {
            double g = 0.0;
            if (r > 0.0) {
                r *= this._s;
                if (this._p == 0.0) {
                    g = r * r * (ArrayMath.log(r) - 1.0);
                } else {
                    double pr = this._p * r;
                    if (r <= this._q) {
                        double t = pr * pr;
                        double y = 0.25 * t;
                        double z = t / 14.0625;
                        g = -ArrayMath.log(0.5 * pr) * (z * (3.5156229 + z * (3.0899424 + z * (1.2067492 + z * (0.2659732 + z * (0.0360768 + z * 0.0045813)))))) + y * (0.4227842 + y * (0.23069756 + y * (0.0348859 + y * (0.00262698 + y * (1.075E-4 + y * 7.4E-6)))));
                    } else {
                        double y = this._q / r;
                        g = ArrayMath.exp(-pr) / ArrayMath.sqrt(pr) * (1.25331414 + y * (-0.07832358 + y * (0.02189568 + y * (-0.01062446 + y * (0.00587872 + y * (-0.0025154 + y * 5.3208E-4)))))) + ArrayMath.log(pr) - 0.6931471805599453 + 0.5772156649015329;
                    }
                }
            }
            return g;
        }
    }

    public static class Biharmonic
    implements Basis {
        private double _s;

        public Biharmonic() {
            this(1.0);
        }

        public Biharmonic(double scale) {
            this._s = 1.0 / scale;
        }

        @Override
        public double evaluate(double r) {
            double g = 0.0;
            if (r > 0.0) {
                g = (r *= this._s) * r * (ArrayMath.log(r) - 1.0);
            }
            return g;
        }
    }

    static interface Basis {
        public double evaluate(double var1);
    }
}

