/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.MouseTrackMode;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.TileAxis;
import edu.mines.jtk.mosaic.TileZoomMode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PlotFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH = 720;
    private static final int DEFAULT_HEIGHT = 550;
    private static final Font DEFAULT_FONT = new Font("Arial", 0, 24);
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private PlotPanel _panelTL;
    private PlotPanel _panelBR;
    private Split _split;
    private JSplitPane _splitPane;
    private MainPanel _panelMain;
    private ModeManager _modeManager;
    private TileZoomMode _tileZoomMode;
    private MouseTrackMode _mouseTrackMode;
    private boolean _fontSizeForPrint;
    private boolean _fontSizeForSlide;
    private double _fracWidthSlide;
    private double _fracHeightSlide;
    private double _aspectRatioSlide;
    private double _fontSizePrint;
    private double _plotWidthPrint;

    public PlotFrame(PlotPanel panel) {
        this._panelTL = panel;
        this._panelBR = panel;
        this._panelMain = new MainPanel();
        this._panelMain.setLayout(new BorderLayout());
        this._panelMain.add((Component)this._panelTL, "Center");
        this.setSize(this._panelMain.getPreferredSize());
        this.add((Component)this._panelMain, "Center");
        this.setFont(DEFAULT_FONT);
        this.setBackground(DEFAULT_BACKGROUND);
        this.setSize(720, 550);
        this.addModeManager();
        this.addResizedShownListener();
    }

    public PlotFrame(PlotPanel panelTL, PlotPanel panelBR, Split split) {
        double resizeWeight;
        this._panelTL = panelTL;
        this._panelBR = panelBR;
        this._split = split;
        this._panelMain = new MainPanel();
        this._panelMain.setLayout(new BorderLayout());
        if (this._split == Split.HORIZONTAL) {
            this._splitPane = new JSplitPane(1, this._panelTL, this._panelBR);
            double colTL = this._panelTL.getMosaic().countColumns();
            double colBR = this._panelBR.getMosaic().countColumns();
            resizeWeight = colTL / (colTL + colBR);
        } else {
            this._splitPane = new JSplitPane(0, this._panelTL, this._panelBR);
            double rowTL = this._panelTL.getMosaic().countRows();
            double rowBR = this._panelBR.getMosaic().countRows();
            resizeWeight = rowTL / (rowTL + rowBR);
        }
        this._splitPane.setResizeWeight(resizeWeight);
        this._splitPane.setDividerLocation(1.0 - resizeWeight);
        this._splitPane.setOneTouchExpandable(true);
        this._panelMain.add((Component)this._splitPane, "Center");
        this.setSize(this._panelMain.getPreferredSize());
        this.add((Component)this._panelMain, "Center");
        this.setBackground(DEFAULT_BACKGROUND);
        this.setFont(DEFAULT_FONT);
        this.setSize(720, 550);
        this.addModeManager();
        this.addResizedShownListener();
    }

    public PlotPanel getPlotPanel() {
        return this._panelTL;
    }

    public PlotPanel getPlotPanelTopLeft() {
        return this._panelTL;
    }

    public PlotPanel getPlotPanelBottomRight() {
        return this._panelBR;
    }

    public JSplitPane getSplitPane() {
        return this._splitPane;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public TileZoomMode getTileZoomMode() {
        return this._tileZoomMode;
    }

    public MouseTrackMode getMouseTrackMode() {
        return this._mouseTrackMode;
    }

    public void paintToPng(double dpi, double win, String fileName) {
        if (this.canPaintToPngNow()) {
            try {
                this._panelMain.paintToPng(dpi, win, fileName);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else {
            final double fdpi = dpi;
            final double fwin = win;
            final String ffileName = fileName;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotFrame.this.paintToPng(fdpi, fwin, ffileName);
                }
            });
        }
    }

    private boolean canPaintToPngNow() {
        if (!this._panelMain.isValid()) {
            return false;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        return !TileAxis.revalidatePending(this);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._panelMain == null) {
            return;
        }
        this._panelMain.setFont(font);
        this._panelTL.setFont(font);
        if (this._panelBR != this._panelTL) {
            this._panelBR.setFont(font);
        }
    }

    public void setFontSize(float size) {
        this.setFontSizeInternal(size);
        this._fontSizeForPrint = false;
        this._fontSizeForSlide = false;
    }

    public void setFontSizeForSlide(double fracWidth, double fracHeight) {
        this.setFontSizeForSlide(fracWidth, fracHeight, 1.3333333333333333);
    }

    public void setFontSizeForSlide(double fracWidth, double fracHeight, double aspectRatio) {
        this._fracWidthSlide = fracWidth;
        this._fracHeightSlide = fracHeight;
        this._aspectRatioSlide = aspectRatio;
        this._fontSizeForSlide = true;
        this._fontSizeForPrint = false;
    }

    public void setFontSizeForPrint(double fontSize, double plotWidth) {
        this._fontSizePrint = fontSize;
        this._plotWidthPrint = plotWidth;
        this._fontSizeForPrint = true;
        this._fontSizeForSlide = false;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._panelMain == null) {
            return;
        }
        this._panelMain.setForeground(color);
        this._panelTL.setForeground(color);
        if (this._panelBR != this._panelTL) {
            this._panelBR.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._panelMain == null) {
            return;
        }
        this._panelMain.setBackground(color);
        this._panelTL.setBackground(color);
        if (this._panelBR != this._panelTL) {
            this._panelBR.setBackground(color);
        }
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private void addModeManager() {
        this._modeManager = new ModeManager();
        this._panelTL.getMosaic().setModeManager(this._modeManager);
        if (this._panelBR != this._panelTL) {
            this._panelBR.getMosaic().setModeManager(this._modeManager);
        }
        this._tileZoomMode = new TileZoomMode(this._modeManager);
        this._mouseTrackMode = new MouseTrackMode(this._modeManager);
        this._tileZoomMode.setActive(true);
        this._mouseTrackMode.setActive(true);
    }

    private void setFontSizeInternal(float size) {
        Font font = this.getFont();
        if (font == null) {
            font = UIManager.getFont("Panel.font");
        }
        if (font != null) {
            font = font.deriveFont(size);
            this.setFont(font);
        }
    }

    private void addResizedShownListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PlotFrame.this.adjustFontSize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                PlotFrame.this.adjustFontSize();
            }
        });
    }

    private void adjustFontSize() {
        if (this._fontSizeForPrint) {
            this.adjustFontSizeForPrint();
        } else if (this._fontSizeForSlide) {
            this.adjustFontSizeForSlide();
        }
    }

    private void adjustFontSizeForSlide() {
        double panelWidth = this._panelMain.getWidth();
        double panelHeight = this._panelMain.getHeight();
        if (panelWidth == 0.0 || panelHeight == 0.0) {
            return;
        }
        double slideWidth = this._fracWidthSlide;
        double slideHeight = this._fracHeightSlide;
        slideWidth *= this._aspectRatioSlide;
        double scaleHeight = 1.0;
        if (panelWidth * slideHeight > panelHeight * slideWidth) {
            scaleHeight = panelHeight * slideWidth / (panelWidth * slideHeight);
        }
        double fontSize = panelHeight / scaleHeight / this._fracHeightSlide / 20.0;
        this.setFontSizeInternal((float)fontSize);
    }

    private void adjustFontSizeForPrint() {
        double panelWidth = this._panelMain.getWidth();
        float fontSize = (float)(this._fontSizePrint * panelWidth / this._plotWidthPrint);
        this.setFontSizeInternal(fontSize);
    }

    private class MainPanel
    extends IPanel {
        private static final long serialVersionUID = 1L;

        private MainPanel() {
        }

        @Override
        public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
            if (PlotFrame.this._split == null) {
                PlotFrame.this._panelTL.paintToRect(g2d, x, y, w, h);
            } else {
                double ws = (double)w / (double)PlotFrame.this._splitPane.getWidth();
                double hs = (double)h / (double)PlotFrame.this._splitPane.getHeight();
                int nc = PlotFrame.this._splitPane.getComponentCount();
                for (int ic = 0; ic < nc; ++ic) {
                    Component c = PlotFrame.this._splitPane.getComponent(ic);
                    int xc = c.getX();
                    int yc = c.getY();
                    int wc = c.getWidth();
                    int hc = c.getHeight();
                    xc = (int)Math.round((double)xc * ws);
                    yc = (int)Math.round((double)yc * hs);
                    wc = (int)Math.round((double)wc * ws);
                    hc = (int)Math.round((double)hc * hs);
                    if (!(c instanceof IPanel)) continue;
                    IPanel ip = (IPanel)c;
                    ip.paintToRect(g2d, xc, yc, wc, hc);
                }
            }
        }
    }

    public static enum Split {
        HORIZONTAL,
        VERTICAL;

    }
}

