/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJUserInterface;
import volume.Volume;

public class VJViewspaceUtil {
    public static int[] suggestViewport(Volume v, VJMatrix m) {
        int[] size = new int[3];
        int[][] minmax = VJViewspaceUtil.minmax(v, m);
        size[0] = Math.round(minmax[1][0] - minmax[0][0]);
        size[1] = Math.round(minmax[1][1] - minmax[0][1]);
        size[2] = Math.round(minmax[1][2] - minmax[0][2]);
        return size;
    }

    public static int[] suggestCineViewport(Volume v, VJMatrix m, double stepx, double stepy, double stepz, int n) {
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        VJMatrix mc = new VJMatrix(m);
        VJUserInterface.status("Calculating viewport extent");
        for (int j = 0; j < n; ++j) {
            int[][] minmax = VJViewspaceUtil.minmax(v, mc);
            int x = Math.round(minmax[1][0] - minmax[0][0]);
            int y = Math.round(minmax[1][1] - minmax[0][1]);
            int z = Math.round(minmax[1][2] - minmax[0][2]);
            if (x > maxx) {
                maxx = x;
            }
            if (y > maxy) {
                maxy = y;
            }
            if (z > maxz) {
                maxz = z;
            }
            VJMatrix mm = new VJMatrix();
            mm.rotatex(stepx);
            mc.mul(mm);
            mm = new VJMatrix();
            mm.rotatey(stepy);
            mc.mul(mm);
            mm = new VJMatrix();
            mm.rotatez(stepz);
            mc.mul(mm);
        }
        int[] size = new int[]{maxx, maxy, maxz};
        return size;
    }

    public int[] centerVolume(Volume v, VJMatrix m) {
        float[] center = new float[]{v.getWidth() / 2, v.getHeight() / 2, v.getHeight() / 2, 1.0f};
        float[] centervs = m.mul(center);
        int[] centerivs = new int[]{Math.round(centervs[0]), Math.round(centervs[1]), Math.round(centervs[2])};
        return centerivs;
    }

    public static int[][] minmax(Volume v, VJMatrix m) {
        int i;
        float[][] boundary = new float[8][4];
        for (i = 0; i < boundary.length; ++i) {
            boundary[i][0] = 0.0f;
            boundary[i][1] = 0.0f;
            boundary[i][2] = 0.0f;
            boundary[i][3] = 1.0f;
        }
        for (i = 4; i < boundary.length; ++i) {
            boundary[i][2] = v.getDepth() - 1;
        }
        boundary[1][0] = v.getWidth() - 1;
        boundary[2][0] = v.getWidth() - 1;
        boundary[2][1] = v.getHeight() - 1;
        boundary[3][1] = v.getHeight() - 1;
        boundary[5][0] = v.getWidth() - 1;
        boundary[6][0] = v.getWidth() - 1;
        boundary[6][1] = v.getHeight() - 1;
        boundary[7][1] = v.getHeight() - 1;
        float[][] boundaryVs = new float[8][];
        for (int i2 = 0; i2 < boundaryVs.length; ++i2) {
            boundaryVs[i2] = m.mul(boundary[i2]);
        }
        int[][] minmax = new int[2][3];
        int n = (int)boundaryVs[0][0];
        minmax[1][0] = n;
        minmax[0][0] = n;
        int n2 = (int)boundaryVs[0][1];
        minmax[1][1] = n2;
        minmax[0][1] = n2;
        int n3 = (int)boundaryVs[0][2];
        minmax[1][2] = n3;
        minmax[0][2] = n3;
        for (int i3 = 1; i3 < boundaryVs.length; ++i3) {
            for (int j = 0; j < 3; ++j) {
                if (minmax[0][j] > (int)boundaryVs[i3][j]) {
                    minmax[0][j] = (int)boundaryVs[i3][j];
                }
                if (minmax[1][j] >= (int)boundaryVs[i3][j]) continue;
                minmax[1][j] = (int)boundaryVs[i3][j];
            }
        }
        int[] nArray = minmax[1];
        nArray[0] = nArray[0] + 1;
        int[] nArray2 = minmax[1];
        nArray2[1] = nArray2[1] + 1;
        int[] nArray3 = minmax[1];
        nArray3[2] = nArray3[2] + 1;
        return minmax;
    }
}

