/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import java.util.Arrays;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.algorithm.blocks.AbstractBlockProcessor;
import net.imglib2.algorithm.blocks.transform.Transform;
import net.imglib2.blocks.BlockInterval;
import net.imglib2.type.PrimitiveType;

abstract class AbstractTransformProcessor<P>
extends AbstractBlockProcessor<P, P> {
    PrimitiveType primitiveType;
    Transform.Interpolation interpolation;
    final int n;
    final long[] destPos;
    final int[] destSize;

    AbstractTransformProcessor(int n, Transform.Interpolation interpolation, PrimitiveType primitiveType) {
        super(primitiveType, n);
        this.primitiveType = primitiveType;
        this.interpolation = interpolation;
        this.n = n;
        this.destPos = new long[n];
        this.destSize = new int[n];
    }

    AbstractTransformProcessor(AbstractTransformProcessor<P> transform) {
        super(transform);
        this.primitiveType = transform.primitiveType;
        this.interpolation = transform.interpolation;
        this.n = transform.n;
        this.destPos = new long[this.n];
        this.destSize = new int[this.n];
    }

    abstract RealInterval estimateBounds(Interval var1);

    @Override
    public void setTargetInterval(Interval interval) {
        BlockInterval.wrap(this.destPos, this.destSize).setFrom(interval);
        RealInterval bounds = this.estimateBounds(interval);
        switch (this.interpolation) {
            case NEARESTNEIGHBOR: {
                Arrays.setAll(this.sourcePos, d -> Math.round(bounds.realMin(d) - 0.5));
                Arrays.setAll(this.sourceSize, d -> (int)(Math.round(bounds.realMax(d) + 0.5) - this.sourcePos[d]) + 1);
                break;
            }
            case NLINEAR: {
                Arrays.setAll(this.sourcePos, d -> (long)Math.floor(bounds.realMin(d) - 0.5));
                Arrays.setAll(this.sourceSize, d -> (int)((long)Math.floor(bounds.realMax(d) + 0.5) - this.sourcePos[d]) + 2);
            }
        }
    }
}

