/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.HashMap;
import java.util.Map;
import net.imglib2.algorithm.math.abstractions.IBinaryFunction;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.algorithm.math.abstractions.ViewableFunction;
import net.imglib2.algorithm.math.execution.LetBinding;
import net.imglib2.algorithm.math.execution.Variable;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

public final class Let
extends ViewableFunction
implements IFunction,
IBinaryFunction {
    private final String varName;
    private final IFunction varValue;
    private final IFunction body;

    public Let(String varName, Object varValue, Object body) {
        this.varName = varName;
        this.varValue = Util.wrap(varValue);
        this.body = Util.wrap(body);
    }

    public Let(Object[] pairs, Object body) {
        if (pairs.length < 2 || 0 != pairs.length % 2) {
            throw new RuntimeException("Let: need an even number of var-value pairs.");
        }
        this.varName = (String)pairs[0];
        this.varValue = Util.wrap(pairs[1]);
        if (2 == pairs.length) {
            this.body = Util.wrap(body);
        } else {
            Object[] pairs2 = new Object[pairs.length - 2];
            System.arraycopy(pairs, 2, pairs2, 0, pairs2.length);
            this.body = new Let(pairs2, body);
        }
    }

    public Let(Object ... obs) {
        this(Let.fixAndValidate(obs), obs[obs.length - 1]);
    }

    private static final Object[] fixAndValidate(Object[] obs) {
        if (obs.length < 3 || 0 == obs.length % 2) {
            throw new RuntimeException("Let: need an even number of var-value pairs plus the body at the end.");
        }
        Object[] obs2 = new Object[obs.length - 1];
        System.arraycopy(obs, 0, obs2, 0, obs2.length);
        return obs2;
    }

    public <O extends RealType<O>> LetBinding<O> reInit(O tmp, Map<String, LetBinding<O>> bindings, Converter<RealType<?>, O> converter, Map<Variable<O>, OFunction<O>> imgSources) {
        RealType scrap = (RealType)tmp.copy();
        HashMap<String, LetBinding<O>> rebind = new HashMap<String, LetBinding<O>>(bindings);
        return new LetBinding<RealType>(scrap, this.varName, rebind, this.varValue, this.body, converter, imgSources);
    }

    @Override
    public IFunction getFirst() {
        return this.varValue;
    }

    @Override
    public IFunction getSecond() {
        return this.body;
    }

    public String getVarName() {
        return this.varName;
    }
}

