/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import org.apposed.appose.Builder;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.builder.MambaBuilder;

public class MambaBuilderFactory
implements BuilderFactory {
    @Override
    public Builder<?> createBuilder() {
        return new MambaBuilder();
    }

    @Override
    public Builder<?> createBuilder(String source) throws IOException {
        return new MambaBuilder(source);
    }

    @Override
    public Builder<?> createBuilder(String source, String scheme) throws IOException {
        return new MambaBuilder(source, scheme);
    }

    @Override
    public String name() {
        return "mamba";
    }

    @Override
    public boolean supportsScheme(String scheme) {
        return "environment.yml".equals(scheme);
    }

    @Override
    public boolean supportsSource(String source) {
        return source.endsWith(".yml") || source.endsWith(".yaml");
    }

    @Override
    public double priority() {
        return 50.0;
    }

    @Override
    public boolean canWrap(File envDir) {
        return new File(envDir, "conda-meta").isDirectory();
    }
}

