/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableLongProperty
extends LongPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableLongProperty() {
    }

    public StyleableLongProperty(long l) {
        super(l);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        long l;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        long l2 = l = number != null ? number.longValue() : 0L;
        if (transitionDefinition2 == null) {
            this.set(l);
        } else if (this.mediator == null || this.mediator.newValue != l) {
            this.mediator = new TransitionMediatorImpl(this.get(), l);
            this.mediator.run(transitionDefinition2);
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    public void set(long l) {
        super.set(l);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final long oldValue;
        private final long newValue;

        public TransitionMediatorImpl(long l, long l2) {
            this.oldValue = l;
            this.newValue = l2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableLongProperty.this.set(d < 1.0 ? this.oldValue + (long)((double)(this.newValue - this.oldValue) * d) : this.newValue);
        }

        @Override
        public void onStop() {
            if (StyleableLongProperty.this.mediator == this) {
                StyleableLongProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableLongProperty.this;
        }
    }
}

