/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.algorithms;

import java.util.ArrayList;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.gauss3.Gauss3;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuKernelConvolution;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperations;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;

public class GpuGauss {
    public static GpuNeighborhoodOperation gauss(GpuApi gpu, double ... sigmas) {
        ArrayList<GpuKernelConvolution> convolutions = new ArrayList<GpuKernelConvolution>();
        for (int d = 0; d < sigmas.length; ++d) {
            convolutions.add(new GpuKernelConvolution(gpu, GpuGauss.gaussKernel(sigmas[d]), d));
        }
        return GpuNeighborhoodOperations.concat(gpu, convolutions);
    }

    private static Kernel1D gaussKernel(double sigma) {
        return Kernel1D.symmetric((double[])Gauss3.halfkernels((double[])new double[]{sigma})[0]);
    }
}

