/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigContainer;

class ConfigObject {
    String baseName = null;
    String instanceName = null;
    Object targetObject = null;
    String targetClassName = null;
    Class targetClass = null;
    List properties = new ArrayList();
    ConfigContainer configContainer = null;
    ConfigCommand creatingCommand = null;
    boolean isAlias = false;
    ConfigObject original = null;
    List aliases = new ArrayList();
    protected ClassLoader classLoader;

    ConfigObject() {
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void initialize(ConfigCommand c) {
        if (c.argc != 3) {
            this.syntaxError("Wrong number of arguments to " + c.commandName);
        }
        if (!this.isName(c.argv[1])) {
            this.syntaxError("The first argument to " + c.commandName + " must be the instance name");
        }
        if (!this.isName(c.argv[2])) {
            this.syntaxError("The second argument to " + c.commandName + " must be the class name");
        }
        this.targetClassName = (String)c.argv[2];
    }

    protected void setProperty(ConfigCommand c) {
        if (c.argc < 4) {
            this.syntaxError("Wrong number of arguments to " + c.commandName);
        }
        if (!this.isName(c.argv[1])) {
            this.syntaxError("The first argument to " + c.commandName + " must be the instance name");
        }
        if (!this.isName(c.argv[2])) {
            this.syntaxError("The second argument to " + c.commandName + " must be the property name");
        }
        this.properties.add(c);
    }

    protected Object createTargetObject() {
        if (this.targetClassName == null) {
            return null;
        }
        this.targetClass = this.getClassForName(this.creatingCommand, this.targetClassName);
        this.targetObject = this.getNewInstance(this.creatingCommand, this.targetClass);
        return this.targetObject;
    }

    protected Class getClassForName(ConfigCommand cmd, String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Class \"" + className + "\" not found"));
        }
    }

    protected Object getNewInstance(ConfigCommand cmd, Class objectClass) {
        try {
            return objectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Illegal access to object class"));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Instantiation error for object class"));
        }
    }

    protected void processProperties() {
        this.evaluateProperties(this.targetClass, this.targetObject, this.properties);
        this.properties.clear();
    }

    protected void evaluateProperties(Class objectClass, Object objectInstance, List properties) {
        Object[] parameters = new Object[1];
        Class[] parameterTypes = new Class[]{parameters.getClass()};
        for (int i = 0; i < properties.size(); ++i) {
            ConfigCommand cmd = (ConfigCommand)properties.get(i);
            String methodName = (String)cmd.argv[2];
            Object[] argv = new Object[cmd.argc - 3];
            for (int a = 0; a < argv.length; ++a) {
                argv[a] = cmd.argv[a + 3];
                if (!(argv[a] instanceof ConfigCommand)) continue;
                ConfigCommand bcmd = (ConfigCommand)argv[a];
                argv[a] = this.configContainer.evaluateBuiltIn(bcmd);
            }
            parameters[0] = argv;
            try {
                Method objectMethod = objectClass.getMethod(methodName, parameterTypes);
                objectMethod.invoke(objectInstance, parameters);
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Unknown property \"" + methodName + "\""));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Illegal access to \"" + methodName + "\""));
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, e.getTargetException().getMessage()));
            }
        }
    }

    protected void syntaxError(String s) {
        throw new IllegalArgumentException(s);
    }

    static String errorMessage(ConfigCommand cmd, String s) {
        return s + "\nat line " + cmd.lineNumber + " in " + cmd.fileName + "\n" + cmd;
    }

    protected boolean isName(Object o) {
        return o instanceof String;
    }
}

