/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import java.io.Serializable;
import java.util.regex.Pattern;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;

public class Operators {
    public static Node plus(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Addition((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        if (left instanceof Primitives.StringExpression && right instanceof Primitives.StringExpression) {
            return new Concatenation((Primitives.StringExpression)left, (Primitives.StringExpression)right);
        }
        throw new SemanticException("Plus is only applicable to doubles & Strings!");
    }

    public static Node minus(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Subtraction((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Minus is only applicable to doubles!");
    }

    public static Node times(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Multiplication((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Multiplication is only applicable to doubles!");
    }

    public static Node division(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Division((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("division is only applicable to doubles!");
    }

    public static Node uplus(Node expr) throws SemanticException {
        if (expr instanceof Primitives.DoubleExpression) {
            return expr;
        }
        throw new SemanticException("unary minus is only applicable to doubles!");
    }

    public static Node uminus(Node expr) throws SemanticException {
        if (expr instanceof Primitives.DoubleExpression) {
            return new UMinus((Primitives.DoubleExpression)expr);
        }
        throw new SemanticException("unary minus is only applicable to doubles!");
    }

    public static Node pow(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Pow((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Power is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression lessThan(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new LessThan((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("less than is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression lessEqual(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new LessEqual((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("less equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression greaterThan(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new GreaterThan((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("greater than is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression greaterEqual(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new GreaterEqual((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("greater equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression equal(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Equal((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression not(Node expr) throws SemanticException {
        if (expr instanceof Primitives.BooleanExpression) {
            return new Not((Primitives.BooleanExpression)expr);
        }
        throw new SemanticException("Logical not is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression and(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.BooleanExpression && right instanceof Primitives.BooleanExpression) {
            return new And((Primitives.BooleanExpression)left, (Primitives.BooleanExpression)right);
        }
        throw new SemanticException("Logical and is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression or(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.BooleanExpression && right instanceof Primitives.BooleanExpression) {
            return new Or((Primitives.BooleanExpression)left, (Primitives.BooleanExpression)right);
        }
        throw new SemanticException("Logical or is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression is(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.StringExpression && right instanceof Primitives.StringExpression) {
            return new Is((Primitives.StringExpression)left, (Primitives.StringExpression)right);
        }
        throw new SemanticException("Is operator is only applicable to strings!");
    }

    public static Primitives.BooleanExpression regexp(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.StringExpression) {
            if (right instanceof Primitives.StringConstant) {
                return new CompiledRegexp((Primitives.StringExpression)left, ((Primitives.StringConstant)right).evaluate());
            }
            if (right instanceof Primitives.StringExpression) {
                return new Regexp((Primitives.StringExpression)left, (Primitives.StringExpression)right);
            }
        }
        throw new SemanticException("Is operator is only applicable to strings!");
    }

    private static class Addition
    extends DoubleBinaryExpression
    implements Serializable {
        private static final long serialVersionUID = 4742624413216069408L;

        public Addition(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() + this.right.evaluate();
        }
    }

    private static class Concatenation
    implements Primitives.StringExpression,
    Serializable {
        private static final long serialVersionUID = 2413200029613562555L;
        private final Primitives.StringExpression left;
        private final Primitives.StringExpression right;

        public Concatenation(Primitives.StringExpression left, Primitives.StringExpression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public String evaluate() {
            return this.left.evaluate() + this.right.evaluate();
        }
    }

    private static class Subtraction
    extends DoubleBinaryExpression
    implements Serializable {
        private static final long serialVersionUID = 2136831100085494486L;

        public Subtraction(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() - this.right.evaluate();
        }
    }

    private static class Multiplication
    extends DoubleBinaryExpression
    implements Serializable {
        private static final long serialVersionUID = 3119913759352807383L;

        public Multiplication(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() * this.right.evaluate();
        }
    }

    private static class Division
    extends DoubleBinaryExpression
    implements Serializable {
        private static final long serialVersionUID = -8438478400061106753L;

        public Division(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() / this.right.evaluate();
        }
    }

    private static class UMinus
    implements Primitives.DoubleExpression,
    Serializable {
        private static final long serialVersionUID = 8950381197456945108L;
        private final Primitives.DoubleExpression expr;

        public UMinus(Primitives.DoubleExpression expr) {
            this.expr = expr;
        }

        @Override
        public double evaluate() {
            return -this.expr.evaluate();
        }
    }

    private static class Pow
    extends DoubleBinaryExpression
    implements Serializable {
        private static final long serialVersionUID = -5103792715762588751L;

        public Pow(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return Math.pow(this.left.evaluate(), this.right.evaluate());
        }
    }

    private static class LessThan
    extends BooleanBinaryExpression<Primitives.DoubleExpression>
    implements Serializable {
        private static final long serialVersionUID = -4323355926531143842L;

        public LessThan(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() < ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class LessEqual
    extends BooleanBinaryExpression<Primitives.DoubleExpression>
    implements Serializable {
        private static final long serialVersionUID = -1949681957973467756L;

        public LessEqual(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() <= ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class GreaterThan
    extends BooleanBinaryExpression<Primitives.DoubleExpression>
    implements Serializable {
        private static final long serialVersionUID = 4541137398510802289L;

        public GreaterThan(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() > ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class GreaterEqual
    extends BooleanBinaryExpression<Primitives.DoubleExpression>
    implements Serializable {
        private static final long serialVersionUID = 3425719763247073382L;

        public GreaterEqual(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() >= ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class Equal
    extends BooleanBinaryExpression<Primitives.DoubleExpression>
    implements Serializable {
        private static final long serialVersionUID = 4154699553290213656L;

        public Equal(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() == ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class Not
    implements Primitives.BooleanExpression,
    Serializable {
        private static final long serialVersionUID = -6235716110409152192L;
        private final Primitives.BooleanExpression expr;

        public Not(Primitives.BooleanExpression expr) {
            this.expr = expr;
        }

        @Override
        public boolean evaluate() {
            return !this.expr.evaluate();
        }
    }

    private static class And
    extends BooleanBinaryExpression<Primitives.BooleanExpression>
    implements Serializable {
        private static final long serialVersionUID = 6786891291372905824L;

        public And(Primitives.BooleanExpression left, Primitives.BooleanExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.BooleanExpression)this.left).evaluate() && ((Primitives.BooleanExpression)this.right).evaluate();
        }
    }

    private static class Or
    extends BooleanBinaryExpression<Primitives.BooleanExpression>
    implements Serializable {
        private static final long serialVersionUID = -5943051466425242059L;

        public Or(Primitives.BooleanExpression left, Primitives.BooleanExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.BooleanExpression)this.left).evaluate() || ((Primitives.BooleanExpression)this.right).evaluate();
        }
    }

    private static class Is
    extends BooleanBinaryExpression<Primitives.StringExpression>
    implements Serializable {
        private static final long serialVersionUID = -7519297057279624722L;

        public Is(Primitives.StringExpression left, Primitives.StringExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.StringExpression)this.left).evaluate().equals(((Primitives.StringExpression)this.right).evaluate());
        }
    }

    private static class CompiledRegexp
    implements Primitives.BooleanExpression,
    Serializable {
        private static final long serialVersionUID = -224974827347001236L;
        private final Primitives.StringExpression expr;
        private final Pattern pattern;

        public CompiledRegexp(Primitives.StringExpression expr, String pattern) {
            this.expr = expr;
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean evaluate() {
            return this.pattern.matcher(this.expr.evaluate()).matches();
        }
    }

    private static class Regexp
    extends BooleanBinaryExpression<Primitives.StringExpression>
    implements Serializable {
        private static final long serialVersionUID = -3987002284718527200L;

        public Regexp(Primitives.StringExpression left, Primitives.StringExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.StringExpression)this.left).evaluate().matches(((Primitives.StringExpression)this.right).evaluate());
        }
    }

    private static abstract class BooleanBinaryExpression<T>
    implements Primitives.BooleanExpression,
    Serializable {
        private static final long serialVersionUID = -5375209267408472403L;
        final T left;
        final T right;

        public BooleanBinaryExpression(T left, T right) {
            this.left = left;
            this.right = right;
        }
    }

    private static abstract class DoubleBinaryExpression
    implements Primitives.DoubleExpression,
    Serializable {
        private static final long serialVersionUID = -5632795030311662604L;
        final Primitives.DoubleExpression left;
        final Primitives.DoubleExpression right;

        public DoubleBinaryExpression(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            this.left = left;
            this.right = right;
        }
    }
}

