/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh.io.ply;

import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imagej.mesh.Mesh;
import net.imagej.mesh.Triangle;
import net.imagej.mesh.Vertex;
import net.imagej.mesh.io.MeshIOPlugin;
import net.imagej.mesh.naive.NaiveFloatMesh;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.util.FileUtils;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.PlyReader;
import org.smurn.jply.PlyReaderFile;
import org.smurn.jply.util.NormalMode;
import org.smurn.jply.util.NormalizingPlyReader;
import org.smurn.jply.util.TesselationMode;
import org.smurn.jply.util.TextureMode;

@Plugin(type=MeshIOPlugin.class)
public class PLYMeshIO
extends AbstractIOPlugin<Mesh>
implements MeshIOPlugin {
    String EXTENSION = "ply";

    public void read(File plyFile, Mesh mesh) throws IOException {
        PlyReaderFile plyReader = new PlyReaderFile(plyFile);
        plyReader = new NormalizingPlyReader((PlyReader)plyReader, TesselationMode.TRIANGLES, NormalMode.ADD_NORMALS_CCW, TextureMode.PASS_THROUGH);
        ElementReader reader = plyReader.nextElementReader();
        TIntLongHashMap rowToVertIndex = new TIntLongHashMap();
        int vertCount = 0;
        while (reader != null) {
            if (reader.getElementType().getName().equals("vertex")) {
                Element vertex = reader.readElement();
                while (vertex != null) {
                    float x = (float)vertex.getDouble("x");
                    float z = (float)vertex.getDouble("z");
                    float y = (float)vertex.getDouble("y");
                    float nx = (float)vertex.getDouble("nx");
                    float ny = (float)vertex.getDouble("ny");
                    float nz = (float)vertex.getDouble("nz");
                    float u = 0.0f;
                    float v = 0.0f;
                    long vIndex = mesh.vertices().addf(x, y, z, nx, ny, nz, u, v);
                    rowToVertIndex.put(vertCount++, vIndex);
                    vertex = reader.readElement();
                }
            }
            reader.close();
            reader = plyReader.nextElementReader();
        }
        plyReader.close();
        plyReader = new PlyReaderFile(plyFile);
        plyReader = new NormalizingPlyReader((PlyReader)plyReader, TesselationMode.TRIANGLES, NormalMode.ADD_NORMALS_CCW, TextureMode.PASS_THROUGH);
        reader = plyReader.nextElementReader();
        while (reader != null) {
            if (reader.getElementType().getName().equals("face")) {
                Element triangle = reader.readElement();
                while (triangle != null) {
                    int[] indices = triangle.getIntList("vertex_index");
                    long v1 = rowToVertIndex.get(indices[0]);
                    long v2 = rowToVertIndex.get(indices[1]);
                    long v3 = rowToVertIndex.get(indices[2]);
                    float nx = 0.0f;
                    float ny = 0.0f;
                    float nz = 0.0f;
                    mesh.triangles().add(v1, v2, v3, 0.0, 0.0, 0.0);
                    triangle = reader.readElement();
                }
            }
            reader.close();
            reader = plyReader.nextElementReader();
        }
        plyReader.close();
    }

    public byte[] writeBinary(Mesh mesh) {
        int vertexBytes = 36;
        int triangleBytes = 13;
        String header = "ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n";
        String vertexHeader = "element vertex " + mesh.vertices().size() + "\nproperty float x\nproperty float y\nproperty float z\nproperty float nx\nproperty float ny\nproperty float nz\nproperty float u\nproperty float v\n";
        String triangleHeader = "element face " + mesh.triangles().size() + "\nproperty list uchar int vertex_index\n";
        String endHeader = "end_header\n";
        long bytes = (long)("ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n".getBytes().length + vertexHeader.getBytes().length + triangleHeader.getBytes().length + "end_header\n".getBytes().length) + mesh.vertices().size() * 36L + mesh.triangles().size() * 13L;
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Mesh data too large: " + bytes);
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put("ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n".getBytes());
        buffer.put(vertexHeader.getBytes());
        buffer.put(triangleHeader.getBytes());
        buffer.put("end_header\n".getBytes());
        if (mesh.vertices().size() == 0L) {
            return buffer.array();
        }
        TLongIntHashMap refToVertId = new TLongIntHashMap((int)mesh.vertices().size());
        int vertId = 0;
        for (Vertex v : mesh.vertices()) {
            buffer.putFloat(v.xf());
            buffer.putFloat(v.yf());
            buffer.putFloat(v.zf());
            buffer.putFloat(v.nxf());
            buffer.putFloat(v.nyf());
            buffer.putFloat(v.nzf());
            buffer.putFloat(v.uf());
            buffer.putFloat(v.vf());
            refToVertId.put(v.index(), vertId);
            ++vertId;
        }
        for (Triangle t : mesh.triangles()) {
            buffer.put((byte)3);
            buffer.putInt(refToVertId.get(t.vertex0()));
            buffer.putInt(refToVertId.get(t.vertex1()));
            buffer.putInt(refToVertId.get(t.vertex2()));
        }
        return buffer.array();
    }

    public byte[] writeAscii(Mesh mesh) throws IOException {
        String header = "ply\nformat ascii 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n";
        String vertexHeader = "element vertex " + mesh.vertices().size() + "\nproperty float x\nproperty float y\nproperty float z\nproperty float nx\nproperty float ny\nproperty float nz\nproperty float u\n property float v\n";
        String triangleHeader = "element face " + mesh.triangles().size() + "\nproperty list uchar int vertex_index\n";
        String endHeader = "end_header\n";
        if (mesh.vertices().size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many vertices: " + mesh.vertices().size());
        }
        if (mesh.triangles().size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many triangles: " + mesh.triangles().size());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
        writer.write("ply\nformat ascii 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n");
        writer.write(vertexHeader);
        writer.write(triangleHeader);
        writer.write("end_header\n");
        if (mesh.vertices().size() == 0L) {
            ((Writer)writer).flush();
            return os.toByteArray();
        }
        TLongIntHashMap refToVertId = new TLongIntHashMap((int)mesh.vertices().size());
        int vertId = 0;
        for (Vertex v : mesh.vertices()) {
            writer.write(Float.toString(v.xf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.yf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.zf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nxf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nyf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nzf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.uf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.vf()));
            ((Writer)writer).write(10);
            refToVertId.put(v.index(), vertId);
            ++vertId;
        }
        for (Triangle t : mesh.triangles()) {
            writer.write("3 ");
            writer.write(Integer.toString(refToVertId.get(t.vertex0())));
            ((Writer)writer).write(32);
            writer.write(Integer.toString(refToVertId.get(t.vertex1())));
            ((Writer)writer).write(32);
            writer.write(Integer.toString(refToVertId.get(t.vertex2())));
            ((Writer)writer).write(10);
        }
        ((Writer)writer).flush();
        return os.toByteArray();
    }

    public boolean supportsOpen(String source) {
        return FileUtils.getExtension((String)source).toLowerCase().equals(this.EXTENSION);
    }

    public boolean supportsSave(String source) {
        return FileUtils.getExtension((String)source).toLowerCase().equals(this.EXTENSION);
    }

    public Mesh open(String source) throws IOException {
        NaiveFloatMesh mesh = new NaiveFloatMesh();
        this.read(new File(source), (Mesh)mesh);
        return mesh;
    }

    public void save(Mesh data, String destination) throws IOException {
        byte[] bytes = this.writeBinary(data);
        FileUtils.writeFile((File)new File(destination), (byte[])bytes);
    }
}

