/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Spot;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class ModelChangeEvent
extends EventObject {
    private static final long serialVersionUID = -1L;
    public static final int FLAG_SPOT_ADDED = 0;
    public static final int FLAG_SPOT_REMOVED = 1;
    public static final int FLAG_SPOT_MODIFIED = 2;
    public static final int FLAG_SPOT_FRAME_CHANGED = 3;
    public static final int FLAG_EDGE_ADDED = 4;
    public static final int FLAG_EDGE_REMOVED = 5;
    public static final int FLAG_EDGE_MODIFIED = 6;
    public static final Map<Integer, String> flagsToString = new HashMap<Integer, String>(7);
    public static final int SPOTS_COMPUTED = 4;
    public static final int SPOTS_FILTERED = 5;
    public static final int TRACKS_COMPUTED = 6;
    public static final int TRACKS_VISIBILITY_CHANGED = 7;
    public static final int MODEL_MODIFIED = 8;
    public static final int FEATURES_COMPUTED = 9;
    private final HashSet<Spot> spots = new HashSet();
    private final HashSet<DefaultWeightedEdge> edges = new HashSet();
    private final HashMap<Spot, Integer> fromFrame = new HashMap();
    private final HashMap<Spot, Integer> toFrame = new HashMap();
    private final HashMap<Spot, Integer> spotFlags = new HashMap();
    private final HashMap<DefaultWeightedEdge, Integer> edgeFlags = new HashMap();
    private final int eventID;
    private Set<Integer> trackUpdated = new HashSet<Integer>();

    public ModelChangeEvent(Object source, int eventID) {
        super(source);
        this.eventID = eventID;
    }

    public int getEventID() {
        return this.eventID;
    }

    public boolean addAllSpots(Collection<Spot> lSpots) {
        return this.spots.addAll(lSpots);
    }

    public boolean addSpot(Spot spot) {
        return this.spots.add(spot);
    }

    public boolean addAllEdges(Collection<DefaultWeightedEdge> lEdges) {
        return this.edges.addAll(lEdges);
    }

    public boolean addEdge(DefaultWeightedEdge edge) {
        return this.edges.add(edge);
    }

    public Integer putEdgeFlag(DefaultWeightedEdge edge, Integer flag) {
        return this.edgeFlags.put(edge, flag);
    }

    public Integer putSpotFlag(Spot spot, Integer flag) {
        return this.spotFlags.put(spot, flag);
    }

    public Integer putFromFrame(Spot spot, Integer lFromFrame) {
        return this.fromFrame.put(spot, lFromFrame);
    }

    public Integer putToFrame(Spot spot, Integer lToFrame) {
        return this.toFrame.put(spot, lToFrame);
    }

    public Set<Spot> getSpots() {
        return this.spots;
    }

    public Set<DefaultWeightedEdge> getEdges() {
        return this.edges;
    }

    public Integer getSpotFlag(Spot spot) {
        return this.spotFlags.get(spot);
    }

    public Integer getEdgeFlag(DefaultWeightedEdge edge) {
        return this.edgeFlags.get(edge);
    }

    public Integer getToFrame(Spot spot) {
        return this.toFrame.get(spot);
    }

    public Integer getFromFrame(Spot spot) {
        return this.fromFrame.get(spot);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[ModelChangeEvent]:\n");
        str.append(" - source: " + this.source.getClass() + "_" + this.source.hashCode() + "\n");
        str.append(" - event type: ");
        switch (this.eventID) {
            case 4: {
                str.append("Spots computed\n");
                break;
            }
            case 5: {
                str.append("Spots filtered\n");
                break;
            }
            case 6: {
                str.append("Tracks computed\n");
                break;
            }
            case 7: {
                str.append("Track visibility changed\n");
                break;
            }
            case 8: {
                str.append("Model modified, with:\n");
                str.append("\t- spots modified: " + (this.spots != null ? this.spots.size() : 0) + "\n");
                for (Spot spot : this.spots) {
                    str.append("\t\t" + spot + ": " + flagsToString.get(this.spotFlags.get(spot)) + "\n");
                }
                str.append("\t- edges modified: " + (this.edges != null ? this.edges.size() : 0) + "\n");
                for (DefaultWeightedEdge edge : this.edges) {
                    str.append("\t\t" + edge + ": " + flagsToString.get(this.edgeFlags.get(edge)) + "\n");
                }
                str.append("\t- tracks to update: " + this.trackUpdated + "\n");
            }
        }
        return str.toString();
    }

    public void setTracksUpdated(Set<Integer> tracksToUpdate) {
        this.trackUpdated = tracksToUpdate;
    }

    public Set<Integer> getTrackUpdated() {
        return this.trackUpdated;
    }

    static {
        flagsToString.put(0, "Spot added");
        flagsToString.put(3, "Spot frame changed");
        flagsToString.put(2, "Spot modified");
        flagsToString.put(1, "Spot removed");
        flagsToString.put(4, "Edge added");
        flagsToString.put(6, "Edge modified");
        flagsToString.put(5, "Edge removed");
    }
}

