/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.imglib2.algorithm.MultiThreaded;

public class SpotCollection
implements MultiThreaded {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public static final String VISIBILITY = "VISIBILITY";
    private static final TimeUnit TIME_OUT_UNITS = TimeUnit.MINUTES;
    private static final long TIME_OUT_DELAY = 1L;
    private ConcurrentSkipListMap<Integer, Set<Spot>> content = new ConcurrentSkipListMap();
    private int numThreads;
    private static final Iterator<Spot> EMPTY_ITERATOR = new Iterator<Spot>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Spot next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public SpotCollection() {
        this.setNumThreads();
    }

    public Spot search(int ID) {
        for (Spot spot : this.iterable(false)) {
            if (spot.ID() != ID) continue;
            return spot;
        }
        return null;
    }

    public String toString() {
        String str = super.toString();
        str = str + ": contains " + this.getNSpots(false) + " spots total in " + this.keySet().size() + " different frames, over which " + this.getNSpots(true) + " are visible:\n";
        Iterator iterator = this.content.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            str = str + "\tframe " + key + ": " + this.getNSpots(key, false) + " spots total, " + this.getNSpots(key, true) + " visible.\n";
        }
        return str;
    }

    public void add(Spot spot, Integer frame) {
        Set<Spot> spots = this.content.get(frame);
        if (null == spots) {
            spots = new HashSet<Spot>();
            this.content.put(frame, spots);
        }
        spots.add(spot);
        spot.putFeature("FRAME", (double)frame);
        spot.putFeature(VISIBILITY, ONE);
    }

    public boolean remove(Spot spot, Integer frame) {
        Set<Spot> spots = this.content.get(frame);
        if (null == spots) {
            return false;
        }
        return spots.remove(spot);
    }

    public void setVisible(boolean visible) {
        final Double val = visible ? ONE : ZERO;
        Set frames = this.content.keySet();
        ExecutorService executors = Threads.newFixedThreadPool(this.numThreads);
        for (final Integer frame : frames) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    Set spots = (Set)SpotCollection.this.content.get(frame);
                    for (Spot spot : spots) {
                        spot.putFeature(SpotCollection.VISIBILITY, val);
                    }
                }
            };
            executors.execute(command);
        }
        executors.shutdown();
        try {
            boolean ok = executors.awaitTermination(1L, TIME_OUT_UNITS);
            if (!ok) {
                System.err.println("[SpotCollection.setVisible()] Timeout of 1 " + (Object)((Object)TIME_OUT_UNITS) + " reached.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public final void filter(final FeatureFilter featurefilter) {
        Set frames = this.content.keySet();
        ExecutorService executors = Threads.newFixedThreadPool(this.numThreads);
        for (final Integer frame : frames) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    Set spots = (Set)SpotCollection.this.content.get(frame);
                    double tval = featurefilter.value;
                    if (featurefilter.isAbove) {
                        Iterator iterator = spots.iterator();
                        while (iterator.hasNext()) {
                            Spot spot;
                            Double val = (spot = (Spot)iterator.next()).getFeature(featurefilter.feature);
                            spot.putFeature(SpotCollection.VISIBILITY, val.compareTo(tval) < 0 ? ZERO : ONE);
                        }
                    } else {
                        Iterator iterator = spots.iterator();
                        while (iterator.hasNext()) {
                            Spot spot;
                            Double val = (spot = (Spot)iterator.next()).getFeature(featurefilter.feature);
                            spot.putFeature(SpotCollection.VISIBILITY, val.compareTo(tval) > 0 ? ZERO : ONE);
                        }
                    }
                }
            };
            executors.execute(command);
        }
        executors.shutdown();
        try {
            boolean ok = executors.awaitTermination(1L, TIME_OUT_UNITS);
            if (!ok) {
                System.err.println("[SpotCollection.filter()] Timeout of 1 " + (Object)((Object)TIME_OUT_UNITS) + " reached while filtering.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public final void filter(final Collection<FeatureFilter> filters) {
        Set frames = this.content.keySet();
        ExecutorService executors = Threads.newFixedThreadPool(this.numThreads);
        for (final Integer frame : frames) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    Set spots = (Set)SpotCollection.this.content.get(frame);
                    for (Spot spot : spots) {
                        boolean shouldNotBeVisible = false;
                        for (FeatureFilter featureFilter : filters) {
                            Double val = spot.getFeature(featureFilter.feature);
                            double tval = featureFilter.value;
                            boolean isAbove = featureFilter.isAbove;
                            if (null != val && (!isAbove || val.compareTo(tval) >= 0) && (isAbove || val.compareTo(tval) <= 0)) continue;
                            shouldNotBeVisible = true;
                            break;
                        }
                        spot.putFeature(SpotCollection.VISIBILITY, shouldNotBeVisible ? ZERO : ONE);
                    }
                }
            };
            executors.execute(command);
        }
        executors.shutdown();
        try {
            boolean ok = executors.awaitTermination(1L, TIME_OUT_UNITS);
            if (!ok) {
                System.err.println("[SpotCollection.filter()] Timeout of 1 " + (Object)((Object)TIME_OUT_UNITS) + " reached while filtering.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public final Spot getClosestSpot(Spot location, int frame, boolean visibleSpotsOnly) {
        Set<Spot> spots = this.content.get(frame);
        if (null == spots) {
            return null;
        }
        double minDist = Double.POSITIVE_INFINITY;
        Spot target = null;
        for (Spot spot : spots) {
            double d2;
            if (visibleSpotsOnly && !SpotCollection.isVisible(spot) || !((d2 = spot.squareDistanceTo(location)) < minDist)) continue;
            minDist = d2;
            target = spot;
        }
        return target;
    }

    public final Spot getSpotAt(Spot location, int frame, boolean visibleSpotsOnly) {
        Set<Spot> spots = this.content.get(frame);
        if (null == spots || spots.isEmpty()) {
            return null;
        }
        double minDist2 = Double.POSITIVE_INFINITY;
        Spot bestSpot = null;
        for (Spot spot : spots) {
            double radius;
            double d2;
            if (visibleSpotsOnly && !SpotCollection.isVisible(spot) || !((d2 = spot.squareDistanceTo(location)) < Math.min(minDist2, (radius = spot.getFeature("RADIUS").doubleValue()) * radius))) continue;
            minDist2 = d2;
            bestSpot = spot;
        }
        return bestSpot;
    }

    public final int getNSpots(boolean visibleSpotsOnly) {
        int nspots = 0;
        if (visibleSpotsOnly) {
            Iterator<Spot> it = this.iterator(true);
            while (it.hasNext()) {
                it.next();
                ++nspots;
            }
        } else {
            for (Set<Spot> spots : this.content.values()) {
                nspots += spots.size();
            }
        }
        return nspots;
    }

    public int getNSpots(int frame, boolean visibleSpotsOnly) {
        if (visibleSpotsOnly) {
            Iterator<Spot> it = this.iterator(frame, true);
            int nspots = 0;
            while (it.hasNext()) {
                it.next();
                ++nspots;
            }
            return nspots;
        }
        Set<Spot> spots = this.content.get(frame);
        if (null == spots) {
            return 0;
        }
        return spots.size();
    }

    public Iterator<Spot> iterator(boolean visibleSpotsOnly) {
        if (visibleSpotsOnly) {
            return new VisibleSpotsIterator();
        }
        return new AllSpotsIterator();
    }

    public Iterator<Spot> iterator(Integer frame, boolean visibleSpotsOnly) {
        Set<Spot> frameContent = this.content.get(frame);
        if (null == frameContent) {
            return EMPTY_ITERATOR;
        }
        if (visibleSpotsOnly) {
            return new VisibleSpotsFrameIterator(frameContent);
        }
        return frameContent.iterator();
    }

    public Iterable<Spot> iterable(boolean visibleSpotsOnly) {
        return new WholeCollectionIterable(visibleSpotsOnly);
    }

    public Iterable<Spot> iterable(int frame, boolean visibleSpotsOnly) {
        if (visibleSpotsOnly) {
            return new FrameVisibleIterable(frame);
        }
        return this.content.get(frame);
    }

    public void put(int frame, Collection<Spot> spots) {
        HashSet<Spot> value = new HashSet<Spot>(spots);
        for (Spot spot : value) {
            spot.putFeature("FRAME", Double.valueOf(frame));
            spot.putFeature(VISIBILITY, ZERO);
        }
        this.content.put(frame, value);
    }

    public Integer firstKey() {
        if (this.content.isEmpty()) {
            return 0;
        }
        return this.content.firstKey();
    }

    public Integer lastKey() {
        if (this.content.isEmpty()) {
            return 0;
        }
        return this.content.lastKey();
    }

    public NavigableSet<Integer> keySet() {
        return this.content.keySet();
    }

    public void clear() {
        this.content.clear();
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void crop() {
        Set frames = this.content.keySet();
        for (Integer frame : frames) {
            Set<Spot> fc = this.content.get(frame);
            ArrayList<Spot> toRemove = new ArrayList<Spot>();
            for (Spot spot : fc) {
                if (SpotCollection.isVisible(spot)) continue;
                toRemove.add(spot);
            }
            fc.removeAll(toRemove);
        }
    }

    public static SpotCollection fromCollection(Iterable<Spot> spots) {
        SpotCollection sc = new SpotCollection();
        for (Spot spot : spots) {
            int frame = spot.getFeature("FRAME").intValue();
            Set<Spot> fc = sc.content.get(frame);
            if (null == fc) {
                fc = new HashSet<Spot>();
                sc.content.put(frame, fc);
            }
            fc.add(spot);
        }
        return sc;
    }

    public static SpotCollection fromMap(Map<Integer, Set<Spot>> source) {
        SpotCollection sc = new SpotCollection();
        sc.content = new ConcurrentSkipListMap<Integer, Set<Spot>>(source);
        return sc;
    }

    private static final boolean isVisible(Spot spot) {
        return spot.getFeature(VISIBILITY).compareTo(ZERO) > 0;
    }

    private final class FrameVisibleIterable
    implements Iterable<Spot> {
        private final int frame;

        public FrameVisibleIterable(int frame) {
            this.frame = frame;
        }

        @Override
        public Iterator<Spot> iterator() {
            return new VisibleSpotsFrameIterator((Set)SpotCollection.this.content.get(this.frame));
        }
    }

    private final class WholeCollectionIterable
    implements Iterable<Spot> {
        private final boolean visibleSpotsOnly;

        public WholeCollectionIterable(boolean visibleSpotsOnly) {
            this.visibleSpotsOnly = visibleSpotsOnly;
        }

        @Override
        public Iterator<Spot> iterator() {
            if (this.visibleSpotsOnly) {
                return new VisibleSpotsIterator();
            }
            return new AllSpotsIterator();
        }
    }

    private class VisibleSpotsFrameIterator
    implements Iterator<Spot> {
        private boolean hasNext = true;
        private Spot next = null;
        private final Iterator<Spot> contentIterator;

        public VisibleSpotsFrameIterator(Set<Spot> frameContent) {
            this.contentIterator = null == frameContent ? EMPTY_ITERATOR : frameContent.iterator();
            this.iterate();
        }

        private void iterate() {
            do {
                if (!this.contentIterator.hasNext()) {
                    this.hasNext = false;
                    this.next = null;
                    return;
                }
                this.next = this.contentIterator.next();
            } while (this.next.getFeature(SpotCollection.VISIBILITY).compareTo(ZERO) <= 0);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Spot next() {
            Spot toReturn = this.next;
            this.iterate();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported for SpotCollection iterators.");
        }
    }

    private class VisibleSpotsIterator
    implements Iterator<Spot> {
        private boolean hasNext = true;
        private final Iterator<Integer> frameIterator;
        private Iterator<Spot> contentIterator;
        private Spot next = null;
        private Set<Spot> currentFrameContent;

        public VisibleSpotsIterator() {
            this.frameIterator = SpotCollection.this.content.keySet().iterator();
            if (!this.frameIterator.hasNext()) {
                this.hasNext = false;
                return;
            }
            this.currentFrameContent = (Set)SpotCollection.this.content.get(this.frameIterator.next());
            this.contentIterator = this.currentFrameContent.iterator();
            this.iterate();
        }

        private void iterate() {
            while (true) {
                if (!this.contentIterator.hasNext()) {
                    if (!this.frameIterator.hasNext()) {
                        this.hasNext = false;
                        this.next = null;
                        return;
                    }
                    this.currentFrameContent = (Set)SpotCollection.this.content.get(this.frameIterator.next());
                    this.contentIterator = this.currentFrameContent.iterator();
                    continue;
                }
                this.next = this.contentIterator.next();
                if (this.next.getFeature(SpotCollection.VISIBILITY).compareTo(ZERO) > 0) break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Spot next() {
            Spot toReturn = this.next;
            this.iterate();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported for SpotCollection iterators.");
        }
    }

    private class AllSpotsIterator
    implements Iterator<Spot> {
        private boolean hasNext = true;
        private final Iterator<Integer> frameIterator;
        private Iterator<Spot> contentIterator;
        private Spot next = null;

        public AllSpotsIterator() {
            this.frameIterator = SpotCollection.this.content.keySet().iterator();
            if (!this.frameIterator.hasNext()) {
                this.hasNext = false;
                return;
            }
            Set currentFrameContent = (Set)SpotCollection.this.content.get(this.frameIterator.next());
            this.contentIterator = currentFrameContent.iterator();
            this.iterate();
        }

        private void iterate() {
            while (!this.contentIterator.hasNext()) {
                if (!this.frameIterator.hasNext()) {
                    this.hasNext = false;
                    this.next = null;
                    return;
                }
                this.contentIterator = ((Set)SpotCollection.this.content.get(this.frameIterator.next())).iterator();
            }
            this.next = this.contentIterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Spot next() {
            Spot toReturn = this.next;
            this.iterate();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported for SpotCollection iterators.");
        }
    }
}

