/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.LogDetector;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.LogDetectorConfigurationPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class LogDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "LOG_DETECTOR";
    public static final String NAME = "LoG detector";
    public static final String INFO_TEXT = "<html>This detector applies a LoG (Laplacian of Gaussian) filter <br>to the image, with a sigma suited to the blob estimated size. <br>Calculations are made in the Fourier space. The maxima in the <br>filtered image are searched for, and maxima too close from each <br>other are suppressed. A quadratic fitting scheme allows to do <br>sub-pixel localization. </html>";
    protected ImgPlus<T> img;
    protected Map<String, Object> settings;
    protected String errorMessage;

    @Override
    public boolean setTarget(ImgPlus<T> img, Map<String, Object> settings) {
        this.img = img;
        this.settings = settings;
        return this.checkSettings(settings);
    }

    protected RandomAccessibleInterval<T> prepareFrameImg(int frame) {
        IntervalView imFrame;
        double[] calibration = TMUtils.getSpatialCalibration(this.img);
        int cDim = this.img.dimensionIndex(Axes.CHANNEL);
        if (cDim < 0) {
            imFrame = this.img;
        } else {
            int channel = (Integer)this.settings.get("TARGET_CHANNEL") - 1;
            imFrame = Views.hyperSlice(this.img, (int)cDim, (long)channel);
        }
        int timeDim = this.img.dimensionIndex(Axes.TIME);
        if (timeDim >= 0) {
            if (cDim >= 0 && timeDim > cDim) {
                --timeDim;
            }
            imFrame = Views.hyperSlice((RandomAccessibleInterval)imFrame, (int)timeDim, (long)frame);
        }
        if (this.img.dimension(0) < 2L) {
            calibration[0] = calibration[1];
            calibration[1] = 1.0;
            imFrame = Views.hyperSlice((RandomAccessibleInterval)imFrame, (int)0, (long)0L);
        }
        if (this.img.dimension(1) < 2L) {
            imFrame = Views.hyperSlice((RandomAccessibleInterval)imFrame, (int)1, (long)0L);
        }
        return imFrame;
    }

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        double radius = (Double)this.settings.get("RADIUS");
        double threshold = (Double)this.settings.get("THRESHOLD");
        boolean doMedian = (Boolean)this.settings.get("DO_MEDIAN_FILTERING");
        boolean doSubpixel = (Boolean)this.settings.get("DO_SUBPIXEL_LOCALIZATION");
        double[] calibration = TMUtils.getSpatialCalibration(this.img);
        RandomAccessibleInterval<T> imFrame = this.prepareFrameImg(frame);
        LogDetector<T> detector = new LogDetector<T>(imFrame, interval, calibration, radius, threshold, doSubpixel, doMedian);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkSettings(Map<String, Object> lSettings) {
        boolean ok = true;
        StringBuilder errorHolder = new StringBuilder();
        ok &= TMUtils.checkParameter(lSettings, "TARGET_CHANNEL", Integer.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "RADIUS", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "THRESHOLD", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "DO_MEDIAN_FILTERING", Boolean.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "DO_SUBPIXEL_LOCALIZATION", Boolean.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("TARGET_CHANNEL");
        mandatoryKeys.add("RADIUS");
        mandatoryKeys.add("THRESHOLD");
        mandatoryKeys.add("DO_MEDIAN_FILTERING");
        mandatoryKeys.add("DO_SUBPIXEL_LOCALIZATION");
        if (!(ok &= TMUtils.checkMapKeys(lSettings, mandatoryKeys, null, errorHolder))) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean marshall(Map<String, Object> lSettings, Element element) {
        boolean ok;
        StringBuilder errorHolder = new StringBuilder();
        boolean bl = ok = IOUtils.writeTargetChannel(lSettings, element, errorHolder) && IOUtils.writeRadius(lSettings, element, errorHolder) && IOUtils.writeThreshold(lSettings, element, errorHolder) && IOUtils.writeDoMedian(lSettings, element, errorHolder) && IOUtils.writeDoSubPixel(lSettings, element, errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> lSettings) {
        lSettings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= IOUtils.readDoubleAttribute(element, lSettings, "RADIUS", errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, lSettings, "THRESHOLD", errorHolder);
        ok &= IOUtils.readBooleanAttribute(element, lSettings, "DO_SUBPIXEL_LOCALIZATION", errorHolder);
        ok &= IOUtils.readBooleanAttribute(element, lSettings, "DO_MEDIAN_FILTERING", errorHolder);
        if (!(ok &= IOUtils.readIntegerAttribute(element, lSettings, "TARGET_CHANNEL", errorHolder))) {
            this.errorMessage = errorHolder.toString();
            return false;
        }
        return this.checkSettings(lSettings);
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new LogDetectorConfigurationPanel(lSettings, model, INFO_TEXT, NAME);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put("RADIUS", 5.0);
        lSettings.put("THRESHOLD", 0.0);
        lSettings.put("DO_MEDIAN_FILTERING", false);
        lSettings.put("DO_SUBPIXEL_LOCALIZATION", true);
        return lSettings;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public LogDetectorFactory<T> copy() {
        return new LogDetectorFactory<T>();
    }
}

