/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import org.scijava.listeners.Listeners;

public class DisplaySettings {
    private String name;
    private Color spotUniformColor;
    private TrackMateObject spotColorByType;
    private String spotColorByFeature;
    private double spotDisplayRadius;
    private boolean spotDisplayedAsRoi;
    private double spotMin;
    private double spotMax;
    private boolean spotShowName;
    private double trackMin;
    private double trackMax;
    private TrackMateObject trackColorByType;
    private String trackColorByFeature;
    private Color trackUniformColor;
    private Color undefinedValueColor;
    private Color missingValueColor;
    private Color highlightColor;
    private TrackDisplayMode trackDisplayMode;
    private Colormap colormap;
    private boolean limitZDrawingDepth;
    private double drawingZDepth;
    private boolean fadeTracks;
    private int fadeTrackRange;
    private boolean useAntialiasing;
    private boolean spotVisible;
    private boolean trackVisible;
    private Font font;
    private double lineThickness;
    private double selectionLineThickness;
    private Color trackschemeBackgroundColor1;
    private Color trackschemeBackgroundColor2;
    private Color trackschemeForegroundColor;
    private Color trackschemeDecorationColor;
    private boolean trackschemeFillBox;
    private boolean spotFilled;
    private double spotTransparencyAlpha;
    private final transient Listeners.List<UpdateListener> updateListeners;
    private static final DisplaySettings df = new DisplaySettings("Default");

    public DisplaySettings() {
        this.updateListeners = new Listeners.SynchronizedList();
        this.set(df);
    }

    private DisplaySettings(String name) {
        this.name = name;
        this.updateListeners = new Listeners.SynchronizedList();
    }

    public DisplaySettings copy(String name) {
        DisplaySettings rs = new DisplaySettings();
        rs.set(this);
        if (name != null) {
            rs.setName(name);
        }
        return rs;
    }

    public DisplaySettings copy() {
        return this.copy(null);
    }

    synchronized void set(DisplaySettings ds) {
        this.name = ds.name;
        this.spotVisible = ds.spotVisible;
        this.spotDisplayedAsRoi = ds.spotDisplayedAsRoi;
        this.spotShowName = ds.spotShowName;
        this.spotDisplayRadius = ds.spotDisplayRadius;
        this.spotColorByType = ds.spotColorByType;
        this.spotColorByFeature = ds.spotColorByFeature;
        this.spotMin = ds.spotMin;
        this.spotMax = ds.spotMax;
        this.spotUniformColor = ds.spotUniformColor;
        this.spotFilled = ds.spotFilled;
        this.spotTransparencyAlpha = ds.spotTransparencyAlpha;
        this.trackVisible = ds.trackVisible;
        this.trackColorByFeature = ds.trackColorByFeature;
        this.trackColorByType = ds.trackColorByType;
        this.trackDisplayMode = ds.trackDisplayMode;
        this.trackMin = ds.trackMin;
        this.trackMax = ds.trackMax;
        this.fadeTracks = ds.fadeTracks;
        this.fadeTrackRange = ds.fadeTrackRange;
        this.trackUniformColor = ds.trackUniformColor;
        this.colormap = ds.colormap;
        this.limitZDrawingDepth = ds.limitZDrawingDepth;
        this.drawingZDepth = ds.drawingZDepth;
        this.highlightColor = ds.highlightColor;
        this.missingValueColor = ds.missingValueColor;
        this.undefinedValueColor = ds.undefinedValueColor;
        this.useAntialiasing = ds.useAntialiasing;
        this.font = ds.font;
        this.lineThickness = ds.lineThickness;
        this.selectionLineThickness = ds.selectionLineThickness;
        this.trackschemeBackgroundColor1 = ds.trackschemeBackgroundColor1;
        this.trackschemeBackgroundColor2 = ds.trackschemeBackgroundColor2;
        this.trackschemeDecorationColor = ds.trackschemeDecorationColor;
        this.trackschemeForegroundColor = ds.trackschemeForegroundColor;
        this.trackschemeFillBox = ds.trackschemeFillBox;
        this.notifyListeners();
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.name = name;
            this.notifyListeners();
        }
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public synchronized void setColormap(Colormap colormap) {
        if (this.colormap != colormap) {
            this.colormap = colormap;
            this.notifyListeners();
        }
    }

    public boolean isZDrawingDepthLimited() {
        return this.limitZDrawingDepth;
    }

    public synchronized void setZDrawingDepthLimited(boolean limitZDrawingDepth) {
        if (this.limitZDrawingDepth != limitZDrawingDepth) {
            this.limitZDrawingDepth = limitZDrawingDepth;
            this.notifyListeners();
        }
    }

    public double getZDrawingDepth() {
        return this.drawingZDepth;
    }

    public synchronized void setZDrawingDepth(double drawingZDepth) {
        if (this.drawingZDepth != drawingZDepth) {
            this.drawingZDepth = drawingZDepth;
            this.notifyListeners();
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public synchronized void setHighlightColor(Color highlightColor) {
        if (this.highlightColor != highlightColor) {
            this.highlightColor = highlightColor;
            this.notifyListeners();
        }
    }

    public boolean isFadeTracks() {
        return this.fadeTracks;
    }

    public synchronized void setFadeTracks(boolean fadeTracks) {
        if (this.fadeTracks != fadeTracks) {
            this.fadeTracks = fadeTracks;
            this.notifyListeners();
        }
    }

    public Color getMissingValueColor() {
        return this.missingValueColor;
    }

    public synchronized void setMissingValueColor(Color missingValueColor) {
        if (this.missingValueColor != missingValueColor) {
            this.missingValueColor = missingValueColor;
            this.notifyListeners();
        }
    }

    public String getSpotColorByFeature() {
        return this.spotColorByFeature;
    }

    public TrackMateObject getSpotColorByType() {
        return this.spotColorByType;
    }

    public synchronized void setSpotColorBy(TrackMateObject spotColorByType, String spotColorByFeature) {
        boolean fire = false;
        if (this.spotColorByType != spotColorByType) {
            this.spotColorByType = spotColorByType;
            fire = true;
        }
        if (this.spotColorByFeature != spotColorByFeature) {
            this.spotColorByFeature = spotColorByFeature;
            fire = true;
        }
        if (fire) {
            this.notifyListeners();
        }
    }

    public boolean isSpotDisplayedAsRoi() {
        return this.spotDisplayedAsRoi;
    }

    public synchronized void setSpotDisplayedAsRoi(boolean spotDisplayedAsRoi) {
        if (this.spotDisplayedAsRoi != spotDisplayedAsRoi) {
            this.spotDisplayedAsRoi = spotDisplayedAsRoi;
            this.notifyListeners();
        }
    }

    public double getSpotDisplayRadius() {
        return this.spotDisplayRadius;
    }

    public synchronized void setSpotDisplayRadius(double spotDisplayRadius) {
        if (this.spotDisplayRadius != spotDisplayRadius) {
            this.spotDisplayRadius = spotDisplayRadius;
            this.notifyListeners();
        }
    }

    public double getSpotMax() {
        return this.spotMax;
    }

    public double getSpotMin() {
        return this.spotMin;
    }

    public synchronized void setSpotMinMax(double spotMin, double spotMax) {
        double smin = Math.min(spotMin, spotMax);
        double smax = Math.max(spotMin, spotMax);
        boolean notify = false;
        if (this.spotMin != smin) {
            this.spotMin = smin;
            notify = true;
        }
        if (this.spotMax != smax) {
            this.spotMax = smax;
            notify = true;
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    public boolean isSpotShowName() {
        return this.spotShowName;
    }

    public synchronized void setSpotShowName(boolean spotShowName) {
        if (this.spotShowName != spotShowName) {
            this.spotShowName = spotShowName;
            this.notifyListeners();
        }
    }

    public boolean isSpotVisible() {
        return this.spotVisible;
    }

    public synchronized void setSpotVisible(boolean spotsVisible) {
        if (this.spotVisible != spotsVisible) {
            this.spotVisible = spotsVisible;
            this.notifyListeners();
        }
    }

    public Color getSpotUniformColor() {
        return this.spotUniformColor;
    }

    public synchronized void setSpotUniformColor(Color spotUniformColor) {
        if (this.spotUniformColor != spotUniformColor) {
            this.spotUniformColor = spotUniformColor;
            this.notifyListeners();
        }
    }

    public int getFadeTrackRange() {
        return this.fadeTrackRange;
    }

    public synchronized void setFadeTrackRange(int fadeTrackRange) {
        if (this.fadeTrackRange != fadeTrackRange) {
            this.fadeTrackRange = fadeTrackRange;
            this.notifyListeners();
        }
    }

    public TrackDisplayMode getTrackDisplayMode() {
        return this.trackDisplayMode;
    }

    public String getTrackColorByFeature() {
        return this.trackColorByFeature;
    }

    public TrackMateObject getTrackColorByType() {
        return this.trackColorByType;
    }

    public synchronized void setTrackColorBy(TrackMateObject trackColorByType, String trackColorByFeature) {
        boolean fire = false;
        if (this.trackColorByType != trackColorByType) {
            this.trackColorByType = trackColorByType;
            fire = true;
        }
        if (this.trackColorByFeature != trackColorByFeature) {
            this.trackColorByFeature = trackColorByFeature;
            fire = true;
        }
        if (fire) {
            this.notifyListeners();
        }
    }

    public double getTrackMax() {
        return this.trackMax;
    }

    public double getTrackMin() {
        return this.trackMin;
    }

    public synchronized void setTrackMinMax(double trackMin, double trackMax) {
        double tmin = Math.min(trackMin, trackMax);
        double tmax = Math.max(trackMin, trackMax);
        boolean notify = false;
        if (this.trackMin != tmin) {
            this.trackMin = tmin;
            notify = true;
        }
        if (this.trackMax != tmax) {
            this.trackMax = tmax;
            notify = true;
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    public synchronized void setTrackDisplayMode(TrackDisplayMode trackDisplayMode) {
        if (this.trackDisplayMode != trackDisplayMode) {
            this.trackDisplayMode = trackDisplayMode;
            this.notifyListeners();
        }
    }

    public boolean isTrackVisible() {
        return this.trackVisible;
    }

    public synchronized void setTrackVisible(boolean trackVisible) {
        if (this.trackVisible != trackVisible) {
            this.trackVisible = trackVisible;
            this.notifyListeners();
        }
    }

    public Color getTrackUniformColor() {
        return this.trackUniformColor;
    }

    public synchronized void setTrackUniformColor(Color trackUniformColor) {
        if (this.trackUniformColor != trackUniformColor) {
            this.trackUniformColor = trackUniformColor;
            this.notifyListeners();
        }
    }

    public Color getUndefinedValueColor() {
        return this.undefinedValueColor;
    }

    public synchronized void setUndefinedValueColor(Color undefinedValueColor) {
        if (this.undefinedValueColor != undefinedValueColor) {
            this.undefinedValueColor = undefinedValueColor;
            this.notifyListeners();
        }
    }

    public boolean getUseAntialiasing() {
        return this.useAntialiasing;
    }

    public synchronized void setUseAntialiasing(boolean useAntialiasing) {
        if (this.useAntialiasing != useAntialiasing) {
            this.useAntialiasing = useAntialiasing;
            this.notifyListeners();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public synchronized void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.notifyListeners();
        }
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public synchronized void setLineThickness(double lineThickness) {
        if (this.lineThickness != lineThickness) {
            this.lineThickness = lineThickness;
            this.notifyListeners();
        }
    }

    public double getSelectionLineThickness() {
        return this.selectionLineThickness;
    }

    public synchronized void setSelectionLineThickness(double selectionLineThickness) {
        if (this.selectionLineThickness != selectionLineThickness) {
            this.selectionLineThickness = selectionLineThickness;
            this.notifyListeners();
        }
    }

    public boolean isSpotFilled() {
        return this.spotFilled;
    }

    public synchronized void setSpotFilled(boolean isSpotFilled) {
        if (this.spotFilled != isSpotFilled) {
            this.spotFilled = isSpotFilled;
            this.notifyListeners();
        }
    }

    public double getSpotTransparencyAlpha() {
        return this.spotTransparencyAlpha;
    }

    public synchronized void setSpotTransparencyAlpha(double spotTransparencyAlpha) {
        if (this.spotTransparencyAlpha != spotTransparencyAlpha) {
            this.spotTransparencyAlpha = spotTransparencyAlpha;
            this.notifyListeners();
        }
    }

    public Color getTrackSchemeBackgroundColor1() {
        return this.trackschemeBackgroundColor1;
    }

    public synchronized void setTrackSchemeBackgroundColor1(Color trackschemeBackgroundColor1) {
        if (this.trackschemeBackgroundColor1 != trackschemeBackgroundColor1) {
            this.trackschemeBackgroundColor1 = trackschemeBackgroundColor1;
            this.notifyListeners();
        }
    }

    public Color getTrackSchemeBackgroundColor2() {
        return this.trackschemeBackgroundColor2;
    }

    public synchronized void setTrackSchemeBackgroundColor2(Color trackschemeBackgroundColor2) {
        if (this.trackschemeBackgroundColor2 != trackschemeBackgroundColor2) {
            this.trackschemeBackgroundColor2 = trackschemeBackgroundColor2;
            this.notifyListeners();
        }
    }

    public Color getTrackSchemeDecorationColor() {
        return this.trackschemeDecorationColor;
    }

    public synchronized void setTrackSchemeDecorationColor(Color trackschemeDecorationColor) {
        if (this.trackschemeDecorationColor != trackschemeDecorationColor) {
            this.trackschemeDecorationColor = trackschemeDecorationColor;
            this.notifyListeners();
        }
    }

    public Color getTrackSchemeForegroundColor() {
        return this.trackschemeForegroundColor;
    }

    public synchronized void setTrackSchemeForegroundColor(Color trackschemeForegroundColor) {
        if (this.trackschemeForegroundColor != trackschemeForegroundColor) {
            this.trackschemeForegroundColor = trackschemeForegroundColor;
            this.notifyListeners();
        }
    }

    public boolean isTrackSchemeFillBox() {
        return this.trackschemeFillBox;
    }

    public synchronized void setTrackschemeFillBox(boolean trackschemeFillBox) {
        if (this.trackschemeFillBox != trackschemeFillBox) {
            this.trackschemeFillBox = trackschemeFillBox;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (UpdateListener l : this.updateListeners.list) {
            l.displaySettingsChanged();
        }
    }

    public Listeners.List<UpdateListener> listeners() {
        return this.updateListeners;
    }

    public static DisplaySettings defaultStyle() {
        return df;
    }

    public String toString() {
        return DisplaySettingsIO.toJson(this);
    }

    public static void main(String[] args) {
        System.out.println(df.toString());
    }

    static {
        DisplaySettings.df.useAntialiasing = true;
        DisplaySettings.df.colormap = Colormap.Jet;
        DisplaySettings.df.limitZDrawingDepth = false;
        DisplaySettings.df.drawingZDepth = 10.0;
        DisplaySettings.df.fadeTracks = true;
        DisplaySettings.df.fadeTrackRange = 30;
        DisplaySettings.df.highlightColor = new Color(0.2f, 0.9f, 0.2f);
        DisplaySettings.df.missingValueColor = Color.GRAY.darker();
        DisplaySettings.df.spotColorByFeature = "UNIFORM_COLOR";
        DisplaySettings.df.spotColorByType = TrackMateObject.DEFAULT;
        DisplaySettings.df.spotDisplayedAsRoi = true;
        DisplaySettings.df.spotDisplayRadius = 1.0;
        DisplaySettings.df.spotFilled = false;
        DisplaySettings.df.spotMin = 0.0;
        DisplaySettings.df.spotMax = 10.0;
        DisplaySettings.df.spotShowName = false;
        DisplaySettings.df.spotTransparencyAlpha = 1.0;
        DisplaySettings.df.spotUniformColor = new Color(0.8f, 0.2f, 0.8f);
        DisplaySettings.df.spotVisible = true;
        DisplaySettings.df.trackDisplayMode = TrackDisplayMode.FULL;
        DisplaySettings.df.trackColorByFeature = "TRACK_INDEX";
        DisplaySettings.df.trackColorByType = TrackMateObject.DEFAULT;
        DisplaySettings.df.trackUniformColor = new Color(0.8f, 0.8f, 0.2f);
        DisplaySettings.df.trackMin = 0.0;
        DisplaySettings.df.trackMax = 10.0;
        DisplaySettings.df.trackVisible = true;
        DisplaySettings.df.undefinedValueColor = Color.BLACK;
        DisplaySettings.df.font = new Font("Arial", 1, 12);
        DisplaySettings.df.lineThickness = 1.0;
        DisplaySettings.df.selectionLineThickness = 4.0;
        DisplaySettings.df.trackschemeBackgroundColor1 = Color.GRAY;
        DisplaySettings.df.trackschemeBackgroundColor2 = Color.LIGHT_GRAY;
        DisplaySettings.df.trackschemeForegroundColor = Color.BLACK;
        DisplaySettings.df.trackschemeDecorationColor = Color.BLACK;
        DisplaySettings.df.trackschemeFillBox = false;
    }

    public static interface UpdateListener {
        public void displaySettingsChanged();
    }

    public static enum TrackMateObject {
        DEFAULT("Default"),
        SPOTS("spots"),
        EDGES("edges"),
        TRACKS("tracks");

        private String name;

        private TrackMateObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum TrackDisplayMode {
        FULL("Show entire tracks"),
        LOCAL("Show tracks local in time"),
        LOCAL_BACKWARD("Show tracks backward in time"),
        LOCAL_FORWARD("Show tracks forward in time"),
        SELECTION_ONLY("Show selection only");

        private final String name;

        private TrackDisplayMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

