/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.view.mxGraph;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.ConvexBranchesDecomposition;
import fiji.plugin.trackmate.graph.GraphUtils;
import fiji.plugin.trackmate.graph.SortedDepthFirstIterator;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.imglib2.algorithm.Benchmark;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class TrackSchemeGraphLayout
extends mxGraphLayout
implements Benchmark {
    private static final int START_COLUMN = 1;
    private final Model model;
    private final JGraphXAdapter graphAdapter;
    private final TrackSchemeGraphComponent component;
    private Map<Integer, Integer> rowLengths;
    private long processingTime;

    public TrackSchemeGraphLayout(JGraphXAdapter graph, Model model, TrackSchemeGraphComponent component) {
        super((mxGraph)graph);
        this.graphAdapter = graph;
        this.model = model;
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object lParent) {
        long start = System.currentTimeMillis();
        Object[] objs = this.graphAdapter.getChildVertices(this.graphAdapter.getDefaultParent());
        ArrayList<mxCell> lonelyCells = new ArrayList<mxCell>(objs.length);
        for (Object obj : objs) {
            lonelyCells.add((mxCell)obj);
        }
        TimeDirectedNeighborIndex neighborCache = this.model.getTrackModel().getDirectedNeighborIndex();
        Map<Spot, Integer> cumulativeBranchWidth = GraphUtils.cumulativeBranchWidth(this.model.getTrackModel());
        int maxFrame = this.model.getSpots().lastKey();
        this.graphAdapter.getModel().beginUpdate();
        try {
            int ntracks = this.model.getTrackModel().nTracks(true);
            this.component.columnWidths = new int[ntracks];
            this.component.columnTrackIDs = new Integer[ntracks];
            int[] columns = new int[maxFrame + 1];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = 1;
            }
            int trackIndex = 0;
            for (Integer trackID : this.model.getTrackModel().trackIDs(true)) {
                Set<Spot> track = this.model.getTrackModel().trackSpots(trackID);
                this.component.columnTrackIDs[trackIndex] = trackID;
                TreeSet<Spot> sortedTrack = new TreeSet<Spot>(Spot.frameComparator);
                sortedTrack.addAll(track);
                Spot first = sortedTrack.first();
                boolean isTree = GraphUtils.isTree(track, neighborCache);
                if (isTree) {
                    SortedDepthFirstIterator<Spot, DefaultWeightedEdge> iterator = this.model.getTrackModel().getSortedDepthFirstIterator(first, Spot.nameComparator, false);
                    while (iterator.hasNext()) {
                        Spot spot = iterator.next();
                        mxCell cell = this.graphAdapter.getCellFor(spot);
                        lonelyCells.remove(cell);
                        int frame = spot.getFeature("FRAME").intValue();
                        int cellPos = columns[frame] + cumulativeBranchWidth.get(spot) / 2;
                        this.setCellGeometry((mxICell)cell, frame, cellPos);
                        int n = frame;
                        columns[n] = columns[n] + cumulativeBranchWidth.get(spot);
                        if (neighborCache.successorsOf(spot).size() != 0) continue;
                        int target = columns[frame];
                        for (int i = 0; i <= maxFrame; ++i) {
                            columns[i] = target;
                        }
                    }
                } else {
                    ConvexBranchesDecomposition.TrackBranchDecomposition branchDecomposition = ConvexBranchesDecomposition.processTrack(trackID, this.model.getTrackModel(), neighborCache, false, false);
                    SimpleDirectedGraph<List<Spot>, DefaultEdge> branchGraph = ConvexBranchesDecomposition.buildBranchGraph(branchDecomposition);
                    DepthFirstIterator depthFirstIterator = new DepthFirstIterator(branchGraph);
                    while (depthFirstIterator.hasNext()) {
                        List branch = (List)depthFirstIterator.next();
                        int firstFrame = ((Spot)branch.get(0)).getFeature("FRAME").intValue();
                        int lastFrame = ((Spot)branch.get(branch.size() - 1)).getFeature("FRAME").intValue();
                        int targetColumn = columns[firstFrame];
                        for (Spot spot : branch) {
                            int sFrame = spot.getFeature("FRAME").intValue();
                            if (columns[sFrame] <= targetColumn) continue;
                            targetColumn = columns[sFrame];
                        }
                        for (Spot spot : branch) {
                            mxCell cell = this.graphAdapter.getCellFor(spot);
                            lonelyCells.remove(cell);
                            int frame = spot.getFeature("FRAME").intValue();
                            this.setCellGeometry((mxICell)cell, frame, targetColumn);
                        }
                        for (int frame = firstFrame; frame <= lastFrame; ++frame) {
                            columns[frame] = targetColumn + 1;
                        }
                    }
                }
                int maxCol = 0;
                for (int j = 0; j < columns.length; ++j) {
                    if (columns[j] <= maxCol) continue;
                    maxCol = columns[j];
                }
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = maxCol + 1;
                }
                int sumWidth = 1;
                for (int i = 0; i < trackIndex; ++i) {
                    sumWidth += this.component.columnWidths[i];
                }
                this.component.columnWidths[trackIndex] = maxCol - sumWidth;
                ++trackIndex;
            }
            for (mxCell cell : lonelyCells) {
                int frame;
                Spot spot = this.graphAdapter.getSpotFor((mxICell)cell);
                int n = frame = spot.getFeature("FRAME").intValue();
                int n2 = columns[n];
                columns[n] = n2 + 1;
                this.setCellGeometry((mxICell)cell, frame, n2);
            }
            this.rowLengths = new HashMap<Integer, Integer>(columns.length);
            for (int i = 0; i < columns.length; ++i) {
                this.rowLengths.put(i, columns[i]);
            }
            Object[] verticesCells = this.graphAdapter.getVertexCells().toArray();
            this.graphAdapter.cellsOrdered(verticesCells, false);
        }
        finally {
            this.graphAdapter.getModel().endUpdate();
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
    }

    private final void setCellGeometry(mxICell cell, int row, int targetColumn) {
        double x = targetColumn * 160 - 64;
        double y = (0.5 + (double)row) * 96.0 - 20.0;
        mxGeometry geometry = cell.getGeometry();
        geometry.setX(x);
        geometry.setY(y);
    }

    public Map<Integer, Integer> getRowLengths() {
        return this.rowLengths;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

