/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.view.mxPerimeter;
import com.mxgraph.view.mxStylesheet;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackSchemeStylist {
    private final Model model;
    private final DisplaySettings displaySettings;
    private final JGraphXAdapter graphx;
    private String globalStyle = "simple";
    private final Map<String, Object> simpleStyle;
    private final Map<String, Object> fullStyle;
    private final Map<String, Object> edgeStyle;
    static final List<String> VERTEX_STYLE_NAMES = new ArrayList<String>();
    private static final String FULL_STYLE_NAME = "full";
    private static final String SIMPLE_STYLE_NAME = "simple";
    private static final String DEFAULT_STYLE_NAME = "simple";
    private static final Map<String, Object> FULL_VERTEX_STYLE = new HashMap<String, Object>();
    private static final Map<String, Object> SIMPLE_VERTEX_STYLE = new HashMap<String, Object>();
    private static final Map<String, Object> BASIC_EDGE_STYLE = new HashMap<String, Object>();

    public TrackSchemeStylist(Model model, JGraphXAdapter graphx, DisplaySettings displaySettings) {
        this.model = model;
        this.graphx = graphx;
        this.displaySettings = displaySettings;
        this.simpleStyle = new HashMap<String, Object>(SIMPLE_VERTEX_STYLE);
        this.fullStyle = new HashMap<String, Object>(FULL_VERTEX_STYLE);
        this.edgeStyle = new HashMap<String, Object>(BASIC_EDGE_STYLE);
        mxStylesheet styleSheet = graphx.getStylesheet();
        styleSheet.setDefaultEdgeStyle(this.edgeStyle);
        styleSheet.setDefaultVertexStyle(this.simpleStyle);
        styleSheet.putCellStyle(FULL_STYLE_NAME, this.fullStyle);
        styleSheet.putCellStyle("simple", this.simpleStyle);
    }

    public void setStyle(String styleName) {
        if (!this.graphx.getStylesheet().getStyles().containsKey(styleName)) {
            throw new IllegalArgumentException("Unknown TrackScheme style: " + styleName);
        }
        this.globalStyle = styleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateEdgeStyle(Collection<mxCell> edges) {
        FeatureColorGenerator<DefaultWeightedEdge> trackColorGenerator = FeatureUtils.createTrackColorGenerator(this.model, this.displaySettings);
        Color missingValueColor = this.displaySettings.getMissingValueColor();
        this.graphx.getModel().beginUpdate();
        try {
            for (mxCell cell : edges) {
                DefaultWeightedEdge edge = this.graphx.getEdgeFor((mxICell)cell);
                Color color = trackColorGenerator.color(edge);
                if (color == null) {
                    color = missingValueColor;
                }
                String colorstr = Integer.toHexString(color.getRGB()).substring(2);
                String style = cell.getStyle();
                style = mxStyleUtils.setStyle((String)style, (String)mxConstants.STYLE_STROKECOLOR, (String)colorstr);
                style = mxStyleUtils.setStyle((String)style, (String)mxConstants.STYLE_STROKEWIDTH, (String)Float.toString((float)this.displaySettings.getLineThickness()));
                this.graphx.getModel().setStyle((Object)cell, style);
            }
        }
        finally {
            this.graphx.getModel().endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVertexStyle(Collection<mxCell> vertices) {
        Font font = this.displaySettings.getFont();
        this.fullStyle.put(mxConstants.STYLE_FONTFAMILY, font.getFamily());
        this.fullStyle.put(mxConstants.STYLE_FONTSIZE, "" + font.getSize());
        this.fullStyle.put(mxConstants.STYLE_FONTSTYLE, "" + font.getStyle());
        FeatureColorGenerator<Spot> spotColorGenerator = FeatureUtils.createSpotColorGenerator(this.model, this.displaySettings);
        Color missingValueColor = this.displaySettings.getMissingValueColor();
        this.graphx.getModel().beginUpdate();
        try {
            for (mxCell vertex : vertices) {
                Spot spot = this.graphx.getSpotFor((mxICell)vertex);
                if (spot == null) continue;
                Color color = spotColorGenerator.color(spot);
                if (color == null) {
                    color = missingValueColor;
                }
                String colorstr = Integer.toHexString(color.getRGB()).substring(2);
                String fillcolorstr = this.displaySettings.isTrackSchemeFillBox() ? colorstr : "white";
                this.setVertexStyle((mxICell)vertex, colorstr, fillcolorstr);
            }
        }
        finally {
            this.graphx.getModel().endUpdate();
        }
    }

    private void setVertexStyle(mxICell vertex, String colorstr, String fillcolorstr) {
        int height;
        int width;
        String targetStyle = vertex.getStyle();
        targetStyle = mxStyleUtils.removeAllStylenames((String)targetStyle);
        targetStyle = mxStyleUtils.setStyle((String)targetStyle, (String)mxConstants.STYLE_STROKECOLOR, (String)colorstr);
        if (this.globalStyle.equals("simple")) {
            targetStyle = mxStyleUtils.setStyle((String)targetStyle, (String)mxConstants.STYLE_FILLCOLOR, (String)colorstr);
            height = width = 40;
        } else {
            targetStyle = mxStyleUtils.setStyle((String)targetStyle, (String)mxConstants.STYLE_FILLCOLOR, (String)fillcolorstr);
            width = 128;
            height = 40;
        }
        targetStyle = this.globalStyle + ";" + targetStyle;
        this.graphx.getModel().setStyle((Object)vertex, targetStyle);
        this.graphx.getModel().getGeometry((Object)vertex).setWidth((double)width);
        this.graphx.getModel().getGeometry((Object)vertex).setHeight((double)height);
    }

    static {
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_FILLCOLOR, "white");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_FONTCOLOR, "black");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_ALIGN, "right");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_SHAPE, "scaledLabel");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_IMAGE_ALIGN, "left");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_ROUNDED, true);
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_PERIMETER, mxPerimeter.RectanglePerimeter);
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_STROKECOLOR, "#FF00FF");
        FULL_VERTEX_STYLE.put(mxConstants.STYLE_NOLABEL, false);
        SIMPLE_VERTEX_STYLE.put(mxConstants.STYLE_SHAPE, "ellipse");
        SIMPLE_VERTEX_STYLE.put(mxConstants.STYLE_NOLABEL, true);
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_SHAPE, "connector");
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_ALIGN, "center");
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_STARTARROW, mxConstants.NONE);
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_ENDARROW, mxConstants.NONE);
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_STROKECOLOR, "#FF00FF");
        BASIC_EDGE_STYLE.put(mxConstants.STYLE_NOLABEL, true);
        VERTEX_STYLE_NAMES.add("simple");
        VERTEX_STYLE_NAMES.add(FULL_STYLE_NAME);
    }
}

