/*
 * Decompiled with CFR 0.152.
 */
package nrrd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import nrrd.NrrdInfo;

public class NrrdHeader {
    String filename;
    String directory;
    LinkedHashMap tags;
    LinkedHashMap fields;
    ArrayList header;
    ArrayList comments;
    String magic;
    String content;
    String contentType;
    String encoding;
    public int lineSkip;
    boolean detachedHeader = false;
    boolean multiLineDataFile = false;
    ArrayList dataFiles;
    StringBuffer textData;
    boolean textNrrd = false;

    public String getTextData() {
        if (!this.textNrrd || this.textData.length() == 0) {
            return null;
        }
        return this.textData.toString();
    }

    public NrrdHeader() {
        this("UTF-8");
    }

    public NrrdHeader(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.header == null || this.header.size() < 1) {
            return null;
        }
        Iterator it = this.header.iterator();
        while (it.hasNext()) {
            sb.append(it.next() + "\n");
        }
        return sb.toString();
    }

    void appendLine(String l) {
        this.header.add(l);
    }

    void init() {
        this.tags = new LinkedHashMap();
        this.fields = new LinkedHashMap();
        this.header = new ArrayList();
        this.comments = new ArrayList();
        this.textData = new StringBuffer();
        this.dataFiles = new ArrayList();
        this.detachedHeader = false;
        this.multiLineDataFile = false;
    }

    public String getCommentStrings() {
        return this.comments.toString();
    }

    void appendCommment(String comment) throws Exception {
        if (!comment.startsWith("#")) {
            throw new Exception("nrrd invalid comment: " + comment);
        }
        this.appendLine(comment);
        comment = comment.split("#\\s*", 1)[0];
    }

    public String getTagStrings() {
        return this.tags.toString();
    }

    void appendTag(String tag) throws Exception {
        this.appendLine(tag);
        int sepPos = tag.indexOf(":=");
        if (sepPos < 1 || tag.length() < 3) {
            throw new Exception("nrrd: invalid tag: " + tag);
        }
        String tagKey = tag.substring(0, sepPos);
        String tagValue = tag.substring(sepPos + 2, tag.length());
        this.tags.put(tagKey, tagValue);
    }

    public String getFieldStrings() {
        if (this.fields == null || this.fields.size() < 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer("{");
        Iterator it = this.fields.keySet().iterator();
        while (it.hasNext()) {
            String fieldname = (String)it.next();
            String sa = Arrays.toString((String[])this.fields.get(fieldname));
            if (sa != null) {
                sb.append(fieldname + "=" + sa);
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    void processDataFile(String allFieldVals) throws Exception {
        String[] fieldVals = null;
        this.detachedHeader = true;
        if (allFieldVals.startsWith("LIST")) {
            this.multiLineDataFile = true;
            fieldVals = allFieldVals.trim().split("\\s+");
        } else if (allFieldVals.matches(".*%[0-9]*d.*")) {
            if (allFieldVals.startsWith("\"")) {
                int lastQuotePos = allFieldVals.lastIndexOf("\"", 1);
                if (lastQuotePos < 2) {
                    throw new Exception("Unable to read quoted format string in data file line");
                }
                String[] sa = allFieldVals.substring(lastQuotePos + 1).split("\\s+");
                if (sa.length < 4 || sa.length > 5) {
                    throw new Exception("Incorrect number of field specifications in data file field");
                }
                fieldVals = new String[1 + sa.length];
                fieldVals[0] = allFieldVals.substring(1, lastQuotePos);
                System.arraycopy(sa, 0, fieldVals, 0, sa.length);
            } else {
                fieldVals = allFieldVals.split("\\s+");
            }
        } else {
            fieldVals = new String[]{allFieldVals};
        }
        this.fields.put("data file", fieldVals);
    }

    void appendField(String fieldspec) throws Exception {
        this.appendLine(fieldspec);
        int sepIndex = fieldspec.indexOf(": ");
        String fieldName = this.standardFieldName(fieldspec.substring(0, sepIndex));
        String allFieldVals = fieldspec.substring(sepIndex + 2, fieldspec.length());
        String[] fieldVals = null;
        if (fieldName.equals("content")) {
            this.content = allFieldVals;
            fieldVals = new String[]{allFieldVals};
            this.fields.put(fieldName, fieldVals);
            return;
        }
        if (fieldName.equals("data file")) {
            this.processDataFile(allFieldVals);
            return;
        }
        if ((allFieldVals = allFieldVals.trim()).startsWith("\"") && allFieldVals.endsWith("\"")) {
            fieldVals = (allFieldVals = allFieldVals.substring(1, allFieldVals.length() - 1)).split("\"\\s+\"");
            if (fieldVals.length < 1) {
                throw new Exception("nrrd: trouble parsing quoted field values: " + fieldspec);
            }
        } else {
            fieldVals = allFieldVals.toLowerCase().split("\\s+");
        }
        this.fields.put(fieldName, fieldVals);
    }

    String standardFieldName(String fieldName) {
        if ((fieldName = fieldName.toLowerCase()).equals("centerings")) {
            return "centers";
        }
        if (fieldName.equals("axismaxs")) {
            return "axis maxs";
        }
        if (fieldName.equals("axismins")) {
            return "axis mins";
        }
        if (fieldName.equals("lineskip")) {
            return "line skip";
        }
        if (fieldName.equals("byteskip")) {
            return "byte skip";
        }
        if (fieldName.equals("datafile")) {
            return "data file";
        }
        if (fieldName.equals("oldmax")) {
            return "old max";
        }
        if (fieldName.equals("oldmin")) {
            return "old min";
        }
        return fieldName;
    }

    public void readHeader(String path) throws IOException {
        FileInputStream fis;
        try {
            File f = new File(path);
            this.filename = f.getName();
            this.directory = f.getParent();
            fis = new FileInputStream(f);
        }
        catch (Exception e) {
            throw new IOException("Unable to access nrrd file: " + path);
        }
        this.readHeader(fis);
        fis.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readHeader(InputStream is) throws IOException {
        try {
            String s;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(is, this.encoding));
            this.init();
            this.magic = in.readLine();
            this.appendLine(this.magic);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#")) {
                    this.appendCommment(s);
                    continue;
                }
                if (s.indexOf(":=") > -1) {
                    this.appendTag(s);
                    continue;
                }
                if (s.indexOf(": ") > -1) {
                    this.appendField(s);
                    continue;
                }
                if (s.length() == 0) {
                    this.lineSkip = in.getLineNumber();
                    return;
                }
                if (this.multiLineDataFile) {
                    this.appendLine(s);
                    this.dataFiles.add(s);
                    continue;
                }
                if (this.textNrrd) {
                    this.textData.append(s);
                    continue;
                }
                if (this.magic.startsWith("NRRD")) {
                    throw new Exception("Invalid nrrd header at line:" + in.getLineNumber());
                }
                this.textData.append(s);
                String[] floatStrings = s.split("\\s+");
                try {
                    for (int i = 0; i < floatStrings.length; ++i) {
                        float f = new Float(floatStrings[i]).floatValue();
                    }
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid nrrd text file - first uncommented line must contain floats");
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Trouble reading nrrd header: " + e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must specify a file name!");
        } else {
            NrrdHeader nh = null;
            NrrdInfo ni = null;
            for (int i = 0; i < args.length; ++i) {
                try {
                    nh = new NrrdHeader();
                    nh.readHeader(args[i]);
                    ni = new NrrdInfo(nh);
                    ni.parseHeader();
                    System.out.println("" + nh);
                    System.out.println("fields:\n" + nh.getFieldStrings() + "\n");
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Problem reading file name: " + args[i] + "\n" + e);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Problem parsing file name: " + args[i] + "\n" + e);
                    e.printStackTrace();
                }
            }
        }
    }
}

