/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Correlation;
import distance.Euclidean;
import distance.MutualInformation;
import distance.PixelPairs;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.NaiveResampler;

public class TransformedImage {
    public InterpolatedImage orig;
    public InterpolatedImage transform;
    FastMatrix fromOrig;
    private FastMatrix transformation;
    FastMatrix toTransform;
    public PixelPairs measure;
    public FastMatrix matrix;
    int imageType = -1;
    int x0;
    int y0;
    int z0;
    int x1;
    int y1;
    int z1;

    public TransformedImage(ImagePlus orig, ImagePlus transform) {
        this.orig = new InterpolatedImage(orig);
        this.transform = new InterpolatedImage(transform);
        this.fromOrig = FastMatrix.fromCalibration(orig);
        this.toTransform = FastMatrix.fromCalibration(transform).inverse();
        this.z0 = 0;
        this.y0 = 0;
        this.x0 = 0;
        this.x1 = this.orig.w;
        this.y1 = this.orig.h;
        this.z1 = this.orig.d;
        if (orig.getType() != transform.getType()) {
            throw new RuntimeException("TransformedImage needs two images of the same bit depth.");
        }
        this.imageType = orig.getType();
        switch (this.imageType) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new RuntimeException("Not yet implemented! (Bit depths != 8 or 16 in TransformedImage.)");
            }
        }
    }

    public ImagePlus getTemplate() {
        return this.orig.getImage();
    }

    public float[] getValuesRange() {
        int value;
        int i;
        Object[] pixels;
        int z;
        int origStackSize = this.orig.image.getStackSize();
        int transformStackSize = this.transform.image.getStackSize();
        ImageStack origStack = this.orig.image.getStack();
        ImageStack transformStack = this.transform.image.getStack();
        int origBitDepth = this.orig.image.getBitDepth();
        int transformBitDepth = this.transform.image.getBitDepth();
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        for (z = 0; z < origStackSize; ++z) {
            if (8 == origBitDepth) {
                pixels = (byte[])origStack.getPixels(z + 1);
                for (i = 0; i < pixels.length; ++i) {
                    value = pixels[i] & 0xFF;
                    if ((float)value > maxValue) {
                        maxValue = value;
                    }
                    if (!((float)value < minValue)) continue;
                    minValue = value;
                }
                continue;
            }
            if (16 != origBitDepth) continue;
            pixels = (short[])origStack.getPixels(z + 1);
            for (i = 0; i < pixels.length; ++i) {
                value = pixels[i];
                if ((float)value > maxValue) {
                    maxValue = value;
                }
                if (!((float)value < minValue)) continue;
                minValue = value;
            }
        }
        for (z = 0; z < transformStackSize; ++z) {
            if (8 == transformBitDepth) {
                pixels = (byte[])transformStack.getPixels(z + 1);
                for (i = 0; i < pixels.length; ++i) {
                    value = pixels[i] & 0xFF;
                    if ((float)value > maxValue) {
                        maxValue = value;
                    }
                    if (!((float)value < minValue)) continue;
                    minValue = value;
                }
                continue;
            }
            if (16 != transformBitDepth) continue;
            pixels = (short[])transformStack.getPixels(z + 1);
            for (i = 0; i < pixels.length; ++i) {
                value = pixels[i];
                if ((float)value > maxValue) {
                    maxValue = value;
                }
                if (!((float)value < minValue)) continue;
                minValue = value;
            }
        }
        float[] result = new float[]{minValue, maxValue};
        return result;
    }

    public void setTransformation(FastMatrix matrix) {
        this.transformation = matrix.inverse();
        this.matrix = this.toTransform.times(this.transformation.times(this.fromOrig));
    }

    public TransformedImage resample(int factor) {
        ImagePlus resTran;
        ImagePlus resOrig;
        if (this.measure instanceof MutualInformation) {
            resOrig = NaiveResampler.resampleMinEnt(this.orig.image, factor);
            resTran = NaiveResampler.resampleMinEnt(this.transform.image, factor);
        } else {
            resOrig = NaiveResampler.resample(this.orig.image, factor);
            resTran = NaiveResampler.resample(this.transform.image, factor);
        }
        TransformedImage res = new TransformedImage(resOrig, resTran);
        res.transformation = this.transformation;
        res.measure = this.measure;
        res.x0 = this.x0 / factor;
        res.y0 = this.y0 / factor;
        res.z0 = this.z0 / factor;
        res.x1 = (this.x1 + factor - 1) / factor;
        res.y1 = (this.y1 + factor - 1) / factor;
        res.z1 = (this.z1 + factor - 1) / factor;
        return res;
    }

    public Iterator iterator() {
        return this.iterator(false);
    }

    public Iterator iterator(boolean showProgress) {
        return this.iterator(showProgress, 0, 0, 0, this.orig.w, this.orig.h, this.orig.d);
    }

    public Iterator iterator(boolean showProgress, int x0, int y0, int z0, int x1, int y1, int z1) {
        return new Iterator(showProgress, x0, y0, z0, x1, y1, z1);
    }

    public float getDistance() {
        this.measure.reset();
        Iterator iter = new Iterator(false, this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
        while (iter.next() != null) {
            float v1 = -1.0f;
            switch (this.imageType) {
                case 0: 
                case 3: {
                    v1 = this.orig.getNoInterpol(iter.i, iter.j, iter.k);
                    break;
                }
                case 1: {
                    v1 = this.orig.getNoInterpolShort(iter.i, iter.j, iter.k);
                }
            }
            float v2 = (float)this.transform.interpol.get(iter.x, iter.y, iter.z);
            this.measure.add(v1, v2);
        }
        return this.measure.distance();
    }

    public ImagePlus getTransformed() {
        InterpolatedImage result = this.orig.cloneDimensionsOnly();
        Iterator iter = this.iterator();
        switch (this.imageType) {
            case 0: 
            case 3: {
                while (iter.next() != null) {
                    result.set(iter.i, iter.j, iter.k, this.transform.getNoInterpol((int)iter.x, (int)iter.y, (int)iter.z));
                }
                break;
            }
            case 1: {
                while (iter.next() != null) {
                    result.setShort(iter.i, iter.j, iter.k, this.transform.getNoInterpolShort((int)iter.x, (int)iter.y, (int)iter.z));
                }
                break;
            }
        }
        result.image.setTitle("transformed");
        return result.image;
    }

    public ImagePlus getDifferenceImage() {
        int typeToCreate = -1;
        switch (this.imageType) {
            case 0: 
            case 3: {
                typeToCreate = 0;
                break;
            }
            case 1: {
                typeToCreate = 1;
            }
        }
        InterpolatedImage result = InterpolatedImage.cloneDimensionsOnly(this.orig.image, typeToCreate);
        PixelPairs differenceMeasure = null;
        differenceMeasure = this.measure instanceof MutualInformation || this.measure instanceof Correlation ? new Euclidean() : this.measure;
        Iterator iter = this.iterator(false, this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
        while (iter.next() != null) {
            differenceMeasure.reset();
            switch (this.imageType) {
                case 0: 
                case 3: {
                    differenceMeasure.add(this.orig.getNoInterpol(iter.i, iter.j, iter.k), this.transform.getNoInterpol((int)iter.x, (int)iter.y, (int)iter.z));
                    break;
                }
                case 1: {
                    differenceMeasure.add(this.orig.getNoInterpolShort(iter.i, iter.j, iter.k), this.transform.getNoInterpolShort((int)iter.x, (int)iter.y, (int)iter.z));
                }
            }
            switch (typeToCreate) {
                case 0: 
                case 3: {
                    result.set(iter.i, iter.j, iter.k, (byte)differenceMeasure.distance());
                    break;
                }
                case 1: {
                    result.setShort(iter.i, iter.j, iter.k, (short)differenceMeasure.distance());
                }
            }
        }
        result.image.setTitle("difference");
        return result.image;
    }

    public void narrowBBox(int x0, int x1, int y0, int y1, int z0, int z1) {
        System.err.println("bbox: " + x0 + " " + x1 + " " + y0 + " " + y1 + " " + z0 + " " + z1);
        if (x0 < 0) {
            x0 = 0;
        } else if (x0 >= this.orig.w) {
            x0 = this.orig.w - 1;
        }
        if (y0 < 0) {
            y0 = 0;
        } else if (y0 >= this.orig.h) {
            y0 = this.orig.h - 1;
        }
        if (z0 < 0) {
            z0 = 0;
        } else if (z0 >= this.orig.d) {
            z0 = this.orig.d - 1;
        }
        if (x1 < 1) {
            x1 = 1;
        } else if (x1 > this.orig.w) {
            x1 = this.orig.w;
        }
        if (y1 < 1) {
            y1 = 1;
        } else if (y1 > this.orig.h) {
            y1 = this.orig.h;
        }
        if (z1 < 1) {
            z1 = 1;
        } else if (z1 > this.orig.d) {
            z1 = this.orig.d;
        }
        this.x0 = x0;
        this.x1 = x1;
        this.y0 = y0;
        this.y1 = y1;
        this.z0 = z0;
        this.z1 = z1;
    }

    public void narrowSearchToMaterial(int value, int border) {
        this.x0 = this.orig.w;
        this.y0 = this.orig.h;
        this.z0 = this.orig.d;
        this.z1 = 0;
        this.y1 = 0;
        this.x1 = 0;
        for (int k = 0; k < this.orig.d; ++k) {
            for (int j = 0; j < this.orig.h; ++j) {
                for (int i = 0; i < this.orig.w; ++i) {
                    int v = this.orig.getNoInterpol(i, j, k);
                    if (v != value) continue;
                    if (this.x0 > i) {
                        this.x0 = i;
                    } else if (this.x1 < i) {
                        this.x1 = i;
                    }
                    if (this.y0 > j) {
                        this.y0 = j;
                    } else if (this.y1 < j) {
                        this.y1 = j;
                    }
                    if (this.z0 > k) {
                        this.z0 = k;
                        continue;
                    }
                    if (this.z1 >= k) continue;
                    this.z1 = k;
                }
            }
        }
        this.x0 -= border;
        this.y0 -= border;
        this.z0 -= border;
        this.x1 += border + 1;
        this.y1 += border + 1;
        this.z1 += border + 1;
        if (this.x0 < 0) {
            this.x0 = 0;
        }
        if (this.y0 < 0) {
            this.y0 = 0;
        }
        if (this.z0 < 0) {
            this.z0 = 0;
        }
        if (this.x1 > this.orig.w) {
            this.x1 = this.orig.w;
        }
        if (this.y1 > this.orig.h) {
            this.y1 = this.orig.h;
        }
        if (this.z1 > this.orig.d) {
            this.z1 = this.orig.d;
        }
    }

    int getOrig(int x, int y, int z) {
        return this.orig.getNoCheck(x, y, z);
    }

    float getTransformed(double x, double y, double z) {
        this.matrix.apply(x, y, z);
        return (float)this.transform.interpol.get(this.matrix.x, this.matrix.y, this.matrix.z);
    }

    float getTransformedNoInterpol(double x, double y, double z) {
        this.matrix.apply(x, y, z);
        return this.transform.getNoInterpol((int)Math.round(this.matrix.x), (int)Math.round(this.matrix.y), (int)Math.round(this.matrix.z));
    }

    public class Iterator
    implements java.util.Iterator {
        public int i;
        public int j;
        public int k;
        public double x;
        public double y;
        public double z;
        public boolean showProgress;
        public int x0;
        public int y0;
        public int z0;
        public int x1;
        public int y1;
        public int z1;
        public int xd;
        public int zd;
        protected boolean isIdentity;
        private Point3d start;
        private Point3d stop;

        public Iterator(boolean showProgress, int x0, int y0, int z0, int x1, int y1, int z1) {
            this.showProgress = showProgress;
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.xd = x1 - x0;
            this.zd = z1 - z0;
            this.i = x1;
            this.j = y0 - 1;
            this.k = z0;
            this.isIdentity = TransformedImage.this.matrix.isIdentity();
        }

        @Override
        public boolean hasNext() {
            return this.i + 1 < this.x1 || this.j + 1 < this.y1 || this.k + 1 < this.z1;
        }

        public Object next() {
            if (++this.i >= this.x1) {
                this.i = this.x0;
                if (++this.j >= this.y1) {
                    this.j = this.y0;
                    if (++this.k >= this.z1) {
                        return null;
                    }
                    if (this.showProgress) {
                        IJ.showProgress((int)(this.k - this.z0 + 1), (int)this.zd);
                    }
                }
                if (!this.isIdentity) {
                    TransformedImage.this.matrix.apply(0.0, this.j, this.k);
                    this.start = TransformedImage.this.matrix.getResult();
                    TransformedImage.this.matrix.apply(this.x1, this.j, this.k);
                    this.stop = TransformedImage.this.matrix.getResult().minus(this.start);
                }
            }
            if (this.isIdentity) {
                this.x = this.i;
                this.y = this.j;
                this.z = this.k;
            } else {
                this.x = this.start.x + this.stop.x * (double)this.i / (double)this.x1;
                this.y = this.start.y + this.stop.y * (double)this.i / (double)this.x1;
                this.z = this.start.z + this.stop.z * (double)this.i / (double)this.x1;
            }
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

