/*
 * Decompiled with CFR 0.152.
 */
package fiji.stacks;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import java.awt.Point;

public class CompositeConverter2 {
    public ImagePlus makeComposite(ImagePlus imp) {
        if (imp.isComposite()) {
            CompositeImage ci = (CompositeImage)imp;
            if (ci.getMode() != 1) {
                ci.setMode(1);
                ci.updateAndDraw();
            }
            return imp;
        }
        int z = imp.getStackSize();
        int c = imp.getNChannels();
        if (c == 1) {
            c = z;
            imp.setDimensions(c, 1, 1);
        }
        if (imp.getBitDepth() == 24) {
            Roi roi = imp.getRoi();
            ImagePlus newImp = z > 1 ? this.convertRGBToCompositeStack(imp) : this.convertRGBToCompositeImage(imp);
            newImp.setRoi(roi);
            return newImp;
        }
        return null;
    }

    ImagePlus convertRGBToCompositeImage(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        Point loc = win != null ? win.getLocation() : null;
        CompositeImage imp2 = new CompositeImage(imp, 1);
        if (loc != null) {
            ImageWindow.setNextLocation((Point)loc);
        }
        imp2.show();
        imp.hide();
        WindowManager.setCurrentWindow((ImageWindow)imp2.getWindow());
        return imp2;
    }

    ImagePlus convertRGBToCompositeStack(ImagePlus imp) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack1 = imp.getStack();
        int n = stack1.getSize();
        ImageStack stack2 = new ImageStack(width, height);
        for (int i = 0; i < n; ++i) {
            ColorProcessor ip = (ColorProcessor)stack1.getProcessor(1);
            stack1.deleteSlice(1);
            byte[] R = new byte[width * height];
            byte[] G = new byte[width * height];
            byte[] B = new byte[width * height];
            ip.getRGB(R, G, B);
            stack2.addSlice(null, (Object)R);
            stack2.addSlice(null, (Object)G);
            stack2.addSlice(null, (Object)B);
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        Point loc = win != null ? win.getLocation() : null;
        ImagePlus imp2 = new ImagePlus(imp.getTitle(), stack2);
        imp2.setDimensions(3, (n *= 3) / 3, 1);
        int mode = 1;
        imp2 = new CompositeImage(imp2, mode);
        if (loc != null) {
            ImageWindow.setNextLocation((Point)loc);
        }
        imp2.show();
        imp.changes = false;
        imp.close();
        return imp2;
    }
}

