/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class LineArrayRetained
extends GeometryArrayRetained
implements Cloneable {
    LineArrayRetained() {
        this.geoType = 4;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[2];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int[] vtxIndexArr = new int[2];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], pickRay.origin, pickRay.direction, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d dir = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], pickSegment.start, dir, sdist, iPnt) || !(sdist[0] <= 1.0)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i < this.validVertexCount) {
                    for (int j = 0; j < 2; ++j) {
                        vtxIndexArr[j] = i;
                        this.getVertexData(i++, pnts[j]);
                    }
                    if (!this.intersectCone(pnts, pickCone, sdist, iPnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = iPnt.x;
                        y = iPnt.y;
                        z = iPnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("LineArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[2];
        double[] dist = new double[1];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        points[0] = new Point3d();
        points[1] = new Point3d();
        switch (pnts.length) {
            case 3: 
            case 4: {
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, points[0]);
                    this.getVertexData(i++, points[1]);
                    if (!this.intersectSegment(pnts, points[0], points[1], dist, null)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                Vector3d dir = new Vector3d();
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, points[0]);
                    this.getVertexData(i++, points[1]);
                    dir.x = points[1].x - points[0].x;
                    dir.y = points[1].y - points[0].y;
                    dir.z = points[1].z - points[0].z;
                    if (!this.intersectLineAndRay(pnts[0], pnts[1], points[0], dir, dist, null) || !(dist[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                Vector3d dir = new Vector3d();
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, points[0]);
                    this.getVertexData(i++, points[1]);
                    dir.x = points[1].x - points[0].x;
                    dir.y = points[1].y - points[0].y;
                    dir.z = points[1].z - points[0].z;
                    if (!this.intersectPntAndRay(pnts[0], points[0], dir, dist) || !(dist[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        Point3d[] pnts = new Point3d[2];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        while (i < this.validVertexCount) {
            this.getVertexData(i++, pnts[0]);
            this.getVertexData(i++, pnts[1]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            if (!geom.intersect(pnts)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        Point3d[] pnts = new Point3d[2];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, pnts[0]);
                    this.getVertexData(i++, pnts[1]);
                    if (!this.intersectBoundingBox(pnts, box, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, pnts[0]);
                    this.getVertexData(i++, pnts[1]);
                    if (!this.intersectBoundingSphere(pnts, bsphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i < this.validVertexCount) {
                    this.getVertexData(i++, pnts[0]);
                    this.getVertexData(i++, pnts[1]);
                    if (!this.intersectBoundingPolytope(pnts, bpolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double length;
        Point3d pnt0 = new Point3d();
        Point3d pnt1 = new Point3d();
        double totallength = 0.0;
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (i < this.validVertexCount) {
            this.getVertexData(i++, pnt0);
            this.getVertexData(i++, pnt1);
            length = pnt0.distance(pnt1);
            this.centroid.x += (pnt0.x + pnt1.x) * length;
            this.centroid.y += (pnt0.y + pnt1.y) * length;
            this.centroid.z += (pnt0.z + pnt1.z) * length;
            totallength += length;
        }
        if (totallength != 0.0) {
            length = 1.0 / (2.0 * totallength);
            this.centroid.x *= length;
            this.centroid.y *= length;
            this.centroid.z *= length;
        }
    }

    @Override
    int getClassType() {
        return 2;
    }
}

