/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.PhysicalBody;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.vecmath.Point3d;

class ViewCache {
    View view;
    int viewAttachPolicy;
    Point3d leftEyePosInHead = new Point3d();
    Point3d rightEyePosInHead = new Point3d();
    Point3d leftEarPosInHead = new Point3d();
    Point3d rightEarPosInHead = new Point3d();
    double nominalEyeHeightFromGround;
    double nominalEyeOffsetFromNominalScreen;
    Transform3D headToHeadTracker = new Transform3D();
    Transform3D coexistenceToTrackerBase = new Transform3D();
    Transform3D headTrackerToTrackerBase = new Transform3D();
    Transform3D trackerBaseToHeadTracker = new Transform3D();
    boolean trackingAvailable;
    int headIndex;
    int coexistenceCenterInPworldPolicy;
    boolean compatibilityModeEnable;
    boolean coexistenceCenteringEnable;
    Point3d leftManualEyeInCoexistence = new Point3d();
    Point3d rightManualEyeInCoexistence = new Point3d();
    int viewPolicy;
    int projectionPolicy;
    int screenScalePolicy;
    double screenScale;
    int windowResizePolicy;
    int windowMovementPolicy;
    int windowEyepointPolicy;
    int monoscopicViewPolicy;
    double fieldOfView;
    double frontClipDistance;
    double backClipDistance;
    int frontClipPolicy;
    int backClipPolicy;
    ViewPlatformRetained vpRetained;
    int visibilityPolicy;
    boolean trackingEnable;
    boolean userHeadToVworldEnable;
    Transform3D compatVpcToEc = new Transform3D();
    Transform3D compatLeftProjection = new Transform3D();
    Transform3D compatRightProjection = new Transform3D();
    int vcDirtyMask = 0;
    private boolean doHeadTracking;
    Transform3D userHeadToVworld = new Transform3D();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void snapshot() {
        PhysicalBody body;
        PhysicalEnvironment env;
        this.vcDirtyMask = this.view.vDirtyMask;
        this.view.vDirtyMask = 0;
        this.compatibilityModeEnable = this.view.compatibilityModeEnable;
        this.coexistenceCenteringEnable = this.view.coexistenceCenteringEnable;
        this.leftManualEyeInCoexistence.set(this.view.leftManualEyeInCoexistence);
        this.rightManualEyeInCoexistence.set(this.view.rightManualEyeInCoexistence);
        this.viewPolicy = this.view.viewPolicy;
        this.projectionPolicy = this.view.projectionPolicy;
        this.screenScalePolicy = this.view.screenScalePolicy;
        this.windowResizePolicy = this.view.windowResizePolicy;
        this.windowMovementPolicy = this.view.windowMovementPolicy;
        this.windowEyepointPolicy = this.view.windowEyepointPolicy;
        this.monoscopicViewPolicy = this.view.monoscopicViewPolicy;
        this.fieldOfView = this.view.fieldOfView;
        this.screenScale = this.view.screenScale;
        this.frontClipDistance = this.view.frontClipDistance;
        this.backClipDistance = this.view.backClipDistance;
        this.frontClipPolicy = this.view.frontClipPolicy;
        this.backClipPolicy = this.view.backClipPolicy;
        this.visibilityPolicy = this.view.visibilityPolicy;
        this.trackingEnable = this.view.trackingEnable;
        this.userHeadToVworldEnable = this.view.userHeadToVworldEnable;
        this.view.compatVpcToEc.getWithLock(this.compatVpcToEc);
        this.view.compatLeftProjection.getWithLock(this.compatLeftProjection);
        this.view.compatRightProjection.getWithLock(this.compatRightProjection);
        ViewPlatform vpp = this.view.getViewPlatform();
        if (vpp == null) {
            return;
        }
        ViewPlatformRetained viewPlatformRetained = this.vpRetained = (ViewPlatformRetained)vpp.retained;
        synchronized (viewPlatformRetained) {
            this.vcDirtyMask |= this.vpRetained.vprDirtyMask;
            this.vpRetained.vprDirtyMask = 0;
            this.viewAttachPolicy = this.vpRetained.viewAttachPolicy;
        }
        PhysicalEnvironment physicalEnvironment = env = this.view.getPhysicalEnvironment();
        synchronized (physicalEnvironment) {
            this.vcDirtyMask |= env.peDirtyMask;
            env.peDirtyMask = 0;
            env.coexistenceToTrackerBase.getWithLock(this.coexistenceToTrackerBase);
            this.trackingAvailable = env.trackingAvailable;
            this.coexistenceCenterInPworldPolicy = env.coexistenceCenterInPworldPolicy;
            boolean bl = this.doHeadTracking = this.trackingEnable && this.trackingAvailable;
            if (this.doHeadTracking) {
                this.headIndex = env.getHeadIndex();
                env.getSensor(this.headIndex).getRead(this.headTrackerToTrackerBase);
                this.vcDirtyMask |= 0x800;
            } else {
                this.headTrackerToTrackerBase.setIdentity();
            }
        }
        PhysicalBody physicalBody = body = this.view.getPhysicalBody();
        synchronized (physicalBody) {
            this.vcDirtyMask |= body.pbDirtyMask;
            body.pbDirtyMask = 0;
            this.leftEyePosInHead.set(body.leftEyePosition);
            this.rightEyePosInHead.set(body.rightEyePosition);
            this.leftEarPosInHead.set(body.leftEarPosition);
            this.rightEarPosInHead.set(body.rightEarPosition);
            this.nominalEyeHeightFromGround = body.nominalEyeHeightFromGround;
            this.nominalEyeOffsetFromNominalScreen = body.nominalEyeOffsetFromNominalScreen;
        }
        body.headToHeadTracker.getWithLock(this.headToHeadTracker);
    }

    synchronized void computeDerivedData() {
        if (this.doHeadTracking) {
            this.trackerBaseToHeadTracker.invert(this.headTrackerToTrackerBase);
        } else {
            this.trackerBaseToHeadTracker.setIdentity();
        }
        this.userHeadToVworld.setIdentity();
    }

    boolean getDoHeadTracking() {
        return this.doHeadTracking;
    }

    ViewCache(View view) {
        this.view = view;
    }
}

