/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.IJEventListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Text;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.ColorPicker;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Series_Labeler
implements ExtendedPlugInFilter,
DialogListener,
ImageListener {
    protected static String PREF_KEY = "Series_Labeler.";
    protected static int x = 2;
    protected static int y = 15;
    protected static Font font;
    protected static double start;
    protected static double interval;
    protected static String customSuffix;
    protected static String chosenSuffix;
    protected static int decimalPlaces;
    protected static String customFormat;
    protected static boolean antiAliasedText;
    protected static int first;
    protected static int last;
    protected static int frameMask;
    protected static boolean backgroundEnabled;
    protected static AbstractStampFormat selectedFormat;
    protected static StackType selectedStackType;
    protected static int locationPreset;
    protected ImagePlus imp;
    protected boolean canceled;
    protected boolean preview = true;
    protected boolean previewCheckState = false;
    protected int frame;
    protected int currentSlice;
    protected PlugInFilterRunner pluginFilterRunner;
    protected int flags = 2111;
    protected GenericDialog gd;
    protected static final String[] locations;
    protected static final int UPPER_RIGHT = 0;
    protected static final int LOWER_RIGHT = 1;
    protected static final int LOWER_LEFT = 2;
    protected static final int UPPER_LEFT = 3;
    protected static final int CUSTOM = 4;
    protected final AbstractStampFormat[] timeFormats = new AbstractStampFormat[]{new DecimalLabelFormat(), new DigitalLabelFormat(), new CustomLabelFormat()};
    protected final AbstractStampFormat[] zFormats = new AbstractStampFormat[]{new DecimalLabelFormat(new String[]{"pixel", "pm", "\u00c5", "nm", "um", "mm", "cm", "m", "km", "Mm", "parsec", "light year"}, "Lengths", false, false), new CustomLabelFormat()};
    protected final AbstractStampFormat[] spectralFormats = new AbstractStampFormat[]{new DecimalLabelFormat(new String[]{"Hz", "pm\u207b\u00b9", "\u00c5\u207b\u00b9", "um\u207b\u00b9", "mm\u207b\u00b9", "cm\u207b\u00b9", "m\u207b\u00b9", "km\u207b\u00b9", "Mm\u207b\u00b9", "parsec\u207b\u00b9", "light year\u207b\u00b9"}, "Frequency", false, false), new DecimalLabelFormat(new String[]{"pm", "\u00c5", "nm", "um", "mm", "cm", "m", "km", "Mm", "parsec", "light year"}, "Wavelength", false, false), new CustomLabelFormat()};
    protected final StackType[] stackTypes = new StackType[]{new TimeStackType("time series or movie", this.timeFormats, 2), new ZStackType("z-stack", this.zFormats, 1), new StackType("spectral", this.spectralFormats, 2)};
    protected Choice labelUnitsComboBox;
    protected Choice formatsComboBox;
    protected Choice locationPresetsComboBox;
    protected Panel generalSettingsContainer;
    protected Panel unitsFormattingContainer;
    protected Panel startStopIntervalsContainer;
    protected Panel locationFontContainer;
    protected Panel fontPropertiesContainer;
    protected TextField locationXTextField;
    protected TextField locationYTextField;
    protected TextField intervalTextField;
    protected TextField suffixTextField;
    protected Panel labelUnitsPanel;
    protected Panel customSuffixPanel;
    protected Panel customLabelFormatPanel;
    protected Panel decimalPlacesPanel;
    protected static boolean customIntervalEntered;
    protected static boolean customUnitSelected;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Series_Labeler.class);
        if (imp != null) {
            if (imp.isHyperStack()) {
                IJ.error((String)"Series Labeler", (String)"Sorry, but this plugin does not work with hyperstacks.");
                return 4096;
            }
            Calibration cal = imp.getCalibration();
            last = imp.getStackSize();
            interval = Math.abs(cal.frameInterval) < 1.0E-7 ? 1.0 : cal.frameInterval;
            this.setFontParams();
        }
        ImagePlus.addImageListener((ImageListener)this);
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.preview = !IJ.isMacro();
        this.pluginFilterRunner = pfr;
        int subpanelHeight = 30;
        int left = 20;
        x = (int)Prefs.get((String)(PREF_KEY + "x"), (double)2.0);
        y = (int)Prefs.get((String)(PREF_KEY + "y"), (double)15.0);
        interval = Prefs.get((String)(PREF_KEY + "interval"), (double)1.0);
        customSuffix = Prefs.get((String)(PREF_KEY + "customSuffix"), (String)"");
        chosenSuffix = Prefs.get((String)(PREF_KEY + "chosenSuffix"), (String)"s");
        decimalPlaces = (int)Prefs.get((String)(PREF_KEY + "decimalPlaces"), (double)3.0);
        customFormat = Prefs.get((String)(PREF_KEY + "customFormat"), (String)"");
        frameMask = (int)Prefs.get((String)(PREF_KEY + "frameMask"), (double)1.0);
        backgroundEnabled = Prefs.get((String)(PREF_KEY + "backgroundEnabled"), (boolean)false);
        locationPreset = (int)Prefs.get((String)(PREF_KEY + "locationPreset"), (double)4.0);
        int stackType = (int)Prefs.get((String)(PREF_KEY + "stackType"), (double)0.0);
        if (stackType < 0 || stackType > this.stackTypes.length) {
            stackType = 0;
        }
        selectedStackType = this.stackTypes[stackType];
        int format = (int)Prefs.get((String)(PREF_KEY + "format"), (double)0.0);
        if (format < 0 || format > selectedStackType.getSupportedFormats().length) {
            format = 0;
        }
        selectedFormat = selectedStackType.getSupportedFormats()[format];
        String unit = Prefs.get((String)(PREF_KEY + "unit"), (String)"s");
        int unitIndex = Arrays.asList(selectedFormat.getAllowedFormatUnits()).indexOf(unit);
        if (unitIndex < 0 || unitIndex > selectedFormat.getAllowedFormatUnits().length) {
            unitIndex = 0;
        }
        if (this.isCustomROI()) {
            locationPreset = 4;
        }
        this.currentSlice = imp.getNSlices();
        imp.setSlice(this.currentSlice);
        this.gd = new NonBlockingGenericDialog("Series Labeler");
        this.generalSettingsContainer = this.createContainerPanel(70, "General Settings");
        String[] stacks = this.convertStackTypesToStrings(this.stackTypes);
        Panel stackTypePanel = this.createComboBoxPanel("Stack_Type", stacks, stackType, 100, 180);
        stackTypePanel.setLocation(left, 30);
        this.addPanelsToDialog(this.generalSettingsContainer, new Panel[]{stackTypePanel});
        this.unitsFormattingContainer = this.createContainerPanel(100, "Units Formatting");
        Panel pLabelFormat = this.createComboBoxPanel("Label_Format", this.convertFormatsToStrings(selectedStackType.getSupportedFormats()), format);
        this.formatsComboBox = (Choice)this.gd.getChoices().lastElement();
        pLabelFormat.setLocation(left, 30);
        this.labelUnitsPanel = this.createComboBoxPanel("Label_Unit", selectedFormat.getAllowedFormatUnits(), unitIndex);
        this.labelUnitsComboBox = (Choice)this.gd.getChoices().lastElement();
        this.labelUnitsPanel.setLocation(left, 60);
        this.customSuffixPanel = this.createTextFieldPanel("Custom_Suffix", customSuffix);
        this.suffixTextField = (TextField)this.gd.getStringFields().lastElement();
        this.customSuffixPanel.setLocation(left, 60);
        this.customLabelFormatPanel = this.createTextFieldPanel("Custom_Format", customFormat);
        this.customLabelFormatPanel.setLocation(280, 30);
        this.decimalPlacesPanel = this.createNumericFieldPanel("Decimal_Places", decimalPlaces, 0);
        this.decimalPlacesPanel.setLocation(280, 30);
        this.addPanelsToDialog(this.unitsFormattingContainer, new Panel[]{pLabelFormat, this.customSuffixPanel, this.labelUnitsPanel, this.decimalPlacesPanel, this.customLabelFormatPanel});
        this.startStopIntervalsContainer = this.createContainerPanel(130, "Start/Stop/Interval of Stack");
        Panel pStartup = this.createNumericFieldPanel("Startup", start, 10);
        pStartup.setLocation(left, 30);
        Panel pInterval = this.createNumericFieldPanel("Interval", interval, 10);
        this.intervalTextField = (TextField)this.gd.getNumericFields().lastElement();
        pInterval.setLocation(left, 60);
        Panel pEveryNth = this.createNumericFieldPanel("Every_n-th", frameMask, 0);
        pEveryNth.setLocation(left, 90);
        Panel pFirstFrame = this.createNumericFieldPanel("First", first, 0);
        pFirstFrame.setLocation(280, 30);
        Panel pLastFrame = this.createNumericFieldPanel("Last", last, 0);
        pLastFrame.setLocation(280, 60);
        this.addPanelsToDialog(this.startStopIntervalsContainer, new Panel[]{pStartup, pInterval, pEveryNth, pFirstFrame, pLastFrame});
        this.locationFontContainer = this.createContainerPanel(110, "Location & Font");
        Panel pLocationX = this.createNumericFieldPanel("X_", x, 0, 20, 50);
        this.locationXTextField = (TextField)this.gd.getNumericFields().lastElement();
        pLocationX.setLocation(left, 30);
        Panel pLocationY = this.createNumericFieldPanel("Y_", y, 0, 20, 50);
        this.locationYTextField = (TextField)this.gd.getNumericFields().lastElement();
        pLocationY.setLocation(120, 30);
        Panel pLocationPresets = this.createComboBoxPanel("Location_Presets", locations, locationPreset, 110, 130);
        this.locationPresetsComboBox = (Choice)this.gd.getChoices().lastElement();
        pLocationPresets.setLocation(240, 30);
        this.fontPropertiesContainer = new FontPropertiesPanel(backgroundEnabled);
        this.fontPropertiesContainer.setBounds(left, 70, 400, subpanelHeight);
        this.addPanelsToDialog(this.locationFontContainer, new Panel[]{pLocationX, pLocationY, pLocationPresets, this.fontPropertiesContainer});
        Panel previewAndMessage = this.createContainerPanel(35, "", false);
        this.gd.addPreviewCheckbox(pfr);
        Checkbox thePreviewCheckbox = this.gd.getPreviewCheckbox();
        this.gd.remove((Component)thePreviewCheckbox);
        previewAndMessage.add(thePreviewCheckbox);
        thePreviewCheckbox.setBounds(10, 0, 80, 20);
        Component theMessage = this.createMessage("Series Labeler for Fiji (is just ImageJ - batteries included)\nmaintained by Dan White MPI-CBG dan(at)chalkie.org.uk");
        theMessage.setBounds(95, 0, 420, 35);
        previewAndMessage.add(theMessage);
        this.addPanelIntoDialog(previewAndMessage);
        if (format != selectedStackType.getCustomFormatIndex()) {
            this.bringMetaDataUnitToGUI();
        }
        this.gd.addDialogListener((DialogListener)this);
        IJ.addEventListener((IJEventListener)new IJEventListener(){

            public void eventOccurred(int event) {
                if (event == 0 || event == 1) {
                    Series_Labeler.this.updatePreview();
                }
            }
        });
        this.gd.addHelp("http://fiji.sc/wiki/index.php/Series_Labeler");
        if (!IJ.isMacro()) {
            this.updateUI();
        }
        this.gd.showDialog();
        ImagePlus.removeImageListener((ImageListener)this);
        if (this.gd.wasCanceled()) {
            imp.setOverlay(null);
            return 4096;
        }
        Prefs.set((String)(PREF_KEY + "x"), (int)x);
        Prefs.set((String)(PREF_KEY + "y"), (int)y);
        Prefs.set((String)(PREF_KEY + "interval"), (double)interval);
        Prefs.set((String)(PREF_KEY + "customSuffix"), (String)customSuffix);
        Prefs.set((String)(PREF_KEY + "chosenSuffix"), (String)chosenSuffix);
        Prefs.set((String)(PREF_KEY + "decimalPlaces"), (int)decimalPlaces);
        Prefs.set((String)(PREF_KEY + "customFormat"), (String)customFormat);
        Prefs.set((String)(PREF_KEY + "unit"), (String)chosenSuffix);
        Prefs.set((String)(PREF_KEY + "frameMask"), (int)frameMask);
        Prefs.set((String)(PREF_KEY + "backgroundEnabled"), (boolean)backgroundEnabled);
        Prefs.set((String)(PREF_KEY + "locationPreset"), (int)locationPreset);
        int stackTypeIndex = Arrays.asList(this.stackTypes).indexOf(selectedStackType);
        Prefs.set((String)(PREF_KEY + "stackType"), (int)stackTypeIndex);
        int formatIndex = Arrays.asList(selectedStackType.getSupportedFormats()).indexOf(selectedFormat);
        Prefs.set((String)(PREF_KEY + "format"), (int)formatIndex);
        this.preview = !this.gd.wasOKed();
        return this.flags;
    }

    public void setNPasses(int nPasses) {
        this.frame = this.preview ? this.imp.getCurrentSlice() : 1;
        --this.frame;
    }

    public void run(ImageProcessor ip) {
        ++this.frame;
        if (this.frame == last) {
            this.imp.updateAndDraw();
        }
        if (!this.preview && (this.canceled || this.frame < first || this.frame > last || this.frame % frameMask != 0)) {
            return;
        }
        ip.setFont(font);
        ip.setAntialiasedText(antiAliasedText);
        double labelValue = this.getLabelValue(this.frame);
        Rectangle backgroundRectangle = this.getBoundingRectangle(ip);
        if (this.preview) {
            Object labelIP = this.imp.getType() == 4 ? new ColorProcessor(backgroundRectangle.width, backgroundRectangle.height) : new FloatProcessor(backgroundRectangle.width, backgroundRectangle.height);
            labelIP.setFont(font);
            labelIP.setAntialiasedText(antiAliasedText);
            labelIP.moveTo(0, backgroundRectangle.height);
            if (backgroundEnabled) {
                labelIP.setColor(Toolbar.getBackgroundColor());
                labelIP.fill(new Roi(new Rectangle(0, 0, backgroundRectangle.width, backgroundRectangle.height)));
            }
            labelIP.setColor(Toolbar.getForegroundColor());
            labelIP.drawString(selectedFormat.getLabelString(labelValue));
            ImageRoi imageRoi = new ImageRoi(backgroundRectangle.x, backgroundRectangle.y, (ImageProcessor)labelIP);
            Overlay overlay = new Overlay((Roi)imageRoi);
            this.imp.setOverlay(overlay);
        } else {
            if (backgroundEnabled) {
                ip.setColor(Toolbar.getBackgroundColor());
                ip.fill(new Roi(backgroundRectangle));
            }
            ip.setColor(Toolbar.getForegroundColor());
            ip.moveTo(backgroundRectangle.x, backgroundRectangle.y + backgroundRectangle.height);
            ip.drawString(selectedFormat.getLabelString(labelValue));
            this.imp.setOverlay(null);
        }
    }

    protected Panel createContainerPanel(int height, String label, boolean border) {
        Panel panel = border ? new BorderPanel(label, null) : new Panel(null);
        panel.setPreferredSize(new Dimension(490, height));
        return panel;
    }

    protected Panel createContainerPanel(int height, String label) {
        return this.createContainerPanel(height, label, true);
    }

    protected Panel createComboBoxPanel(String labelText, String[] values, int defaultIndex) {
        return this.createComboBoxPanel(labelText, values, defaultIndex, 100, 150);
    }

    protected Panel createComboBoxPanel(String labelText, String[] values, int defaultIndex, int labelWidth, int comboboxWidth) {
        this.gd.addChoice(labelText, values, values[defaultIndex]);
        Choice choice = (Choice)this.gd.getChoices().lastElement();
        Label label = (Label)this.gd.getComponent(this.gd.getComponentCount() - 2);
        this.gd.remove((Component)choice);
        this.gd.remove((Component)label);
        Panel panel = new Panel(null);
        label.setBounds(0, 0, labelWidth, 20);
        choice.setBounds(labelWidth, 0, comboboxWidth, 22);
        panel.add(label);
        panel.add(choice);
        panel.setSize(labelWidth + comboboxWidth, 30);
        return panel;
    }

    protected Component createMessage(String labelText) {
        this.gd.addMessage(labelText);
        Component component = this.gd.getMessage();
        this.gd.remove(component);
        return component;
    }

    protected Panel createTextFieldPanel(String labelText, String defaultText) {
        return this.createTextFieldPanel(labelText, defaultText, 100, 100);
    }

    protected Panel createTextFieldPanel(String labelText, String defaultText, int labelWidth, int textFieldWidth) {
        this.gd.addStringField(labelText, defaultText);
        TextField textField = (TextField)this.gd.getStringFields().lastElement();
        Label label = (Label)this.gd.getComponent(this.gd.getComponentCount() - 2);
        this.gd.remove((Component)textField);
        this.gd.remove((Component)label);
        Panel panel = new Panel(null);
        label.setBounds(0, 0, labelWidth, 20);
        textField.setBounds(labelWidth, 0, textFieldWidth, 22);
        panel.add(label);
        panel.add(textField);
        panel.setSize(labelWidth + textFieldWidth, 30);
        return panel;
    }

    protected Panel createNumericFieldPanel(String labelText, double defaultValue, int digits) {
        return this.createNumericFieldPanel(labelText, defaultValue, digits, 100, 100);
    }

    protected Panel createNumericFieldPanel(String labelText, double defaultValue, int digits, int labelWidth, int textFieldWidth) {
        this.gd.addNumericField(labelText, defaultValue, digits);
        TextField textField = (TextField)this.gd.getNumericFields().lastElement();
        Label label = (Label)this.gd.getComponent(this.gd.getComponentCount() - 2);
        this.gd.remove((Component)textField);
        this.gd.remove((Component)label);
        Panel panel = new Panel(null);
        label.setBounds(0, 0, labelWidth, 20);
        textField.setBounds(labelWidth, 0, textFieldWidth, 22);
        panel.add(label);
        panel.add(textField);
        panel.setSize(labelWidth + textFieldWidth, 30);
        return panel;
    }

    protected void selectCustomFormat() {
        int customFormat = selectedStackType.getCustomFormatIndex();
        this.formatsComboBox.select(customFormat);
        selectedFormat = selectedStackType.getSupportedFormats()[customFormat];
    }

    protected void addPanelsToDialog(Panel container, Panel[] panels) {
        for (Panel p : panels) {
            container.add(p);
        }
        this.addPanelIntoDialog(container);
    }

    protected void addPanelIntoDialog(Panel container) {
        this.gd.addPanel(container, 10, new Insets(5, 0, 0, 0));
    }

    protected void updatePreview() {
        if (this.gd != null && this.preview) {
            this.pluginFilterRunner.dialogItemChanged(this.gd, null);
        }
    }

    protected void updateUI() {
        boolean supportsCustomSuffix = selectedFormat.supportsCustomSuffix();
        this.customSuffixPanel.setVisible(supportsCustomSuffix);
        this.labelUnitsPanel.setVisible(!supportsCustomSuffix);
        this.customLabelFormatPanel.setVisible(selectedFormat.supportsCustomFormat());
        this.decimalPlacesPanel.setVisible(selectedFormat.supportsDecimalPlaces());
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        boolean selectedFormatChanged;
        boolean stackTypeChanged;
        int currentType = gd.getNextChoiceIndex();
        StackType st = this.stackTypes[currentType];
        boolean bl = stackTypeChanged = st != selectedStackType;
        if (stackTypeChanged) {
            selectedStackType = st;
            this.formatsComboBox.removeAll();
            for (AbstractStampFormat abstractStampFormat : st.getSupportedFormats()) {
                this.formatsComboBox.addItem(abstractStampFormat.getName());
            }
            this.formatsComboBox.select(0);
            if (!customIntervalEntered) {
                if (selectedStackType == this.stackTypes[0]) {
                    interval = this.imp.getCalibration().frameInterval;
                    interval = Math.abs(interval) < 1.0E-7 ? 1.0 : interval;
                    this.intervalTextField.setText(IJ.d2s((double)interval, (int)10));
                } else if (selectedStackType == this.stackTypes[1]) {
                    interval = this.imp.getCalibration().pixelDepth;
                    interval = Math.abs(interval) < 1.0E-7 ? 1.0 : interval;
                    this.intervalTextField.setText(IJ.d2s((double)interval, (int)10));
                } else if (selectedStackType == this.stackTypes[2]) {
                    interval = 1.0;
                    this.intervalTextField.setText(IJ.d2s((double)interval, (int)10));
                }
            }
        }
        int currentFormat = gd.getNextChoiceIndex();
        AbstractStampFormat lf = selectedStackType.getSupportedFormats()[currentFormat];
        boolean bl2 = selectedFormatChanged = lf != selectedFormat;
        if (selectedFormatChanged) {
            selectedFormat = lf;
            this.labelUnitsComboBox.removeAll();
            for (String unit : selectedFormat.getAllowedFormatUnits()) {
                this.labelUnitsComboBox.addItem(unit);
            }
            if (!stackTypeChanged) {
                customUnitSelected = true;
            }
        }
        customSuffix = gd.getNextString();
        customFormat = gd.getNextString();
        String string = gd.getNextChoice();
        if (!string.equals(chosenSuffix)) {
            chosenSuffix = string;
            if (!stackTypeChanged) {
                customUnitSelected = true;
            }
        }
        if (selectedFormatChanged && !customUnitSelected) {
            this.bringMetaDataUnitToGUI();
        }
        decimalPlaces = (int)gd.getNextNumber();
        start = gd.getNextNumber();
        double currentIntervalInGui = gd.getNextNumber();
        if (Math.abs(currentIntervalInGui - interval) > 1.0E-6) {
            customIntervalEntered = true;
            interval = currentIntervalInGui;
        }
        frameMask = (int)gd.getNextNumber();
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        int preset = gd.getNextChoiceIndex();
        if (preset != locationPreset) {
            locationPreset = preset;
            Point p = this.getPresetPosition(preset);
            this.locationXTextField.setText(Integer.toString(p.x));
            this.locationYTextField.setText(Integer.toString(p.y));
        }
        try {
            int curX = (int)gd.getNextNumber();
            if (curX != x) {
                x = curX;
                this.locationPresetsComboBox.select(4);
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            int curY = (int)gd.getNextNumber();
            if (curY != y) {
                y = curY;
                this.locationPresetsComboBox.select(4);
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        boolean currestPreviewState = gd.getPreviewCheckbox().getState();
        if (currestPreviewState != this.previewCheckState) {
            this.previewCheckState = currestPreviewState;
            if (!currestPreviewState) {
                this.imp.setOverlay(null);
            }
        }
        this.updateUI();
        return true;
    }

    public void imageClosed(ImagePlus imp) {
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageUpdated(ImagePlus imp) {
        int slice = imp.getCurrentSlice();
        if (slice != this.currentSlice) {
            this.currentSlice = slice;
            if (this.previewCheckState) {
                this.updatePreview();
            }
        }
    }

    void bringMetaDataUnitToGUI() {
        String unitFromMetaData = selectedStackType.getStackMetaDataUnit(this.imp);
        int unitIndex = Arrays.asList(selectedFormat.getAllowedFormatUnits()).indexOf(unitFromMetaData);
        if (unitIndex != -1) {
            chosenSuffix = unitFromMetaData;
            this.labelUnitsComboBox.select(unitIndex);
        } else {
            chosenSuffix = selectedFormat.getAllowedFormatUnits()[0];
            this.labelUnitsComboBox.select(0);
            customSuffix = unitFromMetaData;
            this.suffixTextField.setText(unitFromMetaData);
            this.selectCustomFormat();
        }
    }

    protected String[] convertFormatsToStrings(AbstractStampFormat[] formats) {
        String[] formatArray = new String[formats.length];
        int i = 0;
        for (AbstractStampFormat t : formats) {
            formatArray[i] = t.getName();
            ++i;
        }
        return formatArray;
    }

    protected String[] convertStackTypesToStrings(StackType[] types) {
        String[] typeArray = new String[types.length];
        int i = 0;
        for (StackType t : types) {
            typeArray[i] = t.getName();
            ++i;
        }
        return typeArray;
    }

    boolean isCustomROI() {
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return false;
        }
        Rectangle theROI = roi.getBounds();
        return theROI.height != this.imp.getHeight() || theROI.width != this.imp.getWidth();
    }

    void setFontParams() {
        int size = TextRoi.getSize();
        if (this.isCustomROI()) {
            Roi roi = this.imp.getRoi();
            Rectangle theROI = roi.getBounds();
            x = theROI.x;
            y = theROI.y;
            size = theROI.height;
            if (size < 8) {
                size = 8;
            } else if (size > 72) {
                size = 72;
            }
        }
        font = new Font(TextRoi.getFont(), TextRoi.getStyle(), size);
    }

    Rectangle getBoundingRectangle(ImageProcessor ip) {
        Rectangle roi = ip.getRoi();
        if (roi.width == this.imp.getWidth() && roi.height == this.imp.getHeight()) {
            roi.x = x;
            roi.y = y;
            roi.height = font.getSize();
        }
        if (roi.y + roi.height < font.getSize()) {
            roi.y = 1;
            y = 1;
        }
        if (ip.getHeight() < roi.y + font.getSize()) {
            y = roi.y = ip.getHeight() - font.getSize();
        }
        roi.width = ip.getStringWidth(selectedFormat.lastLabelString());
        if (roi.width > ip.getWidth() - roi.x) {
            x = roi.x = ip.getWidth() - roi.width;
        }
        return roi;
    }

    Point getPresetPosition(int preset) {
        ImageProcessor ip = this.imp.getProcessor();
        if (preset == 3) {
            x = 0;
            y = 0;
        } else if (preset == 0) {
            x = ip.getWidth();
            y = 0;
        } else if (preset == 2) {
            x = 0;
            y = ip.getHeight();
        } else if (preset == 1) {
            x = ip.getWidth();
            y = ip.getHeight();
        } else {
            return new Point(x, y);
        }
        Rectangle rect = this.getBoundingRectangle(ip);
        return new Point(rect.x, rect.y);
    }

    double lastFrameValue() {
        return this.getLabelValue(last);
    }

    double getLabelValue(int frame) {
        return start + interval * (double)(frame - 1);
    }

    static {
        start = 0.0;
        interval = 1.0;
        customSuffix = "";
        chosenSuffix = "s";
        decimalPlaces = 3;
        customFormat = "";
        antiAliasedText = true;
        frameMask = 1;
        backgroundEnabled = false;
        locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "Custom"};
    }

    protected class ExtendedFonts
    extends Text {
        protected ExtendedFonts() {
        }

        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            boolean result = super.dialogItemChanged(gd, e);
            font = new Font(TextRoi.getFont(), TextRoi.getStyle(), TextRoi.getSize());
            antiAliasedText = TextRoi.isAntialiased();
            Series_Labeler.this.updatePreview();
            return result;
        }
    }

    protected class FontPropertiesPanel
    extends Panel {
        public FontPropertiesPanel(boolean background) {
            super(null);
            Button fontStyleButton = new Button("Font Settings");
            fontStyleButton.setBounds(0, 0, 120, 25);
            fontStyleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new Thread(){

                        @Override
                        public void run() {
                            new ExtendedFonts().run("");
                        }
                    }.start();
                }
            });
            Button fontColourButton = new Button("Font Color");
            fontColourButton.setBounds(130, 0, 120, 25);
            fontColourButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new ColorPicker();
                }
            });
            final Checkbox drawBackground = new Checkbox("Background");
            drawBackground.setBounds(260, 0, 120, 25);
            drawBackground.setState(background);
            drawBackground.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    backgroundEnabled = drawBackground.getState();
                    Series_Labeler.this.updatePreview();
                }
            });
            this.add(fontStyleButton);
            this.add(fontColourButton);
            this.add(drawBackground);
        }
    }

    protected class CustomLabelFormat
    extends DecimalLabelFormat {
        public CustomLabelFormat() {
            this(new String[]{"Custom Suffix"}, "Custom Format");
        }

        protected CustomLabelFormat(String[] allowedFormatUnits, String name) {
            super(allowedFormatUnits, name, true, false);
        }

        @Override
        public String suffix() {
            return customSuffix;
        }
    }

    protected class DigitalLabelFormat
    extends AbstractStampFormat {
        TimeZone tz;
        Calendar calendar;

        public DigitalLabelFormat() {
            this(new String[]{"min", "s", "ms"}, "Digital");
        }

        public DigitalLabelFormat(String[] allowedFormatUnits, String name) {
            super(allowedFormatUnits, name, false, true, false);
            this.tz = TimeZone.getTimeZone("UTC");
            this.calendar = new GregorianCalendar();
        }

        @Override
        public String getLabelString(double labelValue) {
            this.calendar.setTimeInMillis(0L);
            if (chosenSuffix.equals("min")) {
                labelValue *= 60000.0;
            } else if (chosenSuffix.equals("s")) {
                labelValue *= 1000.0;
            } else if (!chosenSuffix.equals("ms")) {
                IJ.error((String)"For a digital 00:00:00.000 time you must use min, s or ms only as the time units.");
            }
            this.calendar.setTimeInMillis(Math.round(labelValue));
            try {
                DateFormat f = customFormat.length() > 0 ? new HybridDateFormat(customFormat) : new SimpleDateFormat("HH:mm:ss.SSS");
                f.setTimeZone(this.tz);
                return f.format(this.calendar.getTime());
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
        }
    }

    protected class DecimalLabelFormat
    extends AbstractStampFormat {
        public DecimalLabelFormat() {
            this(new String[]{"y", "w", "d", "h", "m", "min", "s", "ms", "us", "ns", "ps", "fs", "as"}, "Decimal");
        }

        public DecimalLabelFormat(String[] allowedFormatUnits, String name) {
            this(allowedFormatUnits, name, false, false);
        }

        protected DecimalLabelFormat(String[] allowedFormatUnits, String name, boolean supportCustomSuffix, boolean supportCustomFormat) {
            super(allowedFormatUnits, name, supportCustomSuffix, supportCustomFormat, true);
        }

        @Override
        public String getLabelString(double labelValue) {
            if (interval == 0.0) {
                return this.suffix();
            }
            return (decimalPlaces == 0 ? "" + (int)labelValue : IJ.d2s((double)labelValue, (int)decimalPlaces)) + " " + this.suffix();
        }
    }

    protected abstract class AbstractStampFormat {
        String[] allowedFormatUnits;
        String name;
        boolean customSuffixSupported;
        boolean customFormatSupported;
        boolean decimalPlacesSupported;

        public AbstractStampFormat(String[] allowedFormatUnits, String name, boolean supportCustomSuffix, boolean supportCustomFormat, boolean supportDecimalPlaces) {
            this.allowedFormatUnits = allowedFormatUnits;
            this.name = name;
            this.customSuffixSupported = supportCustomSuffix;
            this.customFormatSupported = supportCustomFormat;
            this.decimalPlacesSupported = supportDecimalPlaces;
        }

        public abstract String getLabelString(double var1);

        public String lastLabelString() {
            return this.getLabelString(Series_Labeler.this.lastFrameValue());
        }

        public String suffix() {
            return chosenSuffix;
        }

        public String[] getAllowedFormatUnits() {
            return this.allowedFormatUnits;
        }

        public String getName() {
            return this.name;
        }

        public boolean supportsCustomSuffix() {
            return this.customSuffixSupported;
        }

        public boolean supportsCustomFormat() {
            return this.customFormatSupported;
        }

        public boolean supportsDecimalPlaces() {
            return this.decimalPlacesSupported;
        }
    }

    protected class ZStackType
    extends StackType {
        public ZStackType(String name, AbstractStampFormat[] formats, int indexOfCustomFormat) {
            super(name, formats, indexOfCustomFormat);
        }

        @Override
        public String getStackMetaDataUnit(ImagePlus imp) {
            return imp.getCalibration().getUnit();
        }
    }

    protected class TimeStackType
    extends StackType {
        public TimeStackType(String name, AbstractStampFormat[] formats, int indexOfCustomFormat) {
            super(name, formats, indexOfCustomFormat);
        }

        @Override
        public String getStackMetaDataUnit(ImagePlus imp) {
            return imp.getCalibration().getTimeUnit();
        }
    }

    protected class StackType {
        String name;
        AbstractStampFormat[] supportedFormats;
        int customFormatIndex;

        public StackType(String name, AbstractStampFormat[] formats, int indexOfCustomFormat) {
            this.name = name;
            this.supportedFormats = formats;
            this.customFormatIndex = indexOfCustomFormat;
        }

        public String getName() {
            return this.name;
        }

        public AbstractStampFormat[] getSupportedFormats() {
            return this.supportedFormats;
        }

        public int getCustomFormatIndex() {
            return this.customFormatIndex;
        }

        public String getStackMetaDataUnit(ImagePlus imp) {
            return "";
        }
    }
}

