/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.View;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.view.TransformBuilder;
import net.imglib2.view.iteration.IterableTransformBuilder;

public class IntervalView<T>
extends AbstractInterval
implements RandomAccessibleInterval<T>,
View {
    protected final RandomAccessible<T> source;
    protected RandomAccessible<T> fullViewRandomAccessible;
    protected IterableInterval<T> fullViewIterableInterval;

    public IntervalView(RandomAccessible<T> source, Interval interval) {
        super(interval);
        assert (source.numDimensions() == interval.numDimensions());
        this.source = source;
        this.fullViewRandomAccessible = null;
    }

    public IntervalView(RandomAccessible<T> source, long[] min, long[] max) {
        this(source, FinalInterval.wrap(min, max));
    }

    public RandomAccessible<T> getSource() {
        return this.source;
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return TransformBuilder.getEfficientRandomAccessible(interval, this).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        if (this.fullViewRandomAccessible == null) {
            this.fullViewRandomAccessible = TransformBuilder.getEfficientRandomAccessible(this, this);
        }
        return this.fullViewRandomAccessible.randomAccess();
    }

    protected IterableInterval<T> getFullViewIterableInterval() {
        if (this.fullViewIterableInterval == null) {
            this.fullViewIterableInterval = IterableTransformBuilder.getEfficientIterableInterval(this, this);
        }
        return this.fullViewIterableInterval;
    }

    @Override
    public long size() {
        return this.getFullViewIterableInterval().size();
    }

    @Override
    public T firstElement() {
        return this.getFullViewIterableInterval().firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.getFullViewIterableInterval().iterationOrder();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getFullViewIterableInterval().iterator();
    }

    @Override
    public Cursor<T> cursor() {
        return this.getFullViewIterableInterval().cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.getFullViewIterableInterval().localizingCursor();
    }

    @Override
    public LocalizableSpliterator<T> spliterator() {
        return this.getFullViewIterableInterval().spliterator();
    }

    @Override
    public LocalizableSpliterator<T> localizingSpliterator() {
        return this.getFullViewIterableInterval().localizingSpliterator();
    }

    @Override
    public T getType() {
        return this.source.getType();
    }
}

