/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.stack;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.stack.Mapping;

public abstract class AbstractTransformMapping<T>
implements Mapping<T> {
    protected float z = 0.0f;
    protected final T transform;

    @Override
    public final T getTransform() {
        return this.transform;
    }

    public AbstractTransformMapping(T t) {
        this.transform = t;
    }

    protected static Interpolator pickInterpolator(ImageProcessor slice) {
        Interpolator interpolator = ByteProcessor.class.isInstance(slice) ? new ByteInterpolator() : (ShortProcessor.class.isInstance(slice) ? new ShortInterpolator() : (FloatProcessor.class.isInstance(slice) ? new FloatInterpolator() : (ColorProcessor.class.isInstance(slice) ? new RGBInterpolator() : null)));
        return interpolator;
    }

    @Override
    public void setSlice(float z) {
        this.z = z;
    }

    public static class RGBInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, double da) {
            double fra = a >> 16 & 0xFF;
            double frb = b >> 16 & 0xFF;
            double fga = a >> 8 & 0xFF;
            double fgb = b >> 8 & 0xFF;
            double fba = a & 0xFF;
            double fbb = b & 0xFF;
            double fr = RGBInterpolator.interpolate(fra, frb, da);
            double fg = RGBInterpolator.interpolate(fga, fgb, da);
            double fb = RGBInterpolator.interpolate(fba, fbb, da);
            return (int)Math.round(fr) << 16 | (int)(Math.round(fg) << 8) | (int)Math.round(fb);
        }
    }

    public static class FloatInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, double da) {
            double fa = Float.intBitsToFloat(a);
            double fb = Float.intBitsToFloat(b);
            return Float.floatToIntBits((float)FloatInterpolator.interpolate(fa, fb, da));
        }
    }

    public static class ShortInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, double da) {
            double fa = a & 0xFFFF;
            double fb = b & 0xFFFF;
            return (int)Math.round(ShortInterpolator.interpolate(fa, fb, da));
        }
    }

    public static class ByteInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, double da) {
            double fa = a & 0xFF;
            double fb = b & 0xFF;
            return (int)Math.round(ByteInterpolator.interpolate(fa, fb, da));
        }
    }

    public static abstract class Interpolator {
        public abstract int interpolate(int var1, int var2, double var3);

        protected static final float interpolate(float a, float b, float da) {
            return da * (b - a) + a;
        }

        protected static final double interpolate(double a, double b, double da) {
            return da * (b - a) + a;
        }
    }
}

