/*
 * Decompiled with CFR 0.152.
 */
public class ColorKLT {
    double[] mean = new double[this.kltLength];
    private int kltLength = 3;
    KLT klt;

    public ColorKLT(double[][] p) {
        this.klt = new KLT(KLT.normalize(p, this.mean));
    }

    public ColorKLT(int[] pixels) {
        double[][] p = this.pixels2double(pixels);
        this.klt = new KLT(KLT.normalize(p, this.mean));
    }

    private double[][] pixels2double(int[] pixels) {
        int length = pixels.length;
        double[][] p = new double[length][3];
        for (int i = 0; i < length; ++i) {
            int c = pixels[i];
            double[] pp = p[i];
            pp[0] = (c & 0xFF0000) >> 16;
            pp[1] = (c & 0xFF00) >> 8;
            pp[2] = c & 0xFF;
        }
        return p;
    }

    private final double[] einheitsVektor(int i) {
        double[] out = new double[this.kltLength];
        out[i] = this.mean[i];
        return out;
    }

    public double[][] getEigenVectors() {
        double[][] evecs = new double[this.kltLength][this.kltLength];
        for (int i = 0; i < this.kltLength; ++i) {
            evecs[i] = KLT.denormal(this.klt.inverseTransform(this.einheitsVektor(i)), this.mean);
        }
        return evecs;
    }

    public double[][] standardToKlt(double[][] p) {
        return this.transform(p, false, null);
    }

    public double[][] standardToKlt(int[] pixels) {
        double[][] p = this.pixels2double(pixels);
        return this.transform(p, false, null);
    }

    private double[][] transform(double[][] in, boolean inverse, double[] weights) {
        int numberOfVectors = in.length;
        double[][] out = new double[numberOfVectors][this.kltLength];
        if (!inverse) {
            this.klt.transform(in, out, this.mean);
        } else if (weights == null) {
            this.klt.inverseTransform(in, out, this.mean);
        } else {
            this.klt.inverseTransform(in, out, this.mean, weights);
        }
        return out;
    }

    public double[][] kltToStandard(double[][] p) {
        return this.transform(p, true, null);
    }

    public double[][] kltToStandard(double[][] p, double[] weights) {
        return this.transform(p, true, weights);
    }
}

