/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.janelia.saalfeldlab.n5.N5Reader;

@Deprecated
public class N5DatasetSelectorDialog {
    public final N5Reader n5;
    public final String root;
    public BiPredicate<N5Reader, String> isMultiscale;
    public List<String> selectedDatasets;
    public List<ActionListener> listenerList;
    public static final String sep = File.separator;

    public N5DatasetSelectorDialog(N5Reader n5, String root) {
        this.n5 = n5;
        this.root = root;
        this.listenerList = new ArrayList<ActionListener>();
    }

    public N5DatasetSelectorDialog(N5Reader n5) {
        this(n5, "");
    }

    public JFrame showAsTree() {
        DefaultMutableTreeNode root;
        try {
            root = this.datasetTree();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        final JFrame frame = new JFrame("Choose N5 datasets");
        JPanel panel = new JPanel(new BorderLayout());
        final JTree tree = new JTree(root);
        JScrollPane treeView = new JScrollPane(tree);
        panel.add((Component)treeView, "Center");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath[] selectedPaths;
                N5DatasetSelectorDialog.this.selectedDatasets = new ArrayList<String>();
                for (TreePath path : selectedPaths = tree.getSelectionPaths()) {
                    StringBuffer pathString = new StringBuffer();
                    for (Object o : path.getPath()) {
                        pathString.append("/");
                        pathString.append(o.toString());
                    }
                    N5DatasetSelectorDialog.this.selectedDatasets.add(pathString.toString());
                }
                frame.setVisible(false);
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        panel.add((Component)buttonPanel, "South");
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public List<String> getSelectedDatasets() {
        return this.selectedDatasets;
    }

    public DefaultMutableTreeNode datasetTree() throws IOException {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.root);
        this.datasetTreeRecursive(rootNode, this.root, this.n5.list(this.root));
        return rootNode;
    }

    private void datasetTreeRecursive(DefaultMutableTreeNode baseNode, String path, String ... bases) throws IOException {
        for (String s : bases) {
            String fullPath = path.equals(sep) ? path + s : path + sep + s;
            if (!this.n5.exists(fullPath)) continue;
            if (this.n5.datasetExists(fullPath)) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(s);
                baseNode.add(childNode);
                continue;
            }
            String suffix = "";
            if (this.isMultiscale != null && this.isMultiscale.test(this.n5, fullPath)) {
                suffix = " (multiscale)";
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(s + suffix);
            baseNode.add(childNode);
            String[] children = this.n5.list(fullPath);
            this.datasetTreeRecursive(childNode, fullPath, children);
        }
    }

    public JFrame show() {
        List<String> list;
        try {
            list = this.datasetList();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        final JFrame frame = new JFrame("Choose N5 datasets");
        JPanel panel = new JPanel(new BorderLayout());
        Object[] columnNames = new String[]{"datasets"};
        Object[][] data = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = new String[]{list.get(i)};
        }
        final JTable table = new JTable(data, columnNames);
        JScrollPane treeView = new JScrollPane(table);
        panel.add((Component)treeView, "Center");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener((String[][])data, frame){
            final /* synthetic */ String[][] val$data;
            final /* synthetic */ JFrame val$frame;
            {
                this.val$data = stringArray;
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                int[] selected = table.getSelectedRows();
                if (selected.length < 1) {
                    return;
                }
                N5DatasetSelectorDialog.this.selectedDatasets = new ArrayList<String>();
                for (int i : selected) {
                    N5DatasetSelectorDialog.this.selectedDatasets.add(this.val$data[i][0]);
                }
                this.val$frame.setVisible(false);
                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 201));
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        panel.add((Component)buttonPanel, "South");
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public List<String> datasetList() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        this.datasetListRecursive(list, this.root, this.n5.list(this.root));
        return list;
    }

    private void datasetListRecursive(List<String> list, String path, String ... bases) throws IOException {
        for (String s : bases) {
            String fullPath = path.equals(sep) ? path + s : path + sep + s;
            if (!this.n5.exists(fullPath)) continue;
            if (this.n5.datasetExists(fullPath)) {
                list.add(fullPath);
                continue;
            }
            if (this.isMultiscale != null && this.isMultiscale.test(this.n5, fullPath)) {
                list.add(fullPath + " (multiscale)");
            }
            String[] children = this.n5.list(fullPath);
            this.datasetListRecursive(list, fullPath, children);
        }
    }
}

