/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType8BitUnsignedInteger
extends AbstractContextual
implements DataType<UnsignedByteType> {
    private final UnsignedByteType type = new UnsignedByteType();

    @Override
    public UnsignedByteType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "8-bit uint";
    }

    @Override
    public String longName() {
        return "8-bit unsigned integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between 0 and 255";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(UnsignedByteType dest) {
        dest.set(0);
    }

    @Override
    public void upperBound(UnsignedByteType dest) {
        dest.set(255);
    }

    @Override
    public int bitCount() {
        return 8;
    }

    @Override
    public UnsignedByteType createVariable() {
        return new UnsignedByteType();
    }

    @Override
    public void cast(UnsignedByteType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, UnsignedByteType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(UnsignedByteType val) {
        return val.get();
    }

    @Override
    public long asLong(UnsignedByteType val) {
        return val.get();
    }

    @Override
    public void setDouble(UnsignedByteType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(UnsignedByteType val, long v) {
        if (v < 0L) {
            val.set(0);
        } else if (v > 255L) {
            val.set(255);
        } else {
            val.set((int)((short)v));
        }
    }
}

