/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.util;

import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.scijava.util.XML;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MediaWikiClient {
    private static final String IMAGEJ_WIKI_URL = "http://wiki.imagej.net/";
    private final String baseURL;
    private final Set<String> postActions = new HashSet<String>(Arrays.asList("login", "changeuploadpassword"));
    private String currentUser;
    private Map<String, String> cookies = new LinkedHashMap<String, String>();

    public MediaWikiClient() {
        this(IMAGEJ_WIKI_URL);
    }

    public MediaWikiClient(String baseURL) {
        this.baseURL = baseURL.endsWith("/index.php") ? baseURL.substring(0, baseURL.length() - 9) : (baseURL.endsWith("/") ? baseURL : baseURL + "/");
    }

    private static char firstToUpperCase(String word) {
        if (word.length() == 0) {
            return '\u0000';
        }
        char first = word.charAt(0);
        if (Character.isLowerCase(first)) {
            return Character.toUpperCase(first);
        }
        return '\u0000';
    }

    public static boolean isCapitalized(String word) {
        return MediaWikiClient.firstToUpperCase(word) == '\u0000';
    }

    public static String capitalize(String word) {
        char first = MediaWikiClient.firstToUpperCase(word);
        if (first == '\u0000') {
            return word;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(first);
        builder.append(word.substring(1));
        return builder.toString();
    }

    public String getPageSource(String title) throws IOException {
        XML xml = this.query("titles", title, "export", "true", "exportnowrap", "true");
        return xml.cdata("/mediawiki/page/revision/text");
    }

    public boolean userExists(String name) throws IOException {
        if (!MediaWikiClient.isCapitalized(name)) {
            throw new IOException("User name cannot start with a lower-case character: " + name);
        }
        XML xml = this.query("list", "users", "ususers", name);
        NodeList list = xml.xpath("/api/query/users/user");
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            NamedNodeMap node = list.item(i).getAttributes();
            if (node == null || node.getNamedItem("missing") != null) continue;
            return true;
        }
        return false;
    }

    public boolean createUser(String userName, String realName, String email, String reason) throws IOException {
        String[] headers = new String[]{"Requested-User", userName};
        XML xml = this.request(headers, "createimagejwikiaccount", "name", userName, "email", email, "realname", realName, "reason", reason);
        String error = MediaWikiClient.getAttribute(xml.xpath("/api/error"), "info");
        if (error != null) {
            System.err.println("Error creating user " + userName + ": " + error);
            return false;
        }
        return userName.equals(MediaWikiClient.getAttribute(xml.xpath("/api/createimagejwikiaccount"), "created"));
    }

    public boolean changeUploadPassword(String password) throws IOException {
        if (this.currentUser == null) {
            throw new IOException("Can only change the password for a logged-in user");
        }
        System.err.println("action: changeuploadpassword");
        XML xml = this.request(null, "changeuploadpassword", "password", password);
        String error = MediaWikiClient.getAttribute(xml.xpath("/api/error"), "info");
        if (error != null) {
            System.err.println("Error setting upload password for user '" + this.currentUser + "': " + error);
            return false;
        }
        NodeList response = xml.xpath("/api/changeuploadpassword");
        boolean result = "0".equals(MediaWikiClient.getAttribute(response, "result"));
        if (!result) {
            System.err.println("a1: " + response.item(0));
            System.err.println("Error: " + MediaWikiClient.getAttribute(response, "output"));
        }
        return result;
    }

    public boolean login(String user, String password) throws IOException {
        XML xml = this.request(null, "login", "lgname", user, "lgpassword", password);
        String loginToken = MediaWikiClient.getAttribute(xml.xpath("/api/login"), "token");
        if (loginToken == null) {
            System.err.println("Did not get a token!");
            return false;
        }
        xml = this.request(null, "login", "lgname", user, "lgpassword", password, "lgtoken", loginToken);
        boolean result = "Success".equals(MediaWikiClient.getAttribute(xml.xpath("/api/login"), "result"));
        this.currentUser = result ? user : null;
        return result;
    }

    public void logout() throws IOException {
        if (this.currentUser == null) {
            return;
        }
        this.request(null, "logout", new String[0]);
        this.cookies.clear();
        this.currentUser = null;
    }

    public XML request(String[] headers, String action, String ... parameters) throws IOException {
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Requires key/value pairs");
        }
        boolean requiresPOST = this.postActions.contains(action);
        try {
            List<String> newCookies;
            HttpURLConnection http;
            StringBuilder url = new StringBuilder();
            url.append(this.baseURL).append("api.php?action=").append(action).append("&format=xml");
            if (!requiresPOST) {
                for (int i = 0; i < parameters.length; i += 2) {
                    url.append("&").append(URLEncoder.encode(parameters[i], "UTF-8"));
                    url.append("=").append(URLEncoder.encode(parameters[i + 1], "UTF-8"));
                }
            }
            URLConnection connection = new URL(url.toString()).openConnection();
            for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                connection.addRequestProperty("Cookie", entry.getKey() + "=" + entry.getValue());
            }
            if (headers != null) {
                if (headers.length % 2 != 0) {
                    throw new IllegalArgumentException("Requires key/value pairs");
                }
                for (int i = 0; i < headers.length; i += 2) {
                    connection.setRequestProperty(headers[i], headers[i + 1]);
                }
            }
            HttpURLConnection httpURLConnection = http = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (http != null && requiresPOST) {
                http.setRequestMethod("POST");
                String boundary = "---e69de29bb2d1d6434b8b29ae775ad8c2e48c5391";
                http.setRequestProperty("Content-Type", "multipart/form-data; boundary=---e69de29bb2d1d6434b8b29ae775ad8c2e48c5391");
                http.setDoOutput(true);
                http.connect();
                PrintStream ps = new PrintStream(http.getOutputStream());
                for (int i = 0; i < parameters.length; i += 2) {
                    ps.print("-----e69de29bb2d1d6434b8b29ae775ad8c2e48c5391\r\nContent-Disposition: form-data; name=\"" + parameters[i] + "\"\r\n\r\n" + parameters[i + 1] + "\r\n");
                }
                ps.println("-----e69de29bb2d1d6434b8b29ae775ad8c2e48c5391--");
                ps.close();
            }
            if ((newCookies = http.getHeaderFields().get("Set-Cookie")) != null) {
                for (String cookie : newCookies) {
                    int equal = cookie.indexOf("=");
                    if (equal < 0) continue;
                    String key = cookie.substring(0, equal);
                    String value = cookie.substring(equal + 1);
                    if (value.startsWith("deleted; ")) {
                        this.cookies.remove(key);
                        continue;
                    }
                    this.cookies.put(key, value);
                }
            }
            return new XML(connection.getInputStream());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public XML query(String ... parameters) throws IOException {
        return this.request(null, "query", parameters);
    }

    public static String getAttribute(NodeList list, String attributeName) {
        if (list == null || list.getLength() != 1) {
            return null;
        }
        NamedNodeMap attrs = list.item(0).getAttributes();
        if (attrs == null) {
            return null;
        }
        Node node = attrs.getNamedItem(attributeName);
        return node == null ? null : node.getNodeValue();
    }
}

