/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.Macro;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.batch.BatchService;
import org.scijava.command.CommandService;
import org.scijava.event.ContextDisposingEvent;
import org.scijava.event.EventHandler;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.options.OptionsService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugins.scripting.java.JavaEngine;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptHeaderService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.thread.ThreadService;
import org.scijava.ui.CloseConfirmable;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.script.Bookmark;
import org.scijava.ui.swing.script.BookmarkDialog;
import org.scijava.ui.swing.script.CommandPalette;
import org.scijava.ui.swing.script.DefaultAutoImporters;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.ErrorHandler;
import org.scijava.ui.swing.script.ErrorParser;
import org.scijava.ui.swing.script.ExceptionHandler;
import org.scijava.ui.swing.script.FileDrop;
import org.scijava.ui.swing.script.FileFunctions;
import org.scijava.ui.swing.script.FileSystemTree;
import org.scijava.ui.swing.script.FileSystemTreePanel;
import org.scijava.ui.swing.script.FindAndReplaceDialog;
import org.scijava.ui.swing.script.JTextAreaWriter;
import org.scijava.ui.swing.script.MacroFunctions;
import org.scijava.ui.swing.script.OutlineTreePanel;
import org.scijava.ui.swing.script.RecentFilesMenuItem;
import org.scijava.ui.swing.script.SyntaxHighlighter;
import org.scijava.ui.swing.script.TextEditorTab;
import org.scijava.ui.swing.script.TokenFunctions;
import org.scijava.ui.swing.script.autocompletion.ClassUtil;
import org.scijava.ui.swing.script.commands.ChooseFontSize;
import org.scijava.ui.swing.script.commands.ChooseTabSize;
import org.scijava.ui.swing.script.commands.GitGrep;
import org.scijava.ui.swing.script.commands.KillScript;
import org.scijava.util.FileUtils;
import org.scijava.util.MiscUtils;
import org.scijava.util.POM;
import org.scijava.util.PlatformUtils;
import org.scijava.util.Types;

public class TextEditor
extends JFrame
implements ActionListener,
ChangeListener,
CloseConfirmable,
DocumentListener {
    private static final Set<String> TEMPLATE_PATHS = new HashSet<String>();
    public static final String AUTO_IMPORT_PREFS = "script.editor.AutoImport";
    public static final String WINDOW_HEIGHT = "script.editor.height";
    public static final String WINDOW_WIDTH = "script.editor.width";
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final String MAIN_DIV_LOCATION = "script.editor.main.divLocation";
    public static final String TAB_DIV_LOCATION = "script.editor.tab.divLocation";
    public static final String TAB_DIV_ORIENTATION = "script.editor.tab.divOrientation";
    public static final String REPL_DIV_LOCATION = "script.editor.repl.divLocation";
    public static final String LAST_LANGUAGE = "script.editor.lastLanguage";
    private static AbstractTokenMakerFactory tokenMakerFactory;
    private JTabbedPane tabbed;
    private JMenuItem newFile;
    private JMenuItem open;
    private JMenuItem save;
    private JMenuItem saveas;
    private JMenuItem compileAndRun;
    private JMenuItem compile;
    private JMenuItem close;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem find;
    private JMenuItem selectAll;
    private JMenuItem kill;
    private JMenuItem gotoLine;
    private JMenuItem makeJar;
    private JMenuItem makeJarWithSource;
    private JMenuItem removeUnusedImports;
    private JMenuItem sortImports;
    private JMenuItem removeTrailingWhitespace;
    private JMenuItem findNext;
    private JMenuItem findPrevious;
    private JMenuItem openHelp;
    private JMenuItem addImport;
    private JMenuItem nextError;
    private JMenuItem previousError;
    private JMenuItem openHelpWithoutFrames;
    private JMenuItem nextTab;
    private JMenuItem previousTab;
    private JMenuItem runSelection;
    private JMenuItem extractSourceJar;
    private JMenuItem openSourceForClass;
    private JMenuItem openMacroFunctions;
    private JMenuItem decreaseFontSize;
    private JMenuItem increaseFontSize;
    private JMenuItem chooseFontSize;
    private JMenuItem chooseTabSize;
    private JMenuItem gitGrep;
    private JMenuItem replaceTabsWithSpaces;
    private JMenuItem replaceSpacesWithTabs;
    private JMenuItem zapGremlins;
    private JMenuItem openClassOrPackageHelp;
    private RecentFilesMenuItem openRecent;
    private JMenu editMenu;
    private JMenu gitMenu;
    private JMenu tabsMenu;
    private JMenu fontSizeMenu;
    private JMenu tabSizeMenu;
    private JMenu toolsMenu;
    private JMenu runMenu;
    private int tabsMenuTabsStart;
    private Set<JMenuItem> tabsMenuItems;
    private FindAndReplaceDialog findDialog;
    private JCheckBoxMenuItem autoSave;
    private JCheckBoxMenuItem wrapLines;
    private JCheckBoxMenuItem tabsEmulated;
    private JCheckBoxMenuItem autoImport;
    private JCheckBoxMenuItem autocompletion;
    private JCheckBoxMenuItem fallbackAutocompletion;
    private JCheckBoxMenuItem keylessAutocompletion;
    private JCheckBoxMenuItem markOccurences;
    private JCheckBoxMenuItem paintTabs;
    private JCheckBoxMenuItem whiteSpace;
    private JCheckBoxMenuItem marginLine;
    private JCheckBoxMenuItem lockPane;
    private ButtonGroup themeRadioGroup;
    private JTextArea errorScreen = new JTextArea();
    private final FileSystemTree tree;
    private final JSplitPane body;
    private int compileStartOffset;
    private Position compileStartPosition;
    private ErrorHandler errorHandler;
    private boolean respectAutoImports;
    private String activeTheme;
    private int[] panePositions;
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private IOService ioService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ScriptHeaderService scriptHeaderService;
    @Parameter
    private UIService uiService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private AppService appService;
    @Parameter
    private BatchService batchService;
    @Parameter(required=false)
    private OptionsService optionsService;
    private Map<ScriptLanguage, JRadioButtonMenuItem> languageMenuItems;
    private JRadioButtonMenuItem noneLanguageItem;
    private EditableScriptInfo scriptInfo;
    private ScriptModule module;
    private boolean incremental = false;
    private DragSource dragSource;
    private boolean layoutLoading = true;
    private OutlineTreePanel sourceTreePanel;
    protected final CommandPalette cmdPalette;
    public static final ArrayList<TextEditor> instances;
    public static final ArrayList<Context> contexts;
    protected List<AcceleratorTriplet> defaultAccelerators = new ArrayList<AcceleratorTriplet>();
    private String lastSupportStatus = null;
    private final ArrayList<Executer> executingTasks = new ArrayList();

    public TextEditor(Context context) {
        super("Script Editor");
        instances.add(this);
        contexts.add(context);
        context.inject(this);
        this.initializeTokenMakers();
        this.tabbed = GuiUtils.getJTabbedPane();
        this.tree = new FileSystemTree(this.log);
        JTabbedPane sideTabs = GuiUtils.getJTabbedPane();
        sideTabs.addTab("File Explorer", new FileSystemTreePanel(this.tree, context));
        this.sourceTreePanel = new OutlineTreePanel();
        sideTabs.addTab("Outline", this.sourceTreePanel);
        this.body = new JSplitPane(1, sideTabs, this.tabbed);
        this.initializeDynamicMenuComponents();
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean shift = true;
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        this.newFile = this.addToMenu(file, "New", 78, ctrl);
        this.newFile.setMnemonic(78);
        this.open = this.addToMenu(file, "Open...", 79, ctrl);
        this.open.setMnemonic(79);
        this.openRecent = new RecentFilesMenuItem(this.prefService, this);
        this.openRecent.setMnemonic(82);
        file.add(this.openRecent);
        file.addSeparator();
        this.save = this.addToMenu(file, "Save", 83, ctrl);
        this.save.setMnemonic(83);
        this.saveas = this.addToMenu(file, "Save As...", 83, ctrl + 1);
        this.saveas.setMnemonic(65);
        file.addSeparator();
        this.makeJar = this.addToMenu(file, "Export as JAR...", 0, 0);
        this.makeJar.setMnemonic(69);
        this.makeJarWithSource = this.addToMenu(file, "Export as JAR (With Source)...", 0, 0);
        this.makeJarWithSource.setMnemonic(88);
        file.addSeparator();
        this.lockPane = new JCheckBoxMenuItem("Lock (Make Read Only)");
        this.lockPane.setToolTipText("Protects file from accidental editing");
        file.add(this.lockPane);
        this.lockPane.addActionListener(e -> {
            if (this.lockPane.isSelected()) {
                new RTextAreaEditorKit.SetReadOnlyAction().actionPerformedImpl(e, (RTextArea)this.getEditorPane());
            } else {
                new RTextAreaEditorKit.SetWritableAction().actionPerformedImpl(e, (RTextArea)this.getEditorPane());
            }
        });
        JMenuItem jmi = new JMenuItem("Revert...");
        jmi.addActionListener(e -> {
            if (this.getEditorPane().isLocked()) {
                this.error("File is currently locked.");
                return;
            }
            File f = this.getEditorPane().getFile();
            if (f == null || !f.exists()) {
                this.error(this.getEditorPane().getFileName() + "\nhas not been saved or its file is not available.");
            } else {
                this.reloadRevert("Revert to Saved File? Any unsaved changes will be lost.", "Revert");
            }
        });
        file.add(jmi);
        file.addSeparator();
        jmi = new JMenuItem("Show in System Explorer");
        jmi.addActionListener(e -> {
            File f = this.getEditorPane().getFile();
            if (f == null || !f.exists()) {
                this.error(this.getEditorPane().getFileName() + "\nhas not been saved or its file is not available.");
            } else {
                try {
                    Desktop.getDesktop().open(f.getParentFile());
                }
                catch (Error | Exception ignored) {
                    this.error(this.getEditorPane().getFileName() + "\ndoes not seem to be accessible.");
                }
            }
        });
        file.add(jmi);
        file.addSeparator();
        this.close = this.addToMenu(file, "Close", 87, ctrl);
        mbar.add(file);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        mbar.add(this.editMenu);
        this.languageMenuItems = new LinkedHashMap<ScriptLanguage, JRadioButtonMenuItem>();
        HashSet<Integer> usedShortcuts = new HashSet<Integer>();
        JMenu languages = new JMenu("Language");
        languages.setMnemonic(76);
        ButtonGroup group = new ButtonGroup();
        ArrayList<ScriptLanguage> list = new ArrayList<ScriptLanguage>(this.scriptService.getLanguages());
        Collections.sort(list, (l1, l2) -> {
            String name1 = l1.getLanguageName();
            String name2 = l2.getLanguageName();
            return MiscUtils.compare(name1, name2);
        });
        list.add(null);
        HashMap<String, ScriptLanguage> languageMap = new HashMap<String, ScriptLanguage>();
        for (ScriptLanguage language : list) {
            String name = language == null ? "None" : language.getLanguageName();
            languageMap.put(name, language);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
            if (language == null) {
                this.noneLanguageItem = item;
            } else {
                this.languageMenuItems.put(language, item);
            }
            int shortcut = -1;
            for (char ch : name.toCharArray()) {
                int keyCode = KeyStroke.getKeyStroke((int)ch, 0).getKeyCode();
                if (usedShortcuts.contains(keyCode)) continue;
                shortcut = keyCode;
                usedShortcuts.add(shortcut);
                break;
            }
            if (shortcut > 0) {
                item.setMnemonic(shortcut);
            }
            item.addActionListener(e -> this.setLanguage(language, true));
            group.add(item);
            languages.add(item);
        }
        this.noneLanguageItem.setSelected(true);
        mbar.add(languages);
        JMenu templates = new JMenu("Templates");
        templates.setMnemonic(84);
        this.addTemplates(templates);
        mbar.add(templates);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        this.compileAndRun = this.addToMenu(this.runMenu, "Compile and Run", 82, ctrl);
        this.compileAndRun.setMnemonic(82);
        this.runSelection = this.addToMenu(this.runMenu, "Run Selected Code", 82, ctrl | 1);
        this.runSelection.setMnemonic(83);
        this.compile = this.addToMenu(this.runMenu, "Compile", 67, ctrl | 1);
        this.compile.setMnemonic(67);
        this.autoSave = new JCheckBoxMenuItem("Auto-save Before Compiling");
        this.runMenu.add(this.autoSave);
        this.runMenu.addSeparator();
        this.nextError = this.addToMenu(this.runMenu, "Next Error", 115, 0);
        this.nextError.setMnemonic(78);
        this.previousError = this.addToMenu(this.runMenu, "Previous Error", 115, 1);
        this.previousError.setMnemonic(80);
        JMenuItem clearHighlights = new JMenuItem("Clear Marked Errors");
        clearHighlights.addActionListener(e -> this.getEditorPane().getErrorHighlighter().reset());
        this.runMenu.add(clearHighlights);
        this.runMenu.addSeparator();
        this.kill = this.addToMenu(this.runMenu, "Kill Running Script...", 0, 0);
        this.kill.setMnemonic(75);
        this.kill.setEnabled(false);
        mbar.add(this.runMenu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(79);
        this.cmdPalette = new CommandPalette(this);
        this.cmdPalette.install(this.toolsMenu);
        GuiUtils.addMenubarSeparator(this.toolsMenu, "Imports:");
        this.addImport = this.addToMenu(this.toolsMenu, "Add Import...", 0, 0);
        this.addImport.setMnemonic(73);
        this.respectAutoImports = this.prefService.getBoolean(this.getClass(), AUTO_IMPORT_PREFS, false);
        this.autoImport = new JCheckBoxMenuItem("Auto-import (Deprecated)", this.respectAutoImports);
        this.autoImport.setToolTipText("Automatically imports common classes before running code");
        this.autoImport.addItemListener(e -> {
            this.respectAutoImports = e.getStateChange() == 1;
            this.prefService.put(this.getClass(), AUTO_IMPORT_PREFS, this.respectAutoImports);
            if (this.respectAutoImports) {
                this.write("Auto-imports on. Lines associated with execution errors cannot be marked");
            } else {
                this.write("Auto-imports off. Lines associated with execution errors can be marked");
            }
        });
        this.toolsMenu.add(this.autoImport);
        this.removeUnusedImports = this.addToMenu(this.toolsMenu, "Remove Unused Imports", 0, 0);
        this.removeUnusedImports.setMnemonic(85);
        this.sortImports = this.addToMenu(this.toolsMenu, "Sort Imports", 0, 0);
        this.sortImports.setMnemonic(83);
        GuiUtils.addMenubarSeparator(this.toolsMenu, "Source & APIs:");
        this.extractSourceJar = this.addToMenu(this.toolsMenu, "Extract Source Jar...", 0, 0);
        this.extractSourceJar.setMnemonic(69);
        this.openSourceForClass = this.addToMenu(this.toolsMenu, "Open Java File for Class...", 0, 0);
        this.openSourceForClass.setMnemonic(74);
        this.addScritpEditorMacroCommands(this.toolsMenu);
        mbar.add(this.toolsMenu);
        this.gitMenu = new JMenu("Git");
        this.gitMenu.setMnemonic(71);
        this.gitGrep = this.addToMenu(this.gitMenu, "Grep...", 0, 0);
        this.gitGrep.setMnemonic(71);
        mbar.add(this.gitMenu);
        this.tabsMenu = new JMenu("Window");
        this.tabsMenu.setMnemonic(87);
        GuiUtils.addMenubarSeparator(this.tabsMenu, "Panes:");
        JCheckBoxMenuItem jcmi1 = new JCheckBoxMenuItem("Side Pane", this.prefService.getInt(this.getClass(), MAIN_DIV_LOCATION, this.body.getDividerLocation()) > 0 || this.isLeftPaneExpanded(this.body));
        jcmi1.addItemListener(e -> this.collapseSplitPane(0, !jcmi1.isSelected()));
        this.tabsMenu.add(jcmi1);
        JCheckBoxMenuItem jcmi2 = new JCheckBoxMenuItem("Console", this.prefService.getInt(this.getClass(), TAB_DIV_LOCATION, 1) > 0);
        jcmi2.addItemListener(e -> this.collapseSplitPane(1, !jcmi2.isSelected()));
        this.tabsMenu.add(jcmi2);
        JMenuItem mi = new JMenuItem("Reset Layout...");
        mi.addActionListener(e -> {
            if (this.confirm("Reset Location of Console and File Explorer?", "Reset Layout?", "Reset")) {
                this.resetLayout();
                jcmi1.setSelected(true);
                jcmi2.setSelected(true);
            }
        });
        this.tabsMenu.add(mi);
        GuiUtils.addMenubarSeparator(this.tabsMenu, "Tabs:");
        this.nextTab = this.addToMenu(this.tabsMenu, "Next Tab", 34, ctrl);
        this.nextTab.setMnemonic(78);
        this.previousTab = this.addToMenu(this.tabsMenu, "Previous Tab", 33, ctrl);
        this.previousTab.setMnemonic(80);
        this.tabsMenu.addSeparator();
        this.tabsMenuTabsStart = this.tabsMenu.getItemCount();
        this.tabsMenuItems = new HashSet<JMenuItem>();
        mbar.add(this.tabsMenu);
        JMenu options = new JMenu("Options");
        options.setMnemonic(79);
        GuiUtils.addMenubarSeparator(options, "Font:");
        this.decreaseFontSize = this.addToMenu(options, "Decrease Font Size", 45, ctrl);
        this.decreaseFontSize.setMnemonic(68);
        this.increaseFontSize = this.addToMenu(options, "Increase Font Size", 521, ctrl);
        this.increaseFontSize.setMnemonic(67);
        this.fontSizeMenu = new JMenu("Font Size");
        this.fontSizeMenu.setMnemonic(90);
        boolean[] fontSizeShortcutUsed = new boolean[10];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int size : new int[]{8, 10, 12, 16, 20, 28, 42}) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + size + " pt");
            item.addActionListener(event -> this.setFontSize(size));
            for (char c : ("" + size).toCharArray()) {
                int digit = c - 48;
                if (fontSizeShortcutUsed[digit]) continue;
                item.setMnemonic(48 + digit);
                fontSizeShortcutUsed[digit] = true;
                break;
            }
            buttonGroup.add(item);
            this.fontSizeMenu.add(item);
        }
        this.chooseFontSize = new JRadioButtonMenuItem("Other...", false);
        this.chooseFontSize.setMnemonic(79);
        this.chooseFontSize.addActionListener(this);
        buttonGroup.add(this.chooseFontSize);
        this.fontSizeMenu.add(this.chooseFontSize);
        options.add(this.fontSizeMenu);
        GuiUtils.addMenubarSeparator(options, "Indentation:");
        this.tabsEmulated = new JCheckBoxMenuItem("Indent Using Spaces");
        this.tabsEmulated.setMnemonic(83);
        this.tabsEmulated.addItemListener(e -> this.setTabsEmulated(this.tabsEmulated.getState()));
        options.add(this.tabsEmulated);
        this.tabSizeMenu = new JMenu("Tab Width");
        this.tabSizeMenu.setMnemonic(84);
        ButtonGroup bg = new ButtonGroup();
        for (int size : new int[]{2, 4, 8}) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + size);
            item.addActionListener(event -> {
                this.getEditorPane().setTabSize(size);
                this.updateTabAndFontSize(false);
            });
            item.setMnemonic(48 + size % 10);
            bg.add(item);
            this.tabSizeMenu.add(item);
        }
        this.chooseTabSize = new JRadioButtonMenuItem("Other...", false);
        this.chooseTabSize.setMnemonic(79);
        this.chooseTabSize.addActionListener(this);
        bg.add(this.chooseTabSize);
        this.tabSizeMenu.add(this.chooseTabSize);
        options.add(this.tabSizeMenu);
        this.replaceSpacesWithTabs = this.addToMenu(options, "Replace Spaces With Tabs", 0, 0);
        this.replaceTabsWithSpaces = this.addToMenu(options, "Replace Tabs With Spaces", 0, 0);
        GuiUtils.addMenubarSeparator(options, "View:");
        options.add(this.markOccurences);
        options.add(this.paintTabs);
        options.add(this.marginLine);
        options.add(this.whiteSpace);
        options.add(this.wrapLines);
        options.add(this.applyThemeMenu());
        GuiUtils.addMenubarSeparator(options, "Code Completions:");
        options.add(this.autocompletion);
        options.add(this.keylessAutocompletion);
        options.add(this.fallbackAutocompletion);
        options.addSeparator();
        this.appendPreferences(options);
        mbar.add(options);
        mbar.add(this.helpMenu());
        this.tabbed.addChangeListener(this);
        sideTabs.addChangeListener(e -> {
            if (sideTabs.getSelectedIndex() == 1) {
                this.sourceTreePanel.rebuildSourceTree(this.getTab((int)this.tabbed.getSelectedIndex()).editorPane);
            }
        });
        new FileDrop(this.tabbed, files -> {
            ArrayList<File> filteredFiles = new ArrayList<File>();
            TextEditor.assembleFlatFileCollection(filteredFiles, files);
            if (filteredFiles.isEmpty()) {
                this.warn("None of the dropped file(s) seems parseable.");
                return;
            }
            if (filteredFiles.size() < 10 || this.confirm("Confirm loading of " + filteredFiles.size() + " items?", "Confirm?", "Load")) {
                filteredFiles.forEach(f -> this.open((File)f));
            }
        });
        this.open(null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.body.setOneTouchExpandable(true);
        this.body.addPropertyChangeListener(evt -> {
            if ("dividerLocation".equals(evt.getPropertyName())) {
                this.saveWindowSizeToPrefs();
            }
        });
        this.tree.addTopLevelFoldersFrom(this.getEditorPane().loadFolders());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.tree, 1, new DragAndDrop());
        this.tree.ignoreExtension("class");
        this.tree.setMinimumSize(new Dimension(200, 600));
        this.tree.addLeafListener(f -> {
            String ext;
            ScriptLanguage lang;
            String name = f.getName();
            int idot = name.lastIndexOf(46);
            if (idot > -1 && null != (lang = this.scriptService.getLanguageByExtension(ext = name.substring(idot + 1)))) {
                this.open(f);
                return;
            }
            if (TextEditor.isBinary(f)) {
                this.log.debug("isBinary: true");
                try {
                    Object o = this.ioService.open(f.getAbsolutePath());
                    if (null != o) {
                        this.uiService.show(o);
                    } else {
                        this.error("Could not open the file at\n" + f.getAbsolutePath());
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error(e);
                    this.error("Could not open file at\n" + f);
                }
            }
            if (this.confirm("Really try to open file " + name + " in a tab?", "Confirm", "Open")) {
                this.open(f);
            }
        });
        this.getContentPane().add(this.body);
        this.addAccelerator(this.compileAndRun, 122, 0, true);
        this.addAccelerator(this.compileAndRun, 116, 0, true);
        this.compileAndRun.setToolTipText("Also triggered by F5 or F11");
        this.addAccelerator(this.nextTab, 34, ctrl, true);
        this.addAccelerator(this.previousTab, 33, ctrl, true);
        this.addAccelerator(this.increaseFontSize, 61, ctrl | 1, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!TextEditor.this.confirmClose()) {
                    return;
                }
                TextEditor.this.tree.destroy();
                for (DragSourceListener l : TextEditor.this.dragSource.getDragSourceListeners()) {
                    TextEditor.this.dragSource.removeDragSourceListener(l);
                }
                TextEditor.this.dragSource = null;
                TextEditor.this.getTab().destroy();
                TextEditor.this.cmdPalette.dispose();
                TextEditor.this.dispose();
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                TextEditor.this.checkForOutsideChanges();
            }
        });
        this.errorScreen.setFont(this.getEditorPane().getFont());
        this.errorScreen.setEditable(false);
        this.errorScreen.setLineWrap(false);
        this.applyConsolePopupMenu(this.errorScreen);
        this.setDefaultCloseOperation(0);
        try {
            this.threadService.invoke(() -> {
                this.pack();
                this.body.setDividerLocation(0.2);
                this.getTab().setREPLVisible(false);
                this.loadWindowSizePreferences();
                this.pack();
            });
        }
        catch (Exception ie) {
            this.log.debug(ie);
        }
        this.findDialog = new FindAndReplaceDialog(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TextEditor.this.saveWindowSizeToPrefs();
            }
        });
        this.setLocationRelativeTo(null);
        int y = this.getLocation().y - 11;
        if (y < 0) {
            y = 0;
        }
        this.setLocation(this.getLocation().x, y);
        this.open(null);
        EditorPane editorPane = this.getEditorPane();
        this.applyTheme(GuiUtils.isDarkLaF() && "default".equals(editorPane.themeName()) ? "dark" : editorPane.themeName(), true);
        this.setFontSize(this.getEditorPane().getFontSize());
        this.updateUI(true);
        this.panePositions = new int[]{this.body.getDividerLocation(), this.getTab().getDividerLocation()};
        editorPane.requestFocus();
    }

    private void resetLayout() {
        this.body.setDividerLocation(0.2);
        this.getTab().setOrientation(0);
        this.getTab().setDividerLocation(this.incremental ? 0.7 : 0.75);
        if (this.incremental) {
            this.getTab().getScreenAndPromptSplit().setDividerLocation(0.5);
        }
        this.getTab().setREPLVisible(this.incremental);
        this.pack();
    }

    private void assembleEditMenu() {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean shift = true;
        this.undo = this.addToMenu(this.editMenu, "Undo", 90, ctrl);
        this.redo = this.addToMenu(this.editMenu, "Redo", 89, ctrl);
        this.editMenu.addSeparator();
        this.selectAll = this.addToMenu(this.editMenu, "Select All", 65, ctrl);
        this.cut = this.addToMenu(this.editMenu, "Cut", 88, ctrl);
        this.copy = this.addToMenu(this.editMenu, "Copy", 67, ctrl);
        this.addMappedActionToMenu(this.editMenu, "Copy as Styled Text", "RSTA.CopyAsStyledTextAction", false);
        this.paste = this.addToMenu(this.editMenu, "Paste", 86, ctrl);
        this.addMappedActionToMenu(this.editMenu, "Paste History...", "RTA.PasteHistoryAction", true);
        GuiUtils.addMenubarSeparator(this.editMenu, "Find:");
        this.find = this.addToMenu(this.editMenu, "Find/Replace...", 70, ctrl);
        this.find.setMnemonic(70);
        this.findNext = this.addToMenu(this.editMenu, "Find Next", 114, 0);
        this.findNext.setMnemonic(78);
        this.findPrevious = this.addToMenu(this.editMenu, "Find Previous", 114, 1);
        this.findPrevious.setMnemonic(80);
        GuiUtils.addMenubarSeparator(this.editMenu, "Go To:");
        this.gotoLine = this.addToMenu(this.editMenu, "Go to Line...", 71, ctrl);
        this.gotoLine.setMnemonic(71);
        this.addMappedActionToMenu(this.editMenu, "Go to Matching Bracket", "RSTA.GoToMatchingBracketAction", false);
        JMenuItem gotoType = new JMenuItem("Go to Type...");
        gotoType.setAccelerator(KeyStroke.getKeyStroke(79, ctrl + 1));
        gotoType.addActionListener(e -> {
            try {
                this.getTextArea().getActionMap().get("GoToType").actionPerformed(e);
            }
            catch (Error | Exception ignored) {
                this.error("\"Goto Type\" not availabe for current scripting language.");
            }
        });
        this.editMenu.add(gotoType);
        GuiUtils.addMenubarSeparator(this.editMenu, "Bookmarks:");
        this.addMappedActionToMenu(this.editMenu, "Next Bookmark", "RTA.NextBookmarkAction", false);
        this.addMappedActionToMenu(this.editMenu, "Previous Bookmark", "RTA.PrevBookmarkAction", false);
        JMenuItem toggB = this.addMappedActionToMenu(this.editMenu, "Toggle Bookmark", "RTA.ToggleBookmarkAction", false);
        toggB.setToolTipText("Alternatively, click on left bookmark gutter near the line number");
        JMenuItem listBookmarks = this.addToMenu(this.editMenu, "List Bookmarks...", 0, 0);
        listBookmarks.setMnemonic(76);
        listBookmarks.addActionListener(e -> this.listBookmarks());
        JMenuItem clearBookmarks = this.addToMenu(this.editMenu, "Clear Bookmarks...", 0, 0);
        clearBookmarks.addActionListener(e -> this.clearAllBookmarks());
        GuiUtils.addMenubarSeparator(this.editMenu, "Utilities:");
        JMenuItem commentJMI = this.addMappedActionToMenu(this.editMenu, "Toggle Comment", "RSTA.ToggleCommentAction", true);
        commentJMI.setToolTipText("Alternative shortcut: " + this.getEditorPane().getPaneActions().getAcceleratorLabel("RSTA.ToggleCommentAltAction"));
        this.addMappedActionToMenu(this.editMenu, "Insert Time Stamp", "RTA.TimeDateAction", true);
        this.removeTrailingWhitespace = this.addToMenu(this.editMenu, "Remove Trailing Whitespace", 0, 0);
        this.zapGremlins = this.addToMenu(this.editMenu, "Zap Gremlins", 0, 0);
        this.zapGremlins.setToolTipText("Removes invalid (non-printable) ASCII characters");
    }

    private void addScritpEditorMacroCommands(JMenu menu) {
        GuiUtils.addMenubarSeparator(menu, "Script Editor Macros:");
        JMenuItem startMacro = new JMenuItem("Start/Resume Macro Recording");
        startMacro.addActionListener(e -> {
            if (this.getEditorPane().isLocked()) {
                this.error("File is currently locked.");
                return;
            }
            String state = RTextArea.getCurrentMacro() == null ? "on" : "resumed";
            this.write("Script Editor: Macro recording " + state);
            RTextArea.beginRecordingMacro();
        });
        menu.add(startMacro);
        JMenuItem pauseMacro = new JMenuItem("Pause Macro Recording...");
        pauseMacro.addActionListener(e -> {
            if (!RTextArea.isRecordingMacro() || RTextArea.getCurrentMacro() == null) {
                this.warn("No Script Editor Macro recording exists.");
            } else {
                RTextArea.endRecordingMacro();
                int nSteps = RTextArea.getCurrentMacro().getMacroRecords().size();
                this.write("Script Editor: Macro recording off: " + nSteps + " event(s)/action(s) recorded.");
                if (nSteps == 0) {
                    RTextArea.loadMacro(null);
                }
            }
        });
        menu.add(pauseMacro);
        JMenuItem endMacro = new JMenuItem("Stop/Save Recording...");
        endMacro.addActionListener(e -> {
            File fileToSave;
            pauseMacro.doClick();
            if (RTextArea.getCurrentMacro() != null && (fileToSave = this.getMacroFile(false)) != null) {
                try {
                    RTextArea.getCurrentMacro().saveToFile(fileToSave);
                }
                catch (IOException e1) {
                    this.error(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        menu.add(endMacro);
        JMenuItem clearMacro = new JMenuItem("Clear Recorded Macro...");
        clearMacro.addActionListener(e -> {
            if (RTextArea.getCurrentMacro() == null) {
                this.warn("Nothing to clear: No macro has been recorded.");
                return;
            }
            if (this.confirm("Clear Recorded Macro(s)?", "Clear Recording(s)?", "Clear")) {
                RTextArea.loadMacro(null);
                this.write("Script Editor: Recorded macro(s) cleared.");
            }
        });
        menu.add(clearMacro);
        JMenuItem playMacro = new JMenuItem("Run Recorded Macro");
        playMacro.setToolTipText("Runs current recordings. Prompts for\nrecordings file if no recordings exist");
        playMacro.addActionListener(e -> {
            File fileToOpen;
            if (this.getEditorPane().isLocked()) {
                this.error("File is currently locked.");
                return;
            }
            if (null == RTextArea.getCurrentMacro() && (fileToOpen = this.getMacroFile(true)) != null) {
                try {
                    RTextArea.loadMacro((Macro)new Macro(fileToOpen));
                }
                catch (IOException e1) {
                    this.error(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (RTextArea.isRecordingMacro()) {
                if (this.confirm("Recording must be paused before execution. Pause recording now?", "Pause and Run?", "Pause and Run")) {
                    RTextArea.endRecordingMacro();
                    this.write("Script Editor: Recording paused");
                } else {
                    return;
                }
            }
            if (RTextArea.getCurrentMacro() != null) {
                int actions = RTextArea.getCurrentMacro().getMacroRecords().size();
                this.write("Script Editor: Running recorded macro [" + actions + " event(s)/action(s)]");
                try {
                    this.getTextArea().playbackLastMacro();
                }
                catch (Error | Exception ex) {
                    this.error("An Exception occured while running macro. See Console for details");
                    ex.printStackTrace();
                }
            }
        });
        menu.add(playMacro);
    }

    private File getMacroFile(boolean openOtherwiseSave) {
        String yesLabel;
        String msg = openOtherwiseSave ? "No macros have been recorded. Load macro from file?" : "Recording Stopped. Save recorded macro to local file?";
        String title = openOtherwiseSave ? "Load from File?" : "Save to File?";
        String string = yesLabel = openOtherwiseSave ? "Load" : "Save";
        if (this.confirm(msg, title, yesLabel)) {
            File dir = this.appService.getApp().getBaseDirectory();
            String filename = "RecordedScriptEditorMacro.xml";
            if (this.getEditorPane().getFile() != null) {
                dir = this.getEditorPane().getFile().getParentFile();
            }
            return this.uiService.chooseFile(new File(dir, "RecordedScriptEditorMacro.xml"), openOtherwiseSave ? "open" : "save");
        }
        return null;
    }

    private void displayRecordableMap() {
        this.displayMap(this.cmdPalette.getRecordableActions(), "Script Editor Recordable Actions/Events");
    }

    private void displayKeyMap() {
        this.displayMap(this.cmdPalette.getShortcuts(), "Script Editor Shortcuts");
    }

    private void displayMap(Map<String, String> map, String windowTitle) {
        ArrayList lines = new ArrayList();
        map.forEach((cmd, key) -> lines.add("<tr><td>" + cmd + "</td><td>" + key + "</td></tr>"));
        String prefix = "<HTML><center><table><tbody><tr><td style=\"width: 60%; text-align: center;\"><b>Action</b></td><td style=\"width: 40%; text-align: center;\"><b>Shortcut</b></td></tr>";
        String suffix = "</tbody></table></center>";
        this.showHTMLDialog(windowTitle, "<HTML><center><table><tbody><tr><td style=\"width: 60%; text-align: center;\"><b>Action</b></td><td style=\"width: 40%; text-align: center;\"><b>Shortcut</b></td></tr>" + String.join((CharSequence)"", lines) + "</tbody></table></center>");
    }

    public LogService log() {
        return this.log;
    }

    public PlatformService getPlatformService() {
        return this.platformService;
    }

    public JTextArea getErrorScreen() {
        return this.errorScreen;
    }

    public void setErrorScreen(JTextArea errorScreen) {
        this.errorScreen = errorScreen;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private synchronized void initializeTokenMakers() {
        if (tokenMakerFactory != null) {
            return;
        }
        tokenMakerFactory = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        for (PluginInfo<SyntaxHighlighter> info : this.pluginService.getPluginsOfType(SyntaxHighlighter.class)) {
            try {
                tokenMakerFactory.putMapping("text/" + info.getName().toLowerCase().replace(' ', '-'), info.getClassName());
            }
            catch (Throwable t) {
                this.log.warn("Could not register " + info.getName(), t);
            }
        }
    }

    private void initializeDynamicMenuComponents() {
        this.wrapLines = new JCheckBoxMenuItem("Wrap Lines", false);
        this.wrapLines.setMnemonic(87);
        this.marginLine = new JCheckBoxMenuItem("Show Margin Line", false);
        this.marginLine.setToolTipText("Displays right margin at column 80");
        this.marginLine.addItemListener(e -> this.setMarginLineEnabled(this.marginLine.getState()));
        this.wrapLines.addItemListener(e -> this.setWrapLines(this.wrapLines.getState()));
        this.markOccurences = new JCheckBoxMenuItem("Mark Occurences", false);
        this.markOccurences.setToolTipText("Allows for all occurrences of a double-clicked string to be highlighted.\nLines with hits are marked on the Editor's notification strip");
        this.markOccurences.addItemListener(e -> this.setMarkOccurrences(this.markOccurences.getState()));
        this.whiteSpace = new JCheckBoxMenuItem("Show Whitespace", false);
        this.whiteSpace.addItemListener(e -> this.setWhiteSpaceVisible(this.whiteSpace.isSelected()));
        this.paintTabs = new JCheckBoxMenuItem("Show Indent Guides");
        this.paintTabs.setToolTipText("Displays 'tab lines' for leading whitespace");
        this.paintTabs.addItemListener(e -> this.setPaintTabLines(this.paintTabs.getState()));
        this.autocompletion = new JCheckBoxMenuItem("Enable Autocompletion", true);
        this.autocompletion.setToolTipText("Whether code completion should be used.\nNB: Not all languages support this feature");
        this.autocompletion.addItemListener(e -> this.setAutoCompletionEnabled(this.autocompletion.getState()));
        this.keylessAutocompletion = new JCheckBoxMenuItem("Show Completions Without Ctrl+Space", false);
        this.keylessAutocompletion.setToolTipText("If selected, the completion pop-up automatically appears while typing");
        this.keylessAutocompletion.addItemListener(e -> this.setKeylessAutoCompletion(this.keylessAutocompletion.getState()));
        this.fallbackAutocompletion = new JCheckBoxMenuItem("Use Java Completions as Fallback", false);
        this.fallbackAutocompletion.setToolTipText("<HTML>If selected, Java completions will be used when scripting<br>a language for which auto-completions are not available");
        this.fallbackAutocompletion.addItemListener(e -> this.setFallbackAutoCompletion(this.fallbackAutocompletion.getState()));
        this.themeRadioGroup = new ButtonGroup();
        this.openMacroFunctions = new JMenuItem("Open Help on Macro Function(s)...");
        this.openMacroFunctions.setMnemonic(72);
        this.openMacroFunctions.addActionListener(e -> {
            try {
                new MacroFunctions(this).openHelp(this.getTextArea().getSelectedText());
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        });
        this.openHelp = new JMenuItem("Open Help for Class (With Frames)...");
        this.openHelp.setMnemonic(72);
        this.openHelp.addActionListener(e -> this.openHelp(null));
        this.openHelpWithoutFrames = new JMenuItem("Open Help for Class...");
        this.openHelpWithoutFrames.addActionListener(e -> this.openHelp(null, false));
    }

    public void checkForOutsideChanges() {
        EditorPane editorPane = this.getEditorPane();
        if (editorPane.wasChangedOutside()) {
            this.reload(editorPane.getFile().getName() + "\nwas changed outside of the editor.");
        }
    }

    public static void addTemplatePath(String path) {
        TEMPLATE_PATHS.add(path);
    }

    @EventHandler
    private void onEvent(ContextDisposingEvent e) {
        if (this.isDisplayable()) {
            this.dispose();
        }
    }

    public void loadWindowSizePreferences() {
        this.layoutLoading = true;
        Dimension dim = this.getSize();
        if (0 == dim.width) {
            dim.width = 800;
        }
        if (0 == dim.height) {
            dim.height = 600;
        }
        int windowWidth = this.prefService.getInt(this.getClass(), WINDOW_WIDTH, dim.width);
        int windowHeight = this.prefService.getInt(this.getClass(), WINDOW_HEIGHT, dim.height);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)windowWidth > screen.getWidth() || (double)windowHeight > screen.getHeight()) {
            this.setPreferredSize(new Dimension(800, 600));
        } else {
            this.setPreferredSize(new Dimension(windowWidth, windowHeight));
        }
        int mainDivLocation = this.prefService.getInt(this.getClass(), MAIN_DIV_LOCATION, this.body.getDividerLocation());
        this.body.setDividerLocation(mainDivLocation);
        TextEditorTab tab = this.getTab();
        int tabDivLocation = this.prefService.getInt(this.getClass(), TAB_DIV_LOCATION, tab.getDividerLocation());
        int tabDivOrientation = this.prefService.getInt(this.getClass(), TAB_DIV_ORIENTATION, tab.getOrientation());
        int replDividerLocation = this.prefService.getInt(this.getClass(), REPL_DIV_LOCATION, tab.getScreenAndPromptSplit().getDividerLocation());
        tab.setDividerLocation(tabDivLocation);
        tab.setOrientation(tabDivOrientation);
        tab.getScreenAndPromptSplit().setDividerLocation(replDividerLocation);
        this.layoutLoading = false;
    }

    public void saveWindowSizeToPrefs() {
        if (this.layoutLoading) {
            return;
        }
        Dimension dim = this.getSize();
        this.prefService.put(this.getClass(), WINDOW_HEIGHT, dim.height);
        this.prefService.put(this.getClass(), WINDOW_WIDTH, dim.width);
        this.prefService.put(this.getClass(), MAIN_DIV_LOCATION, this.body.getDividerLocation());
        TextEditorTab tab = this.getTab();
        this.prefService.put(this.getClass(), TAB_DIV_LOCATION, tab.getDividerLocation());
        this.prefService.put(this.getClass(), TAB_DIV_ORIENTATION, tab.getOrientation());
        this.prefService.put(this.getClass(), REPL_DIV_LOCATION, tab.getScreenAndPromptSplit().getDividerLocation());
    }

    public final RSyntaxTextArea getTextArea() {
        return this.getEditorPane();
    }

    public TextEditorTab getTab() {
        int index = this.tabbed.getSelectedIndex();
        if (index < 0) {
            if (this.tabbed.getTabCount() == 0) {
                this.createNewDocument();
            }
            this.tabbed.setSelectedIndex(0);
            index = 0;
        }
        return (TextEditorTab)this.tabbed.getComponentAt(index);
    }

    public TextEditorTab getTab(int index) {
        return (TextEditorTab)this.tabbed.getComponentAt(index);
    }

    public EditorPane getEditorPane() {
        return this.getTab().editorPane;
    }

    public ScriptLanguage getCurrentLanguage() {
        return this.getEditorPane().getCurrentLanguage();
    }

    public JMenuItem addToMenu(JMenu menu, String menuEntry, int key, int modifiers) {
        JMenuItem item = new JMenuItem(menuEntry);
        menu.add(item);
        if (key != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(key, modifiers));
        }
        item.addActionListener(this);
        return item;
    }

    private JMenuItem addMappedActionToMenu(JMenu menu, String label, String actionID, boolean editingAction) {
        JMenuItem jmi = new JMenuItem(label);
        jmi.addActionListener(e -> {
            try {
                if (editingAction && this.getEditorPane().isLocked()) {
                    this.warn("File is currently locked.");
                    return;
                }
                if ("RTA.PasteHistoryAction".equals(actionID) && ClipboardHistory.get().getHistory().isEmpty()) {
                    this.warn("The internal clipboard manager is empty.");
                    return;
                }
                this.getTextArea().requestFocusInWindow();
                this.getTextArea().getActionMap().get(actionID).actionPerformed(e);
            }
            catch (Error | Exception ignored) {
                this.error("\"" + label + "\" not availabe for current scripting language.");
            }
        });
        jmi.setAccelerator(this.getEditorPane().getPaneActions().getAccelerator(actionID));
        menu.add(jmi);
        return jmi;
    }

    public void addAccelerator(JMenuItem component, int key, int modifiers) {
        this.addAccelerator(component, key, modifiers, false);
    }

    public void addAccelerator(JMenuItem component, int key, int modifiers, boolean record) {
        RSyntaxTextArea textArea;
        if (record) {
            AcceleratorTriplet triplet = new AcceleratorTriplet();
            triplet.component = component;
            triplet.key = key;
            triplet.modifiers = modifiers;
            this.defaultAccelerators.add(triplet);
        }
        if ((textArea = this.getTextArea()) != null) {
            this.addAccelerator(textArea, component, key, modifiers);
        }
    }

    public void addAccelerator(RSyntaxTextArea textArea, final JMenuItem component, int key, int modifiers) {
        textArea.getInputMap().put(KeyStroke.getKeyStroke(key, modifiers), component);
        textArea.getActionMap().put(component, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!component.isEnabled()) {
                    return;
                }
                ActionEvent event = new ActionEvent(component, 0, "Accelerator");
                TextEditor.this.actionPerformed(event);
            }
        });
    }

    public void addDefaultAccelerators(RSyntaxTextArea textArea) {
        for (AcceleratorTriplet triplet : this.defaultAccelerators) {
            this.addAccelerator(textArea, triplet.component, triplet.key, triplet.modifiers);
        }
    }

    private JMenu getMenu(JMenu root, String menuItemPath, boolean createIfNecessary) {
        int slash = menuItemPath.indexOf(47);
        if (slash < 0) {
            return root;
        }
        String menuLabel = menuItemPath.substring(0, slash);
        String rest = menuItemPath.substring(slash + 1);
        for (int i = 0; i < root.getItemCount(); ++i) {
            JMenuItem item = root.getItem(i);
            if (!(item instanceof JMenu) || !menuLabel.equals(item.getText())) continue;
            return this.getMenu((JMenu)item, rest, createIfNecessary);
        }
        if (!createIfNecessary) {
            return null;
        }
        JMenu subMenu = new JMenu(menuLabel);
        root.add(subMenu);
        return this.getMenu(subMenu, rest, createIfNecessary);
    }

    private void addTemplates(JMenu templatesMenu) {
        File baseDir = this.appService.getApp().getBaseDirectory();
        for (String templatePath : TEMPLATE_PATHS) {
            for (Map.Entry<String, URL> entry : new TreeMap<String, URL>(FileUtils.findResources(null, templatePath, baseDir)).entrySet()) {
                String key = entry.getKey();
                String ext = FileUtils.getExtension(key);
                ScriptLanguage lang = ext.isEmpty() ? null : this.scriptService.getLanguageByExtension(ext);
                String langName = lang == null ? null : lang.getLanguageName();
                String langSuffix = lang == null ? null : " (" + langName + ")";
                String path = this.adjustPath(key, langName);
                int labelIndex = path.lastIndexOf(47) + 1;
                String label = ext.isEmpty() ? path.substring(labelIndex) : path.substring(labelIndex, path.length() - ext.length() - 1);
                ActionListener menuListener = e -> this.loadTemplate((URL)entry.getValue());
                if (langName != null) {
                    String langPath = "[by language]/" + langName + "/" + path;
                    JMenu langMenu = this.getMenu(templatesMenu, langPath, true);
                    JMenuItem langItem = new JMenuItem(label);
                    langMenu.add(langItem);
                    langItem.addActionListener(menuListener);
                }
                JMenu menu = this.getMenu(templatesMenu, path, true);
                JMenuItem item = new JMenuItem(label + langSuffix);
                menu.add(item);
                item.addActionListener(menuListener);
            }
        }
    }

    public void loadTemplate(String url) {
        try {
            this.loadTemplate(new URL(url));
        }
        catch (Exception e) {
            this.log.error(e);
            this.error("The template '" + url + "' was not found.");
        }
    }

    public void loadTemplate(URL url) {
        String path = url.getPath();
        String ext = FileUtils.getExtension(path);
        ScriptLanguage language = ext.isEmpty() ? null : this.scriptService.getLanguageByExtension(ext);
        this.loadTemplate(url, language);
    }

    public void loadTemplate(URL url, ScriptLanguage language) {
        this.createNewDocument();
        try {
            InputStream in = url.openStream();
            this.getTextArea().read((Reader)new BufferedReader(new InputStreamReader(in)), null);
            if (language != null) {
                this.setLanguage(language);
            }
            String path = url.getPath();
            this.setEditorPaneFileName(path.substring(path.lastIndexOf(47) + 1));
        }
        catch (Exception e) {
            this.log.error(e);
            this.error("The template '" + url + "' was not found.");
        }
    }

    public void createNewDocument() {
        this.open(null);
    }

    public void createNewDocument(String title, String text) {
        this.open(null);
        EditorPane editorPane = this.getEditorPane();
        editorPane.setText(text);
        this.setEditorPaneFileName(title);
        editorPane.setLanguageByFileName(title);
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
    }

    public void createNewFromTemplate(File file, File templateFile) {
        this.open(file.exists() ? file : templateFile);
        if (!file.exists()) {
            EditorPane editorPane = this.getEditorPane();
            try {
                editorPane.open(file);
            }
            catch (IOException e) {
                this.handleException(e);
            }
            editorPane.setLanguageByFileName(file.getName());
            this.updateLanguageMenu(editorPane.getCurrentLanguage());
        }
    }

    public boolean fileChanged() {
        return this.getEditorPane().fileChanged();
    }

    public boolean handleUnsavedChanges() {
        return this.handleUnsavedChanges(false);
    }

    public boolean handleUnsavedChanges(boolean beforeCompiling) {
        if (!this.fileChanged()) {
            return true;
        }
        if (beforeCompiling && this.autoSave.getState()) {
            this.save();
            return true;
        }
        if (GuiUtils.confirm(this, "Do you want to save changes?", "Save Changes?", "Save")) {
            return this.save();
        }
        return !beforeCompiling;
    }

    private boolean isJava(ScriptLanguage language) {
        return language != null && language.getLanguageName().equals("Java");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.newFile) {
            this.createNewDocument();
        } else {
            if (source == this.open) {
                EditorPane editorPane = this.getEditorPane();
                File defaultDir = editorPane.getFile() != null ? editorPane.getFile().getParentFile() : this.appService.getApp().getBaseDirectory();
                File file = this.openWithDialog(defaultDir);
                if (file != null) {
                    new Thread(() -> this.open(file)).start();
                }
                return;
            }
            if (source == this.save) {
                this.save();
            } else if (source == this.saveas) {
                this.saveAs();
            } else if (source == this.makeJar) {
                this.makeJar(false);
            } else if (source == this.makeJarWithSource) {
                this.makeJar(true);
            } else if (source == this.compileAndRun) {
                this.runText();
            } else if (source == this.compile) {
                this.compile();
            } else if (source == this.runSelection) {
                this.runText(true);
            } else if (source == this.nextError) {
                if (this.isJava(this.getEditorPane().getCurrentLanguage())) {
                    new Thread(() -> this.nextError(true)).start();
                } else {
                    this.getEditorPane().getErrorHighlighter().gotoNextError();
                }
            } else if (source == this.previousError) {
                if (this.isJava(this.getEditorPane().getCurrentLanguage())) {
                    new Thread(() -> this.nextError(false)).start();
                } else {
                    this.getEditorPane().getErrorHighlighter().gotoPreviousError();
                }
            } else if (source == this.kill) {
                this.chooseTaskToKill();
            } else if (source == this.close) {
                if (this.tabbed.getTabCount() < 2) {
                    this.processWindowEvent(new WindowEvent(this, 201));
                } else {
                    if (!this.handleUnsavedChanges()) {
                        return;
                    }
                    int index = this.tabbed.getSelectedIndex();
                    this.removeTab(index);
                    if (index > 0) {
                        --index;
                    }
                    this.switchTo(index);
                }
            } else if (source == this.copy) {
                this.getTextArea().copy();
            } else if (source == this.find) {
                this.findOrReplace(true);
            } else if (source == this.findNext) {
                this.findDialog.setRestrictToConsole(false);
                this.findDialog.searchOrReplace(false);
            } else if (source == this.findPrevious) {
                this.findDialog.setRestrictToConsole(false);
                this.findDialog.searchOrReplace(false, false);
            } else if (source == this.gotoLine) {
                this.gotoLine();
            } else if (source == this.selectAll) {
                this.getTextArea().setCaretPosition(0);
                this.getTextArea().moveCaretPosition(this.getTextArea().getDocument().getLength());
            } else if (source == this.chooseFontSize) {
                this.commandService.run(ChooseFontSize.class, true, "editor", this);
            } else if (source == this.chooseTabSize) {
                this.commandService.run(ChooseTabSize.class, true, "editor", this);
            } else if (source == this.openClassOrPackageHelp) {
                this.openClassOrPackageHelp(null);
            } else if (source == this.extractSourceJar) {
                this.extractSourceJar();
            } else if (source == this.openSourceForClass) {
                String className = this.getSelectedClassNameOrAsk("Class (fully qualified name):", "Which Class?");
                if (className != null) {
                    try {
                        String url = new FileFunctions(this).getSourceURL(className);
                        this.platformService.open(new URL(url));
                    }
                    catch (Throwable e) {
                        this.handleException(e);
                    }
                }
            } else if (source == this.gitGrep) {
                String searchTerm = this.getTextArea().getSelectedText();
                File searchRoot = this.getEditorPane().getFile();
                if (searchRoot == null) {
                    this.error("File was not yet saved; no location known!");
                    return;
                }
                searchRoot = searchRoot.getParentFile();
                this.commandService.run(GitGrep.class, true, "editor", this, "searchTerm", searchTerm, "searchRoot", searchRoot);
            } else if (source == this.increaseFontSize || source == this.decreaseFontSize) {
                this.getEditorPane().increaseFontSize((float)(source == this.increaseFontSize ? 1.2 : 0.8333333333333334));
                this.setFontSize(this.getEditorPane().getFontSize());
            } else if (source == this.nextTab) {
                this.switchTabRelative(1);
            } else if (source == this.previousTab) {
                this.switchTabRelative(-1);
            } else {
                if (this.handleTabsMenu(source)) {
                    return;
                }
                if (this.getEditorPane().isLocked()) {
                    this.error("File is currently locked.");
                    return;
                }
                if (source == this.cut) {
                    this.getTextArea().cut();
                } else if (source == this.paste) {
                    this.getTextArea().paste();
                } else if (source == this.undo) {
                    this.getTextArea().undoLastAction();
                } else if (source == this.redo) {
                    this.getTextArea().redoLastAction();
                } else if (source == this.addImport) {
                    this.addImport(this.getSelectedClassNameOrAsk("Add import (complete qualified name of class/package)", "Which Class to Import?"));
                } else if (source == this.removeUnusedImports) {
                    new TokenFunctions(this.getTextArea()).removeUnusedImports();
                } else if (source == this.sortImports) {
                    new TokenFunctions(this.getTextArea()).sortImports();
                } else if (source == this.removeTrailingWhitespace) {
                    new TokenFunctions(this.getTextArea()).removeTrailingWhitespace();
                } else if (source == this.replaceTabsWithSpaces) {
                    this.getTextArea().convertTabsToSpaces();
                } else if (source == this.replaceSpacesWithTabs) {
                    this.getTextArea().convertSpacesToTabs();
                } else if (source == this.zapGremlins) {
                    this.zapGremlins();
                }
            }
        }
    }

    private void setAutoCompletionEnabled(boolean enabled) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setAutoCompletion(enabled);
        }
        this.keylessAutocompletion.setEnabled(enabled);
        this.fallbackAutocompletion.setEnabled(enabled);
    }

    private void setTabsEmulated(boolean emulated) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setTabsEmulated(emulated);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setPaintTabLines(boolean paint) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setPaintTabLines(paint);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setKeylessAutoCompletion(boolean noKeyRequired) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setKeylessAutoCompletion(noKeyRequired);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setFallbackAutoCompletion(boolean fallback) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setFallbackAutoCompletion(fallback);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setMarkOccurrences(boolean markOccurrences) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setMarkOccurrences(markOccurrences);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setWhiteSpaceVisible(boolean visible) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setWhitespaceVisible(visible);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setWrapLines(boolean wrap) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setLineWrap(wrap);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private void setMarginLineEnabled(boolean enabled) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            this.getEditorPane(i).setMarginLineEnabled(enabled);
        }
        this.getEditorPane().requestFocusInWindow();
    }

    private JMenu applyThemeMenu() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Default", "default");
        map.put("-", "-");
        map.put("Dark", "dark");
        map.put("Druid", "druid");
        map.put("Monokai", "monokai");
        map.put("Eclipse (Light)", "eclipse");
        map.put("IntelliJ (Light)", "idea");
        map.put("Visual Studio (Light)", "vs");
        this.themeRadioGroup = new ButtonGroup();
        JMenu menu = new JMenu("Theme");
        map.forEach((k, v) -> {
            if ("-".equals(k)) {
                menu.addSeparator();
                return;
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem((String)k);
            item.setActionCommand((String)v);
            this.themeRadioGroup.add(item);
            item.addActionListener(e -> {
                try {
                    this.applyTheme((String)v, false);
                    this.prefService.put((Class<?>)EditorPane.class, "script.editor.theme", (String)v);
                }
                catch (IllegalArgumentException ex) {
                    this.error("Theme could not be loaded. See Console for details.");
                    ex.printStackTrace();
                }
            });
            menu.add(item);
        });
        return menu;
    }

    public void applyTheme(String theme) throws IllegalArgumentException {
        this.applyTheme(theme, true);
    }

    private void applyTheme(String theme, boolean updateMenus) throws IllegalArgumentException {
        try {
            Theme th = TextEditor.getTheme(theme);
            if (th == null) {
                this.writeError("Unrecognized theme ignored: '" + theme + "'");
                return;
            }
            for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
                this.getEditorPane(i).applyTheme(theme);
            }
        }
        catch (Exception ex) {
            this.activeTheme = "default";
            this.updateThemeControls("default");
            this.writeError("Could not load theme. See Console for details.");
            this.updateThemeControls(this.activeTheme);
            throw new IllegalArgumentException(ex);
        }
        this.activeTheme = theme;
        if (updateMenus) {
            this.updateThemeControls(theme);
        }
    }

    static Theme getTheme(String theme) throws IllegalArgumentException {
        try {
            return Theme.load((InputStream)TextEditor.class.getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + theme + ".xml"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private void updateThemeControls(String theme) {
        if (this.themeRadioGroup != null) {
            Enumeration<AbstractButton> choices = this.themeRadioGroup.getElements();
            while (choices.hasMoreElements()) {
                AbstractButton choice = choices.nextElement();
                if (!theme.equals(choice.getActionCommand())) continue;
                choice.setSelected(true);
                break;
            }
        }
    }

    private void collapseSplitPane(int pane, boolean collapse) {
        JSplitPane jsp;
        JSplitPane jSplitPane = jsp = pane == 0 ? this.body : this.getTab();
        if (collapse) {
            this.panePositions[pane] = jsp.getDividerLocation();
            if (pane == 0) {
                jsp.setDividerLocation(0.0);
            } else {
                jsp.setDividerLocation(1.0);
            }
        } else {
            boolean expanded;
            jsp.setDividerLocation(this.panePositions[pane]);
            boolean bl = expanded = pane == 0 ? this.isLeftPaneExpanded(jsp) : this.isRightOrBottomPaneExpanded(jsp);
            if (!expanded) {
                jsp.setDividerLocation(pane == 0 ? 0.2 : 0.75);
                this.panePositions[pane] = jsp.getDividerLocation();
            }
        }
    }

    private boolean isLeftPaneExpanded(JSplitPane pane) {
        return pane.isVisible() && pane.getLeftComponent().getWidth() > 0;
    }

    private boolean isRightOrBottomPaneExpanded(JSplitPane pane) {
        int dim = pane.getOrientation() == 0 ? pane.getRightComponent().getHeight() : pane.getRightComponent().getWidth();
        return pane.isVisible() && dim > 0;
    }

    protected boolean handleTabsMenu(Object source) {
        if (!(source instanceof JMenuItem)) {
            return false;
        }
        JMenuItem item = (JMenuItem)source;
        if (!this.tabsMenuItems.contains(item)) {
            return false;
        }
        for (int i = this.tabsMenuTabsStart; i < this.tabsMenu.getItemCount(); ++i) {
            if (this.tabsMenu.getItem(i) != item) continue;
            this.switchTo(i - this.tabsMenuTabsStart);
            return true;
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbed.getSelectedIndex();
        if (index < 0) {
            this.setTitle("");
            return;
        }
        EditorPane editorPane = this.getEditorPane(index);
        this.lockPane.setSelected(editorPane.isLocked());
        editorPane.requestFocus();
        this.checkForOutsideChanges();
        editorPane.setLanguageByFileName(editorPane.getFileName());
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
        this.setTitle();
    }

    public EditorPane getEditorPane(int index) {
        return this.getTab((int)index).editorPane;
    }

    public void findOrReplace(boolean doReplace) {
        this.findDialog.setLocationRelativeTo(this);
        this.findDialog.setRestrictToConsole(false);
        String selection = this.getEditorPane().getSelectedText();
        if (selection != null) {
            this.findDialog.setSearchPattern(selection);
        }
        this.findDialog.show(doReplace && !this.getEditorPane().isLocked());
    }

    public void gotoLine() {
        String line = GuiUtils.getString(this, "Enter line number:", "Goto Line");
        if (line == null) {
            return;
        }
        try {
            this.gotoLine(Integer.parseInt(line));
        }
        catch (BadLocationException e) {
            this.error("Line number out of range: " + line);
        }
        catch (NumberFormatException e) {
            this.error("Invalid line number: " + line);
        }
    }

    public void gotoLine(int line) throws BadLocationException {
        this.getTextArea().setCaretPosition(this.getTextArea().getLineStartOffset(line - 1));
    }

    public void toggleBookmark() {
        this.getEditorPane().toggleBookmark();
    }

    private Vector<Bookmark> getAllBookmarks() {
        Vector<Bookmark> bookmarks = new Vector<Bookmark>();
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            TextEditorTab tab = (TextEditorTab)this.tabbed.getComponentAt(i);
            tab.editorPane.getBookmarks(tab, bookmarks);
        }
        if (bookmarks.isEmpty()) {
            this.info("No Bookmarks currently exist.\nYou can bookmark lines by clicking next to their line number.", "No Bookmarks");
        }
        return bookmarks;
    }

    public void listBookmarks() {
        Vector<Bookmark> bookmarks = this.getAllBookmarks();
        if (!bookmarks.isEmpty()) {
            new BookmarkDialog((Frame)this, bookmarks).setVisible(true);
        }
    }

    void clearAllBookmarks() {
        Vector<Bookmark> bookmarks = this.getAllBookmarks();
        if (bookmarks.isEmpty()) {
            return;
        }
        if (this.confirm("Delete all bookmarks?", "Confirm Deletion?", "Delete")) {
            bookmarks.forEach(bk -> bk.tab.editorPane.toggleBookmark(bk.getLineNumber()));
        }
    }

    public boolean reload() {
        return this.reload("Reload the file?");
    }

    public boolean reload(String message) {
        return this.reloadRevert(message, "Reload");
    }

    private boolean reloadRevert(String message, String title) {
        EditorPane editorPane = this.getEditorPane();
        File file = editorPane.getFile();
        if (file == null || !file.exists()) {
            return true;
        }
        boolean modified = editorPane.fileChanged();
        Object[] options = new String[]{title, "Do Not " + title};
        if (modified) {
            options[0] = title + " (Discard Changes)";
        }
        switch (JOptionPane.showOptionDialog(this, message, title + "?", -1, 2, null, options, options[0])) {
            case 0: {
                try {
                    editorPane.open(file);
                    return true;
                }
                catch (IOException e) {
                    this.error("Could not reload " + file.getPath());
                    this.updateLanguageMenu(editorPane.getCurrentLanguage());
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBinary(File file) {
        if (file == null) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int count;
            int left = 8000;
            byte[] buffer = new byte[left];
            if (left > 0 && (count = in.read(buffer, 0, left)) >= 0) {
                int i = 0;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public TextEditorTab newTab(String content, String languageExtension) {
        String lang = languageExtension;
        TextEditorTab tab = this.open(null);
        if (null != lang && lang.length() > 0) {
            if ('.' != (lang = lang.trim().toLowerCase()).charAt(0)) {
                lang = "." + languageExtension;
            }
            tab.editorPane.setLanguage(this.scriptService.getLanguageByName(languageExtension));
        } else {
            String lastLanguageName = this.prefService.get(this.getClass(), LAST_LANGUAGE);
            if (null != lastLanguageName && "none" != lastLanguageName) {
                this.setLanguage(this.scriptService.getLanguageByName(lastLanguageName));
            }
        }
        if (null != content) {
            tab.editorPane.setText(content);
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextEditorTab open(File file) {
        if (TextEditor.isBinary(file)) {
            try {
                this.uiService.show(this.ioService.open(file.getAbsolutePath()));
            }
            catch (IOException e) {
                this.log.error(e);
            }
            return null;
        }
        try {
            TextEditorTab tab;
            TextEditorTab prior = tab = this.tabbed.getTabCount() == 0 ? null : this.getTab();
            boolean wasNew = tab != null && tab.editorPane.isNew();
            float font_size = 0.0f;
            if (!wasNew) {
                if (this.tabbed.getTabCount() > 0) {
                    font_size = this.getTab().getEditorPane().getFont().getSize2D();
                }
                tab = new TextEditorTab(this);
                this.context.inject(tab.editorPane);
                tab.editorPane.loadPreferences();
                this.addDefaultAccelerators(tab.editorPane);
            } else if (this.undo == null) {
                this.assembleEditMenu();
            }
            EditorPane editorPane = tab.editorPane;
            synchronized (editorPane) {
                tab.editorPane.open(file);
                if (wasNew) {
                    int index = this.tabbed.getSelectedIndex() + this.tabsMenuTabsStart;
                    this.tabsMenu.getItem(index).setText(tab.editorPane.getFileName());
                } else {
                    this.tabbed.addTab("", tab);
                    this.switchTo(this.tabbed.getTabCount() - 1);
                    this.tabsMenuItems.add(this.addToMenu(this.tabsMenu, tab.editorPane.getFileName(), 0, 0));
                }
                this.setEditorPaneFileName(tab.editorPane.getFile());
                try {
                    this.updateTabAndFontSize(true);
                    if (font_size > 0.0f) {
                        this.setFontSize(font_size);
                    }
                    if (null != prior) {
                        tab.setOrientation(prior.getOrientation());
                        tab.setDividerLocation(prior.getDividerLocation());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (file != null) {
                this.openRecent.add(file.getAbsolutePath());
            } else {
                String lastLanguageName = this.prefService.get(this.getClass(), LAST_LANGUAGE);
                if ("none" != lastLanguageName) {
                    this.setLanguage(this.scriptService.getLanguageByName(lastLanguageName));
                }
            }
            this.updateLanguageMenu(tab.editorPane.getCurrentLanguage());
            tab.editorPane.getDocument().addDocumentListener(this);
            tab.editorPane.requestFocusInWindow();
            return tab;
        }
        catch (FileNotFoundException e) {
            this.log.error(e);
            this.error("The file\n'" + file + "' was not found.");
        }
        catch (Exception e) {
            this.log.error(e);
            this.error("There was an error while opening\n'" + file + "': " + e);
        }
        return null;
    }

    public boolean saveAs() {
        File fileToSave;
        EditorPane editorPane = this.getEditorPane();
        File file = editorPane.getFile();
        if (file == null) {
            File ijDir = this.appService.getApp().getBaseDirectory();
            file = new File(ijDir, editorPane.getFileName());
        }
        if ((fileToSave = this.uiService.chooseFile(file, "save")) == null) {
            return false;
        }
        return this.saveAs(fileToSave.getAbsolutePath(), true);
    }

    public void saveAs(String path) {
        this.saveAs(path, true);
    }

    public boolean saveAs(String path, boolean askBeforeReplacing) {
        File file = new File(path);
        if (file.exists() && askBeforeReplacing && this.confirm("Do you want to replace " + path + "?", "Replace " + path + "?", "Replace")) {
            return false;
        }
        if (!this.write(file)) {
            return false;
        }
        this.setEditorPaneFileName(file);
        this.openRecent.add(path);
        return true;
    }

    public boolean save() {
        File file = this.getEditorPane().getFile();
        if (file == null) {
            return this.saveAs();
        }
        if (!this.write(file)) {
            return false;
        }
        this.setTitle();
        return true;
    }

    public boolean write(File file) {
        try {
            this.getEditorPane().write(file);
            return true;
        }
        catch (IOException e) {
            this.log.error(e);
            this.error("Could not save " + file.getName());
            return false;
        }
    }

    public boolean makeJar(boolean includeSources) {
        File file = this.getEditorPane().getFile();
        if ((file == null || this.isCompiled()) && !this.handleUnsavedChanges(true)) {
            return false;
        }
        String name = this.getEditorPane().getFileName();
        String ext = FileUtils.getExtension(name);
        if (!"".equals(ext)) {
            name = name.substring(0, name.length() - ext.length());
        }
        if (name.indexOf(95) < 0) {
            name = name + "_";
        }
        name = name + ".jar";
        File selectedFile = this.uiService.chooseFile(file, "save");
        if (selectedFile == null) {
            return false;
        }
        if (selectedFile.exists() && this.confirm("Do you want to replace " + selectedFile + "?", "Replace " + selectedFile + "?", "Replace")) {
            return false;
        }
        try {
            this.makeJar(selectedFile, includeSources);
            return true;
        }
        catch (IOException e) {
            this.log.error(e);
            this.error("Could not write " + selectedFile + ": " + e.getMessage());
            return false;
        }
    }

    public void makeJar(File file, boolean includeSources) throws IOException {
        if (!this.handleUnsavedChanges(true)) {
            return;
        }
        ScriptEngine interpreter = this.getCurrentLanguage().getScriptEngine();
        if (interpreter instanceof JavaEngine) {
            JavaEngine java = (JavaEngine)interpreter;
            JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
            this.markCompileStart();
            this.getTab().showErrors();
            new Thread(() -> {
                java.makeJar(this.getEditorPane().getFile(), includeSources, file, (Writer)errors);
                this.errorScreen.insert("Compilation finished.\n", this.errorScreen.getDocument().getLength());
                this.markCompileEnd();
            }).start();
        }
    }

    static void getClasses(File directory, List<String> paths, List<String> names) {
        TextEditor.getClasses(directory, paths, names, "");
    }

    static void getClasses(File directory, List<String> paths, List<String> names, String inPrefix) {
        String prefix = inPrefix;
        if (!prefix.equals("")) {
            prefix = prefix + "/";
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                TextEditor.getClasses(file, paths, names, prefix + file.getName());
                continue;
            }
            paths.add(file.getAbsolutePath());
            names.add(prefix + file.getName());
        }
    }

    static void writeJarEntry(JarOutputStream out, String name, byte[] buf) throws IOException {
        try {
            JarEntry entry = new JarEntry(name);
            out.putNextEntry(entry);
            out.write(buf, 0, buf.length);
            out.closeEntry();
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
    }

    static byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            ((InputStream)in).read(buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }

    static void deleteRecursively(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                TextEditor.deleteRecursively(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    void setLanguage(ScriptLanguage language) {
        this.setLanguage(language, false);
    }

    void setLanguage(ScriptLanguage language, boolean addHeader) {
        if (null != this.getCurrentLanguage() && (null == language || this.getCurrentLanguage().getLanguageName() != language.getLanguageName())) {
            this.scriptInfo = null;
        }
        this.getEditorPane().setLanguage(language, addHeader);
        this.prefService.put(this.getClass(), LAST_LANGUAGE, null == language ? "none" : language.getLanguageName());
        this.setTitle();
        this.updateLanguageMenu(language);
        this.updateUI(true);
    }

    void updateLanguageMenu(ScriptLanguage language) {
        String supportStatus;
        JMenuItem item = this.languageMenuItems.get(language);
        if (item == null) {
            item = this.noneLanguageItem;
            this.setIncremental(false);
        }
        if (!item.isSelected()) {
            item.setSelected(true);
        }
        if ((supportStatus = this.getEditorPane().getSupportStatus()) != null && !Objects.equals(supportStatus, this.lastSupportStatus)) {
            this.write(supportStatus);
            this.lastSupportStatus = supportStatus;
        }
        boolean isRunnable = item != this.noneLanguageItem;
        boolean isCompileable = language != null && language.isCompiledLanguage();
        this.runMenu.setEnabled(isRunnable);
        this.compileAndRun.setText(isCompileable ? "Compile and Run" : "Run");
        this.compileAndRun.setEnabled(isRunnable);
        this.runSelection.setEnabled(isRunnable && !isCompileable);
        this.compile.setEnabled(isCompileable);
        this.autoSave.setEnabled(isCompileable);
        this.makeJar.setEnabled(isCompileable);
        this.makeJarWithSource.setEnabled(isCompileable);
        boolean isJava = language != null && language.getLanguageName().equals("Java");
        this.addImport.setEnabled(isJava);
        this.removeUnusedImports.setEnabled(isJava);
        this.sortImports.setEnabled(isJava);
        boolean isMacro = language != null && language.getLanguageName().equals("ImageJ Macro");
        this.openMacroFunctions.setEnabled(isMacro);
        this.openSourceForClass.setEnabled(!isMacro);
        this.openHelp.setEnabled(!isMacro && isRunnable);
        this.openHelpWithoutFrames.setEnabled(!isMacro && isRunnable);
        this.nextError.setEnabled(!isMacro && isRunnable);
        this.previousError.setEnabled(!isMacro && isRunnable);
        boolean isInGit = this.getEditorPane().getGitDirectory() != null;
        this.gitMenu.setVisible(isInGit);
        this.updateUI(false);
    }

    @Deprecated
    public void updateTabAndFontSize(boolean setByLanguage) {
        this.updateUI(setByLanguage);
    }

    public void updateUI(boolean setByLanguage) {
        EditorPane pane = this.getEditorPane();
        if (setByLanguage && pane.getCurrentLanguage() != null) {
            if (pane.getCurrentLanguage().getLanguageName().equals("Python")) {
                pane.setTabSize(4);
            } else {
                pane.resetTabSize();
            }
        }
        int tabSize = pane.getTabSize();
        boolean defaultSize = false;
        for (int i = 0; i < this.tabSizeMenu.getItemCount(); ++i) {
            JMenuItem item = this.tabSizeMenu.getItem(i);
            if (item == this.chooseTabSize) {
                item.setSelected(!defaultSize);
                item.setText("Other" + (defaultSize ? "" : " (" + tabSize + ")") + "...");
                continue;
            }
            if (tabSize != Integer.parseInt(item.getText())) continue;
            item.setSelected(true);
            defaultSize = true;
        }
        this.getTab().prompt.setTabSize(this.getEditorPane().getTabSize());
        int fontSize = (int)pane.getFontSize();
        defaultSize = false;
        for (int i = 0; i < this.fontSizeMenu.getItemCount(); ++i) {
            JMenuItem item = this.fontSizeMenu.getItem(i);
            if (item == this.chooseFontSize) {
                item.setSelected(!defaultSize);
                item.setText("Other" + (defaultSize ? "" : " (" + fontSize + ")") + "...");
                continue;
            }
            String label = item.getText();
            if (label.endsWith(" pt")) {
                label = label.substring(0, label.length() - 3);
            }
            if (fontSize != Integer.parseInt(label)) continue;
            item.setSelected(true);
            defaultSize = true;
        }
        this.markOccurences.setState(pane.getMarkOccurrences());
        this.wrapLines.setState(pane.getLineWrap());
        this.marginLine.setState(pane.isMarginLineEnabled());
        this.tabsEmulated.setState(pane.getTabsEmulated());
        this.paintTabs.setState(pane.getPaintTabLines());
        this.whiteSpace.setState(pane.isWhitespaceVisible());
        this.autocompletion.setState(pane.isAutoCompletionEnabled());
        this.fallbackAutocompletion.setState(pane.isAutoCompletionFallbackEnabled());
        this.keylessAutocompletion.setState(pane.isAutoCompletionKeyless());
        this.sourceTreePanel.rebuildSourceTree(pane);
    }

    public void setEditorPaneFileName(String baseName) {
        this.getEditorPane().setFileName(baseName);
    }

    public void setEditorPaneFileName(File file) {
        EditorPane editorPane = this.getEditorPane();
        editorPane.setFileName(file);
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
        this.updateGitDirectory();
    }

    void setTitle() {
        EditorPane editorPane = this.getEditorPane();
        boolean fileChanged = editorPane.fileChanged();
        String fileName = editorPane.getFileName();
        String title = (fileChanged ? "*" : "") + fileName + (this.executingTasks.isEmpty() ? "" : " (Running)");
        SwingUtilities.invokeLater(() -> {
            this.setTitle(title);
            for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
                this.tabbed.setTitleAt(i, ((TextEditorTab)this.tabbed.getComponentAt(i)).getTitle());
            }
        });
    }

    @Override
    public synchronized void setTitle(String title) {
        JMenuItem item;
        super.setTitle(title);
        int index = this.tabsMenuTabsStart + this.tabbed.getSelectedIndex();
        if (index < this.tabsMenu.getItemCount() && (item = this.tabsMenu.getItem(index)) != null) {
            item.setText(title);
        }
    }

    public List<Executer> getExecutingTasks() {
        return this.executingTasks;
    }

    public void kill(Executer executer) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            TextEditorTab tab = (TextEditorTab)this.tabbed.getComponentAt(i);
            if (executer != tab.getExecuter()) continue;
            tab.kill();
            break;
        }
    }

    public void chooseTaskToKill() {
        if (this.executingTasks.size() == 0) {
            this.error("\nNo running scripts\n");
            return;
        }
        this.commandService.run(KillScript.class, true, "editor", this);
    }

    public void runText() {
        this.runText(false);
    }

    public void runText(boolean selectionOnly) {
        if (this.isCompiled()) {
            if (selectionOnly) {
                this.error("Cannot run selection of compiled language!");
                return;
            }
            if (this.handleUnsavedChanges(true)) {
                this.runScript();
            } else {
                this.write("Compiled languages must be saved before they can be run.");
            }
            return;
        }
        ScriptLanguage currentLanguage = this.getCurrentLanguage();
        if (currentLanguage == null) {
            this.error("Select a language first!");
            return;
        }
        this.markCompileStart();
        try {
            TextEditorTab tab = this.getTab();
            tab.showOutput();
            this.execute(selectionOnly);
        }
        catch (Throwable t) {
            this.log.error(t);
        }
    }

    public void runBatch() {
        if (null == this.getCurrentLanguage()) {
            this.error("Select a language first! Also, please note that this option\nrequires at least one @File parameter to be declared in the script.");
            return;
        }
        String script = this.getTab().getEditorPane().getText();
        if (script.trim().isEmpty()) {
            this.error("This option requires at least one @File parameter to be declared.");
            return;
        }
        ScriptInfo info = new ScriptInfo(this.context, "dummy." + this.getCurrentLanguage().getExtensions().get(0), new StringReader(script));
        this.batchService.run((ModuleInfo)info);
    }

    private void execute(boolean selectionOnly) throws IOException {
        String text;
        TextEditorTab tab = this.getTab();
        if (selectionOnly) {
            String selected = tab.getEditorPane().getSelectedText();
            if (selected == null) {
                this.error("Selection required!");
                text = null;
            } else {
                text = selected + "\n";
            }
            this.getEditorPane().getErrorHighlighter().setSelectedCodeExecution(true);
        } else {
            text = tab.getEditorPane().getText();
        }
        this.execute(tab, text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final TextEditorTab tab, final String text, final boolean writeCommandLog) throws IOException {
        tab.prepare();
        JTextAreaWriter output = new JTextAreaWriter(tab.screen, this.log);
        JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
        final File file = this.getEditorPane().getFile();
        final PipedInputStream pi = new PipedInputStream();
        final PipedOutputStream po = new PipedOutputStream(pi);
        tab.setExecutor(new Executer(output, errors){

            @Override
            public void execute() {
                try {
                    TextEditor.this.evalScript(file == null ? TextEditor.this.getEditorPane().getFileName() : file.getAbsolutePath(), new InputStreamReader(pi), this.output, this.errors);
                    this.output.flush();
                    this.errors.flush();
                    TextEditor.this.markCompileEnd();
                    if (writeCommandLog && null != text && text.trim().length() > 0) {
                        TextEditor.this.writePromptLog(TextEditor.this.getEditorPane().getCurrentLanguage(), text);
                    }
                }
                catch (Throwable t) {
                    this.output.flush();
                    this.errors.flush();
                    if (t instanceof ScriptException && t.getCause() != null && t.getCause().getClass().getName().endsWith("CompileError")) {
                        TextEditor.this.errorScreen.append("Compilation failed");
                        tab.showErrors();
                    } else {
                        TextEditor.this.handleException(t);
                    }
                }
                finally {
                    tab.restore();
                }
            }
        });
        try {
            new Thread(){
                {
                    this.setPriority(5);
                }

                @Override
                public void run() {
                    try (PrintWriter pw = new PrintWriter(po);){
                        pw.write(text);
                        pw.flush();
                    }
                }
            }.start();
        }
        catch (Throwable t) {
            this.log.error(t);
        }
        finally {
            tab.getEditorPane().setEditable(true);
        }
    }

    private String getPromptCommandsFilename(ScriptLanguage language) {
        String name = language.getLanguageName().replace('/', '_');
        return System.getProperty("user.home").replace('\\', '/') + "/.scijava/" + name + ".command.log";
    }

    private void writePromptLog(ScriptLanguage language, String text) {
        String path = this.getPromptCommandsFilename(language);
        File file = new File(path);
        try {
            boolean exists = file.exists();
            if (!exists) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            Files.write(Paths.get(path, new String[0]), Arrays.asList(text, "#"), Charset.forName("UTF-8"), StandardOpenOption.APPEND, StandardOpenOption.DSYNC);
        }
        catch (IOException e) {
            this.log.error("Failed to write executed prompt command to file " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> loadPromptLog(ScriptLanguage language) {
        String path = this.getPromptCommandsFilename(language);
        File file = new File(path);
        ArrayList<String> lines = new ArrayList<String>();
        if (!file.exists()) {
            return lines;
        }
        RandomAccessFile ra = null;
        List commands = new ArrayList<String>();
        try {
            ra = new RandomAccessFile(path, "r");
            byte[] bytes = new byte[(int)ra.length()];
            ra.readFully(bytes);
            String sep = System.getProperty("line.separator");
            commands.addAll(Arrays.asList(new String(bytes, Charset.forName("UTF-8")).split((String)sep + "#" + (String)sep)));
            if (0 == ((String)commands.get(commands.size() - 1)).length()) {
                commands.remove(commands.size() - 1);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to read history of prompt commands from file " + path, e);
            ArrayList<String> sep = lines;
            return sep;
        }
        finally {
            try {
                if (null != ra) {
                    ra.close();
                }
            }
            catch (IOException e) {
                this.log.error(e);
            }
        }
        if (commands.size() > 1000) {
            commands = commands.subList(commands.size() - 1000, commands.size());
            ArrayList<String> croppedLog = new ArrayList<String>();
            for (String c : commands) {
                croppedLog.add(c);
                croppedLog.add("#");
            }
            try {
                Files.write(Paths.get(path + "-tmp", new String[0]), croppedLog, Charset.forName("UTF-8"), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DSYNC);
                if (!new File(path + "-tmp").renameTo(new File(path))) {
                    this.log.error("Could not rename command log file " + path + "-tmp to " + path);
                }
            }
            catch (Exception e) {
                this.log.error("Failed to crop history of prompt commands file " + path, e);
            }
        }
        lines.addAll(commands);
        return lines;
    }

    public void runScript() {
        if (this.isCompiled()) {
            this.getTab().showErrors();
        } else {
            this.getTab().showOutput();
        }
        this.markCompileStart();
        JTextAreaWriter output = new JTextAreaWriter(this.getTab().screen, this.log);
        JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
        final File file = this.getEditorPane().getFile();
        new Executer(output, errors){

            @Override
            public void execute() {
                try (Reader reader = TextEditor.this.evalScript(file.getPath(), new FileReader(file), this.output, this.errors);){
                    this.output.flush();
                    this.errors.flush();
                    TextEditor.this.markCompileEnd();
                }
                catch (Throwable e) {
                    TextEditor.this.handleException(e);
                }
            }
        };
    }

    public void compile() {
        if (!this.handleUnsavedChanges(true)) {
            return;
        }
        ScriptEngine interpreter = this.getCurrentLanguage().getScriptEngine();
        if (interpreter instanceof JavaEngine) {
            JavaEngine java = (JavaEngine)interpreter;
            JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
            this.markCompileStart();
            this.getTab().showErrors();
            new Thread(() -> {
                java.compile(this.getEditorPane().getFile(), (Writer)errors);
                this.errorScreen.insert("Compilation finished.\n", this.errorScreen.getDocument().getLength());
                this.markCompileEnd();
            }).start();
        }
    }

    private String getSelectedTextOrAsk(String msg, String title) {
        String selection = this.getTextArea().getSelectedText();
        if (selection == null || selection.indexOf(10) >= 0) {
            return GuiUtils.getString(this, msg + "\nAlternatively, select a class declaration and re-run.", title);
        }
        return selection;
    }

    private String getSelectedClassNameOrAsk(String msg, String title) {
        String className = this.getSelectedTextOrAsk(msg, title);
        if (className != null) {
            className = className.trim();
        }
        return className;
    }

    private static void append(JTextArea textArea, String text) {
        int length = textArea.getDocument().getLength();
        textArea.insert(text, length);
        textArea.setCaretPosition(length);
    }

    public void markCompileStart() {
        this.markCompileStart(true);
    }

    public void markCompileStart(boolean with_timestamp) {
        this.errorHandler = null;
        if (with_timestamp) {
            String started = "Started " + this.getEditorPane().getFileName() + " at " + new Date() + "\n";
            TextEditor.append(this.errorScreen, started);
            TextEditor.append(this.getTab().screen, started);
        }
        int offset = this.errorScreen.getDocument().getLength();
        this.compileStartOffset = this.errorScreen.getDocument().getLength();
        try {
            this.compileStartPosition = this.errorScreen.getDocument().createPosition(offset);
        }
        catch (BadLocationException e) {
            this.handleException(e);
        }
        ExceptionHandler.addThread(Thread.currentThread(), this);
    }

    public void markCompileEnd() {
        if (this.errorHandler == null) {
            this.errorHandler = new ErrorHandler(this.getCurrentLanguage(), this.errorScreen, this.compileStartPosition.getOffset());
            if (this.errorHandler.getErrorCount() > 0) {
                this.getTab().showErrors();
            }
        }
        if (this.getEditorPane().getErrorHighlighter().isLogDetailed() && this.compileStartOffset != this.errorScreen.getDocument().getLength()) {
            this.getTab().showErrors();
        }
        if (this.getTab().showingErrors) {
            this.errorHandler.scrollToVisible(this.compileStartOffset);
        }
    }

    public boolean nextError(boolean forward) {
        if (this.errorHandler != null && this.errorHandler.nextError(forward)) {
            try {
                File file = new File(this.errorHandler.getPath());
                if (!file.isAbsolute()) {
                    file = this.getFileForBasename(file.getName());
                }
                this.errorHandler.markLine();
                this.switchTo(file, this.errorHandler.getLine());
                this.getTab().showErrors();
                this.errorScreen.invalidate();
                return true;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return false;
    }

    public void switchTo(String path, int lineNumber) throws IOException {
        this.switchTo(new File(path).getCanonicalFile(), lineNumber);
    }

    public void switchTo(File file, int lineNumber) {
        if (!this.editorPaneContainsFile(this.getEditorPane(), file)) {
            this.switchTo(file);
        }
        SwingUtilities.invokeLater(() -> {
            try {
                this.gotoLine(lineNumber);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    public void switchTo(File file) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (!this.editorPaneContainsFile(this.getEditorPane(i), file)) continue;
            this.switchTo(i);
            return;
        }
        this.open(file);
    }

    public void switchTo(int index) {
        if (index == this.tabbed.getSelectedIndex()) {
            return;
        }
        this.tabbed.setSelectedIndex(index);
    }

    private void switchTabRelative(int delta) {
        int count = this.tabbed.getTabCount();
        int index = (this.tabbed.getSelectedIndex() + delta) % count;
        if (index < 0) {
            index += count;
        }
        this.switchTo(index);
    }

    private void removeTab(int index) {
        int menuItemIndex = index + this.tabsMenuTabsStart;
        try {
            this.tabbed.remove(index);
            this.tabsMenuItems.remove(this.tabsMenu.getItem(menuItemIndex));
            this.tabsMenu.remove(menuItemIndex);
        }
        catch (IndexOutOfBoundsException e) {
            this.log.debug(e);
        }
    }

    boolean editorPaneContainsFile(EditorPane editorPane, File file) {
        try {
            return file != null && editorPane != null && editorPane.getFile() != null && file.getCanonicalFile().equals(editorPane.getFile().getCanonicalFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getFile() {
        return this.getEditorPane().getFile();
    }

    public File getFileForBasename(String baseName) {
        File file = this.getFile();
        if (file != null && file.getName().equals(baseName)) {
            return file;
        }
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            file = this.getEditorPane(i).getFile();
            if (file == null || !file.getName().equals(baseName)) continue;
            return file;
        }
        return null;
    }

    private void updateGitDirectory() {
        EditorPane editorPane = this.getEditorPane();
        editorPane.setGitDirectory(new FileFunctions(this).getGitDirectory(editorPane.getFile()));
    }

    public void addImport(String className) {
        if (className != null) {
            new TokenFunctions(this.getTextArea()).addImport(className.trim());
        }
    }

    public void openHelp(String className) {
        this.openHelp(className, true);
    }

    public void openHelp(String className, boolean withFrames) {
        String url;
        if (className == null) {
            className = this.getSelectedClassNameOrAsk("Class (fully qualified name):", "Online Javadocs...");
        }
        if (className == null) {
            return;
        }
        Class<?> c = Types.load(className, false);
        String path = (withFrames ? "index.html?" : "") + className.replace('.', '/') + ".html";
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            String javaVersion = System.getProperty("java.version");
            String majorVersion = javaVersion.startsWith("1.") ? javaVersion.substring(2, javaVersion.indexOf(46, 2)) : javaVersion.substring(0, javaVersion.indexOf(46));
            url = "https://javadoc.scijava.org/Java" + majorVersion + "/" + path;
        } else {
            POM pom = POM.getPOM(c);
            if (pom == null) {
                throw new IllegalArgumentException("Unknown origin for class " + className);
            }
            String releaseProfiles = pom.cdata("//properties/releaseProfiles");
            boolean scijavaRepo = "deploy-to-scijava".equals(releaseProfiles);
            if (scijavaRepo) {
                String g = pom.getGroupId();
                String project = "net.imagej".equals(g) ? ("ij".equals(pom.getArtifactId()) ? "ImageJ1" : "ImageJ") : ("io.scif".equals(g) ? "SCIFIO" : ("net.imglib2".equals(g) ? "ImgLib2" : ("org.bonej".equals(g) ? "BoneJ" : ("org.scijava".equals(g) ? "SciJava" : ("sc.fiji".equals(g) ? "Fiji" : "Java")))));
                url = "https://javadoc.scijava.org/" + project + "/" + path;
            } else {
                url = "https://javadoc.io/static/" + pom.getGroupId() + "/" + pom.getArtifactId() + "/" + pom.getVersion() + "/" + path;
            }
        }
        try {
            this.platformService.open(new URL(url));
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    public void openClassOrPackageHelp(String text) {
        if (text == null) {
            text = this.getSelectedClassNameOrAsk("Class or package (complete or partial name, e.g., 'ij'):", "Lookup Which Class/Package?");
        }
        if (null == text) {
            return;
        }
        new Thread(new FindClassSourceAndJavadoc(text)).start();
    }

    public void extractSourceJar() {
        File file = this.openWithDialog(null);
        if (file != null) {
            this.extractSourceJar(file);
        }
    }

    public void extractSourceJar(File file) {
        try {
            FileFunctions functions = new FileFunctions(this);
            File workspace = this.uiService.chooseFile(new File(System.getProperty("user.home")), "directory");
            if (workspace == null) {
                return;
            }
            List<String> paths = functions.extractSourceJar(file.getAbsolutePath(), workspace);
            for (String path : paths) {
                if (functions.isBinaryFile(path)) continue;
                this.open(new File(path));
                EditorPane pane = this.getEditorPane();
                new TokenFunctions(pane).removeTrailingWhitespace();
                if (!pane.fileChanged()) continue;
                this.save();
            }
        }
        catch (IOException e) {
            this.error("There was a problem opening " + file + ": " + e.getMessage());
        }
    }

    private File openWithDialog(File defaultDir) {
        return this.uiService.chooseFile(defaultDir, "open");
    }

    public void write(String message) {
        TextEditorTab tab = this.getTab();
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        tab.screen.insert(message, tab.screen.getDocument().getLength());
    }

    public void writeError(String message) {
        this.getTab().showErrors();
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        this.errorScreen.insert(message, this.errorScreen.getDocument().getLength());
    }

    void error(String message) {
        GuiUtils.error(this, message);
    }

    void warn(String message) {
        GuiUtils.warn(this, message);
    }

    void info(String message, String title) {
        GuiUtils.info(this, message, title);
    }

    boolean confirm(String message, String title, String yesButtonLabel) {
        return GuiUtils.confirm(this, message, title, yesButtonLabel);
    }

    void showHTMLDialog(String title, String htmlContents) {
        GuiUtils.showHTMLDialog(this, title, htmlContents);
    }

    public void handleException(Throwable e) {
        TextEditor.handleException(e, this.errorScreen);
        this.getEditorPane().getErrorHighlighter().parse(e);
        this.getTab().showErrors();
    }

    public static void handleException(Throwable e, JTextArea textArea) {
        CharArrayWriter writer = new CharArrayWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            e.printStackTrace(out);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                out.write("Caused by: ");
                cause.printStackTrace(out);
            }
        }
        textArea.append(writer.toString());
    }

    public int zapGremlins() {
        int count = this.getEditorPane().zapGremlins();
        String msg = count > 0 ? "Zap Gremlins converted " + count + " invalid characters to spaces" : "No invalid characters found!";
        this.info(msg, "Zap Gremlins");
        return count;
    }

    private boolean isCompiled() {
        ScriptLanguage language = this.getCurrentLanguage();
        if (language == null) {
            return false;
        }
        return language.isCompiledLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader evalScript(String filename, Reader reader, Writer output, JTextAreaWriter errors) throws ModuleException {
        ScriptLanguage language = this.getCurrentLanguage();
        if (!this.incremental || this.incremental && null == this.scriptInfo || language.isCompiledLanguage() || null != this.scriptInfo && null != this.scriptInfo.getLanguage() && this.scriptInfo.getLanguage().getLanguageName() != this.getCurrentLanguage().getLanguageName()) {
            if (this.respectAutoImports) {
                reader = DefaultAutoImporters.prefixAutoImports(this.context, language, reader, errors);
            }
            this.scriptInfo = new EditableScriptInfo(this.context, filename, reader);
            this.scriptInfo.setLanguage(language);
            this.module = this.scriptInfo.createModule();
            this.context.inject(this.module);
        } else {
            try {
                this.scriptInfo.setScript(reader);
            }
            catch (IOException e) {
                this.log.error(e);
            }
        }
        this.module.setOutputWriter(output);
        this.module.setErrorWriter(errors);
        this.getEditorPane().getErrorHighlighter().setEnabled(!this.respectAutoImports);
        this.getEditorPane().getErrorHighlighter().reset();
        this.getEditorPane().getErrorHighlighter().setWriter(errors);
        try {
            this.moduleService.run(this.module, true, new Object[0]).get();
        }
        catch (InterruptedException e) {
            this.error("Interrupted");
        }
        catch (ExecutionException e) {
            this.log.error(e);
        }
        finally {
            this.getEditorPane().getErrorHighlighter().parse();
        }
        return reader;
    }

    public void setIncremental(boolean incremental) {
        if (incremental && null == this.getCurrentLanguage()) {
            this.error("Select a language first!");
            return;
        }
        this.incremental = incremental;
        final JTextArea prompt = this.getTab().getPrompt();
        if (incremental) {
            this.getTab().setREPLVisible(true);
            prompt.addKeyListener(new KeyAdapter(){
                private final ArrayList<String> commands;
                private int index;
                {
                    this.commands = TextEditor.this.loadPromptLog(TextEditor.this.getCurrentLanguage());
                    this.index = this.commands.size();
                    this.commands.add("");
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                    int keyCode = ke.getKeyCode();
                    if (10 == keyCode) {
                        if (ke.isShiftDown() || ke.isAltDown() || ke.isAltGraphDown() || ke.isMetaDown() || ke.isControlDown()) {
                            prompt.insert("\n", prompt.getCaretPosition());
                            ke.consume();
                            return;
                        }
                        String text = prompt.getText();
                        if (null == text || 0 == text.trim().length()) {
                            ke.consume();
                            return;
                        }
                        try {
                            JTextArea screen = TextEditor.this.getTab().screen;
                            TextEditor.this.getTab().showOutput();
                            screen.append("> " + text + "\n");
                            this.commands.set(this.commands.size() - 1, prompt.getText());
                            this.commands.add("");
                            this.index = this.commands.size() - 1;
                            TextEditor.this.markCompileStart(false);
                            TextEditor.this.execute(TextEditor.this.getTab(), text, true);
                            prompt.setText("");
                            screen.scrollRectToVisible(screen.modelToView(screen.getDocument().getLength()));
                        }
                        catch (Throwable t) {
                            TextEditor.this.log.error(t);
                            prompt.requestFocusInWindow();
                        }
                        ke.consume();
                        return;
                    }
                    if (!(!TextEditor.this.getTab().updownarrows.isSelected() || ke.isShiftDown() || ke.isControlDown() || ke.isAltDown() || ke.isMetaDown())) {
                        switch (keyCode) {
                            case 38: {
                                keyCode = 33;
                                break;
                            }
                            case 40: {
                                keyCode = 34;
                            }
                        }
                    }
                    if (ke.isControlDown()) {
                        switch (keyCode) {
                            case 80: {
                                keyCode = 33;
                                break;
                            }
                            case 78: {
                                keyCode = 34;
                            }
                        }
                    }
                    if (33 == keyCode) {
                        if (this.commands.size() - 1 == this.index) {
                            this.commands.set(this.commands.size() - 1, prompt.getText());
                        }
                        if (this.index > 0) {
                            prompt.setText(this.commands.get(--this.index));
                        }
                        ke.consume();
                        return;
                    }
                    if (34 == keyCode) {
                        if (this.index < this.commands.size() - 1) {
                            prompt.setText(this.commands.get(++this.index));
                        }
                        ke.consume();
                        return;
                    }
                    if (this.commands.size() - 1 != this.index) {
                        this.index = this.commands.size() - 1;
                        this.commands.set(this.commands.size() - 1, prompt.getText());
                    }
                }
            });
        } else {
            prompt.setText("");
            prompt.setEnabled(false);
            for (KeyListener kl : prompt.getKeyListeners()) {
                prompt.removeKeyListener(kl);
            }
            this.getTab().setREPLVisible(false);
        }
    }

    private String adjustPath(String path, String langName) {
        String result = path.replace('_', ' ');
        if (langName != null && path.toLowerCase().startsWith(langName.toLowerCase() + "/")) {
            result = "Uncategorized" + result.substring(langName.length());
        }
        return result;
    }

    @Override
    public boolean confirmClose() {
        while (this.tabbed.getTabCount() > 0) {
            if (!this.handleUnsavedChanges()) {
                return false;
            }
            int index = this.tabbed.getSelectedIndex();
            this.removeTab(index);
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setTitle();
        this.checkForOutsideChanges();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setTitle();
        this.checkForOutsideChanges();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setTitle();
    }

    public void setFontSize(float size) {
        if (this.getEditorPane().getFontSize() != size) {
            this.getEditorPane().setFontSize(size);
        }
        this.changeFontSize(this.errorScreen, size);
        this.changeFontSize(this.getTab().screen, size);
        this.changeFontSize(this.getTab().prompt, size);
        this.updateTabAndFontSize(false);
        this.tree.setFont(this.tree.getFont().deriveFont(size));
    }

    private void changeFontSize(JTextArea a, float size) {
        a.setFont(a.getFont().deriveFont(size));
    }

    private void appendPreferences(JMenu menu) {
        JMenuItem item = new JMenuItem("Save Preferences");
        menu.add(item);
        item.addActionListener(e -> {
            this.getEditorPane().savePreferences(this.tree.getTopLevelFoldersString(), this.activeTheme);
            this.saveWindowSizeToPrefs();
            this.write("Script Editor: Preferences Saved...\n");
        });
        item = new JMenuItem("Reset...");
        menu.add(item);
        item.addActionListener(e -> {
            if (this.confirm("Reset preferences to defaults? (a restart may be required)", "Reset?", "Reset")) {
                this.resetLayout();
                this.prefService.clear(EditorPane.class);
                this.prefService.clear(TextEditor.class);
                this.write("Script Editor: Preferences Reset. Restart is recommended\n");
            }
        });
    }

    private JMenu helpMenu() {
        JMenu menu = new JMenu("Help");
        GuiUtils.addMenubarSeparator(menu, "Offline Help:");
        JMenuItem item = new JMenuItem("List Shortcuts...");
        item.addActionListener(e -> this.displayKeyMap());
        menu.add(item);
        item = new JMenuItem("List Recordable Actions...");
        item.addActionListener(e -> this.displayRecordableMap());
        menu.add(item);
        item = new JMenuItem("Task Tags How-To...");
        item.addActionListener(e -> this.showHTMLDialog("Task Tags Help", "<p>When inserted in source code comments, the following keywords will automatically register task definitions on the rightmost side of the Editor: <code>TODO</code>, <code>README</code>, and <code>HACK</code>.</p><ul><li>To add a task, simply type one of the keywords in a commented line, e.g., <code>TODO</code></li><li>To remove a task, delete the keyword from the comment</li><li>Mouse over the annotation mark to access a summary of the task</li><li>Click on the mark to go to the annotated line</li></ul>"));
        menu.add(item);
        GuiUtils.addMenubarSeparator(menu, "Contextual Help:");
        menu.add(this.openHelpWithoutFrames);
        this.openHelpWithoutFrames.setMnemonic(79);
        menu.add(this.openHelp);
        this.openClassOrPackageHelp = this.addToMenu(menu, "Lookup Class or Package...", 0, 0);
        this.openClassOrPackageHelp.setMnemonic(83);
        menu.add(this.openMacroFunctions);
        GuiUtils.addMenubarSeparator(menu, "Online Resources:");
        menu.add(this.helpMenuItem("Image.sc Forum ", "https://forum.image.sc/"));
        menu.add(this.helpMenuItem("ImageJ Search Portal", "https://search.imagej.net/"));
        menu.add(this.helpMenuItem("SciJava Javadoc Portal", "https://javadoc.scijava.org/"));
        menu.add(this.helpMenuItem("SciJava Maven Repository", "https://maven.scijava.org/"));
        menu.addSeparator();
        menu.add(this.helpMenuItem("Fiji on GitHub", "https://github.com/fiji"));
        menu.add(this.helpMenuItem("SciJava on GitHub", "https://github.com/scijava/"));
        menu.addSeparator();
        menu.add(this.helpMenuItem("ImageJ Macro Functions", "https://imagej.nih.gov/ij/developer/macro/functions.html"));
        menu.add(this.helpMenuItem("ImageJ Docs: Development", "https://imagej.net/develop/"));
        menu.add(this.helpMenuItem("ImageJ Docs: Scripting", "https://imagej.net/scripting/"));
        menu.addSeparator();
        menu.add(this.helpMenuItem("ImageJ Notebook Tutorials", "https://github.com/imagej/tutorials#readme"));
        return menu;
    }

    private JMenuItem helpMenuItem(String label, String url) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(e -> GuiUtils.openURL(this, this.platformService, url));
        return item;
    }

    protected void applyConsolePopupMenu(JTextArea textArea) {
        JPopupMenu popup = new JPopupMenu();
        textArea.setComponentPopupMenu(popup);
        String scope = textArea == this.errorScreen ? "Errors..." : "Outputs...";
        JMenuItem jmi = new JMenuItem("Search " + scope);
        popup.add(jmi);
        jmi.addActionListener(e -> {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.setRestrictToConsole(true);
            String text = textArea.getSelectedText();
            if (text != null) {
                this.findDialog.setSearchPattern(text);
            }
            if (textArea == this.errorScreen && !this.getTab().showingErrors) {
                this.getTab().showErrors();
            } else if (this.getTab().showingErrors) {
                this.getTab().showOutput();
            }
            this.findDialog.show(false);
        });
        this.cmdPalette.register(jmi, scope);
        jmi = new JMenuItem("Search Script for Selected Text...");
        popup.add(jmi);
        jmi.addActionListener(e -> {
            String text = textArea.getSelectedText();
            if (text == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            } else {
                this.findDialog.setLocationRelativeTo(this);
                this.findDialog.setRestrictToConsole(false);
                if (text != null) {
                    this.findDialog.setSearchPattern(text);
                }
                this.findDialog.show(false);
            }
        });
        popup.addSeparator();
        jmi = new JMenuItem("Clear Selected Text");
        popup.add(jmi);
        jmi.addActionListener(e -> {
            if (textArea.getSelectedText() == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            } else {
                textArea.replaceSelection("");
            }
        });
        DefaultHighlighter highlighter = (DefaultHighlighter)textArea.getHighlighter();
        highlighter.setDrawsLayeredHighlights(false);
        jmi = new JMenuItem("Highlight Selected Text");
        popup.add(jmi);
        jmi.addActionListener(e -> {
            try {
                Color taint = textArea == this.errorScreen ? Color.RED : textArea.getSelectionColor();
                Color color = ErrorParser.averageColors(textArea.getBackground(), taint);
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(color);
                textArea.getHighlighter().addHighlight(textArea.getSelectionStart(), textArea.getSelectionEnd(), painter);
                textArea.setCaretPosition(textArea.getSelectionEnd());
                textArea.getHighlighter();
            }
            catch (BadLocationException ignored) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            }
        });
        jmi = new JMenuItem("Clear Highlights");
        popup.add(jmi);
        jmi.addActionListener(e -> textArea.getHighlighter().removeAllHighlights());
        this.cmdPalette.register(jmi, scope);
        popup.addSeparator();
        JCheckBoxMenuItem jmc = new JCheckBoxMenuItem("Wrap Lines");
        popup.add(jmc);
        jmc.addActionListener(e -> textArea.setLineWrap(jmc.isSelected()));
        this.cmdPalette.register(jmc, scope);
    }

    private static Collection<File> assembleFlatFileCollection(Collection<File> collection, File[] files) {
        if (files == null) {
            return collection;
        }
        for (File file : files) {
            if (file == null || TextEditor.isBinary(file)) continue;
            if (file.isDirectory()) {
                TextEditor.assembleFlatFileCollection(collection, file.listFiles());
                continue;
            }
            collection.add(file);
        }
        return collection;
    }

    static {
        TextEditor.addTemplatePath("script_templates");
        TextEditor.addTemplatePath("script-templates");
        tokenMakerFactory = null;
        instances = new ArrayList();
        contexts = new ArrayList();
    }

    static class TextFieldWithPlaceholder
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private String placeholder;

        TextFieldWithPlaceholder() {
        }

        void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            this.update(this.getGraphics());
        }

        Font getPlaceholderFont() {
            return this.getFont().deriveFont(2);
        }

        String getPlaceholder() {
            return this.placeholder;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.getText().isEmpty()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setColor(this.getDisabledTextColor());
                g2.setFont(this.getPlaceholderFont());
                g2.drawString(this.getPlaceholder(), this.getInsets().left, g2.getFontMetrics().getHeight() + this.getInsets().top - this.getInsets().bottom);
                g2.dispose();
            }
        }
    }

    protected static class GuiUtils {
        private GuiUtils() {
        }

        static void error(Component parent, String message) {
            JOptionPane.showMessageDialog(parent, message, "Error", 0);
        }

        static void warn(Component parent, String message) {
            JOptionPane.showMessageDialog(parent, message, "Warning", 2);
        }

        static void info(Component parent, String message, String title) {
            JOptionPane.showMessageDialog(parent, message, title, 1);
        }

        static boolean confirm(Component parent, String message, String title, String yesButtonLabel) {
            return JOptionPane.showConfirmDialog(parent, message, title, 0) == 0;
        }

        static void showHTMLDialog(Component parent, String title, String htmlContents) {
            JTextPane f = new JTextPane();
            f.setContentType("text/html");
            f.setEditable(false);
            f.setBackground(null);
            f.setBorder(null);
            f.setText(htmlContents);
            f.setCaretPosition(0);
            JScrollPane sp = new JScrollPane(f);
            JOptionPane pane = new JOptionPane(sp);
            JDialog dialog = pane.createDialog(parent, title);
            dialog.setResizable(true);
            dialog.pack();
            dialog.setPreferredSize(new Dimension((int)Math.min((double)parent.getWidth() * 0.5, pane.getPreferredSize().getWidth() + (double)(3 * sp.getVerticalScrollBar().getWidth())), (int)Math.min((double)parent.getHeight() * 0.8, pane.getPreferredSize().getHeight())));
            dialog.pack();
            pane.addPropertyChangeListener("value", ignored -> dialog.dispose());
            dialog.setModal(false);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
        }

        static String getString(Component parent, String message, String title) {
            return JOptionPane.showInputDialog(parent, message, title, 3);
        }

        static void runSearchQueryInBrowser(Component parentComponent, PlatformService platformService, String query) {
            String url;
            try {
                url = "https://forum.image.sc/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString());
            }
            catch (Exception ignored) {
                url = query.trim().replace(" ", "%20");
            }
            GuiUtils.openURL(parentComponent, platformService, url);
        }

        static void openURL(Component parentComponent, PlatformService platformService, String url) {
            try {
                platformService.open(new URL(url));
            }
            catch (Exception ignored) {
                JTextPane f = new JTextPane();
                f.setContentType("text/html");
                f.setText("<HTML>Web page could not be open. Please visit<br>" + url + "<br>using your web browser.");
                f.setEditable(false);
                f.setBackground(null);
                f.setBorder(null);
                JOptionPane.showMessageDialog(parentComponent, f, "Error", 0);
            }
        }

        static void openTerminal(File pwd) throws IOException, InterruptedException {
            String[] wrappedCommand;
            File dir;
            File file = dir = pwd.isDirectory() ? pwd : pwd.getParentFile();
            if (PlatformUtils.isWindows()) {
                wrappedCommand = new String[]{"cmd", "/c", "start", "/wait", "cmd.exe", "/K"};
            } else if (PlatformUtils.isLinux()) {
                wrappedCommand = new String[]{"/usr/bin/x-terminal-emulator"};
            } else if (PlatformUtils.isMac()) {
                wrappedCommand = new String[]{"osascript", "-e", "tell application \"Terminal\" to (do script \"cd '" + dir.getAbsolutePath() + "';clear\")"};
            } else {
                throw new IllegalArgumentException("Unsupported OS");
            }
            ProcessBuilder pb = new ProcessBuilder(wrappedCommand);
            pb.directory(dir);
            pb.start();
        }

        static void addMenubarSeparator(JMenu menu, String header) {
            if (menu.getMenuComponentCount() > 0) {
                menu.addSeparator();
            }
            try {
                JLabel label = new JLabel(" " + header);
                label.setEnabled(false);
                label.setForeground(GuiUtils.getDisabledComponentColor());
                menu.add(label);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static void addPopupMenuSeparator(JPopupMenu menu, String header) {
            if (menu.getComponentCount() > 1) {
                menu.addSeparator();
            }
            JLabel label = new JLabel(header);
            label.setEnabled(false);
            label.setForeground(GuiUtils.getDisabledComponentColor());
            menu.add(label);
        }

        static Color getDisabledComponentColor() {
            try {
                return UIManager.getColor("MenuItem.disabledForeground");
            }
            catch (Exception ignored) {
                return Color.GRAY;
            }
        }

        static boolean isDarkLaF() {
            return FlatLaf.isLafDark() || GuiUtils.isDark(new JLabel().getBackground());
        }

        static boolean isDark(Color c) {
            return (double)c.getRed() * 0.299 + (double)c.getGreen() * 0.587 + (double)c.getBlue() * 0.114 < 186.0;
        }

        static void collapseAllTreeNodes(JTree tree) {
            int row1;
            for (int i = row1 = tree.isRootVisible() ? 1 : 0; i < tree.getRowCount(); ++i) {
                tree.collapseRow(i);
            }
        }

        static void expandAllTreeNodes(JTree tree) {
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
        }

        static JTabbedPane getJTabbedPane() {
            JTabbedPane tabbed = new JTabbedPane();
            JPopupMenu popup = new JPopupMenu();
            tabbed.setComponentPopupMenu(popup);
            ButtonGroup bGroup = new ButtonGroup();
            for (String pos : new String[]{"Top", "Left", "Bottom", "Right"}) {
                JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem("Place on " + pos, "Top".equals(pos));
                jcbmi.addItemListener(e -> {
                    switch (pos) {
                        case "Top": {
                            tabbed.setTabPlacement(1);
                            break;
                        }
                        case "Bottom": {
                            tabbed.setTabPlacement(3);
                            break;
                        }
                        case "Left": {
                            tabbed.setTabPlacement(2);
                            break;
                        }
                        case "Right": {
                            tabbed.setTabPlacement(4);
                        }
                    }
                });
                bGroup.add(jcbmi);
                popup.add(jcbmi);
            }
            tabbed.addMouseWheelListener(e -> {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                int units = e.getWheelRotation();
                int oldIndex = pane.getSelectedIndex();
                int newIndex = oldIndex + units;
                if (newIndex < 0) {
                    pane.setSelectedIndex(0);
                } else if (newIndex >= pane.getTabCount()) {
                    pane.setSelectedIndex(pane.getTabCount() - 1);
                } else {
                    pane.setSelectedIndex(newIndex);
                }
            });
            return tabbed;
        }
    }

    private final class EditableScriptInfo
    extends ScriptInfo {
        private String script;

        public EditableScriptInfo(Context context, String path, Reader reader) {
            super(context, path, reader);
        }

        public void setScript(Reader reader) throws IOException {
            int read;
            char[] buffer = new char[8192];
            StringBuilder builder = new StringBuilder();
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
            this.script = builder.toString();
        }

        @Override
        public String getProcessedScript() {
            return null == this.script ? super.getProcessedScript() : this.script;
        }
    }

    public class FindClassSourceAndJavadoc
    implements Runnable {
        private final String text;

        public FindClassSourceAndJavadoc(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            HashMap<String, ArrayList<String>> matches;
            TextEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                matches = ClassUtil.findDocumentationForClass(this.text);
            }
            finally {
                TextEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (matches.isEmpty()) {
                if (TextEditor.this.confirm("No info found for: '" + this.text + "'.\nSearch for it on the web?", "Search the Web?", "Search")) {
                    GuiUtils.runSearchQueryInBrowser(TextEditor.this, TextEditor.this.getPlatformService(), this.text.trim());
                }
                return;
            }
            JPanel panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            panel.setLayout(gridbag);
            ArrayList<String> keys = new ArrayList<String>(matches.keySet());
            Collections.sort(keys);
            c.gridy = 0;
            for (String classname : keys) {
                c.gridx = 0;
                c.anchor = 13;
                JLabel class_label = new JLabel(classname);
                gridbag.setConstraints(class_label, c);
                panel.add(class_label);
                ArrayList<String> urls = matches.get(classname);
                if (urls.isEmpty()) {
                    urls = new ArrayList();
                    urls.add("https://duckduckgo.com/?q=" + classname);
                }
                for (String url : urls) {
                    ++c.gridx;
                    c.anchor = 17;
                    String title = "JavaDoc";
                    if (url.endsWith(".java")) {
                        title = "Source";
                    } else if (url.contains("duckduckgo")) {
                        title = "Search...";
                    }
                    JButton link = new JButton(title);
                    gridbag.setConstraints(link, c);
                    panel.add(link);
                    link.addActionListener(event -> GuiUtils.openURL(TextEditor.this, TextEditor.this.platformService, url));
                }
                ++c.gridy;
            }
            JScrollPane jsp = new JScrollPane(panel);
            SwingUtilities.invokeLater(() -> {
                JFrame frame = new JFrame("Resources for '" + this.text + "'");
                frame.getContentPane().add(jsp);
                frame.setLocationRelativeTo(TextEditor.this);
                frame.pack();
                frame.setVisible(true);
            });
        }
    }

    public abstract class Executer
    extends ThreadGroup {
        JTextAreaWriter output;
        JTextAreaWriter errors;

        Executer(final JTextAreaWriter output, final JTextAreaWriter errors) {
            super("Script Editor Run :: " + new Date().toString());
            this.output = output;
            this.errors = errors;
            TextEditor.this.executingTasks.add(this);
            TextEditor.this.setTitle();
            TextEditor.this.kill.setEnabled(true);
            new Thread(this, this.getName()){
                {
                    super(x0, x1);
                    this.setPriority(5);
                    this.start();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block21: {
                        Executer.this.execute();
                        int activeCount = this.getThreadGroup().activeCount();
                        while (activeCount > 1 && !this.isInterrupted()) {
                            try {
                                Thread.sleep(500L);
                                List<Thread> ts = Executer.this.getAllThreads();
                                activeCount = ts.size();
                                if (activeCount <= 1) break;
                                TextEditor.this.log.debug("Waiting for " + ts.size() + " threads to die");
                                int count_zSelector = 0;
                                for (Thread t : ts) {
                                    if (t.getName().equals("zSelector")) {
                                        ++count_zSelector;
                                    }
                                    TextEditor.this.log.debug("THREAD: " + t.getName());
                                }
                                if (activeCount != count_zSelector + 1) continue;
                                break;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        TextEditor.this.executingTasks.remove(Executer.this);
                        try {
                            if (null != output) {
                                output.shutdown();
                            }
                            if (null != errors) {
                                errors.shutdown();
                            }
                        }
                        catch (Exception e) {
                            TextEditor.this.handleException(e);
                        }
                        TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                        TextEditor.this.setTitle();
                        break block21;
                        catch (Throwable t) {
                            try {
                                TextEditor.this.handleException(t);
                                TextEditor.this.executingTasks.remove(Executer.this);
                            }
                            catch (Throwable throwable) {
                                TextEditor.this.executingTasks.remove(Executer.this);
                                try {
                                    if (null != output) {
                                        output.shutdown();
                                    }
                                    if (null != errors) {
                                        errors.shutdown();
                                    }
                                }
                                catch (Exception e) {
                                    TextEditor.this.handleException(e);
                                }
                                TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                                TextEditor.this.setTitle();
                                throw throwable;
                            }
                            try {
                                if (null != output) {
                                    output.shutdown();
                                }
                                if (null != errors) {
                                    errors.shutdown();
                                }
                            }
                            catch (Exception e) {
                                TextEditor.this.handleException(e);
                            }
                            TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                            TextEditor.this.setTitle();
                        }
                    }
                }
            };
        }

        abstract void execute();

        List<Thread> getAllThreads() {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            ThreadGroup[] tgs = new ThreadGroup[this.activeGroupCount() * 2 + 100];
            this.enumerate(tgs, true);
            for (ThreadGroup tg : tgs) {
                if (null == tg) continue;
                Thread[] ts = new Thread[tg.activeCount() * 2 + 100];
                tg.enumerate(ts);
                for (Thread t : ts) {
                    if (null == t) continue;
                    threads.add(t);
                }
            }
            Thread[] ts = new Thread[this.activeCount() * 2 + 100];
            this.enumerate(ts);
            for (Thread t : ts) {
                if (null == t) continue;
                threads.add(t);
            }
            return threads;
        }

        void obliterate() {
            try {
                if (null != this.output) {
                    this.output.shutdownNow();
                }
                if (null != this.errors) {
                    this.errors.shutdownNow();
                }
            }
            catch (Exception e) {
                TextEditor.this.log.error(e);
            }
            for (Thread thread : this.getAllThreads()) {
                try {
                    thread.interrupt();
                    Thread.yield();
                    thread.stop();
                }
                catch (Throwable t) {
                    TextEditor.this.log.error(t);
                }
            }
            TextEditor.this.executingTasks.remove(this);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    protected static class AcceleratorTriplet {
        JMenuItem component;
        int key;
        int modifiers;

        protected AcceleratorTriplet() {
        }
    }

    private class DragAndDrop
    implements DragSourceListener,
    DragGestureListener {
        private DragAndDrop() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath path = TextEditor.this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            final String filepath = (String)((FileSystemTree.Node)path.getLastPathComponent()).getUserObject();
            TextEditor.this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, new Transferable(){

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.javaFileListFlavor == flavor;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(flavor)) {
                        return Arrays.asList(filepath);
                    }
                    return null;
                }
            }, this);
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            if (TextEditor.this.tree == dsde.getSource()) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            } else if (dsde.getDropAction() == 1) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

