/*
 * Decompiled with CFR 0.152.
 */
package com.headius.unsafe.fences;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class UnsafeFences {
    public static final boolean SUPPORTS_FENCES = UnsafeFences.supportsFences();
    private static final Unsafe U = UnsafeFences.loadUnsafe();

    public static void fullFence() {
        U.fullFence();
    }

    public static void loadFence() {
        U.loadFence();
    }

    public static void storeFence() {
        U.storeFence();
    }

    private UnsafeFences() {
    }

    private static Unsafe loadUnsafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    private static boolean supportsFences() {
        if (U == null) {
            return false;
        }
        try {
            Method m = U.getClass().getDeclaredMethod("fullFence", new Class[0]);
            if (m != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

