/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import org.jhotdraw.color.ColorUtil;

public class CIEXYChromaticityDiagramImageProducer
extends MemoryImageSource {
    private static final float eps = 0.0f;
    private static final float ceps = 0.0f;
    protected int[] pixels;
    protected int w;
    protected int h;
    protected ColorSpace colorSpace;
    protected int radialIndex = 1;
    protected int angularIndex = 0;
    protected int verticalIndex = 2;
    protected boolean isPixelsValid = false;
    protected float verticalValue = 1.0f;
    protected boolean isLookupValid = false;
    private OutsideGamutHandling outsideGamutHandling = OutsideGamutHandling.LEAVE_OUTSIDE;

    public CIEXYChromaticityDiagramImageProducer(int w, int h) {
        super(w, h, null, 0, w);
        this.colorSpace = ICC_ColorSpace.getInstance(1001);
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.setAnimated(true);
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, w);
    }

    public boolean needsGeneration() {
        return !this.isPixelsValid;
    }

    public void regenerateDiagram() {
        if (!this.isPixelsValid) {
            this.generateImage();
        }
    }

    public void generateImage() {
        float wf = 0.8f / (float)this.w;
        float hf = 0.9f / (float)this.h;
        Arrays.fill(this.pixels, 0);
        float[] rgb = new float[3];
        for (int iY = 0; iY <= 100; ++iY) {
            float Y = (float)(100 - iY) / 100.0f;
            float[] XYZ = new float[3];
            for (int ix = 0; ix < this.w; ++ix) {
                float x = (float)ix * wf;
                for (int iy = 0; iy < this.h; ++iy) {
                    int alpha;
                    if (this.pixels[ix + iy * this.w] != 0) continue;
                    float y = 0.9f - (float)iy * hf;
                    float z = 1.0f - x - y;
                    if (y == 0.0f) {
                        XYZ[2] = 0.0f;
                        XYZ[1] = 0.0f;
                        XYZ[0] = 0.0f;
                    } else {
                        XYZ[1] = Y;
                        XYZ[0] = x * XYZ[1] / y;
                        XYZ[2] = z * XYZ[1] / y;
                    }
                    int n = alpha = XYZ[0] >= 0.0f && XYZ[1] >= 0.0f && XYZ[2] >= 0.0f && XYZ[0] <= 1.0f && XYZ[1] <= 1.0f && XYZ[2] <= 1.0f ? 255 : 0;
                    if (alpha != 255) continue;
                    this.toRGB(XYZ, rgb);
                    int n2 = alpha = rgb[0] >= 0.0f && rgb[1] >= 0.0f && rgb[2] >= 0.0f && rgb[0] <= 1.0f && rgb[1] <= 1.0f && rgb[2] <= 1.0f ? 255 : 0;
                    if (alpha != 255) continue;
                    this.pixels[ix + iy * this.w] = alpha << 24 | (0xFF & (int)(rgb[0] * 255.0f)) << 16 | (0xFF & (int)(rgb[1] * 255.0f)) << 8 | 0xFF & (int)(rgb[2] * 255.0f);
                }
            }
        }
    }

    @Nullable
    public Point getColorLocation(Color c) {
        float[] components = ColorUtil.fromColor(this.colorSpace, c);
        return this.getColorLocation(components);
    }

    @Nullable
    public Point getColorLocation(float[] components) {
        return null;
    }

    @Nullable
    public float[] getColorAt(int x, int y) {
        return null;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void toRGB(float[] ciexyz, float[] rgb) {
        double X = ciexyz[0];
        double Y = ciexyz[1];
        double Z = ciexyz[2];
        double Rs = 1.4628067 * X + -0.1840623 * Y + -0.2743606 * Z;
        double Gs = -0.5217933 * X + 1.4472381 * Y + 0.0677227 * Z;
        double Bs = 0.0349342 * X + -0.096893 * Y + 1.2884099 * Z;
        Rs = Rs <= 0.00304 ? 12.92 * Rs : 1.055 * Math.pow(Rs, 0.4166666666666667) - 0.055;
        Gs = Gs <= 0.00304 ? 12.92 * Gs : 1.055 * Math.pow(Gs, 0.4166666666666667) - 0.055;
        Bs = Bs <= 0.00304 ? 12.92 * Bs : 1.055 * Math.pow(Bs, 0.4166666666666667) - 0.055;
        switch (this.outsideGamutHandling) {
            case CLAMP: {
                Rs = Math.min(1.0, Math.max(0.0, Rs));
                Gs = Math.min(1.0, Math.max(0.0, Gs));
                Bs = Math.min(1.0, Math.max(0.0, Bs));
            }
        }
        rgb[0] = (float)Rs;
        rgb[1] = (float)Gs;
        rgb[2] = (float)Bs;
    }

    public static enum OutsideGamutHandling {
        CLAMP,
        LEAVE_OUTSIDE;

    }
}

